/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.AbstractWBFileFilter;
import com.elluminate.groupware.whiteboard.ShutdownListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import com.elluminate.groupware.whiteboard.module.ImageFileFilter;
import com.elluminate.groupware.whiteboard.module.ReadableFileFilter;
import com.elluminate.groupware.whiteboard.module.SaveProcessor;
import com.elluminate.groupware.whiteboard.module.StarOfficeInformation;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.groupware.whiteboard.module.WhiteboardWBDFileFilter;
import com.elluminate.groupware.whiteboard.module.WhiteboardWBPFileFilter;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationImage;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationImport;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationInterface;
import com.elluminate.groupware.whiteboard.module.presentations.StarOfficeImport;
import com.elluminate.groupware.whiteboard.module.ui.DisplayUtilities;
import com.elluminate.groupware.whiteboard.module.ui.FileChoice;
import com.elluminate.groupware.whiteboard.module.ui.IMGLoadDialog;
import com.elluminate.groupware.whiteboard.module.ui.WBDLoadDialog;
import com.elluminate.groupware.whiteboard.module.ui.WBDSaveDialog;
import com.elluminate.groupware.whiteboard.tools.BackgroundTool;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.io.FileSysUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;

public class FileUtils {
    private static I18n i18n = I18n.create((Object)new Object(){});
    public static final int WBD = 1;
    public static final int PPT = 2;
    public static final int IMG = 3;
    public static final int LOAD_FAILED = 0;
    public static final int LOAD_WBD = 1;
    public static final int LOAD_WBP = 2;
    private static final String LAST_FILTER_PREF = ".lastLoadFilter";

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhiteboardModel getLoadModel(WhiteboardContext context, File defaultFile, boolean queryUser, int width, int height) {
        WhiteboardModel modelRead;
        block60: {
            int ix;
            CFileChooser chooser = null;
            File[] filesToLoad = null;
            modelRead = null;
            boolean ppt = PresentationImport.isSupported("powerpoint");
            boolean pptFailure = !ppt;
            StarOfficeInformation.instance().validateApp();
            boolean starOffice = PresentationImport.isSupported("staroffice");
            boolean starOfficeFailure = !starOffice;
            chooser = new CFileChooser(defaultFile);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_LOADDIALOGTITLE));
            chooser.resetChoosableFileFilters();
            chooser.setAcceptAllFileFilterUsed(false);
            ReadableFileFilter allFilesFilter = new ReadableFileFilter(i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_ALLREADABLEFILESFILTER));
            allFilesFilter.addChoosableFileFilter((JFileChooser)chooser);
            FileFilter pptFilter = null;
            if (ppt) {
                try {
                    PresentationImport.addChoosableFileFilter((JFileChooser)chooser, "powerpoint");
                    FileFilter[] filters = chooser.getChoosableFileFilters();
                    if (filters.length > 0) {
                        pptFilter = filters[filters.length - 1];
                    }
                }
                catch (Exception e) {
                    pptFailure = true;
                }
            }
            FileFilter soFilter = null;
            if (starOffice) {
                try {
                    PresentationImport.addChoosableFileFilter((JFileChooser)chooser, "staroffice");
                    FileFilter[] filters = chooser.getChoosableFileFilters();
                    if (filters.length > 0) {
                        soFilter = filters[filters.length - 1];
                    }
                }
                catch (Exception e) {
                    starOfficeFailure = true;
                }
            }
            ImageFileFilter imgFilter = new ImageFileFilter();
            imgFilter.addChoosableFileFilter((JFileChooser)chooser);
            WhiteboardWBPFileFilter wbpFilter = new WhiteboardWBPFileFilter();
            wbpFilter.addChoosableFileFilter((JFileChooser)chooser);
            WhiteboardWBDFileFilter wbdFilter = new WhiteboardWBDFileFilter();
            wbdFilter.addChoosableFileFilter((JFileChooser)chooser);
            switch (Platform.getOS()) {
                case 202: {
                    if (soFilter != null) {
                        allFilesFilter.addChoosableFileFilter(soFilter);
                    }
                    if (pptFilter == null) break;
                    allFilesFilter.addChoosableFileFilter(pptFilter);
                    break;
                }
                default: {
                    if (pptFilter != null) {
                        allFilesFilter.addChoosableFileFilter(pptFilter);
                    }
                    if (soFilter == null) break;
                    allFilesFilter.addChoosableFileFilter(soFilter);
                }
            }
            allFilesFilter.addChoosableFileFilter((FileFilter)((Object)imgFilter));
            allFilesFilter.addChoosableFileFilter((FileFilter)((Object)wbpFilter));
            allFilesFilter.addChoosableFileFilter((FileFilter)((Object)wbdFilter));
            FileFilter[] filters = chooser.getChoosableFileFilters();
            boolean defaultFilterSet = false;
            WhiteboardModule mod = ((WhiteboardBean)context.getBean()).getModule();
            String prefix = mod.getPrefix();
            Preferences prefs = mod.getPreferences();
            String filter = prefs.getSetting(prefix + LAST_FILTER_PREF);
            if (defaultFile != null && defaultFile.isFile()) {
                if (filter != null) {
                    for (ix = 0; ix < filters.length; ++ix) {
                        if (filters[ix] == null || !filter.equals(filters[ix].getClass().getName())) continue;
                        if (!filters[ix].accept(defaultFile)) break;
                        chooser.setFileFilter(filters[ix]);
                        defaultFilterSet = true;
                        break;
                    }
                }
                if (!defaultFilterSet) {
                    for (ix = 1; ix < filters.length; ++ix) {
                        if (filters[ix] == null || !filters[ix].accept(defaultFile)) continue;
                        chooser.setFileFilter(filters[ix]);
                        defaultFilterSet = true;
                        break;
                    }
                }
            } else if (filter != null) {
                for (ix = 0; ix < filters.length; ++ix) {
                    if (filters[ix] == null || !filter.equals(filters[ix].getClass().getName())) continue;
                    chooser.setFileFilter(filters[ix]);
                    defaultFilterSet = true;
                    break;
                }
            }
            if (!defaultFilterSet) {
                int plat = Platform.getPlatform();
                int os = Platform.getOS();
                filter = plat == 1 ? (ppt && pptFilter != null ? pptFilter.getClass().getName() : (starOffice && soFilter != null ? soFilter.getClass().getName() : imgFilter.getClass().getName())) : (os == 202 || os == 250 || os == 300 ? (starOffice && soFilter != null ? soFilter.getClass().getName() : imgFilter.getClass().getName()) : ((Object)((Object)wbdFilter)).getClass().getName());
                for (int ix2 = 0; ix2 < filters.length; ++ix2) {
                    if (filters[ix2] == null || !filter.equals(filters[ix2].getClass().getName())) continue;
                    chooser.setFileFilter(filters[ix2]);
                    defaultFilterSet = true;
                    break;
                }
            }
            if (defaultFile != null) {
                if (defaultFile.isDirectory()) {
                    chooser.setCurrentDirectory(defaultFile);
                } else {
                    chooser.setCurrentDirectory(new File(defaultFile.getParent()));
                }
                if (defaultFile.isFile()) {
                    chooser.setSelectedFile(defaultFile);
                    chooser.ensureFileIsVisible(defaultFile);
                }
            } else {
                chooser.setCurrentDirectory(Platform.getDefaultDir());
            }
            int result = 0;
            if (queryUser) {
                result = chooser.showOpenDialog(context.getDialogParentFrame());
            }
            imgFilter.dispose();
            if (result == 0) {
                Object chosenFilter = chooser.getFileFilter();
                if (!allFilesFilter.containsFileFilter((FileFilter)chosenFilter)) {
                    chosenFilter = allFilesFilter;
                }
                if (queryUser) {
                    prefs.setSetting(prefix + LAST_FILTER_PREF, chosenFilter.getClass().getName());
                } else {
                    chosenFilter = allFilesFilter;
                }
                filesToLoad = chooser.getSelectedFiles();
                if ((filesToLoad == null || filesToLoad.length == 0) && chooser.getSelectedFile() != null) {
                    filesToLoad = new File[]{chooser.getSelectedFile()};
                }
                if (!chosenFilter.accept(defaultFile = filesToLoad[0])) {
                    chosenFilter = allFilesFilter;
                }
                for (int index = 0; index < filesToLoad.length; ++index) {
                    if (filesToLoad[index] == null || !filesToLoad[index].exists()) {
                        ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_CANTFINDFILE, new Object[]{filesToLoad[index].getPath()}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_CANTFINDFILETITLE), (int)0);
                        return null;
                    }
                    if (filesToLoad[index].length() != 0L) continue;
                    ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_EMPTYFILE, new Object[]{filesToLoad[index].getPath()}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_EMPTYFILETITLE), (int)0);
                    return null;
                }
                Object effectiveFilter = chosenFilter;
                if (effectiveFilter == allFilesFilter) {
                    boolean found = false;
                    for (int ix3 = 1; ix3 < filters.length; ++ix3) {
                        if (filters[ix3] == null || !filters[ix3].accept(defaultFile)) continue;
                        effectiveFilter = filters[ix3];
                        found = true;
                        break;
                    }
                    if (!found) {
                        ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_UNKNOWNFILE, new Object[]{defaultFile.getPath()}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_UNKNOWNFILETITLE), (int)0);
                        return null;
                    }
                }
                if (effectiveFilter instanceof PresentationInterface) {
                    PresentationInterface pptI = null;
                    try {
                        pptI = (PresentationInterface)((Object)effectiveFilter);
                        context.addShutdownListener((ShutdownListener)pptI);
                        String ownerPrefix = context.getBean().getOwnerPrefix();
                        Preferences preferences = context.getBean().getPreferences();
                        int screenWidth = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeWidth", 1014);
                        int screenHeight = preferences.getIntegerSetting(ownerPrefix + ".importScreenSizeHeight", 835);
                        pptI.importFromFile(filesToLoad[0], context, screenWidth, screenHeight);
                        int screenCount = pptI.screenCount(pptI.getDesiredSlideType());
                        if (screenCount > 0) {
                            boolean withNotes = queryUser ? pptI.isNotesIncluded() : true;
                            modelRead = FileUtils.importPresentation(context, pptI, new Dimension(screenWidth, screenHeight), withNotes);
                        }
                        ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATIONERROR, new Object[]{pptI.getFailReason()}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATION), (int)0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)e.getMessage(), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATION), (int)0);
                    }
                    finally {
                        context.removeShutdownListener((ShutdownListener)pptI);
                        pptI.dispose();
                    }
                } else {
                    if (effectiveFilter == null) {
                        ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_WRONGTYPE), (String)defaultFile.getAbsolutePath(), (int)0);
                        return null;
                    }
                    if (effectiveFilter instanceof ImageFileFilter) {
                        IMGLoadDialog loadImg = null;
                        try {
                            filesToLoad = ((ImageFileFilter)effectiveFilter).getFiles();
                            loadImg = new IMGLoadDialog(context, context.getDialogParentFrame(), i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_LOADIMG), filesToLoad, true);
                            loadImg.processFile(true);
                            modelRead = loadImg.getModel();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (loadImg != null) {
                                loadImg.dispose();
                            }
                            break block60;
                        }
                    }
                    WBDLoadDialog loadWBD = null;
                    try {
                        loadWBD = new WBDLoadDialog(context, context.getDialogParentFrame(), i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_LOADDIALOG), filesToLoad[0], true);
                        loadWBD.processFile(true);
                        modelRead = loadWBD.getModel();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        if (loadWBD != null) {
                            loadWBD.dispose();
                        }
                    }
                }
            }
        }
        context.fileToLoad = defaultFile;
        return modelRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhiteboardModel getPowerpointLoadModel(WhiteboardContext context, File fileToUpload, int width, int height, int quality, boolean withNotes) {
        WhiteboardModel modelRead = null;
        PowerPointImport pptI = null;
        try {
            pptI = new PowerPointImport();
            context.addShutdownListener((ShutdownListener)pptI);
            pptI.importFromFile(fileToUpload, context, width, height);
            int screenCount = pptI.screenCount(pptI.getDesiredSlideType());
            if (screenCount > 0) {
                modelRead = FileUtils.importPresentation(context, pptI, new Dimension(width, height), withNotes);
            } else {
                ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATIONERROR, new Object[]{pptI.getFailReason()}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATION), (int)0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)e.getMessage(), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATION), (int)0);
        }
        finally {
            context.removeShutdownListener((ShutdownListener)pptI);
            pptI.dispose();
        }
        return modelRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhiteboardModel getOpenOfficeLoadModel(WhiteboardContext context, File fileToUpload, int width, int height, boolean withNotes) {
        WhiteboardModel modelRead = null;
        StarOfficeImport ooI = null;
        try {
            ooI = new StarOfficeImport();
            context.addShutdownListener((ShutdownListener)ooI);
            ooI.importFromFile(fileToUpload, context, width, height);
            int screenCount = ooI.screenCount(ooI.getDesiredSlideType());
            if (screenCount > 0) {
                modelRead = FileUtils.importPresentation(context, ooI, new Dimension(width, height), withNotes);
            } else {
                ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATIONERROR, new Object[]{ooI.getFailReason()}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATION), (int)0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)e.getMessage(), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_IMPORTPRESENTATION), (int)0);
        }
        finally {
            context.removeShutdownListener((ShutdownListener)ooI);
            ooI.dispose();
        }
        return modelRead;
    }

    public static WhiteboardModel getImageLoadModel(WhiteboardContext context, File[] filesToLoad, int width, int height, int quality, boolean withNotes) {
        WhiteboardModel modelRead;
        block2: {
            modelRead = null;
            IMGLoadDialog loadImg = null;
            try {
                loadImg = new IMGLoadDialog(context, context.getDialogParentFrame(), i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_LOADIMG), filesToLoad, true);
                loadImg.processFile(true);
                modelRead = loadImg.getModel();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (loadImg == null) break block2;
                loadImg.dispose();
            }
        }
        return modelRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhiteboardModel getWhiteboardLoadModel(WhiteboardContext context, File fileToLoad, int width, int height, int quality, boolean withNotes) {
        WhiteboardModel modelRead = null;
        WBDLoadDialog loadWBD = null;
        try {
            loadWBD = new WBDLoadDialog(context, context.getDialogParentFrame(), i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_LOADDIALOG), fileToLoad, true);
            loadWBD.processFile(true);
            modelRead = loadWBD.getModel();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (loadWBD != null) {
                loadWBD.dispose();
            }
        }
        return modelRead;
    }

    public static FileChoice getSaveFile(WhiteboardContext context, File fileToSave, AbstractWBFileFilter[] filterSet) {
        AbstractWBFileFilter chosenFilter = null;
        CFileChooser chooser = new CFileChooser();
        chooser.setCurrentDirectory(FileUtils.selectSaveDirectory(fileToSave));
        chooser.resetChoosableFileFilters();
        chooser.setAcceptAllFileFilterUsed(false);
        for (int i = 0; i < filterSet.length; ++i) {
            chooser.addChoosableFileFilter((FileFilter)filterSet[i]);
        }
        chosenFilter = FileUtils.selectFilter(fileToSave, filterSet);
        if (chosenFilter != null) {
            chooser.setFileFilter((FileFilter)chosenFilter);
        }
        if (fileToSave != null && fileToSave.isFile()) {
            chooser.setSelectedFile(FileUtils.removeKnownExtension(fileToSave, filterSet));
            chooser.ensureFileIsVisible(fileToSave);
        }
        chooser.setDialogTitle(i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_SAVEDIALOGTITLE));
        if (chooser.showSaveDialog(context.getDialogParentFrame()) != 0) {
            return null;
        }
        File chosenFile = new File(chooser.getSelectedFile().getAbsolutePath());
        if (chosenFile == null || chosenFile.isDirectory()) {
            return null;
        }
        chosenFilter = (AbstractWBFileFilter)chooser.getFileFilter();
        if (fileToSave != null && FileUtils.findFilterMatch(fileToSave, filterSet) == null) {
            chosenFile = FileSysUtils.setExtensionDefault((File)chosenFile, (String)FileSysUtils.getExtension((File)fileToSave));
        }
        if ((chosenFile = FileSysUtils.setExtensionDefault((File)chosenFile, (String)chosenFilter.getSuffix())).exists()) {
            if (FileUtils.confirmFileOverwrite(context, chosenFile) != 0) {
                return null;
            }
            if (!chosenFile.canWrite()) {
                FileUtils.showCanNotOverwriteMsg(context.getDialogParentFrame(), chosenFile.getName());
                return null;
            }
        }
        return new FileChoice(chosenFile, chosenFilter);
    }

    private static void showCanNotOverwriteMsg(Frame frame, String fileName) {
        ModalDialog.showMessageDialog((Component)frame, (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_CANTSAVEMSG, new Object[]{fileName}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_CANTSAVETITLE), (int)0);
    }

    private static int confirmFileOverwrite(WhiteboardContext context, File chosenFile) {
        return ModalDialog.showConfirmDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_FILEEXISTSMSG, new Object[]{chosenFile.getName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_FILEEXISTSTITLE), (int)0, (int)3);
    }

    private static File selectSaveDirectory(File fileToSave) {
        if (fileToSave == null) {
            return Platform.getDefaultDir();
        }
        if (fileToSave.isDirectory()) {
            return fileToSave;
        }
        return new File(fileToSave.getParent());
    }

    public static void saveThisFile(WhiteboardContext context, String fileName, SaveProcessor saveProcessor) {
        WBDSaveDialog save = new WBDSaveDialog(context, context.getDialogParentFrame(), i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_SAVEDIALOG), fileName, true);
        save.processFile(true, saveProcessor);
        save.dispose();
    }

    public static WhiteboardModel importPresentation(WhiteboardContext context, PresentationInterface pptI, Dimension screenSize, boolean includeNotes) throws Exception {
        Dimension dim = new Dimension();
        if (screenSize.width * screenSize.height > 4000000) {
            throw new RuntimeException("Requested Presentation Screen Size exceeeds maximum image size of: 4000000");
        }
        WhiteboardModel whiteboardModel = new WhiteboardModel(context);
        whiteboardModel.setTemplate(context);
        int nImportedScreens = pptI.screenCount(pptI.getDesiredSlideType());
        for (int screenId = 1; screenId <= nImportedScreens; ++screenId) {
            Rectangle area;
            int i;
            String altText;
            PresentationImage[] images = pptI.getScreenImages(screenId, pptI.getDesiredSlideType());
            if (images == null) continue;
            ScreenModel screen = new ScreenModel(pptI.getSlideTitle(screenId - 1), context);
            if (includeNotes) {
                screen.setPresentersNotes(pptI.getSlideNotes(screenId), screen.getScreenName());
            }
            if ((altText = pptI.getSlideAltText(screenId)) != null) {
                screen.setAltTextText(altText);
            }
            screen.setScreenSize(screenSize);
            screen.setTemplate(context);
            screen.setOriginator();
            context.getObjectManager().setObjectInMap((UniqueObjectID)screen);
            BackgroundTool background = new BackgroundTool(context);
            background.setTemplate(context);
            background.setOriginator();
            context.getObjectManager().setObjectInMap((UniqueObjectID)background);
            whiteboardModel.add((WBNode)screen);
            screen.add((WBNode)background);
            dim.width = 0;
            dim.height = 0;
            for (i = 0; i < images.length; ++i) {
                area = images[i].getArea();
                if (area.x + area.width > dim.width) {
                    dim.width = area.x + area.width;
                }
                if (area.y + area.height <= dim.height) continue;
                dim.height = area.y + area.height;
            }
            if (dim.width != screen.getScreenSize().width || dim.height != screen.getScreenSize().height) {
                screen.setScreenSize(dim);
            }
            for (i = 0; i < images.length; ++i) {
                if (images[i] == null) continue;
                area = images[i].getArea();
                ImageToolModel imageTool = new ImageToolModel(context, images[i].getImageData(), images[i].getImageName(), images[i].getImageName(), area);
                context.getObjectManager().setObjectInMap((UniqueObjectID)imageTool);
                imageTool.setOriginator();
                imageTool.setFrameVisible(false);
                if (i == 0 && images.length > 1) {
                    imageTool.setAsBackground(true);
                }
                background.add((WBNode)imageTool);
            }
        }
        return whiteboardModel;
    }

    public static ScreenModel[] createScreensFromPaths(TreePath[] paths) {
        if (paths == null) {
            return new ScreenModel[0];
        }
        LinkedList<ScreenModel> screenList = new LinkedList<ScreenModel>();
        for (int i = 0; i < paths.length; ++i) {
            ScreenModel screen;
            DisplayNode proxy;
            if (!(paths[i].getLastPathComponent() instanceof DisplayNode) || (proxy = (DisplayNode)paths[i].getLastPathComponent()) == null || (screen = (ScreenModel)proxy.whiteboardPeer()) == null || !screen.canSave()) continue;
            screenList.add(screen);
        }
        ScreenModel[] screens = new ScreenModel[screenList.size()];
        screens = screenList.toArray(screens);
        return screens;
    }

    private static WhiteboardModel createWhiteboardModel(WhiteboardContext context, Image[] images, String[] names, String title) {
        WhiteboardModel whiteboardModel = new WhiteboardModel(context);
        whiteboardModel.setTemplate(context);
        whiteboardModel.add((WBNode)FileUtils.createScreen(context, images, names, title));
        return whiteboardModel;
    }

    public static ScreenModel createScreen(WhiteboardContext context, Image[] images, String[] names, String title) {
        ScreenModel screen = new ScreenModel(title, context);
        screen.setTemplate(context);
        screen.setOriginator();
        context.getObjectManager().setObjectInMap((UniqueObjectID)screen);
        BackgroundTool background = FileUtils.createBackground(context, images, names);
        Dimension dim = new Dimension(background.getIntSize().width, background.getIntSize().height);
        if (dim.width > screen.getScreenSize().width || dim.height > screen.getScreenSize().height) {
            screen.setScreenSize(dim);
        }
        screen.add((WBNode)background);
        return screen;
    }

    public static BackgroundTool createBackground(WhiteboardContext context, Image[] images, String[] names) {
        BackgroundTool background = new BackgroundTool(context);
        background.setTemplate(context);
        background.setOriginator();
        context.getObjectManager().setObjectInMap((UniqueObjectID)background);
        for (int i = 0; i < images.length; ++i) {
            if (images[i] == null) continue;
            background.add((WBNode)FileUtils.createImageTool(context, images[i], names[i]));
        }
        return background;
    }

    public static ImageToolModel createImageTool(WhiteboardContext context, Image image, String name) {
        Rectangle area = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
        ImageToolModel imageTool = new ImageToolModel(context, ImageSupport.encodeAsPNG((Image)image), name + ".png", name + ".png", area);
        context.getObjectManager().setObjectInMap((UniqueObjectID)imageTool);
        imageTool.setOriginator();
        imageTool.setFrameVisible(false);
        return imageTool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadWhiteboardFile(File preloadFile, ScreenRoot[] roots, WhiteboardContext context) {
        WBDLoadDialog loadWBD = null;
        int sucess = 0;
        WhiteboardModel whiteboardModel = null;
        try {
            loadWBD = new WBDLoadDialog(context, context.getDialogParentFrame(), i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_LOADDIALOG), preloadFile, true);
            loadWBD.processFile(true);
            whiteboardModel = loadWBD.getModel();
            ActionUtilities.deleteScreens((WBNode[])roots, (WhiteboardContext)context);
            boolean allRootsReplaced = false;
            if (context.getDataModel().getPublicScreens() == null) {
                if (context.getDataModel().getPrivateScreens() != null) {
                    allRootsReplaced = context.getDataModel().getPrivateScreens().getScreenCount() == 0;
                }
            } else {
                allRootsReplaced = context.getDataModel().getPublicScreens().getScreenCount() == 0;
            }
            ScreenModel[] screens = new ScreenModel[whiteboardModel.getScreenCount()];
            for (int i = 0; i < screens.length; ++i) {
                screens[i] = (ScreenModel)whiteboardModel.getScreenAt(i);
            }
            ActionUtilities.pasteScreens((ScreenModel[])roots, (WhiteboardContext)context, (int)1, (ScreenModel[])screens);
            int n = sucess = preloadFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".wbp") ? 2 : 1;
            if (allRootsReplaced) {
                ((WhiteboardBean)context.getBean()).setDocumentChanged(false);
            }
        }
        catch (Exception ex) {
        }
        finally {
            loadWBD.dispose();
            if (whiteboardModel != null) {
                whiteboardModel.delete();
            }
        }
        return sucess;
    }

    public static boolean loadWBD(WhiteboardContext context, File defaultFile, boolean queryUser, int insertRelationship, ScreenModel watchingScreen, TreePath[] pathsToProcess) {
        WhiteboardModel model = FileUtils.getLoadModel(context, context.fileToLoad, queryUser, watchingScreen.getScreenSize().width, watchingScreen.getScreenSize().height);
        return FileUtils.loadWBD(context, insertRelationship, watchingScreen, pathsToProcess, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadWBD(WhiteboardContext context, int insertRelationship, ScreenModel watchingScreen, TreePath[] pathsToProcess, WhiteboardModel model) {
        ScreenModel target2 = null;
        ScreenModel[] fixedScreens = null;
        if (model == null) {
            return false;
        }
        boolean proprietary = context.fileToLoad.getName().toLowerCase(Locale.ENGLISH).endsWith(".wbp");
        if (context.getMediaCache().isCacheFull() && context.getController() != null) {
            String msgKey;
            long GB = 0x40000000L;
            long MB = 0x100000L;
            long KB = 1024L;
            long overSize = context.getMediaCache().getCacheSize() - context.getMediaCache().getMaxImageCache();
            long maxSize = new Long(context.getMediaCache().getMaxImageCache());
            String maxSizeString = NumberFormat.getIntegerInstance().format(maxSize);
            if (overSize >= GB) {
                overSize = (overSize + GB / 2L) / GB;
                msgKey = "FileUtils.tooBigGB";
            } else if (overSize >= MB) {
                overSize = (overSize + MB / 2L) / MB;
                msgKey = "FileUtils.tooBigMB";
            } else if (overSize >= KB) {
                overSize = (overSize + KB / 2L) / KB;
                msgKey = "FileUtils.tooBigKB";
            } else {
                msgKey = "FileUtils.tooBig";
            }
            model.delete();
            model = null;
            ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getStringLegacy(msgKey, new Object[]{maxSizeString, new Long(overSize)}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_TOOBIGTITLE), (int)0);
            return false;
        }
        boolean replace = insertRelationship == 2;
        ScreenModel[] screens = new ScreenModel[model.getChildCount()];
        LinkedList pasteTargets = null;
        context.getDataExporter().blockCodecs();
        boolean codecsBlocked = true;
        boolean allRootsReplaced = false;
        try {
            int j;
            if (replace) {
                insertRelationship = 4;
                pathsToProcess = ActionUtilities.pruneRootChildren((TreePath[])pathsToProcess);
            }
            LinkedList<WBNode> emptyRootList = new LinkedList<WBNode>();
            LinkedList<WBNode> nonEmptyRootList = new LinkedList<WBNode>();
            for (int i = 0; i < pathsToProcess.length; ++i) {
                if (!(pathsToProcess[i].getLastPathComponent() instanceof DisplayNode)) continue;
                WBNode node = ((DisplayNode)pathsToProcess[i].getLastPathComponent()).whiteboardPeer();
                if (node instanceof ScreenRoot && node.getRealScreenCount() == 0) {
                    emptyRootList.add(node);
                    continue;
                }
                nonEmptyRootList.add(node);
            }
            ScreenModel[] emptyRootScreens = new ScreenModel[emptyRootList.size()];
            emptyRootScreens = emptyRootList.toArray(emptyRootScreens);
            ScreenModel[] nonEmptyRootScreens = new ScreenModel[nonEmptyRootList.size()];
            nonEmptyRootScreens = nonEmptyRootList.toArray(nonEmptyRootScreens);
            if (insertRelationship == 8) {
                fixedScreens = nonEmptyRootScreens;
            } else if (replace) {
                fixedScreens = ActionUtilities.removeScreenRoots((ScreenModel[])nonEmptyRootScreens, (boolean)replace, (WhiteboardContext)context);
                allRootsReplaced = FileUtils.willReplaceAll(fixedScreens, context);
            } else {
                fixedScreens = nonEmptyRootScreens;
                block9: for (int i = 0; i < fixedScreens.length; ++i) {
                    if (!(fixedScreens[i] instanceof ScreenRoot)) continue;
                    switch (insertRelationship) {
                        case 1: {
                            fixedScreens[i] = fixedScreens[i].getLastScreen();
                            continue block9;
                        }
                        case 4: {
                            fixedScreens[i] = fixedScreens[i].getFirstScreen();
                            continue block9;
                        }
                    }
                }
            }
            for (j = 0; j < model.getChildCount(); j += 1) {
                screens[j] = (ScreenModel)model.getChildAt(j);
                screens[j].publishPresentersNotes();
            }
            if (watchingScreen != null && watchingScreen.getParent() != null) {
                pasteTargets = ActionUtilities.pasteScreens((ScreenModel[])fixedScreens, (WhiteboardContext)context, (int)insertRelationship, (ScreenModel[])screens);
                if (pasteTargets != null) {
                    pasteTargets.addAll(ActionUtilities.pasteScreens((ScreenModel[])emptyRootScreens, (WhiteboardContext)context, (int)8, (ScreenModel[])screens));
                }
            } else {
                context.getDataExporter().unblockCodecs();
                codecsBlocked = false;
                ModalDialog.showMessageDialog((Component)context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_CANNOTREPLACE, new Object[]{watchingScreen.getScreenName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.FILEUTILS_CANNOTREPLACETITLE), (int)0);
                j = 0;
                return j != 0;
            }
            if (replace && fixedScreens != null && fixedScreens.length > 0 && pasteTargets != null && !pasteTargets.isEmpty()) {
                Long uid;
                if (watchingScreen != null && ActionUtilities.isUIDInScreens((Long)(uid = watchingScreen.getObjectID()), (WBNode[])fixedScreens) != null) {
                    for (ScreenModel target2 : pasteTargets) {
                        if (watchingScreen.getRoot() != target2.getRoot()) continue;
                        context.getController().gotoUIScreen(target2.getObjectID(), false);
                        break;
                    }
                }
                DisplayUtilities.deleteScreens((WBNode[])fixedScreens, context);
            }
            ((WhiteboardBean)context.getBean()).setDocumentChanged(!allRootsReplaced);
        }
        finally {
            if (codecsBlocked) {
                context.getDataExporter().unblockCodecs();
            }
            model.delete();
        }
        if (context.getController() != null && proprietary) {
            context.getClientList().setProperty("whitebordProprietaryContent", true);
        }
        if (pasteTargets != null && pasteTargets.size() > 0) {
            Long gotoID = ((ScreenModel)pasteTargets.getFirst()).getObjectID();
            context.getController().gotoUIScreen(gotoID, false);
        }
        return true;
    }

    public static final File removeKnownExtension(File file, AbstractWBFileFilter[] filterSet) {
        if (FileUtils.findFilterMatch(file, filterSet) == null) {
            return file;
        }
        String s = file.getName();
        int lastDotIndex = s.lastIndexOf(46);
        if (lastDotIndex - 1 < 0) {
            return file;
        }
        return new File(file.getParent(), s.substring(0, lastDotIndex));
    }

    public static AbstractWBFileFilter findFilterMatch(File fileToMatch, AbstractWBFileFilter[] filterSet) {
        if (fileToMatch != null) {
            for (int i = 0; i < filterSet.length; ++i) {
                if (!filterSet[i].accept(fileToMatch)) continue;
                return filterSet[i];
            }
        }
        return null;
    }

    private static boolean willReplaceAll(ScreenModel[] screens, WhiteboardContext context) {
        boolean publicScreensAffected = false;
        boolean privateScreensAffected = false;
        int publicRootChildren = 0;
        int privateRootChildren = 0;
        for (int i = 0; i < screens.length; ++i) {
            if (screens[i].isPrivate()) {
                privateScreensAffected |= true;
                if (!(screens[i].getScreenParent() instanceof ScreenRoot)) continue;
                ++privateRootChildren;
                continue;
            }
            publicScreensAffected |= true;
            if (!(screens[i].getScreenParent() instanceof ScreenRoot)) continue;
            ++publicRootChildren;
        }
        boolean allRootsReplaced = false;
        if (publicScreensAffected && context.getDataModel().getPublicScreens() != null) {
            allRootsReplaced |= context.getDataModel().getPublicScreens().getScreenCount() != publicRootChildren;
        }
        if (privateScreensAffected && context.getDataModel().getPrivateScreens() != null) {
            allRootsReplaced |= context.getDataModel().getPrivateScreens().getScreenCount() != publicRootChildren;
        }
        return allRootsReplaced;
    }

    private static AbstractWBFileFilter selectFilter(File fileToMatch, AbstractWBFileFilter[] filterSet) {
        AbstractWBFileFilter filter = FileUtils.findFilterMatch(fileToMatch, filterSet);
        if (filter != null) {
            return filter;
        }
        for (int i = 0; i < filterSet.length; ++i) {
            if (!(filterSet[i] instanceof WhiteboardWBDFileFilter) && !(filterSet[i] instanceof WhiteboardWBPFileFilter)) continue;
            return filterSet[i];
        }
        return null;
    }
}

