/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.groupware.whiteboard.conference.GroupManager;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class AbstractWhiteboardCommand
extends AbstractCommand {
    public static final String PARENT_CHILD_SEPARATOR = ":";
    @Inject
    private WhiteboardModule whiteboardModule;

    protected WhiteboardBean getWhiteboardBean() {
        return this.whiteboardModule != null ? this.whiteboardModule.getWhiteboardBean() : null;
    }

    public ScreenModel findScreenInMainGroup(String screenKey, boolean rootSearch, boolean searchChildren) {
        ScreenModel currentScreen = null;
        WhiteboardBean bean = this.getWhiteboardBean();
        GroupManager.GroupInfo grp = bean.getContext().getGroupManager().getGroupInfo(GroupManager.MAIN_GROUP_ID);
        try {
            currentScreen = (ScreenModel)bean.getContext().getObjectManager().getObjectFromMap(grp.getScreenUID());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (screenKey == null || screenKey.length() == 0) {
            return currentScreen;
        }
        ScreenRoot rootScreen = null;
        if (rootSearch) {
            rootScreen = bean.getContext().getDataModel().getPublicScreens();
        } else if (currentScreen != null) {
            rootScreen = currentScreen.getScreenParent();
        }
        return this.findScreen(screenKey, null, (ScreenModel)rootScreen, searchChildren);
    }

    public ScreenModel findScreenInCurrentGroup(String screenKey, boolean rootSearch, boolean searchChildren) {
        WhiteboardBean bean = this.getWhiteboardBean();
        ScreenModel currentScreen = bean.getContext().getController().getScreen();
        if (screenKey == null || screenKey.length() == 0) {
            return currentScreen;
        }
        ScreenModel rootScreen = rootSearch ? currentScreen.getRoot() : currentScreen.getScreenParent();
        return this.findScreen(screenKey, currentScreen, rootScreen, searchChildren);
    }

    private ScreenModel findScreen(String screenKey, ScreenModel fromScreen, ScreenModel rootScreen, boolean searchChildren) {
        if (rootScreen == null) {
            return null;
        }
        try {
            ArrayList<ArrayList<String>> possibilities = this.getTokenPossibilities(screenKey);
            for (int i = 0; i < possibilities.size(); ++i) {
                ArrayList<String> toks = possibilities.get(i);
                boolean recursive = searchChildren;
                if (toks.size() != 1) {
                    recursive = false;
                }
                ScreenModel scr = null;
                String key2 = null;
                for (String key2 : toks) {
                    scr = AbstractWhiteboardCommand.findScreenByName(rootScreen, fromScreen, key2, recursive);
                    if (scr == null) {
                        int index = 0;
                        try {
                            index = Integer.parseInt(key2) - 1;
                            scr = AbstractWhiteboardCommand.findScreenByIndex(rootScreen, index, recursive);
                        }
                        catch (NumberFormatException nfe) {
                            scr = null;
                        }
                    }
                    rootScreen = scr;
                }
                if (scr == null) continue;
                return scr;
            }
            return null;
        }
        catch (NullPointerException npe) {
            LogSupport.message((Object)((Object)this), (String)"findScreenInCurrentGroup", (String)"Caught null pointer exception, returning null from this method");
            return null;
        }
    }

    private ArrayList<ArrayList<String>> getTokenPossibilities(String key) {
        StringTokenizer toks = new StringTokenizer(key, PARENT_CHILD_SEPARATOR);
        if (toks == null || toks.countTokens() == 0) {
            return new ArrayList<ArrayList<String>>(0);
        }
        ArrayList<ArrayList<String>> container = new ArrayList<ArrayList<String>>();
        ArrayList<String> allDelimitersInName = new ArrayList<String>(1);
        allDelimitersInName.add(key);
        container.add(allDelimitersInName);
        int tokenCount = toks.countTokens();
        if (tokenCount == 1) {
            return container;
        }
        ArrayList<String> allDelimitersAsDelimiters = new ArrayList<String>(tokenCount);
        while (toks.hasMoreElements()) {
            allDelimitersAsDelimiters.add(toks.nextToken());
        }
        container.add(allDelimitersAsDelimiters);
        return container;
    }

    private static ScreenModel findScreenByName(ScreenModel parent, ScreenModel from, String screenName, boolean searchChildren) {
        ScreenModel scr;
        int i;
        int start = 0;
        if (from != null) {
            for (i = 0; i < parent.getScreenCount(); ++i) {
                if (parent.getScreenAt(i) != from) continue;
                start = i;
                break;
            }
        }
        for (i = start; i < parent.getScreenCount(); ++i) {
            if (!(parent.getScreenAt(i) instanceof ScreenModel)) continue;
            scr = (ScreenModel)parent.getScreenAt(i);
            if (scr.getScreenName().equalsIgnoreCase(screenName)) {
                return scr;
            }
            if (!searchChildren || (scr = AbstractWhiteboardCommand.findScreenByName(scr, from, screenName, searchChildren)) == null) continue;
            return scr;
        }
        if (start != 0) {
            for (i = 0; i < start; ++i) {
                if (!(parent.getScreenAt(i) instanceof ScreenModel)) continue;
                scr = (ScreenModel)parent.getScreenAt(i);
                if (scr.getScreenName().equalsIgnoreCase(screenName)) {
                    return scr;
                }
                if (!searchChildren || (scr = AbstractWhiteboardCommand.findScreenByName(scr, from, screenName, searchChildren)) == null) continue;
                return scr;
            }
        }
        return null;
    }

    private static ScreenModel findScreenByIndex(ScreenModel parent, int screenIndex, boolean searchChildren) {
        if (searchChildren) {
            return AbstractWhiteboardCommand.findScreenByFlatIndex((ScreenModel)parent, (FindData)new FindData((int)screenIndex)).screen;
        }
        if (screenIndex < parent.getScreenCount()) {
            return (ScreenModel)parent.getScreenAt(screenIndex);
        }
        return null;
    }

    private static FindData findScreenByFlatIndex(ScreenModel parent, FindData data) {
        for (int i = 0; i < parent.getScreenCount(); ++i) {
            if (!(parent.getScreenAt(i) instanceof ScreenModel)) continue;
            ScreenModel scr = (ScreenModel)parent.getScreenAt(i);
            if (data.index <= 0) {
                data.screen = scr;
                return data;
            }
            --data.index;
            if (scr.getScreenCount() == 0) continue;
            data = AbstractWhiteboardCommand.findScreenByFlatIndex(scr, data);
            if (data.screen == null) continue;
            return data;
        }
        return data;
    }

    private static class FindData {
        public int index;
        public ScreenModel screen;

        public FindData(int index) {
            this.index = index;
        }
    }
}

