/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.player.module;

import com.elluminate.groupware.player.PlayerDebug;
import com.elluminate.groupware.player.module.PlaybackSliderModel;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultPlaybackSliderModel
implements PlaybackSliderModel {
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private long duration = 0L;
    private long tBuffer = 0L;
    private long tPlaying = 0L;
    private long tDesired = 0L;
    private boolean adjusting = false;
    private boolean resyncing = false;
    private Logger log;
    private ListenerRegistry<ChangeListener> registry;

    @Inject
    public void initListenerRegistry(ListenerRegistry<ChangeListener> lr) {
        this.registry = lr;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    @Override
    public void setDuration(long millis) {
        if (PlayerDebug.PLAYBACK_SLIDER.show()) {
            this.log.message("setDuration: " + this.duration + " -> " + millis);
        }
        this.duration = millis;
        this.fireStateChanged();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public void setBufferedTime(long millis) {
        if (PlayerDebug.PLAYBACK_SLIDER.show()) {
            this.log.message("setBufferedTime: " + this.tBuffer + " -> " + millis);
        }
        this.tBuffer = millis;
        this.fireStateChanged();
    }

    @Override
    public long getBufferedTime() {
        return this.tBuffer;
    }

    @Override
    public void setPlayingTime(long millis) {
        if (this.resyncing && this.tPlaying <= this.tDesired && millis >= this.tDesired) {
            this.resyncing = false;
        }
        this.tPlaying = millis;
        if (!this.resyncing) {
            this.tDesired = millis;
        }
        if (PlayerDebug.PLAYBACK_SLIDER.show()) {
            this.log.message("setPlayingTime: playing[" + this.tPlaying + "] " + "resynching[" + this.resyncing + "] desired[" + this.tDesired + "]");
        }
        this.fireStateChanged();
    }

    @Override
    public long getPlayingTime() {
        return this.tPlaying;
    }

    @Override
    public void setDesiredTime(long millis) {
        this.tDesired = millis;
        boolean bl = this.resyncing = this.tDesired != this.tPlaying;
        if (PlayerDebug.PLAYBACK_SLIDER.show()) {
            this.log.message("setDesiredTime: desired[" + this.tDesired + "] resynching[" + this.resyncing + "]");
        }
        this.fireStateChanged();
    }

    @Override
    public long getDesiredTime() {
        return this.tDesired;
    }

    @Override
    public void setAdjusting(boolean moving) {
        this.adjusting = moving;
        if (PlayerDebug.PLAYBACK_SLIDER.show()) {
            this.log.message("setAdjusting [" + this.adjusting + "]");
        }
        this.fireStateChanged();
    }

    @Override
    public boolean isAdjusting() {
        return this.adjusting;
    }

    @Override
    public boolean isSynchronized() {
        return !this.resyncing;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (l != null) {
            this.registry.add((Object)l);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        if (l != null) {
            this.registry.remove((Object)l);
        }
    }

    protected void fireStateChanged() {
        this.registry.fire((FiringFunctor)new FiringFunctor<ChangeListener>(){

            public void fire(ChangeListener listener) {
                listener.stateChanged(DefaultPlaybackSliderModel.this.changeEvent);
            }
        });
    }
}

