/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.util.event.Operation;
import com.elluminate.util.event.OperationProgressException;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SaveAgendaOperation
extends Operation {
    private File file;

    public SaveAgendaOperation(Agenda agenda, String name) {
        this(agenda, null, null);
    }

    public SaveAgendaOperation(Agenda agenda, File file, String name) {
        super((Object)agenda, name, (long)(agenda.getFileCount() + 1));
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void perform() throws OperationProgressException {
        File f = null;
        try {
            Agenda ag = (Agenda)this.getObject();
            ZipOutputStream out = null;
            try {
                int step = 1;
                File file = this.file;
                if (file == null) {
                    file = ag.getFile();
                }
                f = AgendaUtils.createSaveFile(file);
                out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
                this.checkCanceled();
                this.setProgressSize(step++);
                ZipEntry en = new ZipEntry("Agenda.ead");
                out.putNextEntry(en);
                ag.writeDefinition(out);
                out.closeEntry();
                this.checkCanceled();
                for (int i = 0; i < ag.getFileCount(); ++i) {
                    this.setProgressSize(step++);
                    AgendaFile af = ag.getFile(i);
                    en = new ZipEntry("Files/" + new File(af.getPath()).getName());
                    out.putNextEntry(en);
                    Agenda.writeFile(out, af);
                    out.closeEntry();
                    this.checkCanceled();
                }
                out.finish();
                this.setProgressSize(100L);
                this.checkCanceled();
            }
            catch (IOException ex) {
                LogSupport.error((Object)((Object)this), (String)"perform", (String)ex.getMessage());
                throw new OperationProgressException(ex.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {}
                }
            }
            if (this.file.exists() && !this.file.delete()) {
                throw new OperationProgressException("Could not delete original file for replacement");
            }
            if (!f.renameTo(this.file)) {
                throw new OperationProgressException("Could not rename temporary file to original file");
            }
            ag.setFile(this.file);
            ag.setModified(false);
        }
        finally {
            if (f != null && f.exists()) {
                f.delete();
            }
        }
    }
}

