/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.util.event.Operation;
import com.elluminate.util.event.OperationCanceledException;
import com.elluminate.util.event.OperationProgressException;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LoadAgendaOperation
extends Operation {
    public LoadAgendaOperation(Agenda agenda, String name) {
        super((Object)agenda, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void perform() throws OperationProgressException {
        Agenda ag = (Agenda)this.getObject();
        if (ag.isLoaded()) {
            return;
        }
        File cache = null;
        try {
            String name = AgendaUtils.filterFileName(ag.getName());
            cache = AgendaUtils.createTempDirectory("plan-" + name);
            cache.deleteOnExit();
            this.checkCanceled();
            File file = ag.getFile();
            if (file != null) {
                ag.readDefinitionFromFile();
                this.checkCanceled();
                ZipFile zf = null;
                BufferedInputStream in = null;
                try {
                    zf = new ZipFile(file, 1);
                    File filesCache = new File(cache, "Files");
                    if (!filesCache.exists()) {
                        filesCache.mkdir();
                        filesCache.deleteOnExit();
                    }
                    AgendaFile[] files = ag.getFiles();
                    this.setSize(files.length);
                    for (int i = 0; i < files.length; ++i) {
                        AgendaFile af = files[i];
                        this.setProgressSize(i + 1);
                        this.checkCanceled();
                        ZipEntry e = zf.getEntry("Files/" + af.getPath());
                        if (e == null) {
                            ag.removeFile(af);
                            continue;
                        }
                        in = new BufferedInputStream(zf.getInputStream(e));
                        File f = new File(filesCache, af.getPath());
                        Agenda.readFile(in, f);
                        f.deleteOnExit();
                        af.setPath(f.getAbsolutePath());
                        af.setSize(f.length());
                        in.close();
                        in = null;
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {}
                    }
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                this.checkCanceled();
            }
            ag.setCache(cache);
            ag.setLoaded(true);
            ag.setModified(false);
        }
        catch (OperationCanceledException ex) {
            if (cache != null && cache.exists()) {
                AgendaUtils.deleteRecursively(cache);
            }
            throw ex;
        }
        catch (IOException ex) {
            if (cache != null && cache.exists()) {
                AgendaUtils.deleteRecursively(cache);
            }
            LogSupport.error((Object)((Object)this), (String)"perform", (String)ex.getMessage());
            throw new OperationProgressException(ex.getMessage());
        }
    }
}

