/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaNode;
import java.util.ArrayList;

public class AgendaTopic
extends AgendaNode {
    private String name;
    private String note = Agenda.TOPIC_NOTE_DEFAULT;
    private ArrayList nodes = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCovered(boolean covered) {
        if (this.covered != covered) {
            ArrayList arrayList = this.nodes;
            synchronized (arrayList) {
                for (AgendaNode node : this.nodes) {
                    if (node.isCovered() == covered) continue;
                    node.setCovered(covered);
                }
            }
            this.setCoveredInternal(covered);
        }
    }

    private void setCoveredInternal(boolean covered) {
        this.covered = covered;
        this.changeItemNotify(this, "covered");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null && this.name != name || !this.name.equals(name)) {
            this.name = name;
            this.changeItemNotify(this, "name");
        }
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        if (this.note == null && this.note != note || !this.note.equals(note)) {
            this.note = note;
            this.changeItemNotify(this, "note");
        }
    }

    public void addNode(AgendaNode node) {
        this.addNode(node, -1);
    }

    public void addNode(AgendaNode node, int index) {
        if (node.parent != null) {
            node.removeFromParent();
        }
        node.parent = this;
        if (index >= 0) {
            this.nodes.add(index, node);
        } else {
            this.nodes.add(node);
        }
        this.addItemNotify(node, index);
    }

    public void removeNode(AgendaNode node) {
        if (this.nodes.remove(node)) {
            this.removeItemNotify(node);
        }
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public AgendaNode getNode(int index) {
        return (AgendaNode)this.nodes.get(index);
    }

    public int getNodeIndex(AgendaNode node) {
        return this.nodes.indexOf(node);
    }

    public synchronized AgendaNode[] getNodes() {
        ArrayList<AgendaNode> list = new ArrayList<AgendaNode>();
        for (AgendaNode node : this.nodes) {
            list.add(node);
        }
        return list.toArray(new AgendaNode[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void changeItemNotify(AgendaItem item, String property) {
        super.changeItemNotify(item, property);
        if (item != this && property.equals("covered")) {
            boolean covered = true;
            ArrayList arrayList = this.nodes;
            synchronized (arrayList) {
                for (AgendaNode node : this.nodes) {
                    if (node.isCovered()) continue;
                    covered = false;
                    break;
                }
            }
            if (this.covered != covered) {
                this.setCoveredInternal(covered);
            }
        }
    }

    @Override
    protected String paramString() {
        StringBuffer b = new StringBuffer();
        b.append(super.paramString());
        b.append(",name=");
        b.append(this.name);
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        AgendaTopic cl = (AgendaTopic)super.clone();
        cl.nodes = new ArrayList();
        ArrayList arrayList = this.nodes;
        synchronized (arrayList) {
            for (AgendaNode node : this.nodes) {
                cl.addNode((AgendaNode)node.clone());
            }
        }
        return cl;
    }
}

