/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.AgendaResponder;
import com.elluminate.groupware.agenda.AgendaText;
import com.elluminate.groupware.agenda.AgendaTopic;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;

public class AgendaProtocol
extends JinxProtocolAdapter {
    public static final String CHANNEL = "agenda";
    public static final byte PRIORITY = 4;
    public static final String VIEWABILITY_PROPERTY = "agenda.viewability";
    public static final byte VIEWABILITY_MODERATORS = 1;
    public static final byte VIEWABILITY_EVERYONE = 2;
    public static final byte VIEWABILITY_DEFAULT = 1;
    public static final String PRESENTER_PROPERTY = "agenda.presenter";
    public static final String PROTECTED_PROPERTY = "agenda.protected";
    public static final boolean PROTECTED_DEFAULT = false;
    public static final byte CMD_ERROR = 0;
    public static final byte CMD_NEW_AGENDA = 1;
    public static final byte CMD_CHANGE_AGENDA = 2;
    public static final byte CMD_DELETE_AGENDA = 3;
    public static final byte CMD_NEW_ITEM = 4;
    public static final byte CMD_CHANGE_ITEM = 5;
    public static final byte CMD_DELETE_ITEM = 6;
    public static final byte CMD_UPLOAD_AGENDA = 7;
    public static final byte CMD_DOWNLOAD_AGENDA = 8;
    public static final byte CMD_RELEASE_DEFINITION = 10;
    public static final byte CMD_ACTIVATE_AGENDA = 11;
    public static final byte CMD_DEACTIVATE_AGENDA = 12;
    public static final byte CMD_AUTOLOAD_AGENDA = 13;
    public static final byte CMD_REQUEST_EDIT_AGENDA = 14;
    public static final byte CMD_RESPOND_EDIT_AGENDA = 15;
    public static final byte CMD_EDIT_AGENDA = 16;
    public static final byte CMD_START_TIMER = 17;
    public static final byte CMD_STOP_TIMER = 18;
    public static final byte CMD_DOWNLOAD_FILE = 19;
    public static final byte CMD_DOWNLOAD_DEFINITION = 20;
    public static final byte MSG_TRANSFER_REQUEST = 1;
    public static final byte MSG_TRANSFER_ID = 2;
    public static final byte MSG_TRANSFER_DATA = 3;
    public static final byte MSG_TRANSFER_ACK = 4;
    public static final byte MSG_TRANSFER_COMPLETE = 5;
    public static final byte MSG_TRANSFER_CANCEL = 6;

    public AgendaProtocol() {
        this.defineChannel(CHANNEL, (byte)4);
        this.defineProperty(VIEWABILITY_PROPERTY, (byte)1, Bytes.get((byte)1));
        this.defineProperty(PRESENTER_PROPERTY, (byte)1, ShortList.get((short)-32767));
        this.defineProperty(PROTECTED_PROPERTY, (byte)1, new Boolean(false));
    }

    public ProtocolResponder getResponder() {
        return new AgendaResponder(this);
    }

    public String messageToString(byte command, DataInputStream inputStream) {
        String msg = this.commandToString(command);
        switch (command) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
        }
        return msg;
    }

    public String commandToString(byte command) {
        switch (command) {
            case 1: {
                return "NewAgenda";
            }
            case 2: {
                return "ChangeAgenda";
            }
            case 3: {
                return "DeleteAgenda";
            }
            case 4: {
                return "NewItem";
            }
            case 5: {
                return "ChangeItem";
            }
            case 6: {
                return "DeleteItem";
            }
            case 7: {
                return "UploadAgenda";
            }
            case 8: {
                return "DownloadAgenda";
            }
            case 10: {
                return "ReleaseDefinition";
            }
            case 11: {
                return "ActivateAgenda";
            }
            case 12: {
                return "DeactivateAgenda";
            }
            case 13: {
                return "AutoloadAgenda";
            }
            case 14: {
                return "RequestEditAgenda";
            }
            case 15: {
                return "RespondEditAgenda";
            }
            case 16: {
                return "EditAgenda";
            }
            case 17: {
                return "StartTimer";
            }
            case 18: {
                return "StopTimer";
            }
            case 19: {
                return "DownloadFile";
            }
            case 20: {
                return "DownloadDefinition";
            }
        }
        return "Unknown command: " + command;
    }

    private static String[] parseParameterName(String parameter) {
        int pos = parameter.indexOf(":");
        if (pos == -1 || pos == parameter.length() - 1) {
            return null;
        }
        String prop = parameter.substring(0, pos);
        String param = parameter.substring(pos + 1);
        return new String[]{prop, param};
    }

    public static String formatParameterName(String property, String parameter) {
        return property + ":" + parameter;
    }

    public static String[] parseProperty(String property) {
        int pos = property.indexOf("=");
        if (pos != -1) {
            String name = null;
            if (pos > 0) {
                name = property.substring(0, pos);
            }
            String value = null;
            if (pos < property.length() - 1) {
                value = property.substring(pos + 1);
            }
            if (name != null && value != null) {
                return new String[]{name, value};
            }
        }
        return null;
    }

    public static String formatProperty(Agenda agenda, String property) {
        return AgendaProtocol.formatProperty(property, AgendaProtocol.getProperty(agenda, property));
    }

    public static String formatProperty(AgendaItem item, String property) {
        return AgendaProtocol.formatProperty(property, AgendaProtocol.getProperty(item, property));
    }

    public static String formatProperty(String name, String value) {
        return name + "=" + value;
    }

    public static String getProperty(Agenda agenda, String name) {
        if (name.equals("filename")) {
            return agenda.getName();
        }
        if (name.equals("autotimetracking")) {
            return agenda.isTimeTrackingAutomatic() ? "true" : "false";
        }
        if (name.equals("labeltype")) {
            switch (agenda.getLabelType()) {
                case 6: {
                    return "uppercaseletter";
                }
                case 5: {
                    return "lowercaseletter";
                }
                case 4: {
                    return "legal";
                }
                case 3: {
                    return "number";
                }
                case 2: {
                    return "bullet";
                }
                case 1: {
                    return "leader";
                }
            }
            return "none";
        }
        if (name.equals("showicons")) {
            return agenda.isShowingIcons() ? "true" : "false";
        }
        if (name.equals("currentitem")) {
            AgendaNode cur = agenda.getCurrentNode();
            int id = cur != null ? cur.getID() : -1;
            return String.valueOf(id);
        }
        LogSupport.log(AgendaProtocol.class, (String)"getProperty", (String)("Unknown agenda property: " + name));
        return null;
    }

    public static String getProperty(AgendaItem item, String name) {
        if (item instanceof AgendaFile) {
            AgendaFile file = (AgendaFile)item;
            if (name.equals("autoload")) {
                return file.isAutoload() ? "true" : "false";
            }
            if (name.equals("command")) {
                return file.getCommandName();
            }
            if (name.equals("name")) {
                return file.getName();
            }
            if (name.equals("path")) {
                return file.getPath();
            }
            if (name.equals("size")) {
                return String.valueOf(file.getSize());
            }
            if (name.startsWith("parameter:")) {
                String[] pair = AgendaProtocol.parseParameterName(name);
                if (pair == null) {
                    LogSupport.log(AgendaProtocol.class, (String)"getProperty", (String)("Invalid file parameter name: " + name));
                    return null;
                }
                return file.getCommandParameter(pair[1]);
            }
            LogSupport.log(AgendaProtocol.class, (String)"getProperty", (String)("Unknown file property: " + name));
            return null;
        }
        if (item instanceof AgendaTopic) {
            AgendaTopic topic = (AgendaTopic)item;
            if (name.equals("covered")) {
                return topic.isCovered() ? "true" : "false";
            }
            if (name.equals("name")) {
                return topic.getName();
            }
            if (name.equals("note")) {
                return topic.getNote();
            }
            if (name.equals("duration")) {
                return String.valueOf(topic.getDuration());
            }
            LogSupport.log(AgendaProtocol.class, (String)"getProperty", (String)("Unknown topic property: " + name));
            return null;
        }
        if (item instanceof AgendaAction) {
            AgendaAction action = (AgendaAction)item;
            if (name.equals("command")) {
                return action.getCommandName();
            }
            if (name.equals("covered")) {
                return action.isCovered() ? "true" : "false";
            }
            if (name.equals("description")) {
                return action.getDescription();
            }
            if (name.equals("note")) {
                return action.getNote();
            }
            if (name.equals("duration")) {
                return String.valueOf(action.getDuration());
            }
            if (name.startsWith("parameter:")) {
                String[] pair = AgendaProtocol.parseParameterName(name);
                if (pair == null) {
                    LogSupport.log(AgendaProtocol.class, (String)"getProperty", (String)("Invalid action parameter name: " + name));
                    return null;
                }
                return action.getCommandParameter(pair[1]);
            }
            LogSupport.log(AgendaProtocol.class, (String)"getProperty", (String)("Unknown action property: " + name));
            return null;
        }
        if (item instanceof AgendaText) {
            AgendaText text = (AgendaText)item;
            if (name.equals("covered")) {
                return text.isCovered() ? "true" : "false";
            }
            if (name.equals("duration")) {
                return String.valueOf(text.getDuration());
            }
            if (name.equals("text")) {
                return text.getText();
            }
            LogSupport.log(AgendaProtocol.class, (String)"getProperty", (String)("Unknown text property: " + name));
            return null;
        }
        return null;
    }

    public static void setProperty(Agenda agenda, String name, String value) {
        if (name.equals("filename")) {
            agenda.setName(value);
        } else if (name.equals("autotimetracking")) {
            agenda.setTimeTrackingAutomatic(value.equals("true"));
        } else if (name.equals("labeltype")) {
            int type = value.equals("uppercaseletter") ? 6 : (value.equals("lowercaseletter") ? 5 : (value.equals("legal") ? 4 : (value.equals("number") ? 3 : (value.equals("bullet") ? 2 : (value.equals("leader") ? 1 : 0)))));
            agenda.setLabelType(type);
        } else if (name.equals("showicons")) {
            agenda.setShowingIcons(value.equals("true"));
        } else if (name.equals("currentitem")) {
            try {
                AgendaItem it;
                AgendaNode cur = null;
                int id = Integer.parseInt(value);
                if (id != -1 && (it = agenda.getItemByID(id)) instanceof AgendaNode) {
                    cur = (AgendaNode)it;
                }
                agenda.setCurrentNode(cur);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            LogSupport.log(AgendaProtocol.class, (String)"setProperty", (String)("Unknown agenda property: " + name));
        }
    }

    public static void setProperty(AgendaItem item, String name, String value) {
        if (item instanceof AgendaFile) {
            AgendaFile file = (AgendaFile)item;
            if (name.equals("autoload")) {
                file.setAutoload(value.equals("true"));
            } else if (name.equals("command")) {
                file.setCommandName(value);
            } else if (name.equals("name")) {
                file.setName(value);
            } else if (name.equals("path")) {
                file.setPath(value);
            } else if (name.equals("size")) {
                try {
                    file.setSize(Long.valueOf(value));
                }
                catch (NumberFormatException ex) {
                    LogSupport.error(AgendaProtocol.class, (String)"setProperty", (String)("Invalid file size: " + value));
                }
            } else if (name.startsWith("parameter:")) {
                String[] pair = AgendaProtocol.parseParameterName(name);
                if (pair == null) {
                    LogSupport.log(AgendaProtocol.class, (String)"setProperty", (String)("Invalid file parameter name: " + name));
                    return;
                }
                file.setCommandParameter(pair[1], value);
            } else {
                LogSupport.log(AgendaProtocol.class, (String)"setProperty", (String)("Unknown file property: " + name));
            }
        } else if (item instanceof AgendaTopic) {
            AgendaTopic topic = (AgendaTopic)item;
            if (name.equals("covered")) {
                topic.setCovered(value.equals("true"));
            } else if (name.equals("name")) {
                topic.setName(value);
            } else if (name.equals("note")) {
                topic.setNote(value);
            } else if (name.equals("duration")) {
                try {
                    topic.setDuration(Integer.parseInt(value));
                }
                catch (NumberFormatException ex) {
                    LogSupport.error(AgendaProtocol.class, (String)"setProperty", (String)("Invalid topic duration: " + value));
                }
            } else {
                LogSupport.log(AgendaProtocol.class, (String)"setProperty", (String)("Unknown topic property: " + name));
            }
        } else if (item instanceof AgendaAction) {
            AgendaAction action = (AgendaAction)item;
            if (name.equals("command")) {
                action.setCommandName(value);
            } else if (name.equals("covered")) {
                action.setCovered(value.equals("true"));
            } else if (name.equals("description")) {
                action.setDescription(value);
            } else if (name.equals("note")) {
                action.setNote(value);
            } else if (name.equals("duration")) {
                try {
                    action.setDuration(Integer.parseInt(value));
                }
                catch (NumberFormatException ex) {
                    LogSupport.error(AgendaProtocol.class, (String)"setProperty", (String)("Invalid action duration: " + value));
                }
            } else if (name.startsWith("parameter:")) {
                String[] pair = AgendaProtocol.parseParameterName(name);
                if (pair == null) {
                    LogSupport.log(AgendaProtocol.class, (String)"setProperty", (String)("Invalid action parameter name: " + name));
                    return;
                }
                action.setCommandParameter(pair[1], value);
            } else {
                LogSupport.log(AgendaProtocol.class, (String)"setProperty", (String)("Unknown action property: " + name));
            }
        } else if (item instanceof AgendaText) {
            AgendaText text = (AgendaText)item;
            if (name.equals("covered")) {
                text.setCovered(value.equals("true"));
            } else if (name.equals("duration")) {
                try {
                    text.setDuration(Integer.parseInt(value));
                }
                catch (NumberFormatException ex) {
                    LogSupport.error(AgendaProtocol.class, (String)"setProperty", (String)("Invalid text duration: " + value));
                }
            } else if (name.equals("text")) {
                text.setText(value);
            } else {
                LogSupport.log(AgendaProtocol.class, (String)"setProperty", (String)("Unknown text property: " + name));
            }
        }
    }
}

