/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NotesUtilities {
    private static final DateFormat legacyDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat convertedDateFormatter = new SimpleDateFormat("yyyy\\MM\\dd");

    public static Date parseDate(String date) {
        try {
            long theDate = Long.parseLong(date);
            return new Date(theDate);
        }
        catch (NumberFormatException pe) {
            return NotesUtilities.parseLegacyDate(date);
        }
    }

    private static Date parseLegacyDate(String legacyDate) {
        if (legacyDate == null) {
            return null;
        }
        try {
            return legacyDateFormatter.parse(legacyDate);
        }
        catch (ParseException ex) {
            try {
                legacyDate = legacyDate.replace('-', '\\');
                return convertedDateFormatter.parse(legacyDate);
            }
            catch (ParseException ex2) {
                return null;
            }
        }
    }

    public static String formatDate(Date date) {
        return Long.toString(date.getTime());
    }
}

