/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.NotesFontResize;
import com.elluminate.groupware.notes.module.StringsProperties;
import com.elluminate.groupware.notes.module.text.ResizeableText;
import com.elluminate.gui.swing.CMenu;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class NotesFontResizePopup
extends CPopupMenu {
    private static final long serialVersionUID = -6596922918801249112L;
    private static final I18n i18n = I18n.create(NotesFontResizePopup.class);
    private Icon checkMarkIcon = i18n.getIcon("NotesModule.checkIcon");
    private Icon blankIcon = i18n.getIcon("NotesModule.blankIcon");

    public NotesFontResizePopup(ResizeableText textResizer) {
        this.add(this.makeBiggerItem(textResizer));
        this.add(this.makeSmallerItem(textResizer));
        this.add(this.makeRestoreDefaultItem(textResizer));
        this.add(this.makeSizeMenu(textResizer));
    }

    private JMenuItem makeBiggerItem(final ResizeableText textResizer) {
        CMenuItem item = new CMenuItem(i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_MAKEBIGGER));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int ix = NotesFontResize.lookupNearestFontIndex(textResizer.getTextSize()) + 1;
                if (ix >= NotesFontResize.FONT_SIZE_STRINGS.length) {
                    ix = NotesFontResize.FONT_SIZE_STRINGS.length - 1;
                }
                textResizer.setTextSize(NotesFontResize.FONT_SIZE_STRINGS[ix]);
            }
        });
        return item;
    }

    private JMenuItem makeSmallerItem(final ResizeableText textResizer) {
        CMenuItem item = new CMenuItem(i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_MAKESMALLER));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int ix = NotesFontResize.lookupNearestFontIndex(textResizer.getTextSize()) - 1;
                if (ix < 0) {
                    ix = 0;
                }
                textResizer.setTextSize(NotesFontResize.FONT_SIZE_STRINGS[ix]);
            }
        });
        return item;
    }

    JMenuItem makeRestoreDefaultItem(final ResizeableText textResizer) {
        CMenuItem item = new CMenuItem(i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_RESTOREDEFAULT));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                textResizer.setDefaultTextSize();
            }
        });
        return item;
    }

    JMenu makeSizeMenu(final ResizeableText textResizer) {
        ActionListener act = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                textResizer.setTextSize(ev.getActionCommand());
            }
        };
        CMenu sizeMenu = new CMenu(i18n.getString((PropertiesEnum)StringsProperties.NOTESBEAN_FONTSIZE));
        for (int ix = 0; ix < NotesFontResize.FONT_SIZE_STRINGS.length; ++ix) {
            JMenuItem item = new JMenuItem(NotesFontResize.FONT_SIZE_STRINGS[ix]);
            item.setActionCommand(NotesFontResize.FONT_SIZE_STRINGS[ix]);
            item.addActionListener(act);
            sizeMenu.add(item);
        }
        SizeMenuListener pml = new SizeMenuListener((JMenu)sizeMenu, textResizer);
        sizeMenu.getPopupMenu().addPopupMenuListener(pml);
        return sizeMenu;
    }

    class SizeMenuListener
    implements PopupMenuListener {
        private JMenu sizeMenu;
        private ResizeableText textItem;

        public SizeMenuListener(JMenu sizeMenu, ResizeableText textItem) {
            this.sizeMenu = sizeMenu;
            this.textItem = textItem;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            for (int ix = 0; ix < this.sizeMenu.getItemCount(); ++ix) {
                JMenuItem item = this.sizeMenu.getItem(ix);
                try {
                    if (NotesFontResize.lookupFontSize(item.getText()) == this.textItem.getTextSize()) {
                        item.setIcon(NotesFontResizePopup.this.checkMarkIcon);
                        continue;
                    }
                    item.setIcon(NotesFontResizePopup.this.blankIcon);
                    continue;
                }
                catch (Throwable t) {
                    item.setIcon(NotesFontResizePopup.this.blankIcon);
                }
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

