/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.notes.module;

import com.elluminate.groupware.notes.module.Note;
import com.elluminate.util.image.ImageSupport;
import java.awt.Image;
import java.io.IOException;

class ImageNote
extends Note {
    public static final String IMAGE_PROPERTY = "image";
    private static final int PNG_COMPRESSION = 9;
    private static final int JPEG_COMPRESSION = 70;
    private Image image;

    public ImageNote(String contentType) {
        super(contentType);
        if (!contentType.startsWith("image/png") && !contentType.startsWith("image/jpeg")) {
            throw new IllegalArgumentException("unsupported content type: " + contentType);
        }
    }

    @Override
    public byte[] getData() throws IOException {
        String ctype = this.getContentType();
        if (ctype.startsWith("image/jpeg")) {
            return ImageSupport.encodeAsJPEG((Image)this.image, (int)70);
        }
        return ImageSupport.encodeAsPNG((Image)this.image, (int)9);
    }

    @Override
    public void setData(byte[] data) throws IOException {
        this.image = ImageSupport.loadImage((String)this.getContentType(), (byte[])data);
    }

    @Override
    public String getDataAsText() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.image == null;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image oldImage = this.image;
        this.image = image;
        this.changeSupport.firePropertyChange(IMAGE_PROPERTY, oldImage, image);
    }
}

