/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import java.awt.Container;

public abstract class FeatureAdapter
implements MetaDataListener {
    public static final String NAME_OVERRIDE_HINT = ".nameOverride";
    public static final String TIP_OVERRIDE_HINT = ".tooltipOverride";
    private Component component;
    private Container parent;
    private Feature feature;
    private String hintPrefix = null;
    private String nameOverride = null;
    private String tooltipOverride = null;

    protected FeatureAdapter() {
    }

    protected void init(String prefix, Feature feature, Component component, Container parent) {
        if (component == null) {
            throw new IllegalArgumentException("Component is null for " + feature.getPath());
        }
        this.feature = feature;
        this.component = component;
        this.parent = parent;
        this.hintPrefix = prefix;
        if (this.hintPrefix != null) {
            this.nameOverride = (String)feature.getHintValue(this.hintPrefix + NAME_OVERRIDE_HINT, String.class);
            this.tooltipOverride = (String)feature.getHintValue(this.hintPrefix + TIP_OVERRIDE_HINT, String.class);
        }
    }

    public abstract void dispose();

    public abstract void setHasToolTip(boolean var1);

    public abstract void setHasText(boolean var1);

    public Feature getFeature() {
        return this.feature;
    }

    public Component getComponent() {
        return this.component;
    }

    public Container getParent() {
        return this.parent;
    }

    public String getHintPrefix() {
        return this.hintPrefix;
    }

    public String getNameOverride() {
        return this.nameOverride;
    }

    public String getTooltipOverride() {
        return this.tooltipOverride;
    }

    public final void metaDataChanged(MetaDataEvent e) {
        SwingRunnerSupport.invokeLater((Runnable)new MetaDataRunner(this, e));
    }

    public void doMetaDataChanged(MetaDataEvent e) {
        throw new UnsupportedOperationException();
    }

    class MetaDataRunner
    implements Runnable {
        MetaDataEvent event;
        FeatureAdapter adapter;

        public MetaDataRunner(FeatureAdapter a, MetaDataEvent e) {
            this.adapter = a;
            this.event = e;
        }

        @Override
        public void run() {
            this.adapter.doMetaDataChanged(this.event);
        }
    }
}

