/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.location.DefaultMenuHandler;
import com.elluminate.framework.location.ParameterSource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;

public class DefaultMenuHandlerProvider {
    private Provider<DefaultMenuHandler> provider;

    @Inject
    public void initProvider(Provider<DefaultMenuHandler> prov) {
        this.provider = prov;
    }

    public DefaultMenuHandler get(String name, String location) {
        DefaultMenuHandler handler = (DefaultMenuHandler)this.provider.get();
        handler.setMenuAndLocation(name, location, -1);
        return handler;
    }

    public DefaultMenuHandler get(String name, String location, int mnemonic) {
        DefaultMenuHandler handler = (DefaultMenuHandler)this.provider.get();
        handler.setMenuAndLocation(name, location, mnemonic);
        return handler;
    }

    public DefaultMenuHandler get(String name, String location, Collection<ParameterSource<?>> sources) {
        return this.get(name, location, -1, sources);
    }

    public DefaultMenuHandler get(String name, String location, int mnemonic, Collection<ParameterSource<?>> sources) {
        DefaultMenuHandler handler = (DefaultMenuHandler)this.provider.get();
        handler.setMenuAndLocation(name, location, mnemonic);
        for (ParameterSource<?> src : sources) {
            handler.addParameterSource(src);
        }
        return handler;
    }
}

