/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.location.MenuFactory;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CMenu;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.gui.swing.CRadioButtonMenuItem;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class DefaultMenuFactory
implements MenuFactory {
    public static final String INVERSE_HINT = "menus.inverse";

    @Override
    public JMenu createMenu(String name) {
        return new CMenu(name);
    }

    @Override
    public JMenuItem createAction() {
        return new CMenuItem();
    }

    @Override
    public JCheckBoxMenuItem createCheckBox() {
        return new CCheckBoxMenuItem();
    }

    @Override
    public JRadioButtonMenuItem createRadioButton() {
        return new CRadioButtonMenuItem();
    }

    public JMenuItem createLabel() {
        return new CMenuItem();
    }

    @Override
    public JMenuItem createItem(Feature f) {
        if (f instanceof ActionFeature) {
            if (f.hasHint(INVERSE_HINT)) {
                return this.createCheckBox();
            }
            return this.createAction();
        }
        if (f instanceof BooleanFeature) {
            return this.createCheckBox();
        }
        if (f instanceof EnumeratedFeature) {
            return this.createMenu("");
        }
        if (f instanceof StringFeature) {
            return this.createLabel();
        }
        throw new IllegalArgumentException("Unsupported Feature type '" + f.getClass() + "'");
    }
}

