/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.location.CachedImageIcon;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.ImageSetter;
import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.gui.KeyBindingAdapter;
import com.elluminate.gui.Mnemonic;
import com.elluminate.platform.PlatformIssues;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class BooleanFeatureAdapter
extends FeatureAdapter
implements ActionListener {
    private static final String APP_SHORTCUT = "application.shortcut";
    private Provider<KeyBindingAdapter> keyBinding;
    private boolean text = false;
    private boolean icon = false;
    private boolean tips = false;
    private BooleanFeature feature;
    private AbstractButton button;
    private CachedImageIcon trueIcon;
    private CachedImageIcon falseIcon;
    private CachedImageIcon pressedIcon;
    private CachedImageIcon disabledTrueIcon;
    private CachedImageIcon disabledFalseIcon;
    private CachedImageIcon rolloverTrueIcon;
    private CachedImageIcon rolloverFalseIcon;

    protected BooleanFeatureAdapter() {
    }

    @Inject
    public void initKeyBindingAdapterProvider(Provider<KeyBindingAdapter> kbap) {
        this.keyBinding = kbap;
    }

    void init(String prefix, BooleanFeature feature, AbstractButton btn, Container parent) {
        super.init(prefix, (Feature)feature, btn, parent);
        this.button = btn;
        this.feature = feature;
        this.trueIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                BooleanFeatureAdapter.this.button.setSelectedIcon(i);
            }
        });
        this.falseIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                BooleanFeatureAdapter.this.button.setIcon(i);
            }
        });
        this.pressedIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                BooleanFeatureAdapter.this.button.setPressedIcon(i);
            }
        });
        this.disabledTrueIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                BooleanFeatureAdapter.this.button.setDisabledSelectedIcon(i);
            }
        });
        this.disabledFalseIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                BooleanFeatureAdapter.this.button.setDisabledIcon(i);
            }
        });
        this.rolloverTrueIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                BooleanFeatureAdapter.this.button.setRolloverSelectedIcon(i);
            }
        });
        this.rolloverFalseIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                BooleanFeatureAdapter.this.button.setRolloverIcon(i);
            }
        });
        this.button.setSelected((Boolean)feature.getValue());
        this.button.setEnabled(feature.isMutable() && feature.isEnabled());
        this.button.addActionListener(this);
        if (feature.hasHint(APP_SHORTCUT)) {
            AbstractAction absAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BooleanFeatureAdapter.this.button.doClick();
                }
            };
            String keystroke = (String)feature.getHintValue(APP_SHORTCUT, String.class);
            String path = feature.getPath().replaceAll("/", ".");
            String actionName = path + "_button.action." + this.button.hashCode();
            ((KeyBindingAdapter)this.keyBinding.get()).bind(actionName, absAction, keystroke);
        }
        feature.addMetaDataListener((MetaDataListener)this);
        this.setAccessibilityInfo();
    }

    private void setAccessibilityInfo() {
        String name = this.feature.getAccessibleName() != null ? this.feature.getAccessibleName() : this.feature.getName();
        String description = this.feature.getAccessibleDescription() != null ? this.feature.getAccessibleDescription() : this.feature.getDescription();
        AccessibilityUtils.setAccessibleInfo((Object)this.button, (String)name, (String)description);
    }

    @Override
    public void setHasText(boolean value) {
        if (this.text == value) {
            return;
        }
        this.text = value;
        if (this.text) {
            this.updateText();
        } else {
            this.getButton().setText(null);
        }
    }

    public void setHasIcon(boolean value) {
        if (this.icon == value) {
            return;
        }
        this.icon = value;
        if (this.icon) {
            this.updateIcons();
        } else {
            this.falseIcon.set(null);
            this.trueIcon.set(null);
            this.pressedIcon.set(null);
            this.disabledTrueIcon.set(null);
            this.disabledFalseIcon.set(null);
            this.rolloverTrueIcon.set(null);
            this.rolloverFalseIcon.set(null);
        }
    }

    @Override
    public void setHasToolTip(boolean value) {
        if (this.tips == value) {
            return;
        }
        this.tips = value;
        if (this.tips) {
            this.updateTip();
        } else {
            this.button.setToolTipText(null);
        }
    }

    public AbstractButton getButton() {
        return this.button;
    }

    public BooleanFeature getBooleanFeature() {
        return this.feature;
    }

    @Override
    public void dispose() {
        this.button.removeActionListener(this);
        this.feature.removeMetaDataListener((MetaDataListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS) {
            SwingRunnerSupport.invokeOnEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BooleanFeatureAdapter.this.doPerformAction();
                }
            });
        } else {
            this.doPerformAction();
        }
    }

    private void doPerformAction() {
        if (this.feature.isChangeRequestSupported()) {
            this.button.setSelected((Boolean)this.feature.getValue());
            this.feature.requestValue((Object)((Boolean)this.feature.getValue() == false ? 1 : 0));
        } else {
            this.feature.setValue((Object)((Boolean)this.feature.getValue() == false ? 1 : 0));
        }
    }

    private void updateText() {
        if (!this.text) {
            return;
        }
        String label = null;
        label = (Boolean)this.feature.getValue() != false ? this.feature.getTrueText() : this.feature.getFalseText();
        if (label == null) {
            label = this.feature.getName();
        }
        if (label == null) {
            if (this.button.getText() != null) {
                this.button.setText(null);
                this.button.getAccessibleContext().setAccessibleName(null);
            }
        } else if (!Mnemonic.getText((String)label).equals(this.button.getText())) {
            Mnemonic.setTextAndMnemonic((AbstractButton)this.button, (String)label);
            this.button.getAccessibleContext().setAccessibleName(Mnemonic.getText((String)label));
        }
    }

    private void updateIcons() {
        if (!this.icon) {
            return;
        }
        this.falseIcon.set(this.feature.getFalseIcon());
        this.trueIcon.set(this.feature.getTrueIcon());
        this.pressedIcon.set(this.feature.getPressedIcon());
        this.disabledTrueIcon.set(this.feature.getDisabledTrueIcon());
        this.disabledFalseIcon.set(this.feature.getDisabledFalseIcon());
        this.rolloverTrueIcon.set(this.feature.getRolloverTrueIcon());
        this.rolloverFalseIcon.set(this.feature.getRolloverFalseIcon());
    }

    private void updateTip() {
        String keystroke;
        if (!this.tips) {
            return;
        }
        String tooltip = this.getTooltipOverride();
        if (tooltip == null) {
            tooltip = this.feature.getDescription();
        }
        if ((keystroke = this.getBooleanFeature().getKeyStroke()) != null) {
            tooltip = tooltip != null ? tooltip + " (" + keystroke + ")" : keystroke;
        }
        this.button.setToolTipText(tooltip);
    }

    @Override
    public void doMetaDataChanged(MetaDataEvent e) {
        String id = e.getID();
        if (id.equals("ValueFeature.value")) {
            Boolean value = (Boolean)this.feature.getValue();
            this.button.setSelected(value);
            if (value.booleanValue()) {
                if (this.feature.hasHint("JAWSTrue")) {
                    String trueHintValue = (String)this.feature.getHintValue("JAWSTrue");
                    this.button.getAccessibleContext().firePropertyChange("AccessibleDescription", "", trueHintValue);
                }
            } else if (this.feature.hasHint("JAWSFalse")) {
                String falseHintValue = (String)this.feature.getHintValue("JAWSFalse");
                this.button.getAccessibleContext().firePropertyChange("AccessibleDescription", "", falseHintValue);
            }
            this.updateText();
        } else if (id.equals("Feature.enabled")) {
            this.button.setEnabled(this.feature.isMutable() && this.feature.isEnabled());
        } else if (this.icon && id.equals("BooleanFeature.falseIconImage")) {
            this.updateIcons();
        } else if (this.icon && id.equals("BooleanFeature.trueIconImage")) {
            this.updateIcons();
        } else if (this.icon && id.equals("BooleanFeature.pressedIconImage")) {
            this.updateIcons();
        } else if (this.icon && id.equals("BooleanFeature.disabledFalseIconImage")) {
            this.updateIcons();
        } else if (this.icon && id.equals("BooleanFeature.disabledTrueIconImage")) {
            this.updateIcons();
        } else if (this.icon && id.equals("BooleanFeature.rolloverFalseIconImage")) {
            this.updateIcons();
        } else if (this.icon && id.equals("BooleanFeature.rolloverTrueIconImage")) {
            this.updateIcons();
        } else if (this.text && id.equals("BooleanFeature.falseText")) {
            this.updateText();
        } else if (this.text && id.equals("BooleanFeature.trueText")) {
            this.updateText();
        } else if (this.text && id.equals("Feature.name")) {
            this.updateText();
        } else if (this.text && id.equals("Feature.accessibleName")) {
            this.button.getAccessibleContext().setAccessibleName(this.feature.getAccessibleName());
        } else if (this.tips && id.equals("Feature.description")) {
            this.updateTip();
        } else if (id.equals("Feature.accessibileDescription")) {
            this.button.getAccessibleContext().setAccessibleDescription(this.feature.getAccessibleDescription());
        } else if (id.equals("BooleanFeature.keystroke")) {
            this.updateTip();
        }
    }
}

