/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.hints.HintImage;
import com.elluminate.framework.location.CachedImageIcon;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.ImageSetter;
import com.elluminate.framework.location.ParameterSource;
import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.gui.KeyBindingAdapter;
import com.elluminate.platform.PlatformIssues;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class ActionFeatureAdapter
extends FeatureAdapter
implements ActionListener,
PropertyChangeListener {
    public static final String ICON_OVERRIDE_HINT = ".iconOverride";
    private static final String APP_SHORTCUT = "application.shortcut";
    private Provider<KeyBindingAdapter> keyBinding;
    private ActionFeature feature;
    private AbstractButton button;
    private boolean text = false;
    private boolean icon = false;
    private boolean tips = false;
    private HintImage iconOverride = null;
    private String nameOverride = null;
    private String tipOverride = null;
    private CachedImageIcon defaultIcon = null;
    private CachedImageIcon pressedIcon = null;
    private CachedImageIcon disabledIcon = null;
    private CachedImageIcon rolloverIcon = null;
    private String interactiveSubstitution = null;
    private Map<Class<?>, ParameterSource<?>> sources = new HashMap();

    @Inject
    public void initKeyBindingAdapterProvider(Provider<KeyBindingAdapter> kbap) {
        this.keyBinding = kbap;
    }

    void init(String prefix, ActionFeature af, AbstractButton btn, Container c) {
        super.init(prefix, (Feature)af, btn, c);
        this.button = btn;
        this.feature = af;
        this.button.addActionListener(this);
        this.checkEnabled();
        this.iconOverride = (HintImage)this.feature.getHintValue(this.getHintPrefix() + ICON_OVERRIDE_HINT, HintImage.class);
        this.nameOverride = this.getNameOverride();
        this.tipOverride = this.getTooltipOverride();
        this.defaultIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                ActionFeatureAdapter.this.button.setIcon(i);
            }
        });
        this.pressedIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                ActionFeatureAdapter.this.button.setPressedIcon(i);
            }
        });
        this.disabledIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                ActionFeatureAdapter.this.button.setDisabledIcon(i);
            }
        });
        this.rolloverIcon = new CachedImageIcon(new ImageSetter(){

            @Override
            public void setIcon(Icon i) {
                ActionFeatureAdapter.this.button.setRolloverIcon(i);
            }
        });
        this.feature.addMetaDataListener((MetaDataListener)this);
        if (this.feature.hasHint(APP_SHORTCUT)) {
            AbstractAction absAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionFeatureAdapter.this.button.doClick();
                }
            };
            String keystroke = (String)this.feature.getHintValue(APP_SHORTCUT, String.class);
            String path = this.feature.getPath().replaceAll("/", ".");
            String actionName = path + "_button.action." + this.button.hashCode();
            ((KeyBindingAdapter)this.keyBinding.get()).bind(actionName, absAction, keystroke);
        }
        this.checkParameters();
        this.setAccessibilityInfo();
    }

    private void setAccessibilityInfo() {
        String name = this.feature.getAccessibleName() != null ? this.feature.getAccessibleName() : this.feature.getName();
        String description = this.feature.getAccessibleDescription() != null ? this.feature.getAccessibleDescription() : this.feature.getDescription();
        AccessibilityUtils.setAccessibleInfo((Object)this.button, (String)name, (String)description);
    }

    void init(String prefix, Collection<ParameterSource<?>> srcList, ActionFeature af, AbstractButton btn, Container c) {
        for (ParameterSource<?> src : srcList) {
            this.sources.put(src.getParameterType(), src);
        }
        this.init(prefix, af, btn, c);
    }

    private void checkParameters() {
        if (!this.feature.hasParameters()) {
            return;
        }
        for (ActionParameterDescriptor desc : this.feature.getParameterList()) {
            ParameterSource<?> src = this.sources.get(desc.getImplementationType());
            if (src == null) {
                throw new IllegalArgumentException("Feature " + this.feature.getPath() + " requires parameters that are not available.");
            }
            src.addPropertyChangeListener(this);
        }
    }

    @Override
    public void dispose() {
        this.getButton().removeActionListener(this);
        this.getActionFeature().removeMetaDataListener((MetaDataListener)this);
        for (ParameterSource<?> src : this.sources.values()) {
            src.removePropertyChangeListener(this);
        }
    }

    public ActionFeature getActionFeature() {
        return this.feature;
    }

    public AbstractButton getButton() {
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS) {
            SwingRunnerSupport.invokeOnEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ActionFeatureAdapter.this.doPerformAction();
                }
            });
        } else {
            this.doPerformAction();
        }
    }

    private void doPerformAction() {
        if (this.feature.hasParameters()) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (String key : this.feature.getParameterKeys()) {
                ActionParameterDescriptor desc = this.feature.getParameterDescriptor(key);
                ParameterSource<?> src = this.sources.get(desc.getImplementationType());
                if (desc.isSingular()) {
                    parameters.put(key, src.getParameter());
                    continue;
                }
                parameters.put(key, src.getParameters());
            }
            this.feature.fireActionFeatureListeners(parameters);
        } else {
            this.feature.fireActionFeatureListeners();
        }
    }

    @Override
    public void setHasText(boolean value) {
        if (this.text == value) {
            return;
        }
        this.text = value;
        if (this.text) {
            this.setText();
        } else {
            this.button.setText(null);
        }
    }

    public void setInteractiveSubstitution(String format) {
        this.interactiveSubstitution = format;
    }

    public void setHasIcon(boolean value) {
        if (this.icon == value) {
            return;
        }
        this.icon = value;
        if (this.icon) {
            this.setIcon();
        } else {
            this.button.setIcon(null);
        }
    }

    @Override
    public void setHasToolTip(boolean value) {
        if (this.tips == value) {
            return;
        }
        this.tips = value;
        if (this.tips) {
            this.setTip();
        } else {
            this.button.setToolTipText(null);
        }
    }

    public void setText() {
        String name = this.nameOverride;
        if (name == null) {
            name = this.getActionFeature().getName();
        }
        if (this.interactiveSubstitution != null && this.getActionFeature().isInteractive()) {
            name = MessageFormat.format(this.interactiveSubstitution, name);
        }
        this.button.setText(name);
        this.setAccessibleName();
    }

    public void setIcon() {
        if (this.iconOverride != null) {
            this.defaultIcon.set(this.iconOverride.get());
        } else {
            this.defaultIcon.set(this.feature.getDefaultIcon());
            this.pressedIcon.set(this.feature.getPressedIcon());
            this.disabledIcon.set(this.feature.getDisabledIcon());
            this.rolloverIcon.set(this.feature.getRolloverIcon());
        }
    }

    public void setTip() {
        String keystroke;
        String tooltip = this.tipOverride;
        ActionFeature af = this.getActionFeature();
        if (this.tipOverride == null) {
            tooltip = af.getDescription();
        }
        if ((keystroke = af.getKeyStroke()) != null) {
            tooltip = tooltip != null ? tooltip + " (" + keystroke + ")" : keystroke;
        }
        this.button.setToolTipText(tooltip);
    }

    @Override
    public void doMetaDataChanged(MetaDataEvent e) {
        String id = e.getID();
        if (id.equals("Feature.enabled")) {
            this.checkEnabled();
        } else if (id.equals("Feature.name")) {
            if (this.text && this.nameOverride == null) {
                this.setText();
            }
        } else if (id.equals("Feature.accessibleName")) {
            this.setAccessibleName();
        } else if (id.equals("Action.dftIcon")) {
            if (this.icon && this.iconOverride == null) {
                this.setIcon();
            }
        } else if (id.equals("Action.pressedIcon")) {
            if (this.icon && this.iconOverride == null) {
                this.setIcon();
            }
        } else if (id.equals("Action.disabledIcon")) {
            if (this.icon && this.iconOverride == null) {
                this.setIcon();
            }
        } else if (id.equals("Action.rolloverIcon")) {
            if (this.icon && this.iconOverride == null) {
                this.setIcon();
            }
        } else if (id.equals("Feature.description")) {
            if (this.tips && this.tipOverride == null) {
                this.setTip();
            }
        } else if (id.equals("Feature.accessibileDescription")) {
            this.setAccessibleDescription();
        } else if (id.equals("Action.keystroke")) {
            this.setTip();
        }
    }

    private void setAccessibleName() {
        this.button.getAccessibleContext().setAccessibleName(this.feature.getAccessibleName());
    }

    private void setAccessibleDescription() {
        this.button.getAccessibleContext().setAccessibleDescription(this.feature.getAccessibleDescription());
    }

    private void checkEnabled() {
        boolean enabled = this.feature.isEnabled();
        if (enabled && this.feature.hasParameters()) {
            for (ActionParameterDescriptor desc : this.feature.getParameterList()) {
                ParameterSource<?> src = this.sources.get(desc.getImplementationType());
                int count = src.getParameterCount();
                if (count < desc.getMinCount()) {
                    enabled = false;
                    continue;
                }
                if (count <= desc.getMaxCount()) continue;
                enabled = false;
            }
        }
        this.button.setEnabled(enabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.checkEnabled();
    }
}

