/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.chat.Address;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyAccessAPI;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Chat {
    private Address from = null;
    private List<Address> addrs = new LinkedList<Address>();
    private String msg = null;
    private boolean announcement = false;
    private boolean broadcast = false;
    private boolean seen = false;
    private boolean included = false;
    private Date timestamp = null;
    private boolean moderatorsMessage = false;

    public boolean isSeen() {
        return this.seen;
    }

    public void setSeen(boolean isSeen) {
        this.seen = isSeen;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean isIncluded) {
        this.included = isIncluded;
    }

    private Address makeAddress(byte type, ClientInfo ci) {
        ClientList clients = ci.getClientList();
        Chair chair = ChairProtocol.getChair((ClientList)clients);
        boolean isChair = chair.contains(ci.getAddress());
        String role = isChair ? LabelProps.get((PropertyAccessAPI)clients, (String)"Label.Moderator") : "";
        return new Address(type, ci.getDisplayName(), role, isChair, ci.isMe(), ci.getAddress());
    }

    private Address makeAddress(byte type, CRParticipant p) {
        PropertyAccessAPI propStore = p.getSession().getPropertyStore();
        String role = p.isChair() ? LabelProps.get((PropertyAccessAPI)propStore, (String)"Label.Moderator") : "";
        return new Address(type, p.getDisplayName(), role, p.isChair(), p.isMe(), p.getClientInfo().getAddress());
    }

    public void addTo(ClientInfo ci) {
        this.addAddress(this.makeAddress((byte)3, ci));
    }

    public void addTo(CRParticipant p) {
        this.addAddress(this.makeAddress((byte)3, p));
    }

    public void addBCC(ClientInfo ci) {
        this.addAddress(this.makeAddress((byte)6, ci));
    }

    public void setFrom(ClientInfo ci) {
        this.from = ci != null ? this.makeAddress((byte)2, ci) : new Address(2, " Off Line", "", false, true);
    }

    public void addAllRooms() {
        this.addrs.clear();
        this.addrs.add(new Address(5, ""));
        this.broadcast = true;
    }

    public void addAll() {
        this.addrs.clear();
        this.addrs.add(new Address(4, ""));
        this.broadcast = true;
    }

    public void addAddress(Address addr) {
        switch (addr.getType()) {
            case 2: {
                this.from = addr;
                break;
            }
            case 5: {
                this.broadcast = true;
                this.addrs.add(addr);
                break;
            }
            case 4: {
                this.broadcast = true;
                this.addrs.add(addr);
                break;
            }
            case 7: {
                this.moderatorsMessage = true;
                this.addrs.add(addr);
                break;
            }
            default: {
                if (this.broadcast) {
                    return;
                }
                Address prev = this.findRecipient(addr.getName());
                if (prev == null) {
                    this.addrs.add(addr);
                    break;
                }
                if (prev.getType() != 6) break;
                prev.setType(addr.getType());
            }
        }
    }

    public Address getOriginator() {
        return this.from;
    }

    public Collection<Address> getRecipients() {
        return this.addrs;
    }

    public void setText(String text) {
        this.msg = text;
    }

    public String getText() {
        return this.msg;
    }

    public void setAnnouncement(boolean announcement) {
        this.announcement = announcement;
    }

    public boolean isAnnouncement() {
        return this.announcement;
    }

    public boolean isRecipient(String name) {
        Address addr = this.findRecipient(name);
        return addr != null;
    }

    public boolean isPrivate() {
        return !this.broadcast;
    }

    public boolean isToMe() {
        Address me = this.getMyRecipient();
        if (me == null) {
            return false;
        }
        return me.getType() == 3;
    }

    public boolean isFromMe() {
        Address origin = this.getOriginator();
        if (origin == null) {
            return false;
        }
        return origin.isMe();
    }

    public Address getMyRecipient() {
        for (Address addr : this.addrs) {
            if (!addr.isMe()) continue;
            return addr;
        }
        return null;
    }

    public Address findRecipient(String name) {
        for (Address addr : this.addrs) {
            if (!name.equals(addr.getName())) continue;
            return addr;
        }
        return null;
    }

    public void setTimestamp(Date when) {
        this.timestamp = when;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean isMonitor() {
        return this.getMyRecipient() != null && !this.getOriginator().isMe() && this.getMyRecipient().getType() == 6;
    }

    public boolean isModeratorsMessage() {
        return this.moderatorsMessage;
    }

    public void setModeratorsMessage(boolean moderatorsMessage) {
        this.moderatorsMessage = moderatorsMessage;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (this.announcement) {
            buf.append("announcement: ");
        }
        if (this.moderatorsMessage) {
            buf.append("to-all-moderators: ");
        }
        buf.append(this.from);
        buf.append("->");
        Iterator<Address> i = this.addrs.iterator();
        while (i.hasNext()) {
            buf.append(i.next());
            if (i.hasNext()) {
                buf.append(",");
                continue;
            }
            buf.append(") ");
        }
        buf.append(this.msg);
        return buf.toString();
    }
}

