/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.utils;

import com.elluminate.groupware.audio.resampler.Resampler;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.log.LogSupport;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileLoader {
    public static final DebugFlag LOADER = DebugFlag.get((String)"audio.loader.debug");
    private static final String RAW_DATA_EXTENSION = ".samples";

    public static short[] loadAudioFile(File f, float sampleRate) {
        short[] result = null;
        try {
            result = f.getName().endsWith(RAW_DATA_EXTENSION) ? AudioFileLoader.loadRawSamples(f) : AudioFileLoader.loadJavaSound(f.toURL(), sampleRate);
        }
        catch (Throwable t) {
            LogSupport.message(AudioFileLoader.class, (String)"loadAudioFile", (String)("Cannot load file " + f + ": " + t));
            result = null;
        }
        if (result != null && LOADER.show()) {
            LogSupport.message(AudioFileLoader.class, (String)"loadAudioFile", (String)("Loaded " + result.length + " samples, " + (float)result.length / sampleRate + " seconds"));
        }
        return result;
    }

    public static short[] loadAudioFile(URL url, float sampleRate) {
        short[] result = null;
        String name = url.getPath();
        try {
            result = name.endsWith(RAW_DATA_EXTENSION) ? AudioFileLoader.loadRawSamples(url) : AudioFileLoader.loadJavaSound(url, sampleRate);
        }
        catch (Throwable t) {
            LogSupport.message(AudioFileLoader.class, (String)"loadAudioFile", (String)("Cannot load URL " + url + ": " + t));
            result = null;
        }
        if (result != null && LOADER.show()) {
            LogSupport.message(AudioFileLoader.class, (String)"loadAudioFile", (String)("Loaded " + result.length + " samples, " + (float)result.length / sampleRate + " seconds "));
        }
        return result;
    }

    private static short[] loadJavaSound(URL url, float sampleRate) throws IOException, UnsupportedAudioFileException {
        float fileRate;
        byte[] data = null;
        short[] samples = null;
        String name = url.getFile();
        AudioFileFormat fileFmt = AudioSystem.getAudioFileFormat(url);
        if (LOADER.show()) {
            LogSupport.message(AudioFileLoader.class, (String)"loadJavaSound", (String)("Loading " + name + ": " + fileFmt));
        }
        if ((fileRate = fileFmt.getFormat().getSampleRate()) < 1000.0f) {
            LogSupport.message(AudioFileLoader.class, (String)"loadJavaSound", (String)("Invalid sample rate for " + name + ": " + fileRate + " Hz " + fileFmt));
            return null;
        }
        int nSamples = fileFmt.getFrameLength();
        if (nSamples <= 0) {
            LogSupport.message(AudioFileLoader.class, (String)"loadJavaSound", (String)("Failed to load any samples from " + name + " " + fileFmt));
            return null;
        }
        if (Math.abs(fileRate - sampleRate) / sampleRate < 0.05f) {
            if (LOADER.show() && (double)Math.abs(fileRate - sampleRate) > 1.0) {
                LogSupport.message(AudioFileLoader.class, (String)"loadJavaSound", (String)("Sample rate for file " + name + " " + fileRate + " Hz is within 5% of the playback rate. The audio " + " data will be time-shifted rather than resampled."));
            }
            fileRate = sampleRate;
        }
        AudioFormat origFmt = fileFmt.getFormat();
        AudioFormat fmt = new AudioFormat(origFmt.getEncoding(), fileRate, origFmt.getSampleSizeInBits(), origFmt.getChannels(), origFmt.getFrameSize(), fileRate, true);
        data = AudioFileLoader.readAudioData(url, fmt);
        nSamples = data.length / fmt.getFrameSize();
        samples = AudioFileLoader.convertAudioData(data, fmt, nSamples);
        if (fileRate != sampleRate) {
            samples = AudioFileLoader.resampleAudio(Math.round(fileRate), samples, nSamples, Math.round(sampleRate));
        }
        return samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readAudioData(URL url, AudioFormat fmt) throws IOException, UnsupportedAudioFileException {
        AudioInputStream rawStrm = null;
        AudioInputStream fmtStrm = null;
        byte[] data = null;
        try {
            rawStrm = AudioSystem.getAudioInputStream(url);
            fmtStrm = AudioSystem.getAudioInputStream(fmt, rawStrm);
            int frameSize = fmtStrm.getFormat().getFrameSize();
            int nFrames = (int)fmtStrm.getFrameLength();
            data = new byte[nFrames * frameSize];
            AudioFileLoader.readFully(fmtStrm, data);
        }
        finally {
            if (fmtStrm != null && fmtStrm != rawStrm) {
                try {
                    fmtStrm.close();
                }
                catch (Throwable ignored) {}
            }
            fmtStrm = null;
            if (rawStrm != null) {
                try {
                    rawStrm.close();
                }
                catch (Throwable ignored) {}
            }
            rawStrm = null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short[] convertAudioData(byte[] data, AudioFormat fmt, int nSamples) throws IOException {
        int ALAW_MASK = 65536;
        int ULAW_MASK = 131072;
        int SIGNED_PCM_MASK = 262144;
        int UNSIGNED_PCM_MASK = 524288;
        int FMT_ALAW_8 = 65544;
        int FMT_ULAW_8 = 131080;
        int FMT_SPCM_8 = 262152;
        int FMT_SPCM_16 = 262160;
        int FMT_SPCM_32 = 262176;
        int FMT_UPCM_8 = 524296;
        int FMT_UPCM_16 = 524304;
        ByteArrayInputStream byteStrm = null;
        FilterInputStream dataStrm = null;
        short[] samples = new short[nSamples];
        int nChannels = fmt.getChannels();
        int sampleFormat = fmt.getSampleSizeInBits();
        AudioFormat.Encoding encoding = fmt.getEncoding();
        if (AudioFormat.Encoding.ALAW.equals(encoding)) {
            sampleFormat |= 0x10000;
        } else if (AudioFormat.Encoding.ULAW.equals(encoding)) {
            sampleFormat |= 0x20000;
        } else if (AudioFormat.Encoding.PCM_SIGNED.equals(encoding)) {
            sampleFormat |= 0x40000;
        } else if (AudioFormat.Encoding.PCM_UNSIGNED.equals(encoding)) {
            sampleFormat |= 0x80000;
        }
        try {
            byteStrm = new ByteArrayInputStream(data);
            dataStrm = new DataInputStream(byteStrm);
            for (int ix = 0; ix < nSamples; ++ix) {
                int val = 0;
                block21: for (int cx = 0; cx < nChannels; ++cx) {
                    switch (sampleFormat) {
                        case 65544: {
                            val += AudioFileLoader.fromALAW(((DataInputStream)dataStrm).readUnsignedByte());
                            continue block21;
                        }
                        case 131080: {
                            val += AudioFileLoader.fromULAW(((DataInputStream)dataStrm).readUnsignedByte());
                            continue block21;
                        }
                        case 262152: {
                            val += ((DataInputStream)dataStrm).readByte() * 256;
                            continue block21;
                        }
                        case 262160: {
                            val += ((DataInputStream)dataStrm).readShort();
                            continue block21;
                        }
                        case 262176: {
                            val += ((DataInputStream)dataStrm).readInt() / 65536;
                            continue block21;
                        }
                        case 524296: {
                            val += (((DataInputStream)dataStrm).readUnsignedByte() - 128) * 256;
                            continue block21;
                        }
                        case 524304: {
                            val += ((DataInputStream)dataStrm).readUnsignedShort() - 32768;
                            continue block21;
                        }
                        default: {
                            throw new RuntimeException("Unsupported audio format: " + fmt);
                        }
                    }
                }
                samples[ix] = (short)((val + nChannels / 2) / nChannels);
            }
        }
        finally {
            if (dataStrm != null) {
                try {
                    dataStrm.close();
                }
                catch (Throwable ignored) {}
            }
            if (byteStrm != null) {
                try {
                    byteStrm.close();
                }
                catch (Throwable ignored) {}
            }
        }
        return samples;
    }

    private static int fromALAW(int aVal) {
        int tmp = ((aVal ^= 0x55) & 0xF) << 4;
        int seg = (aVal & 0x70) >> 4;
        switch (seg) {
            case 0: {
                tmp += 8;
                break;
            }
            case 1: {
                tmp += 264;
                break;
            }
            default: {
                tmp += 264;
                tmp <<= seg - 1;
            }
        }
        return (aVal & 0x80) != 0 ? tmp : -tmp;
    }

    private static int fromULAW(int uVal) {
        int complement = ~uVal;
        int tmp = ((complement & 0xF) << 3) + 132;
        return (complement & 0x80) != 0 ? 132 - tmp : (tmp <<= (complement & 0x70) >> 4) - 132;
    }

    private static short[] resampleAudio(int sourceRate, short[] source, int nSamples, int targetRate) {
        int nOutputSamples;
        int delay = sourceRate / 400;
        Resampler resampler = new Resampler(sourceRate, delay);
        int targetLength = (nSamples * targetRate + sourceRate - 1) / sourceRate;
        if (targetLength < 1) {
            return null;
        }
        short[] buffer = new short[nSamples + delay];
        short[] target = new short[targetLength + delay];
        System.arraycopy(source, 0, buffer, 0, nSamples);
        Arrays.fill(buffer, nSamples, source.length, (short)0);
        if (LOADER.show()) {
            LogSupport.message(AudioFileLoader.class, (String)"resampleAudio", (String)("Resampling " + nSamples + " @ " + sourceRate + " => " + targetLength + " @ " + targetRate));
        }
        if ((nOutputSamples = resampler.resample(buffer, 0, buffer.length, targetRate, target, 0)) < 1) {
            return null;
        }
        short[] result = new short[targetLength];
        System.arraycopy(target, delay, result, 0, targetLength);
        return result;
    }

    private static void readFully(InputStream strm, byte[] buf) throws IOException {
        int nRead;
        int totalRead = 0;
        for (int nToRead = buf.length; nToRead > 0; nToRead -= nRead) {
            nRead = strm.read(buf, totalRead, nToRead);
            if (nRead < 0) {
                throw new EOFException();
            }
            totalRead += nRead;
        }
    }

    private static short[] loadRawSamples(File f) throws IOException {
        return AudioFileLoader.loadRawSamples(new FileInputStream(f), (int)(f.length() / 2L));
    }

    private static short[] loadRawSamples(byte[] bytes) throws IOException {
        return AudioFileLoader.loadRawSamples(new ByteArrayInputStream(bytes), bytes.length / 2);
    }

    private static short[] loadRawSamples(URL url) throws IOException {
        URLConnection con = url.openConnection();
        return AudioFileLoader.loadRawSamples(con.getInputStream(), con.getContentLength() / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short[] loadRawSamples(InputStream is, int nSamples) throws IOException {
        short[] samples = new short[nSamples];
        DataInputStream dis = new DataInputStream(is);
        try {
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = dis.readShort();
            }
        }
        finally {
            dis.close();
        }
        return samples;
    }
}

