/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.resampler;

public class Complex {
    private double re;
    private double im;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double r) {
        this(r, 0.0);
    }

    public Complex(double r, double i) {
        this.re = r;
        this.im = i;
    }

    public void add(Complex addend) {
        this.re += addend.re;
        this.im += addend.im;
    }

    public void div(Complex divisor) {
        double scale = divisor.re * divisor.re + divisor.im * divisor.im;
        double qr = (this.re * divisor.re + this.im * divisor.im) / scale;
        double qi = (this.im * divisor.re - this.re * divisor.im) / scale;
        this.re = qr;
        this.im = qi;
    }

    public double imag() {
        return this.im;
    }

    public void mul(Complex multiplier) {
        double pr = this.re * multiplier.re - this.im * multiplier.im;
        double pi = this.re * multiplier.im + this.im * multiplier.re;
        this.re = pr;
        this.im = pi;
    }

    public double real() {
        return this.re;
    }

    public void set(double r) {
        this.re = r;
        this.im = 0.0;
    }

    public void set(double r, double i) {
        this.re = r;
        this.im = i;
    }

    public void set(Complex z) {
        this.re = z.re;
        this.im = z.im;
    }

    public void sub(Complex subtrahend) {
        this.re -= subtrahend.re;
        this.im -= subtrahend.im;
    }
}

