/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio;

import com.elluminate.groupware.PropertyACL;
import com.elluminate.groupware.audio.AudioResponder;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.PropertyAccessController;
import com.elluminate.jinx.ProtocolResponder;
import com.google.inject.Inject;
import java.io.DataInputStream;

public class AudioProtocol
extends JinxProtocolAdapter {
    public static final String CHANNEL = "audio";
    public static final byte PRIORITY = 0;
    public static final byte FLOOR_REQUEST = 1;
    public static final byte FLOOR_RELEASE = 2;
    public static final byte FLOOR_GRANT = 3;
    public static final byte FLOOR_REVOKE = 4;
    public static final byte STATUS_CHANGED = 5;
    public static final byte STATUS_ACK = 6;
    public static final byte STATUS_REQ = 7;
    public static final byte CHANGE_AUDIO_MODE = 8;
    public static final byte MINIMIZE_BANDWIDTH = 9;
    public static final byte MINIMIZE_LAG_TIME = 10;
    public static final byte QUERY_STATE = 11;
    public static final byte SPEAKING = 12;
    public static final byte SPEAKER = 13;
    public static final byte VOL_ACK = 16;
    public static final byte VOL_INC = 17;
    public static final byte VOL_DEC = 18;
    public static final byte AUDIO_DATA = 64;
    public static final String ACTIVE_PROPERTY = "audioActive";
    public static final String FLOOR_PROPERTY = "audioFloor";
    public static final String MAX_VOIP_TALKERS_PROPERTY = "audioMaxVOIPTalkers";
    public static final String BOOST_PEAK__RESTORE_PERCENT_LIMIT_PROPERTY = "audioBoostPeakRestorePercent";
    public static final String MAX_VOIP_TALKERS_LIMIT_PROPERTY = "audioMaxVOIPTalkersLimit";
    public static final String WEBRTC_COMPRESSION_GAIN_PROPERTY = "audioWebrtcCompressionGain";
    public static final String WEBRTC_TARGET_LEVEL_PROPERTY = "audioWebrtcTargetLevel";
    public static final String MILLIS_BETWEEN_BOOSTS_PROPERTY = "audioMillisBetweenBoosts";
    public static final String MIN_MILLIS_PER_PACKET_PROPERTY = "audioMinMillisPerPacket";
    public static final String MUTE_WHEN_TALKING_PROPERTY = "audioMuteWhenTalking";
    public static final String MUTE_THRESHOLD_PROPERTY = "audioMuteThreshold";
    public static final String NOISE_FLOOR_SAMPLE_PERIOD_PROPERTY = "audioNoiseFloorSamplePeriod";
    public static final String NONSILENCE_GAIN_BOOST_THRESHOLD_PROPERTY = "audioNonsilenceGainBoostThreshold";
    public static final String NONSILENCE_THRESHOLD_PROPERTY = "audioNonsilenceThreshold";
    public static final String RETAINED_SILENCE_LIMIT_PROPERTY = "audioRetainedSilenceLimit";
    public static final String SILENCE_SUSTAIN_LIMIT_PROPERTY = "audioSilenceSustainLimit";
    public static final String STATUS_RED_PROPERTY = "audioRedStatus";
    public static final String STATUS_YELLOW_PROPERTY = "audioYellowStatus";
    public static final String TALKER_SILENCE_LIMIT_PROPERTY = "audioTalkerSilenceLimit";
    public static final String SILENCE_SUSTAIN_LIMIT = "audioSilenceSustainLimit";
    public static final String TESTER_TALK_PROPERTY = "audioTesters";
    public static final String SETTING_UP_AUDIO_PROPERTY = "audioSettingUpAudio";
    public static final byte LARGE_BACKLOG = 4;
    public static final byte MEDIUM_BACKLOG = 2;
    public static final byte NO_BACKLOG = 0;
    public static final byte NOT_RESPONDING = 3;
    public static final byte SMALL_BACKLOG = 1;
    public static final byte CHANGE_TO_VOIP = 1;
    public static final byte CHANGE_TO_TELEPHONE = 2;
    private AudioResponder responder = null;

    public AudioProtocol() {
        this(false);
    }

    public AudioProtocol(boolean defaultAccess) {
        this.defineChannel(CHANNEL, (byte)0);
        this.defineProperty(ACTIVE_PROPERTY, (byte)0, Boolean.FALSE);
        this.defineProperty(FLOOR_PROPERTY, (byte)0, new Boolean(defaultAccess));
        this.defineProperty(MAX_VOIP_TALKERS_PROPERTY, (byte)1, new Integer(1));
        this.defineProperty(MAX_VOIP_TALKERS_LIMIT_PROPERTY, (byte)1, new Integer(6));
        this.defineProperty(WEBRTC_COMPRESSION_GAIN_PROPERTY, (byte)1, 5);
        this.defineProperty(WEBRTC_TARGET_LEVEL_PROPERTY, (byte)1, 6);
        this.defineProperty(MILLIS_BETWEEN_BOOSTS_PROPERTY, (byte)1, 200);
        this.defineProperty(MIN_MILLIS_PER_PACKET_PROPERTY, (byte)1, new Integer(20));
        this.defineProperty(MUTE_WHEN_TALKING_PROPERTY, (byte)0, Boolean.FALSE);
        this.defineProperty(NONSILENCE_GAIN_BOOST_THRESHOLD_PROPERTY, (byte)1, 1000);
        this.defineProperty(MUTE_THRESHOLD_PROPERTY, (byte)1, 10);
        this.defineProperty(BOOST_PEAK__RESTORE_PERCENT_LIMIT_PROPERTY, (byte)1, 50);
        this.defineProperty(NONSILENCE_THRESHOLD_PROPERTY, (byte)1, 2000);
        this.defineProperty(NOISE_FLOOR_SAMPLE_PERIOD_PROPERTY, (byte)1, 500);
        this.defineProperty(RETAINED_SILENCE_LIMIT_PROPERTY, (byte)1, 20);
        this.defineProperty("audioSilenceSustainLimit", (byte)1, 1500);
        this.defineProperty(TALKER_SILENCE_LIMIT_PROPERTY, (byte)1, 2);
        this.defineProperty(TESTER_TALK_PROPERTY, (byte)1, Boolean.FALSE);
        this.defineProperty(SETTING_UP_AUDIO_PROPERTY, (byte)0, Boolean.FALSE, (PropertyAccessController)PropertyACL.OwnerACL);
    }

    @Inject
    protected void initResponder(AudioResponder resp) {
        this.responder = resp;
    }

    public static String commandName(byte cmd) {
        switch (cmd) {
            case 1: {
                return "Floor Request";
            }
            case 2: {
                return "Floor Release";
            }
            case 3: {
                return "Floor Grant";
            }
            case 4: {
                return "Floor Revoke";
            }
            case 5: {
                return "Audio Status Changed";
            }
            case 6: {
                return "Audio Status Acknowledgement";
            }
            case 7: {
                return "Audio Status Request";
            }
            case 8: {
                return "Change Audio Mode";
            }
            case 9: {
                return "Minimize Bandwidth";
            }
            case 10: {
                return "Minimize Lag Time";
            }
            case 11: {
                return "Query State";
            }
            case 12: {
                return "Speaking";
            }
            case 13: {
                return "Speaker";
            }
            case 16: {
                return "Volumn Ack";
            }
            case 17: {
                return "Volume Increment";
            }
            case 18: {
                return "Volume Decrement";
            }
        }
        if (cmd > 64) {
            byte id = (byte)(cmd - 64);
            return "Sampled Audio Data (" + id + ")";
        }
        return "[ Unknown audio command - " + cmd + " ]";
    }

    public String commandToString(byte cmd) {
        return AudioProtocol.commandName(cmd);
    }

    public static String decodeStatus(int status) {
        switch (status) {
            case 4: {
                return "LARGE_BACKLOG";
            }
            case 2: {
                return "MEDIUM_BACKLOG";
            }
            case 0: {
                return "NO_BACKLOG";
            }
            case 1: {
                return "SMALL_BACKLOG";
            }
            case 3: {
                return "NOT_RESPONDING";
            }
        }
        return "Invalid#" + status;
    }

    public static String decodeAudioMode(byte mode) {
        switch (mode) {
            case 1: {
                return "VoIP";
            }
            case 2: {
                return "Telephone";
            }
        }
        return "Unknown mode 0x" + Integer.toHexString(mode & 0xFF);
    }

    public ProtocolResponder getResponder() {
        if (this.responder == null) {
            this.responder = new AudioResponder();
        }
        return this.responder;
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String msg = this.commandToString(cmd);
        try {
            switch (cmd) {
                case 1: 
                case 2: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 3: 
                case 4: 
                case 13: {
                    short who = str.readShort();
                    msg = msg + " - " + who;
                    break;
                }
                case 12: {
                    short ss = str.readShort();
                    msg = msg + " - signal strength " + ss;
                    break;
                }
                case 5: {
                    short count = str.readShort();
                    StringBuffer buf = new StringBuffer();
                    buf.append(msg + ": ");
                    for (short i = 0; i < count; i = (short)(i + 1)) {
                        buf.append("(" + str.readShort() + "=" + AudioProtocol.decodeStatus(str.readByte()) + ")");
                        if (i >= count - 1) continue;
                        buf.append(", ");
                    }
                    msg = buf.toString();
                    break;
                }
                case 8: {
                    byte mode = str.readByte();
                    msg = msg + " " + AudioProtocol.decodeAudioMode(mode);
                    break;
                }
                default: {
                    if (cmd > 64) {
                        msg = msg + " - " + str.available() + " bytes of compressed audio.";
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            msg = msg + " - [ Exception while decoding message - " + ex + " ]";
        }
        return msg;
    }
}

