/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.AppShareMessage;
import com.elluminate.groupware.appshare.AppShareMessageHandler;
import com.elluminate.util.StopWatchTimer;
import com.elluminate.util.log.LogSupport;

public final class ProtocolWindow {
    private static final int MODE_UNDEFINED = 0;
    private static final int MODE_OUTGOING = 1;
    private static final int MODE_INCOMING = -1;
    private static final float ACK_THRESHOLD = 0.5f;
    private int mode = 0;
    private volatile long bytes = 0L;
    private volatile long acked = 0L;
    private int window = 0;
    private int ackDelta = 0;
    private StopWatchTimer closeTimer = new StopWatchTimer();

    public final void reset(int size) {
        this.window = size;
        this.bytes = 0L;
        this.acked = 0L;
        this.ackDelta = (int)((float)size * 0.5f);
        this.closeTimer.reset();
    }

    public final void forceClose() {
        if (this.mode == 0) {
            this.mode = 1;
        } else if (this.mode != 1) {
            LogSupport.message((Object)this, (String)"transmit", (String)"Incoming window being closed!!!");
        }
        boolean wasOpen = this.isOpen();
        if (this.bytes < this.acked) {
            this.bytes = this.acked;
        }
        this.bytes += (long)(2 * this.window + 1);
        if (wasOpen) {
            this.closeTimer.start();
        }
    }

    public final void reopen(int size) {
        if (this.mode == 0) {
            this.mode = 1;
        } else if (this.mode != 1) {
            LogSupport.message((Object)this, (String)"transmit", (String)"Incoming window being reopened!!!");
        }
        boolean wasOpen = this.isOpen();
        this.bytes = this.acked;
        this.window = size;
        this.ackDelta = (int)((float)size * 0.5f);
        if (!wasOpen) {
            this.closeTimer.stop();
        }
    }

    public final void sync(short to, AppShareMessageHandler h, int size) {
        int span = (int)this.getSpan();
        AppShareMessage.ScreenDataAck ack = new AppShareMessage.ScreenDataAck(span);
        ack.send(to, h);
        this.acked += (long)span;
        if (size > 0) {
            this.window = size;
            this.ackDelta = (int)((float)size * 0.5f);
        }
    }

    public final int getSize() {
        return this.window;
    }

    public final int getDelta() {
        return this.ackDelta;
    }

    public final long getBytes() {
        return this.bytes;
    }

    public final long getAcked() {
        return this.acked;
    }

    public final long getSpan() {
        return this.bytes - this.acked;
    }

    public final int getAvail() {
        return (int)((long)this.window - (this.bytes - this.acked));
    }

    public final long getTimeClosed() {
        return this.closeTimer.getTotalTime();
    }

    public final long getCurrentTimeClosed() {
        return this.closeTimer.getElapsed();
    }

    public final boolean receive(AppShareMessage msg) {
        if (this.mode == 0) {
            this.mode = -1;
        } else if (this.mode != -1) {
            LogSupport.message((Object)this, (String)"receive", (String)"Window being used in both directions!!!");
        }
        this.bytes += (long)msg.getWindowLength();
        long span = this.getSpan();
        if (span > (long)this.ackDelta) {
            if (span > 65535L) {
                long count = (span + 65535L - 1L) / 65535L;
                LogSupport.message((Object)this, (String)"receive", (String)("Oversize ACK: " + span + ", partitioning by " + 65535 + " (" + count + " messages)"));
            }
            while (span > 0L) {
                long nToAck = span;
                if (nToAck > 65535L) {
                    nToAck = 65535L;
                }
                AppShareMessage.ScreenDataAck ack = new AppShareMessage.ScreenDataAck((int)nToAck);
                ack.send(msg.getSender(), msg.getHandler());
                this.acked += nToAck;
                span -= nToAck;
            }
            if (this.bytes - this.acked < 0L) {
                if (AppShareDebug.WINDOW.show()) {
                    LogSupport.message((Object)this, (String)"receive", (String)("ACK overrun: " + (this.acked - this.bytes) + " (ACKed " + this.acked + " of " + this.bytes + " received)"));
                }
                this.acked = this.bytes;
            }
            return true;
        }
        return false;
    }

    public final boolean transmit(AppShareMessage msg) {
        if (this.mode == 0) {
            this.mode = 1;
        } else if (this.mode != 1) {
            LogSupport.message((Object)this, (String)"transmit", (String)"Window being used in both directions!!!");
        }
        boolean wasOpen = this.isOpen();
        this.bytes += (long)msg.getWindowLength();
        boolean nowOpen = this.isOpen();
        if (wasOpen && !nowOpen) {
            this.closeTimer.start();
        }
        return nowOpen;
    }

    public final boolean acknowledge(AppShareMessage.ScreenDataAck msg) {
        if (this.mode == 0) {
            this.mode = 1;
        } else if (this.mode != 1) {
            LogSupport.message((Object)this, (String)"acknowledge", (String)"Window being used in both directions!!!");
        }
        boolean wasOpen = this.isOpen();
        this.acked += (long)msg.getBytes();
        if (this.bytes - this.acked < 0L) {
            if (AppShareDebug.WINDOW.show()) {
                LogSupport.message((Object)this, (String)"acknowledge", (String)("ACK overrun: " + (this.acked - this.bytes) + " (ACKed " + this.acked + " of " + this.bytes + " sent)"));
            }
            this.acked = this.bytes;
        }
        boolean nowOpen = this.isOpen();
        if (!wasOpen && nowOpen) {
            this.closeTimer.stop();
        }
        return nowOpen;
    }

    public final boolean isOpen() {
        return this.getSpan() < (long)this.window;
    }

    public final String toString() {
        return "ProtocolWindow [" + (this.isOpen() ? "open" : "closed") + ",window=" + this.window + ",mode=" + this.mode + ",span=" + this.getSpan() + ",sent=" + this.bytes + ",acked=" + this.acked + ",delta=" + this.ackDelta + ",closeTimer={" + this.closeTimer.getTotalTime() + "}]";
    }
}

