/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.profile;

import com.elluminate.groupware.profile.ImageDataProfileItem;
import com.elluminate.groupware.profile.ProfileItem;
import com.elluminate.groupware.profile.ProfileItemFactory;
import com.elluminate.groupware.profile.ProfileItemID;
import com.elluminate.groupware.profile.ProxyProfileItem;
import com.elluminate.groupware.profile.TextProfileItem;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;

public class DefaultProfileItemFactory
implements ProfileItemFactory {
    @Override
    public ProfileItem getInstance(Element e) throws JDOMException {
        Attribute a = e.getAttribute("mime");
        if (a == null) {
            return null;
        }
        try {
            if (a.getValue().equals("text/plain")) {
                return new TextProfileItem(e);
            }
            if (a.getValue().equals("image/jpeg")) {
                return new ImageDataProfileItem(e);
            }
        }
        catch (JDOMException jdomx) {
            LogSupport.error((Object)this, (String)"getInstance", (String)jdomx.toString());
        }
        return null;
    }

    @Override
    public ProfileItem getInstance(DataInputStream str) throws IOException {
        byte itemType = str.readByte();
        if (itemType == 0) {
            return null;
        }
        ProfileItemID id = ProfileItemID.read(str);
        if (itemType == 1) {
            return new TextProfileItem(id, str);
        }
        if (itemType == 2) {
            return new ImageDataProfileItem(id, str);
        }
        if (itemType == 3) {
            return new ProxyProfileItem(id, str);
        }
        return null;
    }

    @Override
    public ProfileItem getInstance(ProfileItemID id, String value) {
        return new TextProfileItem(id, value);
    }

    @Override
    public ProfileItem getInstance(ProfileItemID id, Image value) {
        return new ImageDataProfileItem(id, value);
    }

    @Override
    public ProfileItem getInstance(ProfileItemID id, byte[] img, String mime) {
        return new ImageDataProfileItem(id, img, mime);
    }

    protected ProfileItem getProxy(ProfileItemID id, DataInputStream str) throws IOException {
        return new ProxyProfileItem(id, str);
    }
}

