/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chair.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.chair.ChairDebug;
import com.elluminate.groupware.chair.LegacyChairSupport;
import com.elluminate.groupware.chair.module.ChairBean;
import com.elluminate.groupware.chair.module.StringsProperties;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

@Singleton
public class ChairModule
extends AbstractClientModule
implements PropertyChangeListener,
ParticipantSelectionListener,
ModulePublisherInfo {
    private static final I18n i18n = I18n.create(ChairModule.class);
    private static final String MODULE_NAME = "Chair";
    private static final Icon MODULE_ICON = i18n.getIcon((PropertiesEnum)StringsProperties.CHAIRMODULE_ICON);
    private ChairBean chairBean = null;
    private Client client = null;
    private ClientList clients = null;
    private String title = i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TITLE);
    private ParticipantSelectorAPI selector = null;
    private boolean recursive = false;
    private LegacyChairSupport legacySupport;
    private Imps imps;
    private ClientProvider clientProvider;
    private Provider<ChairBean> beanProvider;
    private DialogParentProvider parentProvider;
    private Logger logger;
    private ChairProtocol chairProtocol;
    private FeatureBroker broker;
    private BooleanFeature unlockedFeature;
    private ActionFeature giveFeature;
    private ActionFeature giveParameterizedFeature;
    private ActionFeature takeFeature;
    private ActionFeature takeParameterizedFeature;
    private ActionFeature removeFeature;
    private boolean updating;
    private static final String MODERATOR_GRANTED_NOTIFICATION = "/chair/moderatorGranted";

    @Inject
    public void initChairProtocol(ChairProtocol proto) {
        this.chairProtocol = proto;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initChairBeanProvider(Provider<ChairBean> provider) {
        this.beanProvider = provider;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initDialogParentProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    @Inject
    public ChairModule(ComponentRegistrar registrar, Logger logger) {
        registrar.registerComponent((Object)this);
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFeatures() {
        ChairProtocol chairProtocol = new ChairProtocol();
        boolean isChair = chairProtocol.fetchChair(this.clients).isMe();
        boolean isUnlocked = !this.clients.getProperty("chair.locked", false);
        ChairModule chairModule = this;
        synchronized (chairModule) {
            if (this.updating) {
                return;
            }
            this.updating = true;
        }
        this.createFeatures(isUnlocked);
        this.giveFeature.setEnabled(isChair && this.getCanGive());
        this.giveParameterizedFeature.setEnabled(isChair);
        this.takeFeature.setEnabled(isChair && this.getCanTake());
        this.takeParameterizedFeature.setEnabled(isChair);
        this.removeFeature.setEnabled(isChair && this.getCanRemove());
        this.unlockedFeature.setEnabled(isChair);
        this.unlockedFeature.setValue((Object)isUnlocked);
        this.broker.setFeaturePublished((Feature)this.giveFeature, isChair);
        this.broker.setFeaturePublished((Feature)this.giveParameterizedFeature, isChair);
        this.broker.setFeaturePublished((Feature)this.takeFeature, isChair);
        this.broker.setFeaturePublished((Feature)this.takeParameterizedFeature, isChair);
        this.broker.setFeaturePublished((Feature)this.removeFeature, isChair);
        this.broker.setFeaturePublished((Feature)this.unlockedFeature, isChair);
        chairModule = this;
        synchronized (chairModule) {
            this.updating = false;
        }
    }

    private boolean createFeatures(boolean isUnlocked) {
        if (this.unlockedFeature != null) {
            return false;
        }
        this.unlockedFeature = this.broker.createBooleanFeature((Object)this, "/chair/unlocked", true, isUnlocked, i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_ALLOWNEWPARTICIPANTS), i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_ALLOWNEWPARTICIPANTS));
        this.unlockedFeature.setTrueText(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_ALLOWNEWPARTICIPANTS));
        this.unlockedFeature.setFalseText(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_ALLOWNEWPARTICIPANTS));
        this.unlockedFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                if (ChairModule.this.recursive) {
                    return;
                }
                ChairModule.this.recursive = true;
                boolean newLocked = (Boolean)ChairModule.this.unlockedFeature.getValue() == false;
                boolean wasLocked = ChairModule.this.clients.getProperty("chair.locked", false);
                if (ChairDebug.TRACE.show()) {
                    ChairModule.this.logger.message((Object)this, "metaDataChanged", "newLocked:" + newLocked + ", wasLocked: " + wasLocked);
                }
                if (newLocked != wasLocked) {
                    ChairModule.this.clients.setProperty("chair.locked", newLocked);
                }
                ChairModule.this.recursive = false;
            }
        });
        this.giveFeature = this.broker.createActionFeature((Object)this, "/chair/give", i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_GIVETITLE), i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_GIVETITLE));
        this.giveFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ChairModule.this.doGiveAction(ChairModule.this.getSelectedClients());
                ChairModule.this.updateFeatures();
            }
        });
        ArrayList<ActionParameterDescriptor> paramDescs = new ArrayList<ActionParameterDescriptor>();
        paramDescs.add(new ActionParameterDescriptor("participants", ActionParameterDescriptor.Type.PARTICIPANT, 1, Integer.MAX_VALUE));
        this.giveParameterizedFeature = this.broker.createActionFeature((Object)this, "/chair/giveParameterized", paramDescs, null, null);
        this.giveParameterizedFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent e) {
                ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
                for (CRParticipant p : e.getParameterAsCollectionOf(CRParticipant.class, "participants")) {
                    ClientInfo info = ChairModule.this.clients.get(p.getID());
                    if (info == null) continue;
                    list.add(info);
                }
                boolean success = false;
                if (!list.isEmpty()) {
                    success = ChairModule.this.doGiveAction(list.toArray(new ClientInfo[0]));
                }
                e.setComplete(success);
            }
        });
        this.takeFeature = this.broker.createActionFeature((Object)this, "/chair/take", i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TAKETITLE), i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TAKETITLE));
        this.takeFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ChairModule.this.doTakeAction(ChairModule.this.getSelectedClients());
                ChairModule.this.updateFeatures();
            }
        });
        paramDescs = new ArrayList();
        paramDescs.add(new ActionParameterDescriptor("participants", ActionParameterDescriptor.Type.PARTICIPANT, 1, Integer.MAX_VALUE));
        this.takeParameterizedFeature = this.broker.createActionFeature((Object)this, "/chair/takeParameterized", paramDescs, null, null);
        this.takeParameterizedFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent e) {
                ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
                for (CRParticipant p : e.getParameterAsCollectionOf(CRParticipant.class, "participants")) {
                    ClientInfo info = ChairModule.this.clients.get(p.getID());
                    if (info == null) continue;
                    list.add(info);
                }
                boolean success = false;
                if (!list.isEmpty()) {
                    success = ChairModule.this.doTakeAction(list.toArray(new ClientInfo[0]));
                }
                e.setComplete(success);
            }
        });
        this.removeFeature = this.broker.createActionFeature((Object)this, "/chair/remove", i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVETITLE), i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVETITLE));
        this.removeFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ChairModule.this.doRemoveAction(ChairModule.this.getSelectedClients());
                ChairModule.this.updateFeatures();
            }
        });
        this.updateLabels();
        return true;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.getTitle();
    }

    public Icon getModuleIcon() {
        return MODULE_ICON;
    }

    public void start() {
        this.chairBean = (ChairBean)this.beanProvider.get();
        this.chairBean.registerProvider();
    }

    public void attach() {
        this.chairBean.init();
        this.client = this.clientProvider.get();
        this.clients = this.client.getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("chair.locked", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Moderator", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Participants", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Participant", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Label.Session", (PropertyChangeListener)this);
        this.legacySupport = new LegacyChairSupport(this.clients);
        this.updateFeatures();
    }

    public void setupUI() {
        this.updateLabels();
        this.selector = (ParticipantSelectorAPI)this.imps.findBest(ParticipantSelectorAPI.class);
        if (this.selector != null) {
            this.selector.addSelectionListener((ParticipantSelectionListener)this);
        }
        this.broker.announceNotification((Object)this, MODERATOR_GRANTED_NOTIFICATION);
    }

    public void cleanupUI() {
    }

    public void detach() {
        if (this.legacySupport != null) {
            this.legacySupport.dispose();
            this.legacySupport = null;
        }
    }

    public void stop() {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    private boolean doTakeAction(ClientInfo[] selectedClients) {
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "doTakeAction", "take: [" + selectedClients.length + "]");
        }
        if (this.chairProtocol == null || this.clients == null) {
            return false;
        }
        boolean takeFailed = false;
        if (selectedClients.length < 1) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProvider.getDialogParent(), (Object)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TAKESELECTREQD, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator"), LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participant")}), (String)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TAKETITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (int)0);
            takeFailed = true;
        } else {
            for (int ix = 0; ix < selectedClients.length; ++ix) {
                if (!selectedClients[ix].getProperty("chair.ofRecord", false)) continue;
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProvider.getDialogParent(), (Object)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TAKECHAIROFRECORD, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator"), selectedClients[ix].getDisplayName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TAKETITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (int)0);
                takeFailed = true;
                break;
            }
        }
        if (!takeFailed) {
            this.chairBean.takeChair(selectedClients);
        }
        return !takeFailed;
    }

    private boolean doGiveAction(ClientInfo[] selectedClients) {
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "doGiveAction", "give: [" + selectedClients.length + "]");
        }
        boolean giveFailed = false;
        if (selectedClients.length < 1) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProvider.getDialogParent(), (Object)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_GIVESELECTREQD, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator"), LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participant")}), (String)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_GIVETITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (int)0);
            giveFailed = true;
        } else {
            this.chairBean.giveChair(selectedClients, true);
        }
        return !giveFailed;
    }

    private boolean doRemoveAction(ClientInfo[] selectedClients) {
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "doRemoveAction", "remove: [" + selectedClients.length + "]");
        }
        if (this.chairProtocol == null || this.clients == null) {
            return false;
        }
        boolean removedFailed = false;
        if (selectedClients.length == 0) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProvider.getDialogParent(), (Object)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVESELECTREQD, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participant")}), (String)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVETITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participant")}), (int)0);
            removedFailed = true;
        } else {
            for (int i = 0; i < selectedClients.length; ++i) {
                if (selectedClients[i].isMe()) {
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProvider.getDialogParent(), (Object)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_SELFREMOVE), (String)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVETITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.participant")}), (int)0);
                    removedFailed = true;
                    break;
                }
                if (!selectedClients[i].getProperty("chair.ofRecord", false)) continue;
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProvider.getDialogParent(), (Object)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVECHAIROFRECORD, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator"), selectedClients[i].getDisplayName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVETITLE, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderator")}), (int)0);
                removedFailed = true;
                break;
            }
        }
        if (!removedFailed) {
            this.chairBean.removeParticipants(selectedClients, true);
        }
        return !removedFailed;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("chair.locked")) {
            this.updateFeatures();
        } else if (propertyName.equals("Label.Moderator") || propertyName.equals("Label.Participants") || propertyName.equals("Label.Participant") || propertyName.equals("Label.Session")) {
            this.updateLabels();
        } else if (e.getPropertyName().equals("chair")) {
            this.updateFeatures();
        }
        this.updateFeatures();
    }

    public void participantSelectionChanged() {
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "participantSelectionChanged", "selection changed");
        }
        this.updateFeatures();
    }

    private boolean getHasBridgeSelected(ClientInfo[] selectedClients) {
        boolean hasBridgeSelected = false;
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        if (telephony != null && selectedClients != null) {
            for (int ix = 0; !hasBridgeSelected && ix < selectedClients.length; ++ix) {
                hasBridgeSelected = telephony.getAudioMode(selectedClients[ix].getAddress()) == 3;
            }
        }
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "gethasBridgeSelected", "hasBridgeSelected = " + hasBridgeSelected);
        }
        return hasBridgeSelected;
    }

    private ClientInfo[] getSelectedClients() {
        List selectedClients;
        List list = selectedClients = this.selector != null ? this.selector.getSelectedClients() : new ArrayList();
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getSelectedClients", "selected clients: who.length=" + (selectedClients != null ? selectedClients.size() : 0));
        }
        ClientInfo[] info = new ClientInfo[selectedClients.size()];
        return selectedClients.toArray(info);
    }

    private boolean getHasGroupSelected() {
        boolean hasGroupSelected;
        boolean bl = this.selector != null ? this.selector.getSelectedRoomCount() > 0 : (hasGroupSelected = false);
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getHasGroupSelected", "hasGroupSelected = " + hasGroupSelected);
        }
        return hasGroupSelected;
    }

    private boolean getCanGive() {
        boolean canGive;
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getCanGive", "chair = " + chair);
        }
        ClientInfo[] selectedClients = this.getSelectedClients();
        boolean hasGroupSelected = this.getHasGroupSelected();
        boolean hasBridgeSelected = this.getHasBridgeSelected(selectedClients);
        boolean bl = canGive = selectedClients != null && selectedClients.length >= 1 && !hasBridgeSelected && !hasGroupSelected && !chair.containsEvery(selectedClients);
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getCanGive", "canGive = " + canGive);
        }
        return canGive;
    }

    private boolean getCanTake() {
        boolean canTake;
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getCanTake", "chair = " + chair);
        }
        ClientInfo[] selectedClients = this.getSelectedClients();
        boolean hasGroupSelected = this.getHasGroupSelected();
        boolean ofRecord = false;
        for (ClientInfo ci : selectedClients) {
            if (!ci.getProperty("chair.ofRecord", false)) continue;
            ofRecord = true;
            break;
        }
        boolean bl = canTake = selectedClients != null && selectedClients.length >= 1 && chair.containsAny(selectedClients) && !hasGroupSelected && !ofRecord;
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getCanTake", "canTake = " + canTake);
        }
        return canTake;
    }

    private boolean getCanRemove() {
        boolean canRemove;
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getCanRemove", "chair = " + chair);
        }
        ClientInfo[] selectedClients = this.getSelectedClients();
        boolean hasGroupSelected = this.getHasGroupSelected();
        boolean hasBridgeSelected = this.getHasBridgeSelected(selectedClients);
        boolean bl = canRemove = selectedClients != null && selectedClients.length > 0 && !hasBridgeSelected && !hasGroupSelected && chair.isMe();
        if (ChairDebug.TRACE.show()) {
            this.logger.message((Object)this, "getCanRemove", "canRemove = " + canRemove);
        }
        if (canRemove) {
            for (int i = 0; selectedClients != null && i < selectedClients.length; ++i) {
                if (!selectedClients[i].isMe() && !selectedClients[i].getProperty("chair.ofRecord", false)) continue;
                canRemove = false;
                break;
            }
        }
        return canRemove;
    }

    private void updateLabels() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String moderatorTitle = LabelProps.get((PropertyAccessAPI)ChairModule.this.clients, (String)"Label.Moderator");
                String participantTitle = LabelProps.get((PropertyAccessAPI)ChairModule.this.clients, (String)"Label.Participant");
                String participantPluralTitle = LabelProps.get((PropertyAccessAPI)ChairModule.this.clients, (String)"Label.Participants");
                String sessionTitle = LabelProps.get((PropertyAccessAPI)ChairModule.this.clients, (String)"Label.Session");
                ChairModule.this.giveFeature.setName(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_GIVECHAIRMENU, new Object[]{moderatorTitle}));
                ChairModule.this.giveFeature.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_GIVECHAIRMENU, new Object[]{moderatorTitle}));
                ChairModule.this.takeFeature.setName(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TAKECHAIRMENU, new Object[]{moderatorTitle}));
                ChairModule.this.takeFeature.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_TAKECHAIRMENU, new Object[]{moderatorTitle}));
                ChairModule.this.removeFeature.setName(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVEMENU, new Object[]{participantTitle}));
                ChairModule.this.removeFeature.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_REMOVEMENU, new Object[]{participantTitle}));
                ChairModule.this.unlockedFeature.setName(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_ALLOWNEWPARTICIPANTS, new Object[]{participantPluralTitle, sessionTitle}));
                ChairModule.this.unlockedFeature.setFalseText(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_ALLOWNEWPARTICIPANTS, new Object[]{participantPluralTitle, sessionTitle}));
                ChairModule.this.unlockedFeature.setTrueText(i18n.getString((PropertiesEnum)StringsProperties.CHAIRMODULE_ALLOWNEWPARTICIPANTS, new Object[]{participantPluralTitle, sessionTitle}));
                if (ChairDebug.TRACE.show()) {
                    ChairModule.this.logger.message((Object)this, "updateLabels", "sessionTitle = " + sessionTitle + "\nmoderatorTitle = " + moderatorTitle + "\nparticipantTitle = " + participantTitle + "\nparticipantPluralTitle = " + participantPluralTitle + "\nmoderatorTitle = " + moderatorTitle + "\nmoderatorTitle = " + moderatorTitle);
                }
                ChairModule.this.setTitle(moderatorTitle);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)run);
        }
    }

    void postModeratorGranted(String message) {
        this.broker.sendNotification((Object)this, MODERATOR_GRANTED_NOTIFICATION, message, this.client.getSessionTime());
    }
}

