/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.elluminate.groupware.imps.ImageAcceptAPI;
import com.elluminate.groupware.imps.ImageAcceptAccessibleListener;
import com.elluminate.groupware.imps.ImageAcceptData;
import com.elluminate.groupware.polling.PollingProtocol;
import com.elluminate.groupware.polling.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class SummaryDialog
extends EasyDialog {
    private static final long serialVersionUID = 8884522214182327656L;
    private static final int WIDTH = 400;
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static final ImageIcon YES = i18n.getIcon("PollInfoColumn.yesIcon");
    private static final ImageIcon NO = i18n.getIcon("PollInfoColumn.noIcon");
    private static final ImageIcon A = i18n.getIcon("PollInfoColumn.aIcon");
    private static final ImageIcon B = i18n.getIcon("PollInfoColumn.bIcon");
    private static final ImageIcon C = i18n.getIcon("PollInfoColumn.cIcon");
    private static final ImageIcon D = i18n.getIcon("PollInfoColumn.dIcon");
    private static final ImageIcon E = i18n.getIcon("PollInfoColumn.eIcon");
    private static final ImageIcon FASTER = i18n.getIcon("PollInfoColumn.fasterIcon");
    private static final ImageIcon SLOWER = i18n.getIcon("PollInfoColumn.slowerIcon");
    ClientList clients = null;
    JButton publishButton = new JButton();
    JButton doneButton = new JButton();
    JPanel panel = new JPanel();
    GridBagLayout panelLayout = new GridBagLayout();
    JLabel r1Label = new JLabel();
    JLabel r1Stats = new JLabel();
    JProgressBar r1Value = new JProgressBar();
    JLabel r2Label = new JLabel();
    JLabel r2Stats = new JLabel();
    JProgressBar r2Value = new JProgressBar();
    JLabel r3Label = new JLabel();
    JLabel r3Stats = new JLabel();
    JProgressBar r3Value = new JProgressBar();
    JLabel r4Label = new JLabel();
    JLabel r4Stats = new JLabel();
    JProgressBar r4Value = new JProgressBar();
    JLabel r5Label = new JLabel();
    JLabel r5Stats = new JLabel();
    JProgressBar r5Value = new JProgressBar();
    JLabel r6Label = new JLabel();
    JLabel r6Stats = new JLabel();
    JProgressBar r6Value = new JProgressBar();
    JLabel[] labels = new JLabel[]{this.r1Label, this.r2Label, this.r3Label, this.r4Label, this.r5Label};
    JLabel[] stats = new JLabel[]{this.r1Stats, this.r2Stats, this.r3Stats, this.r4Stats, this.r5Stats, this.r6Stats};
    JProgressBar[] values = new JProgressBar[]{this.r1Value, this.r2Value, this.r3Value, this.r4Value, this.r5Value, this.r6Value};
    ImageAcceptAPI publishAPI = null;
    ImageAcceptData publishData = null;
    private Listener listener = new Listener();

    public SummaryDialog(Frame owner, ClientList clients, String title, Imps imps) {
        super((Component)owner, title, false);
        this.setDefaultCloseOperation(1);
        this.clients = clients;
        ImpsAvailableListener<ImageAcceptAPI> impsListener = new ImpsAvailableListener<ImageAcceptAPI>(){

            public void available(ImageAcceptAPI instance) {
                SummaryDialog.this.publishAPI = instance;
            }

            public void removed(ImageAcceptAPI instance) {
                SummaryDialog.this.publishAPI = null;
            }
        };
        imps.addImpsAvailableListener((ImpsAvailableListener)impsListener, ImageAcceptAPI.class);
        try {
            this.jbInit();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)((Object)this), (String)"SummaryDialog", (Throwable)t, (boolean)true);
            throw new RuntimeException();
        }
        clients.addClientListener((ClientListener)this.listener);
        clients.addClientPropertyChangeListener("pollingValue", (PropertyChangeListener)this.listener);
        clients.addGroupPropertyChangeListener("pollingMode", (PropertyChangeListener)this.listener);
        clients.getConnection().addClientGroupListener((ClientGroupListener)this.listener);
        this.updateMode();
        this.updateTotal();
        this.updateValues();
    }

    public void cleanup() {
        this.publishAPI = null;
        this.clients.removeClientListener((ClientListener)this.listener);
        this.clients.removeClientPropertyChangeListener((PropertyChangeListener)this.listener);
        this.clients.removeGroupPropertyChangeListener((PropertyChangeListener)this.listener);
        this.clients.getConnection().removeClientGroupListener((ClientGroupListener)this.listener);
        this.listener = null;
    }

    public void show() {
        this.pack();
        Dimension s = this.getSize();
        this.setSize(400, s.height);
        super.show();
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.panelLayout);
        SummaryDialog.setProgressBarUI(this.r1Value);
        SummaryDialog.setProgressBarUI(this.r2Value);
        SummaryDialog.setProgressBarUI(this.r3Value);
        SummaryDialog.setProgressBarUI(this.r4Value);
        SummaryDialog.setProgressBarUI(this.r5Value);
        SummaryDialog.setProgressBarUI(this.r6Value);
        this.r1Value.setForeground(Color.red);
        this.r2Value.setForeground(Color.blue);
        this.r3Value.setForeground(Color.green);
        this.r4Value.setForeground(Color.yellow);
        this.r5Value.setForeground(Color.cyan);
        this.r6Value.setForeground(Color.black);
        this.r6Label.setText(i18n.getString((PropertiesEnum)StringsProperties.SUMMARYDIALOG_NOANSWER));
        this.panel.add((Component)this.r1Label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.r1Value, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r1Stats, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r2Label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.r2Value, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r2Stats, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r3Label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.r3Value, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r3Stats, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r4Label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.r4Value, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r4Stats, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r5Label, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.r5Value, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r5Stats, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r6Label, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.r6Value, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.panel.add((Component)this.r6Stats, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.doneButton.setText(i18n.getString((PropertiesEnum)StringsProperties.SUMMARYDIALOG_DONEBTN));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryDialog.this.setVisible(false);
            }
        });
        if (this.publishAPI != null) {
            this.publishButton.setText(i18n.getString((PropertiesEnum)StringsProperties.SUMMARYDIALOG_PUBLISH, new Object[]{this.publishAPI.getProvider()}));
            this.publishButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SummaryDialog.this.publishStats();
                }
            });
            this.addPassiveComponent(this.publishButton);
        }
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setStringPainted(false);
        }
        this.addCancelButton(this.doneButton);
        this.setDefaultCloseOperation(1);
        this.setContent(this.panel);
        this.setInitialFocus(this.publishAPI != null ? this.publishButton : this.doneButton);
    }

    public boolean publishStats() {
        if (this.publishAPI == null) {
            return false;
        }
        if (PollingProtocol.DEBUG.show()) {
            System.out.println("polling: publishing results");
        }
        this.panel.setVisible(true);
        if (!this.isVisible()) {
            this.pack();
            Dimension s = this.getSize();
            this.setSize(400, s.height);
            this.validate();
        }
        this.publishData = new ImageAcceptData(8, 0, 0);
        this.publishData = this.publishAPI.setImage((Component)this.panel, i18n.getString((PropertiesEnum)StringsProperties.SUMMARYDIALOG_POLLINGSUMMARY), this.publishData);
        if (this.publishData.getException() != null) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.SUMMARYDIALOG_CANTPUBLISHMSG, new Object[]{this.publishData.getException().getMessage()}), (String)i18n.getString((PropertiesEnum)StringsProperties.SUMMARYDIALOG_CANTPUBLISHTITLE), (int)0);
            return false;
        }
        return true;
    }

    public void addImageAccessibilityListener(ImageAcceptAccessibleListener l) {
        if (this.publishAPI != null) {
            this.publishAPI.addAccessibleListener(l);
        }
    }

    public void removeImageAccessibilityListener(ImageAcceptAccessibleListener l) {
        if (this.publishAPI != null) {
            this.publishAPI.removeAccessibleListener(l);
        }
    }

    private void updateValues() {
        int[] count = new int[6];
        int total = 0;
        ClientGroup cg = this.clients.getMyGroup();
        if (cg == null) {
            return;
        }
        for (ClientInfo ci : cg) {
            if (!ci.isVisible()) continue;
            char value = ci.getProperty("pollingValue", ' ');
            ++total;
            switch (value) {
                case 'a': {
                    count[0] = count[0] + 1;
                    break;
                }
                case 'b': {
                    count[1] = count[1] + 1;
                    break;
                }
                case 'c': {
                    count[2] = count[2] + 1;
                    break;
                }
                case 'd': {
                    count[3] = count[3] + 1;
                    break;
                }
                case 'e': {
                    count[4] = count[4] + 1;
                    break;
                }
                case 'n': {
                    count[0] = count[0] + 1;
                    break;
                }
                case 'y': {
                    count[1] = count[1] + 1;
                    break;
                }
                case ' ': {
                    count[5] = count[5] + 1;
                }
            }
        }
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setValue(count[i]);
            if (count[i] == 0) {
                this.stats[i].setText(null);
                continue;
            }
            int pct = count[i] * 100 / total;
            String txt = count[i] + "/" + total + " (" + pct + "%)";
            this.stats[i].setText(txt);
        }
    }

    private void updateTotal() {
        ClientGroup cg = this.clients.getMyGroup();
        if (cg == null) {
            return;
        }
        int count = cg.getVisibleSize();
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setMaximum(count);
        }
    }

    private void updateMode() {
        ClientGroup cg = this.clients.getMyGroup();
        if (cg == null) {
            return;
        }
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].setIcon(null);
            this.labels[i].setText(null);
            this.labels[i].setVisible(false);
            this.stats[i].setVisible(false);
            this.values[i].setVisible(false);
        }
        switch (cg.getProperty("pollingMode", (short)0)) {
            case 4: {
                this.labels[4].setIcon(E);
                this.labels[4].setVisible(true);
                this.stats[4].setVisible(true);
                this.values[4].setVisible(true);
            }
            case 3: {
                this.labels[3].setIcon(D);
                this.labels[3].setVisible(true);
                this.stats[3].setVisible(true);
                this.values[3].setVisible(true);
            }
            case 2: {
                this.labels[2].setIcon(C);
                this.labels[2].setVisible(true);
                this.stats[2].setVisible(true);
                this.values[2].setVisible(true);
                this.labels[1].setIcon(B);
                this.labels[1].setVisible(true);
                this.stats[1].setVisible(true);
                this.values[1].setVisible(true);
                this.labels[0].setIcon(A);
                this.labels[0].setVisible(true);
                this.stats[0].setVisible(true);
                this.values[0].setVisible(true);
                break;
            }
            case 1: {
                this.labels[0].setIcon(NO);
                this.labels[0].setVisible(true);
                this.stats[0].setVisible(true);
                this.values[0].setVisible(true);
                this.labels[1].setIcon(YES);
                this.labels[1].setVisible(true);
                this.stats[1].setVisible(true);
                this.values[1].setVisible(true);
            }
        }
        this.pack();
        Dimension s = this.getSize();
        this.setSize(400, s.height);
        this.validate();
    }

    private static void setProgressBarUI(JProgressBar bar) {
        bar.setUI(new BasicProgressBarUI());
        bar.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        bar.setForeground(Color.darkGray);
        bar.setBackground(Color.lightGray);
    }

    class Listener
    implements ClientListener,
    PropertyChangeListener,
    ClientGroupListener,
    Runnable {
        private volatile boolean totalChanged = false;
        private volatile boolean modeChanged = false;
        private volatile boolean valuesChanged = false;

        Listener() {
        }

        public void onAddClient(ClientEvent e) {
            this.totalChanged = true;
            ClientInfo ci = null;
            if (SummaryDialog.this.clients != null) {
                ci = SummaryDialog.this.clients.get(e.getAddress());
            }
            if (ci != null && ci.isMe()) {
                this.modeChanged = true;
            }
            SwingRunnerSupport.invokeLater((Runnable)this);
        }

        public void onRemoveClient(ClientEvent e) {
            this.totalChanged = true;
            SwingRunnerSupport.invokeLater((Runnable)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("pollingMode")) {
                this.modeChanged = true;
            }
            this.valuesChanged = true;
            SwingRunnerSupport.invokeLater((Runnable)this);
        }

        public void clientGroupCreated(ClientGroupEvent e) {
        }

        public void clientGroupDeleted(ClientGroupEvent e) {
        }

        public void clientGroupRenamed(ClientGroupEvent e) {
        }

        public void clientGroupChanged(ClientGroupEvent e) {
            if (e.getClient().isMe()) {
                this.modeChanged = true;
                this.valuesChanged = true;
                this.totalChanged = true;
            }
            if (e.getGroupID() == SummaryDialog.this.clients.getMyGroupID() || e.getPreviousGroupID() == SummaryDialog.this.clients.getMyGroupID()) {
                this.totalChanged = true;
                this.valuesChanged = true;
            }
            SwingRunnerSupport.invokeLater((Runnable)this);
        }

        @Override
        public void run() {
            if (this.totalChanged) {
                this.totalChanged = false;
                SummaryDialog.this.updateTotal();
            }
            if (this.modeChanged) {
                this.modeChanged = false;
                SummaryDialog.this.updateMode();
            }
            if (this.valuesChanged) {
                this.valuesChanged = false;
                SummaryDialog.this.updateValues();
            }
        }
    }
}

