/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.polling.PollingProtocol;
import com.elluminate.groupware.polling.module.PollingModel;
import com.elluminate.groupware.polling.module.PollingUtils;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class PollingResponseTranslator {
    private Logger log = null;
    private CRSession session = null;
    private PropertyChangeListener responseChangeListener = null;
    private ClientProvider clientProvider = null;
    private PollingModel model = null;
    private PropertyChangeListener visibilityChangeListener = null;
    private PollingUtils utils = null;
    private Timer refreshTimer = new Timer("pollRefreshTimer");
    private TimerTask refreshTask = null;

    @Inject
    public void initCRSession(CRSession crs) {
        this.session = crs;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    @Inject
    public void initPollingModel(PollingModel pm) {
        this.model = pm;
    }

    @Inject
    public void initPollingUtils(PollingUtils pu) {
        this.utils = pu;
    }

    public void setup() {
        this.session.registerAnnotation("PollingAnnotation", (Object)Character.valueOf(' '));
        this.responseChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PollingResponseTranslator.this.handleResponseChange(evt);
            }
        };
        this.clientProvider.get().getClientList().addClientPropertyChangeListener("pollingValue", this.responseChangeListener);
        this.setupGroupChangeListener();
        this.setupVisibilityChangeListener();
    }

    private void setupGroupChangeListener() {
        this.clientProvider.get().addClientGroupListener(new ClientGroupListener(){

            public void clientGroupRenamed(ClientGroupEvent event) {
            }

            public void clientGroupDeleted(ClientGroupEvent event) {
            }

            public void clientGroupCreated(ClientGroupEvent event) {
            }

            public void clientGroupChanged(ClientGroupEvent event) {
                PollingResponseTranslator.this.handleGroupChange();
            }
        });
    }

    private void setupVisibilityChangeListener() {
        this.visibilityChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PollingResponseTranslator.this.handlePollingVisibleChange(evt);
            }
        };
        try {
            this.clientProvider.get().getClientList().addGroupPropertyChangeListener("pollingVisible", this.visibilityChangeListener);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register a listener for the polling visibility state");
        }
    }

    private void handlePollingVisibleChange(PropertyChangeEvent evt) {
        this.refreshAnnotations();
    }

    private void handleResponseChange(PropertyChangeEvent evt) {
        CRParticipant participant = this.session.getParticipantById(((ClientInfo)evt.getSource()).getAddress());
        this.showResponse(participant);
    }

    private void showResponse(CRParticipant participant) {
        Character value;
        block5: {
            value = Character.valueOf(' ');
            try {
                if (this.isChair() || participant.isMe()) {
                    value = Character.valueOf(participant.getPropertyStore().getProperty("pollingValue", ' '));
                } else {
                    CRRoom myRoom = this.session.getMe().getRoom();
                    if (myRoom.getPropertyStore().getProperty("pollingVisible", false) && myRoom.getID() == participant.getRoom().getID()) {
                        value = Character.valueOf(participant.getPropertyStore().getProperty("pollingValue", ' '));
                    }
                }
            }
            catch (Exception e) {
                if (!PollingProtocol.DEBUG.show()) break block5;
                this.log.error("Hit a problem (likely when getting the room info): " + e.getMessage());
            }
        }
        this.session.setAnnotationValue(participant, "PollingAnnotation", (Object)value);
    }

    private boolean isChair() {
        try {
            return this.session.isChair(this.session.getMe());
        }
        catch (Exception e) {
            return false;
        }
    }

    public void cleanup() {
        block2: {
            try {
                this.session.deRegisterAnnotation("PollingAnnotation");
                this.clientProvider.get().getClientList().removeClientPropertyChangeListener("pollingValue", this.responseChangeListener);
            }
            catch (Exception e) {
                if (!PollingProtocol.DEBUG.show()) break block2;
                this.log.message("Exception thrown during cleanup, no action required");
            }
        }
    }

    private void handleGroupChange() {
        this.refreshAnnotations();
    }

    private void refreshAnnotations() {
        block3: {
            if (this.refreshTask != null) {
                this.refreshTask.cancel();
                this.refreshTask = null;
            }
            this.refreshTask = new TimerTask(){

                @Override
                public void run() {
                    Iterator participants = PollingResponseTranslator.this.session.getParticipantIterator();
                    while (participants.hasNext()) {
                        try {
                            PollingResponseTranslator.this.showResponse((CRParticipant)participants.next());
                        }
                        catch (Exception e) {
                            if (!PollingProtocol.DEBUG.show()) continue;
                            PollingResponseTranslator.this.log.message("Exception thrown during showResponse, no action required");
                        }
                    }
                }
            };
            try {
                this.refreshTimer.schedule(this.refreshTask, 100L);
            }
            catch (Exception e) {
                if (!PollingProtocol.DEBUG.show()) break block3;
                this.log.message("Timer has already been cancelled. Probably shutting down, no need to panic");
            }
        }
    }
}

