/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.polling.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.ImageAcceptAccessibleListener;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.polling.PollingProtocol;
import com.elluminate.groupware.polling.module.AnswerPollCmd;
import com.elluminate.groupware.polling.module.HidePollResponsesCmd;
import com.elluminate.groupware.polling.module.LockPollResponsesCmd;
import com.elluminate.groupware.polling.module.PollTypeFactory;
import com.elluminate.groupware.polling.module.PollingModel;
import com.elluminate.groupware.polling.module.PollingResponseTranslator;
import com.elluminate.groupware.polling.module.PollingStatsListener;
import com.elluminate.groupware.polling.module.PollingTypeAdapter;
import com.elluminate.groupware.polling.module.PollingUtils;
import com.elluminate.groupware.polling.module.PublishPollStatisticsToWhiteboardCmd;
import com.elluminate.groupware.polling.module.SetPollTypeCmd;
import com.elluminate.groupware.polling.module.ShowPollResponsesCmd;
import com.elluminate.groupware.polling.module.StatsModel;
import com.elluminate.groupware.polling.module.StringsProperties;
import com.elluminate.groupware.polling.module.SummaryDialog;
import com.elluminate.groupware.polling.module.UnlockPollResponsesCmd;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Icon;

public class PollingModule
extends AbstractClientModule
implements ModulePublisherInfo,
ImageAcceptAccessibleListener {
    private static final String MODULE_NAME = "Polling";
    private static final Short NO_MODE = null;
    private static final String LOCALIZED_RESPONSE_PREFIX = "PollingModule.response.";
    private static final String MODE_FEATURE_PATH = "/polling/mode";
    private static final String LOCK_FEATURE_PATH = "/polling/lock";
    private static final String VISIBLE_FEATURE_PATH = "/polling/visible";
    private static final String PUBLISH_FEATURE_PATH = "/polling/publish";
    private static final String CLEAR_RESPONSES_FEATURE = "/polling/clear";
    private static final String POLL_SUMMARY_FEATURE_BASE = "/polling/summary/";
    private I18n i18n = I18n.create((Object)((Object)this));
    private Logger log = null;
    private ChairProtocol chairProtocol = null;
    private DialogParentProvider parentProvider = null;
    private boolean isChair = false;
    private FeatureBroker broker = null;
    private EnumeratedFeature<Short> pollingModeFeature = null;
    private PollTypeFactory factory = null;
    private BooleanFeature lockFeature = null;
    private BooleanFeature visibilityFeature = null;
    private ActionFeature publishFeature = null;
    private ActionFeature clearFeature = null;
    private ClientProvider clientProvider = null;
    private SwingRunner swingRunner = null;
    private SummaryDialog stats = null;
    private StatsModel statsModel = null;
    private Map<Character, NumericFeature<Integer>> summaryData = new LinkedHashMap<Character, NumericFeature<Integer>>();
    private PollingUtils utils = null;
    private PollingModel model = null;
    private Imps imps = null;
    private Provider<PollingResponseTranslator> responseTranslatorProvider = null;
    private ConferencingEngine confEngine = null;
    private Provider<AnswerPollCmd> answerPollProvider = null;
    private Provider<SetPollTypeCmd> setPollTypeProvider = null;
    private Provider<PublishPollStatisticsToWhiteboardCmd> publishPollStatsProvider = null;
    private Provider<ShowPollResponsesCmd> showPollResponsesProvider = null;
    private Provider<HidePollResponsesCmd> hidePollResponsesProvider = null;
    private Provider<LockPollResponsesCmd> lockPollResponsesProvider = null;
    private Provider<UnlockPollResponsesCmd> unlockPollResponsesProvider = null;
    private PropertyChangeListener modeListener;
    private PropertyChangeListener responseListener;
    private PropertyChangeListener chairListener;
    private PropertyChangeListener visibilityChangeListener;
    private PropertyChangeListener lockedChangeListener;

    @Inject
    public PollingModule(ComponentRegistrar registrar) {
        registrar.registerComponent((Object)this);
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    @Inject
    public void initChairProtocol(ChairProtocol cp) {
        this.chairProtocol = cp;
    }

    @Inject
    public void initParentProvider(DialogParentProvider p) {
        this.parentProvider = p;
    }

    @Inject
    public void initModel(PollingModel theModel) {
        this.model = theModel;
    }

    @Inject
    public void initStatsModel(StatsModel m) {
        this.statsModel = m;
    }

    @Inject
    public void initPollingUtils(PollingUtils u) {
        this.utils = u;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initPollingResponseTranslatorProvider(Provider<PollingResponseTranslator> prov) {
        this.responseTranslatorProvider = prov;
    }

    @Inject
    public void initSwingRunner(SwingRunner runner) {
        this.swingRunner = runner;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine confEngine) {
        this.confEngine = confEngine;
    }

    @Inject
    public void initAnswerPollProvider(Provider<AnswerPollCmd> answerPollProvider) {
        this.answerPollProvider = answerPollProvider;
    }

    @Inject
    public void initSetPollTypeProvider(Provider<SetPollTypeCmd> setPollTypeProvider) {
        this.setPollTypeProvider = setPollTypeProvider;
    }

    @Inject
    public void initPublishStatsProvider(Provider<PublishPollStatisticsToWhiteboardCmd> publishPollStatsProvider) {
        this.publishPollStatsProvider = publishPollStatsProvider;
    }

    @Inject
    public void initPollResponseProvider(Provider<ShowPollResponsesCmd> showPollResponsesProvider) {
        this.showPollResponsesProvider = showPollResponsesProvider;
    }

    @Inject
    public void initHidePollResponsesProvider(Provider<HidePollResponsesCmd> hidePollResponsesProvider) {
        this.hidePollResponsesProvider = hidePollResponsesProvider;
    }

    @Inject
    public void initLockPollResponsesProvider(Provider<LockPollResponsesCmd> lockPollResponsesProvider) {
        this.lockPollResponsesProvider = lockPollResponsesProvider;
    }

    @Inject
    public void initUnlockPollResponsesProvider(Provider<UnlockPollResponsesCmd> unlockPollResponsesProvider) {
        this.unlockPollResponsesProvider = unlockPollResponsesProvider;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker fb) {
        this.broker = fb;
    }

    @Inject
    public void initPollTypeFactory(PollTypeFactory f) {
        this.factory = f;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_DISPLAY_NAME);
    }

    public Icon getModuleIcon() {
        return null;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public void start() {
    }

    public void attach() {
        Chair chair = this.chairProtocol.makeChair((Connection)this.clientProvider.get());
        this.isChair = chair.isMe();
        this.confEngine.registerCommand(this.answerPollProvider);
        this.confEngine.registerCommand(this.setPollTypeProvider);
        this.confEngine.registerCommand(this.publishPollStatsProvider);
        this.confEngine.registerCommand(this.showPollResponsesProvider);
        this.confEngine.registerCommand(this.hidePollResponsesProvider);
        this.confEngine.registerCommand(this.lockPollResponsesProvider);
        this.confEngine.registerCommand(this.unlockPollResponsesProvider);
        this.model.setPlayingStatus(this.clientProvider.get().isPlayback());
        this.statsModel.setup();
    }

    private void setupPropertyChangeListeners() {
        this.setupChairListener();
        this.setupClientListener();
        this.setupVisibilityChangeListener();
        this.setupLockedChangeListener();
        this.setupModeChangeListener();
    }

    private void setupClientListener() {
        this.clientProvider.get().addClientGroupListener(new ClientGroupListener(){

            public void clientGroupRenamed(ClientGroupEvent event) {
            }

            public void clientGroupDeleted(ClientGroupEvent event) {
            }

            public void clientGroupCreated(ClientGroupEvent event) {
            }

            public void clientGroupChanged(ClientGroupEvent event) {
                if (event.getClient().isMe()) {
                    PollingModule.this.utils.matchToGroup(event.getGroup());
                }
                PollingModule.this.statsModel.requestStatsUpdate();
            }
        });
    }

    private void setupModeChangeListener() {
        this.modeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PollingModule.this.utils.isMyGroup(PollingModule.this.clientProvider.get(), (ClientGroup)evt.getSource())) {
                    PollingModule.this.handlePollingModeChanged((Short)evt.getNewValue());
                }
            }
        };
        try {
            this.clientProvider.get().getClientList().addGroupPropertyChangeListener("pollingMode", this.modeListener);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set up listener for polling MODE changes");
        }
    }

    private void setupLockedChangeListener() {
        this.lockedChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PollingModule.this.handlePollingLockedChange(evt);
            }
        };
        try {
            this.clientProvider.get().getClientList().addGroupPropertyChangeListener("pollingLocked", this.lockedChangeListener);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register a listener for the polling locked state");
        }
    }

    private void setupVisibilityChangeListener() {
        this.visibilityChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PollingModule.this.handlePollingVisibleChange(evt);
            }
        };
        try {
            this.clientProvider.get().getClientList().addGroupPropertyChangeListener("pollingVisible", this.visibilityChangeListener);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register a listener for the polling visibility state");
        }
    }

    private void setupChairListener() {
        this.chairListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PollingModule.this.chairPropertyChange(evt);
            }
        };
        try {
            this.clientProvider.get().getClientList().addPropertyChangeListener("chair", this.chairListener);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register listener for the \"chair\" property");
        }
    }

    private void chairPropertyChange(PropertyChangeEvent evt) {
        Chair chair = this.chairProtocol.makeChair((Connection)this.clientProvider.get(), evt.getNewValue());
        this.isChair = chair.isMe();
        this.publishFeatures();
    }

    private void setupUIFeatures() {
        this.setupModeFeature();
        this.setupLockedFeature();
        this.setupVisibilityFeature();
        this.setupPublishFeature();
        this.setupClearFeature();
        this.publishFeatures();
        for (PollingTypeAdapter type : this.factory.getAllTypes()) {
            type.setup();
        }
    }

    private void registerStatsModelListener() {
        this.statsModel.addPollingStatsListener(new PollingStatsListener(){

            @Override
            public void resultsUpdate(Map<Character, Integer> currentResults) {
                PollingModule.this.handleResultsUpdate(currentResults);
            }
        });
    }

    protected void handleResultsUpdate(Map<Character, Integer> currentResults) {
        this.updateSummaryData(currentResults);
        this.updateSummaryFeatures(currentResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSummaryFeatures(Map<Character, Integer> currentResults) {
        if (!this.isChair || !this.anythingAboveZero(currentResults)) {
            this.broker.setFeaturePublished((Feature)this.clearFeature, false);
            currentResults.clear();
        } else if (!this.clearFeature.isPublished()) {
            this.broker.setFeaturePublished((Feature)this.clearFeature, true);
        }
        Map<Character, NumericFeature<Integer>> map = this.summaryData;
        synchronized (map) {
            for (NumericFeature<Integer> feature : this.summaryData.values()) {
                if (!feature.isPublished()) continue;
                this.broker.setFeaturePublished(feature, false);
            }
            for (Character c : this.summaryData.keySet()) {
                NumericFeature<Integer> feature = this.summaryData.get(c);
                if (currentResults.containsKey(c)) {
                    feature.setValue((Object)currentResults.get(c));
                    this.broker.setFeaturePublished(feature, true);
                    continue;
                }
                feature.setValue((Object)0);
            }
        }
    }

    private boolean anythingAboveZero(Map<Character, Integer> currentResults) {
        for (Character c : currentResults.keySet()) {
            if (c.charValue() == ' ' || currentResults.get(c) <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSummaryData(Map<Character, Integer> currentResults) {
        Map<Character, NumericFeature<Integer>> map = this.summaryData;
        synchronized (map) {
            if (currentResults != null) {
                for (Character pollResult : currentResults.keySet()) {
                    if (pollResult.charValue() == ' ' || this.summaryData.containsKey(pollResult)) continue;
                    this.summaryData.put(pollResult, this.generatePollResultFeature(pollResult, currentResults.get(pollResult)));
                }
            }
        }
    }

    private NumericFeature<Integer> generatePollResultFeature(Character pollResult, Integer value) {
        if (pollResult.charValue() == ' ') {
            throw new IllegalArgumentException("PollingProtocol.NONE is not an accepted response type");
        }
        String path = "/polling/summary/response" + pollResult;
        String name = "";
        String description = "";
        try {
            name = description = this.i18n.getStringLegacy(LOCALIZED_RESPONSE_PREFIX + pollResult);
        }
        catch (MissingResourceException mre) {
            name = description = pollResult.toString();
        }
        NumericFeature feature = this.broker.createNumericFeature((Object)this, path, true, value.intValue(), name, description);
        feature.setMetaDatum("responseName", (Object)this.getTextForResponse(pollResult));
        switch (pollResult.charValue()) {
            case 'n': 
            case 'y': {
                feature.setDefaultIcon(this.getIconForResponse(pollResult));
            }
        }
        return feature;
    }

    private Image getIconForResponse(Character response) {
        return this.factory.getCurrentPollingType().getImageFor(response);
    }

    private String getTextForResponse(Character response) {
        return this.factory.getCurrentPollingType().getTextFor(response);
    }

    private void setupClearFeature() {
        this.clearFeature = this.broker.createActionFeature((Object)this, CLEAR_RESPONSES_FEATURE, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_CLEARRESPONSES), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_CLEARRESPONSES));
        this.clearFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PollingModule.this.clearResponses();
            }
        });
    }

    protected void clearResponses() {
        this.model.clearAllPollAnswers(this.isChair);
    }

    private void publishFeatures() {
        this.broker.setFeaturePublished(this.pollingModeFeature, this.isChair);
        this.broker.setFeaturePublished((Feature)this.lockFeature, this.isChair);
        this.broker.setFeaturePublished((Feature)this.publishFeature, this.isChair);
        this.broker.setFeaturePublished((Feature)this.visibilityFeature, this.isChair);
        this.statsModel.requestStatsUpdate();
    }

    private void setupPublishFeature() {
        this.publishFeature = this.broker.createActionFeature((Object)this, PUBLISH_FEATURE_PATH, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_PUBLISHMENU), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_PUBLISHTIP));
        this.publishFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PollingModule.this.stats.publishStats();
            }
        });
    }

    private void setupLockedFeature() {
        this.lockFeature = this.broker.createBooleanFeature((Object)this, LOCK_FEATURE_PATH, true, false, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_LOCKANSWERSMENU), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_LOCKTIP));
        this.lockFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                Boolean locked = (Boolean)ev.getNewValue();
                if (locked == null) {
                    locked = false;
                }
                PollingModule.this.model.setPollingLock(locked);
            }
        });
        this.lockFeature.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_LOCKTIP));
        this.lockFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_LOCKANSWERSMENU));
        this.lockFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_LOCKANSWERSMENU));
    }

    private void setupVisibilityFeature() {
        this.visibilityFeature = this.broker.createBooleanFeature((Object)this, VISIBLE_FEATURE_PATH, true, false, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_SHOWANSWERSMENU), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_SHOWTIP));
        this.visibilityFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                Boolean visible = (Boolean)ev.getNewValue();
                if (visible == null) {
                    visible = false;
                }
                PollingModule.this.model.setPollingVisible(visible);
            }
        });
        this.visibilityFeature.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_SHOWTIP));
        this.visibilityFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_SHOWANSWERSMENU));
        this.visibilityFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_SHOWANSWERSMENU));
    }

    private void setupModeFeature() {
        Object[] allowedModes = new Short[]{NO_MODE, (short)1, (short)2, (short)3, (short)4};
        this.pollingModeFeature = this.broker.createEnumeratedFeature((Object)this, MODE_FEATURE_PATH, Short.class, true, (Object)NO_MODE, allowedModes, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_TYPE), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_TYPE));
        this.setPollModeValues();
        this.pollingModeFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                PollingModule.this.pollingModeChanged(ev);
            }
        });
        this.broker.setFeaturePublished(this.pollingModeFeature, true);
    }

    private void pollingModeChanged(MetaDataEvent evt) {
        Short newValue = (Short)evt.getNewValue();
        if (newValue == null) {
            this.model.setPollingMode((short)0);
        } else {
            this.model.setPollingMode(newValue);
        }
    }

    private void setPollModeValues() {
        this.pollingModeFeature.setValueText((Object)NO_MODE, null);
        this.pollingModeFeature.setValueText((Object)1, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_YESNOMENU));
        this.pollingModeFeature.setValueText((Object)2, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_ATOCMENU));
        this.pollingModeFeature.setValueText((Object)3, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_ATODMENU));
        this.pollingModeFeature.setValueText((Object)4, this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_ATOEMENU));
    }

    public void setupUI() {
        if (PollingProtocol.DEBUG.show()) {
            this.log.message("Polling.setupUI()");
        }
        if (!this.model.isPlaying()) {
            this.setupUIFeatures();
            this.setupPropertyChangeListeners();
            this.registerStatsModelListener();
            this.stats = new SummaryDialog(this.parentProvider.getDialogParent(), this.clientProvider.get().getClientList(), this.i18n.getString((PropertiesEnum)StringsProperties.POLLINGMODULE_SUMMARYTITLE), this.imps);
            this.stats.addImageAccessibilityListener(this);
        } else {
            if (PollingProtocol.DEBUG.show()) {
                this.log.message("We are in playback mode, we don't need to show any of the UI features.");
            }
            this.setupVisibilityChangeListener();
        }
        ((PollingResponseTranslator)this.responseTranslatorProvider.get()).setup();
    }

    public void cleanupUI() {
        ((PollingResponseTranslator)this.responseTranslatorProvider.get()).cleanup();
        if (this.broker != null) {
            for (NumericFeature<Integer> feature : this.summaryData.values()) {
                this.broker.setFeaturePublished(feature, false);
            }
        }
    }

    public void detach() {
        if (!this.model.isPlaying()) {
            Client client = this.clientProvider.get();
            ClientList clients = client.getClientList();
            clients.removePropertyChangeListener("chair", this.chairListener);
            clients.removeGroupPropertyChangeListener("pollingVisible", this.visibilityChangeListener);
            clients.removeGroupPropertyChangeListener("pollingLocked", this.lockedChangeListener);
            clients.removeGroupPropertyChangeListener("pollingMode", this.modeListener);
            clients.removeClientPropertyChangeListener("pollingValue", this.responseListener);
            for (PollingTypeAdapter pt : this.factory.getAllTypes()) {
                pt.cleanup();
            }
            this.statsModel.cleanup();
            this.swingRunner.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (PollingModule.this.stats != null) {
                        try {
                            PollingModule.this.stats.removeImageAccessibilityListener(PollingModule.this);
                            PollingModule.this.stats.dispose();
                            PollingModule.this.stats.cleanup();
                        }
                        finally {
                            PollingModule.this.stats = null;
                        }
                    }
                }
            });
        }
    }

    public void stop() {
    }

    public SummaryDialog getStatsDialog() {
        return this.stats;
    }

    private void handlePollingModeChanged(Short newMode) {
        if (newMode == null || newMode == 0) {
            this.model.setPollingMode((short)0);
            this.pollingModeFeature.setValue(null);
        } else {
            this.model.setPollingMode(newMode);
            this.pollingModeFeature.setValue((Object)newMode);
        }
        this.statsModel.requestStatsUpdate();
    }

    private void handlePollingLockedChange(PropertyChangeEvent e) {
        Boolean locked;
        if (this.utils.isMyGroup(this.clientProvider.get(), (ClientGroup)e.getSource()) && (locked = (Boolean)e.getNewValue()) != null) {
            this.model.setPollingLock(locked);
            this.lockFeature.setValue((Object)locked);
        }
    }

    private void handlePollingVisibleChange(PropertyChangeEvent e) {
        Boolean visible;
        if (this.utils.isMyGroup(this.clientProvider.get(), (ClientGroup)e.getSource()) && (visible = (Boolean)e.getNewValue()) != null) {
            this.model.setPollingVisible(visible);
            if (this.visibilityFeature != null) {
                this.visibilityFeature.setValue((Object)visible);
            }
        }
    }

    public void onAccessChange() {
        boolean publish = this.stats != null && this.model.canPublish();
        this.model.setPublishable(publish);
        this.publishFeature.setEnabled(publish);
    }
}

