/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio;

import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.audio.AudioProtocol;
import com.elluminate.groupware.audio.LoadTestResponderInterface;
import com.elluminate.groupware.imps.FollowTheSpeakerAPI;
import com.elluminate.groupware.imps.FollowTheSpeakerListener;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;
import java.io.DataInputStream;
import java.io.IOException;

public class AudioResponder
extends DefaultProtocolResponder
implements ChannelDataListener,
FollowTheSpeakerAPI {
    private ClientList clients = null;
    private boolean isRecorder = true;
    private LoadTestResponderInterface testResponder = null;
    private Imps imps;
    private short speaker = (short)-32767;
    private ListenerRegistry<FollowTheSpeakerListener> listenerRegistry;
    private Object lock = new Object();

    public AudioResponder() {
        super((JinxProtocol)new AudioProtocol());
        this.setChannelDataListener(this);
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initListenerRegistry(ListenerRegistry<FollowTheSpeakerListener> listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    public void join(Connection connection, String channel) {
        super.join(connection, channel);
        try {
            this.imps.provideAPI(FollowTheSpeakerAPI.class, (ImpsAPI)this);
            this.clients = connection.getClientList();
            ClientInfo ci = this.clients.get((short)1);
            boolean bl = this.isRecorder = ci != null && ci.isMe();
            if (!this.isRecorder) {
                Class<?> testClass = Class.forName("com.elluminate.groupware.audio.module.LoadTestResponder");
                this.testResponder = (LoadTestResponderInterface)testClass.newInstance();
                this.testResponder.setClientList(this.clients);
                this.testResponder.setChannels(this.channels);
            }
        }
        catch (Exception ex) {
            System.out.println("AudioResponder.join: Connection: " + connection + ", channel: " + channel + ", clients: " + this.clients);
            System.err.println("AudioResponder.join, cannot instantiate test responder");
            this.isRecorder = true;
        }
    }

    public void leave(String channel) {
        super.leave(channel);
        this.imps.revokeAPI(FollowTheSpeakerAPI.class, (ImpsAPI)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelData(ChannelDataEvent e) {
        if (e.getCommand() == 13) {
            DataInputStream istr = e.read();
            try {
                this.fireSpeakerChanged(istr.readShort());
            }
            catch (IOException iox) {
            }
            finally {
                try {
                    istr.close();
                }
                catch (Throwable t) {}
            }
            return;
        }
        if (this.isRecorder) {
            switch (e.getCommand()) {
                case 11: {
                    Channel chnl = (Channel)this.channels.get(0);
                    ChannelDataEvent event = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)10);
                    chnl.onChannelData(event, (byte)0);
                    break;
                }
                case 7: {
                    Channel chnl = (Channel)this.channels.get(0);
                    ChannelDataEvent event = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)6);
                    chnl.onChannelData(event, (byte)0);
                    break;
                }
            }
        } else {
            this.testResponder.onChannelData(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSpeakerChanged(short newSpeaker) {
        Object object = this.lock;
        synchronized (object) {
            this.speaker = newSpeaker;
        }
        this.listenerRegistry.fire((FiringFunctor)new FiringFunctor<FollowTheSpeakerListener>(){

            public void fire(FollowTheSpeakerListener listener) {
                listener.speakerChanged(AudioResponder.this.speaker);
            }
        });
    }

    public String getProvider() {
        return "AudioResponder";
    }

    public byte getTier() {
        return 32;
    }

    public short getSpeaker() {
        return this.speaker;
    }

    public void addFollowTheSpeakerListener(FollowTheSpeakerListener listener) {
        this.listenerRegistry.add((Object)listener);
    }

    public void removeFollowTheSpeakerListener(FollowTheSpeakerListener listener) {
        this.listenerRegistry.remove((Object)listener);
    }
}

