/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.webrtc;

import com.elluminate.groupware.audio.module.SampleData;
import com.elluminate.util.log.LogSupport;
import java.util.Date;
import java.util.LinkedList;

public class WebRTC {
    private static final int WebrtcCode_badDataLengthError = -8;
    private static final int WebrtcCode_badStreamParameterWarning = -13;
    private static boolean nativeLibLoaded = false;
    private LinkedList aecQueue;
    private volatile int aecQueueAmt = 0;
    private boolean recording = false;
    private long apm = 0L;
    private Object apmLock = new Object();
    private volatile int echoCancellationLevel = 2;
    private volatile boolean echoCancellationLevelChanged = false;
    private volatile int noiseSuppressionLevel = 0;
    private volatile boolean noiseSuppressionLevelChanged = false;
    private volatile int agcCompressionGain = 5;
    private volatile boolean agcCompressionGainChanged = false;
    private volatile int agcTargetLevel = 6;
    private volatile boolean agcTargetLevelChanged = false;
    private volatile boolean noiseSuppressionEnabled = true;
    private volatile boolean noiseSuppressionChanged = false;
    private volatile boolean useAGC = false;
    private volatile boolean useAEC = false;
    private volatile boolean useMetrics = false;
    private volatile boolean metricsSettingChanged = false;
    private int sampleRate;
    private int oldLevel = 0;
    private int oldMicLevel = 0;

    private static native String nativeGetVersion();

    private native long apm_Create();

    private native void apm_Destroy(long var1);

    private native void apm_setDebug(int var1);

    private native int apm_startDebugRecording(long var1, String var3);

    private native void apm_stopDebugRecording(long var1);

    private native int apm_SetSampleRateHz(long var1, int var3);

    private native int apm_SetNumChannels(long var1, int var3, int var4);

    private native int apm_SetNumReverseChannels(long var1, int var3);

    private native int apm_SetStreamDelayMS(long var1, int var3);

    private native int apmHPF_enable(long var1, int var3);

    private native int apmNS_enable(long var1, int var3);

    private native int apmAGC_enable(long var1, int var3);

    private native int apmLE_enable(long var1, int var3);

    private native int apmVAD_enable(long var1, int var3);

    private native int apmEC_enable(long var1, int var3);

    private native int apmHPF_enabled(long var1);

    private native int apmNS_enabled(long var1);

    private native int apmAGC_enabled(long var1);

    private native int apmLE_enabled(long var1);

    private native int apmVAD_enabled(long var1);

    private native int apmEC_enabled(long var1);

    private native int apmVAD_setFrameSize_ms(long var1, int var3);

    private native int apmVAD_getFrameSize_ms(long var1);

    private native int apmVAD_setLikelihood(long var1, int var3);

    private native int apmVAD_getLikelihood(long var1);

    private native int apmVAD_hasVoice(long var1);

    private native int apmNS_setLevel(long var1, int var3);

    private native int apmNS_getLevel(long var1);

    private native int apmEC_enableDriftCompensation(long var1, int var3);

    private native int apmEC_enableMetrics(long var1, int var3);

    private native int apmEC_setDeviceSampleRateHz(long var1, int var3);

    private native int apmEC_setStreamDriftSamples(long var1, int var3);

    private native int apmEC_setSuppressionLevel(long var1, int var3);

    private native int apmEC_printMetrics(long var1);

    private native int apmEC_hasEcho(long var1);

    private native int apmAGC_setAnalogLevelLimits(long var1, int var3, int var4);

    private native int apmAGC_setMode(long var1, int var3);

    private native int apmAGC_setAnalogLevel(long var1, int var3);

    private native int apmAGC_getAnalogLevel(long var1);

    private native int apmAGC_streamIsSaturated(long var1);

    private native int apmAGC_getTargetLevel(long var1);

    private native int apmAGC_setTargetLevel(long var1, int var3);

    private native int apmAGC_getCompressionGain(long var1);

    private native int apmAGC_setCompressionGain(long var1, int var3);

    private native int apmAGC_getLimiterEnabled(long var1);

    private native int apmAGC_setLimiterEnabled(long var1, int var3);

    private native int apm_processStream(long var1, short[] var3, short var4, int var5);

    private native int apm_analyzeReverseStream(long var1, short[] var3, short var4, int var5);

    public WebRTC() {
        this.aecQueue = new LinkedList();
    }

    public int setSampleRate(int _sampleRate) {
        int ret = this.apm_SetSampleRateHz(this.apm, _sampleRate);
        if (ret == 0) {
            this.sampleRate = _sampleRate;
            LogSupport.message((Object)this, (String)"setSampleRate", (String)("set sample rate " + _sampleRate));
        } else {
            LogSupport.error((Object)this, (String)"setSampleRate", (String)("FAILED setting sample rate " + _sampleRate + "  ret=" + ret));
        }
        return ret;
    }

    public boolean hasEcho() {
        boolean ret = false;
        if (this.apm != 0L) {
            ret = 1 == this.apmEC_hasEcho(this.apm);
        }
        return ret;
    }

    public void setNoiseSuppression(boolean enable) {
        this.noiseSuppressionEnabled = enable;
        this.noiseSuppressionChanged = true;
    }

    public void setNoiseSuppressionLevel(int level) {
        this.noiseSuppressionLevel = level;
        this.noiseSuppressionLevelChanged = true;
    }

    public void setEchoCancellationLevel(int level) {
        this.echoCancellationLevel = level;
        this.echoCancellationLevelChanged = true;
    }

    public void enableMetrics(boolean enable) {
        this.useMetrics = enable;
        this.metricsSettingChanged = true;
    }

    public void setCompressionGain(int gain) {
        this.agcCompressionGain = gain;
        this.agcCompressionGainChanged = true;
        LogSupport.message((Object)this, (String)"setCompressionGain", (String)("reset AGC to set compression gain: " + this.agcCompressionGain));
    }

    public void setTargetLevel(int level) {
        this.agcTargetLevel = level;
        this.agcTargetLevelChanged = true;
        LogSupport.message((Object)this, (String)"setTargetLevel", (String)("reset AGC to set target level: " + this.agcTargetLevel));
    }

    public int initAGC(boolean enable) {
        int retValue = 0;
        if (this.apm != 0L) {
            if (enable && !this.useAGC) {
                LogSupport.message((Object)this, (String)"initAGC", (String)"initializing AGC...");
                LogSupport.message((Object)this, (String)"initAGC", (String)("AGC target level: " + this.agcTargetLevel));
                LogSupport.message((Object)this, (String)"initAGC", (String)("AGC compression gain: " + this.agcCompressionGain));
                int ret1 = this.apmAGC_setAnalogLevelLimits(this.apm, 0, 255);
                int ret2 = this.apmAGC_setMode(this.apm, 0);
                int ret3 = this.apmAGC_setTargetLevel(this.apm, this.agcTargetLevel);
                int ret4 = this.apmAGC_setCompressionGain(this.apm, this.agcCompressionGain);
                int ret5 = this.apmAGC_setLimiterEnabled(this.apm, 0);
                if (ret1 != 0 || ret2 != 0 || ret3 != 0 || ret4 != 0 || ret5 != 0) {
                    LogSupport.error((Object)this, (String)"initAGC", (String)"AGC FAILED initialization");
                    retValue = -1;
                    this.useAGC = false;
                } else {
                    retValue = this.apmAGC_enable(this.apm, 1);
                    if (retValue != 0) {
                        LogSupport.message((Object)this, (String)"initAGC", (String)"FAILED enabling AGC");
                        this.useAGC = false;
                    } else {
                        this.useAGC = true;
                    }
                }
            } else if (!enable && this.useAGC) {
                LogSupport.message((Object)this, (String)"initAGC", (String)"disabling AGC...");
                this.useAGC = false;
                retValue = this.apmAGC_enable(this.apm, 0);
            }
        } else {
            LogSupport.message((Object)this, (String)"initAGC", (String)"disabling AGC since webrtc not initialized");
            retValue = -1;
            this.useAGC = false;
        }
        return retValue;
    }

    public int initAEC(boolean enable) {
        int retValue = 0;
        if (this.apm != 0L) {
            if (enable && !this.useAEC) {
                LogSupport.message((Object)this, (String)"initAEC", (String)"initializing AEC...");
                int ret1 = this.apmEC_setSuppressionLevel(this.apm, this.echoCancellationLevel);
                int ret2 = this.apmEC_enableDriftCompensation(this.apm, 0);
                int ret3 = this.apmEC_enableMetrics(this.apm, this.useMetrics ? 1 : 0);
                this.apm_setDebug(this.useMetrics ? 1 : 0);
                if (ret1 != 0 || ret2 != 0 || ret3 != 0) {
                    LogSupport.error((Object)this, (String)"initAEC", (String)"AEC FAILED initialization");
                    retValue = -1;
                    this.useAEC = false;
                } else {
                    retValue = this.apmEC_enable(this.apm, 1);
                    if (retValue != 0) {
                        LogSupport.error((Object)this, (String)"initAEC", (String)"FAILED enabling AEC");
                        this.useAEC = false;
                    } else {
                        this.useAEC = true;
                    }
                }
            } else if (!enable && this.useAEC) {
                LogSupport.message((Object)this, (String)"initAEC", (String)"disabling AEC...");
                this.useAEC = false;
                retValue = this.apmEC_enable(this.apm, 0);
            }
        } else {
            LogSupport.message((Object)this, (String)"initAEC", (String)"disabling AEC since webrtc not initialized");
            retValue = -1;
            this.useAEC = false;
        }
        return retValue;
    }

    public void startDebugRecording() {
        if (this.apm != 0L) {
            Date date = new Date();
            String fname = "_webrtc_debug_" + date.getTime() + ".pb";
            int ret = this.apm_startDebugRecording(this.apm, fname);
            if (ret != 0) {
                LogSupport.error((Object)this, (String)"startDebugRecording", (String)("problem starting webrtc debug recording: " + fname));
            } else {
                this.recording = true;
                LogSupport.message((Object)this, (String)"startDebugRecording", (String)("starting webrtc debug recording: " + fname));
            }
        }
    }

    public void stopDebugRecording() {
        if (this.apm != 0L && this.recording) {
            Date date = new Date();
            this.recording = false;
            LogSupport.message((Object)this, (String)"stopDebugRecording", (String)("stopping webrtc debug recording: time stamp = " + date.getTime()));
            this.apm_stopDebugRecording(this.apm);
        }
    }

    public int defaultInit(int _sampleRate) {
        int retValue = 0;
        if (this.apm == 0L && nativeLibLoaded) {
            this.apm = this.apm_Create();
        } else {
            LogSupport.message((Object)this, (String)"defaultInit", (String)("nativeLibLoaded = " + nativeLibLoaded + "   Did NOT create apm <---"));
        }
        if (this.apm != 0L) {
            this.apm_setDebug(0);
            int ret0 = this.apm_SetSampleRateHz(this.apm, _sampleRate);
            int ret1 = this.apm_SetNumChannels(this.apm, 1, 1);
            int ret2 = this.apm_SetNumReverseChannels(this.apm, 1);
            int ret3 = this.apmHPF_enable(this.apm, 1);
            int ret4 = this.apmNS_setLevel(this.apm, this.noiseSuppressionLevel);
            int ret5 = this.apmNS_enable(this.apm, this.noiseSuppressionEnabled ? 1 : 0);
            if (ret0 != 0 || ret1 != 0 || ret2 != 0 || ret3 != 0 || ret4 != 0 || ret5 != 0) {
                LogSupport.error((Object)this, (String)"defaultInit", (String)("FAILED initializing webrtc: ret0 = " + ret0 + " ret1 = " + ret1 + " ret2 = " + ret2 + " ret3 = " + ret3 + " ret4 = " + ret4 + " ret5 = " + ret5));
                this.apm_Destroy(this.apm);
                this.apm = 0L;
                retValue = -1;
            }
            if (retValue == 0) {
                this.sampleRate = _sampleRate;
                LogSupport.message((Object)this, (String)"defaultInit", (String)"initialized");
            }
        } else {
            retValue = -1;
        }
        return retValue;
    }

    private void enqueueReferenceAudio(int sampleCnt, short[] data) {
        SampleData sampleData = new SampleData(data, 0, sampleCnt);
        this.aecQueue.addLast(sampleData);
        this.aecQueueAmt += sampleCnt;
    }

    private int dequeueAECReferenceAudio(int countRequest, short[] referenceBuf) {
        int sampleCnt = 0;
        boolean queueExhausted = false;
        boolean balk = false;
        if (this.aecQueueAmt < countRequest) {
            balk = true;
        }
        while (!balk && sampleCnt < countRequest && this.aecQueue.size() > 0) {
            int needed = countRequest - sampleCnt;
            SampleData sampleData = (SampleData)this.aecQueue.getFirst();
            if (needed < sampleData.dataLen) {
                System.arraycopy(sampleData.dataBuf, sampleData.dataOff, referenceBuf, sampleCnt, needed);
                sampleData.dataOff += needed;
                sampleData.dataLen -= needed;
                sampleCnt += needed;
                this.aecQueueAmt -= needed;
            } else {
                System.arraycopy(sampleData.dataBuf, sampleData.dataOff, referenceBuf, sampleCnt, sampleData.dataLen);
                sampleCnt += sampleData.dataLen;
                this.aecQueue.removeFirst();
                this.aecQueueAmt -= sampleData.dataLen;
            }
            if (this.aecQueueAmt > 0) continue;
            queueExhausted = true;
        }
        if (balk) {
            return -1;
        }
        return sampleCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeReverseStream(int totalSampleCnt, short[] data) {
        if (this.apm != 0L && this.useAEC) {
            int ret;
            this.enqueueReferenceAudio(totalSampleCnt, data);
            int samplesNeeded = this.sampleRate * 10 / 1000;
            do {
                short[] refBuff;
                int samplesDequeued;
                if ((samplesDequeued = this.dequeueAECReferenceAudio(samplesNeeded, refBuff = new short[samplesNeeded])) != samplesNeeded) {
                    return;
                }
                Object object = this.apmLock;
                synchronized (object) {
                    ret = this.apm_analyzeReverseStream(this.apm, refBuff, (short)samplesDequeued, this.sampleRate);
                }
            } while (ret == 0);
            LogSupport.error((Object)this, (String)"analyzeReverseStream", (String)("ERROR analyzing stream: " + ret + " samplesNeeded " + samplesNeeded));
            return;
        }
    }

    private void checkProcessParameters() {
        if (this.agcTargetLevelChanged) {
            this.apmAGC_setTargetLevel(this.apm, this.agcTargetLevel);
            this.agcTargetLevelChanged = false;
        }
        if (this.agcCompressionGainChanged) {
            this.apmAGC_setCompressionGain(this.apm, this.agcCompressionGain);
            this.agcCompressionGainChanged = false;
        }
        if (this.noiseSuppressionLevelChanged) {
            this.apmNS_setLevel(this.apm, this.noiseSuppressionLevel);
            this.noiseSuppressionLevelChanged = false;
        }
        if (this.echoCancellationLevelChanged) {
            this.apmEC_setSuppressionLevel(this.apm, this.echoCancellationLevel);
            this.echoCancellationLevelChanged = false;
        }
        if (this.noiseSuppressionChanged) {
            this.apmNS_enable(this.apm, this.noiseSuppressionEnabled ? 1 : 0);
            this.noiseSuppressionChanged = false;
        }
        if (this.metricsSettingChanged) {
            this.apmEC_enableMetrics(this.apm, this.useMetrics ? 1 : 0);
            this.apm_setDebug(this.useMetrics ? 1 : 0);
            this.metricsSettingChanged = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processStream(int totalSampleCount, short[] sampleBuff, int currentMicLevel, int latency) {
        int prescribedMicLevel = 0;
        int chunkSampleSize = this.sampleRate / 100;
        if (totalSampleCount % chunkSampleSize != 0) {
            LogSupport.error((Object)this, (String)"processStream", (String)("ERROR: handling " + totalSampleCount + " audio samples at a time"));
        }
        if (this.apm != 0L) {
            int numChunks = totalSampleCount / chunkSampleSize;
            short[][] sampleBuffs = new short[numChunks][chunkSampleSize];
            int currLevel = 0;
            int numPrescriptions = 0;
            int delta = 0;
            int newLevel = 0;
            if (this.useAGC) {
                currLevel = (currentMicLevel * 255 + 50) / 100;
                if (this.oldMicLevel == currentMicLevel) {
                    currLevel = this.oldLevel;
                }
            }
            for (int i = 0; i < numChunks; ++i) {
                Object object = this.apmLock;
                synchronized (object) {
                    int chunk_latency_ms;
                    int ret;
                    if (this.useAGC && (ret = this.apmAGC_setAnalogLevel(this.apm, currLevel)) != 0) {
                        LogSupport.error((Object)this, (String)"processStream", (String)("ERROR setting stream analog level: " + ret));
                        return -1;
                    }
                    if (this.useAEC && (ret = this.apm_SetStreamDelayMS(this.apm, latency + (chunk_latency_ms = (numChunks - i - 1) * 10))) != 0) {
                        LogSupport.error((Object)this, (String)"processStream", (String)("ERROR setting stream delay (of " + latency + " + " + chunk_latency_ms + " ms)  returned: " + ret));
                        if (ret != -13) {
                            return -1;
                        }
                    }
                    System.arraycopy(sampleBuff, i * chunkSampleSize, sampleBuffs[i], 0, chunkSampleSize);
                    this.checkProcessParameters();
                    ret = this.apm_processStream(this.apm, sampleBuffs[i], (short)chunkSampleSize, this.sampleRate);
                    if (ret != 0) {
                        switch (ret) {
                            case -8: {
                                LogSupport.error((Object)this, (String)"processStream", (String)("Bad Data Length. chunkSampleSize = " + chunkSampleSize + "  sampleRate = " + this.sampleRate + " (ret=" + ret + ")"));
                                break;
                            }
                            case -13: {
                                LogSupport.message((Object)this, (String)"processStream", (String)("Bad Stream Parameter Warning (ret=" + ret + ")  sampleRate = " + this.sampleRate + "  Will continue processing"));
                                break;
                            }
                            default: {
                                LogSupport.error((Object)this, (String)"processStream", (String)("ERROR processing stream: " + ret));
                            }
                        }
                        if (ret != -13) {
                            return -1;
                        }
                    }
                    if (ret == 0 && this.useAGC) {
                        newLevel = this.apmAGC_getAnalogLevel(this.apm);
                        if (newLevel < 0) {
                            LogSupport.error((Object)this, (String)"processStream", (String)("AGC: ERROR getting stream analog level: " + ret));
                            newLevel = this.oldLevel;
                        } else if (newLevel != currLevel) {
                            delta += newLevel - currLevel;
                            ++numPrescriptions;
                        }
                        if (this.apmAGC_streamIsSaturated(this.apm) == 1) {
                            LogSupport.message((Object)this, (String)"processStream", (String)"AUDIO WARNING: stream is SATURATED");
                        }
                    }
                }
                System.arraycopy(sampleBuffs[i], 0, sampleBuff, i * chunkSampleSize, chunkSampleSize);
            }
            this.oldLevel = newLevel;
            this.oldMicLevel = currentMicLevel;
            if (numPrescriptions > 0 && this.useAGC) {
                prescribedMicLevel = ((currLevel + delta / numChunks) * 100 + 127) / 255;
            }
        }
        return prescribedMicLevel;
    }

    public void destroy() {
        if (this.apm != 0L) {
            this.aecQueue.clear();
            this.aecQueueAmt = 0;
            this.apm_Destroy(this.apm);
            this.apm = 0L;
        }
    }

    static {
        try {
            System.loadLibrary("WebRTC");
            System.out.println("Loaded native library WebRTC, version: " + WebRTC.nativeGetVersion());
            nativeLibLoaded = true;
        }
        catch (Throwable t) {
            System.out.println("[ FAILED to load WebRTC library ] " + t);
        }
    }

    public static enum PlatformType {
        PLATFORM_WINDOWS,
        PLATFORM_OSX;

    }
}

