/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module.windows;

import java.util.LinkedList;

class NativeWorker
extends Thread {
    private static int workerSequence = 1;
    private LinkedList<RunnerData> runnableQueue = new LinkedList();
    private boolean idle = true;

    public NativeWorker() {
        super("Audio Native Windows Worker " + workerSequence++);
        this.setDaemon(true);
        this.setPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Runnable runnable, boolean wake) {
        if (wake && Thread.currentThread() == this) {
            throw new RuntimeException("Attempt to invoke and wait from NativeWorker invoked task");
        }
        RunnerData runnerData = new RunnerData(runnable, wake);
        Object object = this.runnableQueue;
        synchronized (object) {
            this.runnableQueue.add(runnerData);
            if (this.idle) {
                this.runnableQueue.notify();
            }
        }
        object = runnerData;
        synchronized (object) {
            if (runnerData.wake) {
                try {
                    runnerData.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorker() {
        LinkedList<RunnerData> linkedList = this.runnableQueue;
        synchronized (linkedList) {
            this.interrupt();
            this.runnableQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!NativeWorker.interrupted()) {
            RunnerData runnerData;
            Object object = this.runnableQueue;
            synchronized (object) {
                runnerData = null;
                while (this.runnableQueue.size() == 0) {
                    try {
                        this.idle = true;
                        this.runnableQueue.wait();
                        this.idle = false;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                if (this.runnableQueue.size() > 0) {
                    try {
                        runnerData = this.runnableQueue.removeFirst();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            if (runnerData == null) continue;
            try {
                runnerData.runnable.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            object = runnerData;
            synchronized (object) {
                if (runnerData.wake) {
                    runnerData.wake = false;
                    runnerData.notify();
                }
            }
        }
    }

    class RunnerData {
        boolean wake;
        Runnable runnable;

        RunnerData(Runnable runnable, boolean wake) {
            this.runnable = runnable;
            this.wake = wake;
        }
    }
}

