/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.gui.component.MediaBorder;
import com.elluminate.platform.Platform;
import com.elluminate.util.LightweightTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;

public class VUMeter
extends JPanel {
    static final int BAR_WIDTH = 3;
    static final int PEAK_BAR_WIDTH = 2;
    static final int GAP_WIDTH = 1;
    static final int BAR_INTERVAL = 4;
    static final int BAR_OFFSET = 1;
    static final int MARGIN = 1;
    static final long PEAK_HOLD_TIME = 750L;
    static final long MIN_REPAINT_DELTA = 250L;
    JSlider level = null;
    int value = 0;
    int range = 100;
    int peakX = 0;
    Color peakColor;
    long peakTime = 0L;
    boolean peakHoldOn;
    MediaBorder mborder = new MediaBorder();
    int delta = 0;
    LightweightTimer peakTimer = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            VUMeter.this.repaint();
        }
    });
    float yThreshold = 0.6f;
    float rThreshold = 0.85f;
    long lastRepaintTime = 0L;
    int maxValueSinceLastRepaint = 0;
    private static final Color backColor = Color.black;
    private static final Color unlitColor = new Color(32, 32, 32);
    private static final Color goodColor = new Color(40, 169, 64);
    private static final Color thresholdColor = new Color(255, 205, 0);
    private static final Color loudColor = new Color(255, 40, 0);

    public VUMeter() {
        this(true);
    }

    public VUMeter(JSlider level) {
        this(level, true);
    }

    public VUMeter(boolean peakHoldOn) {
        this((JSlider)null, peakHoldOn);
    }

    public VUMeter(JSlider level, boolean peakHoldOn) {
        super(null);
        this.level = level;
        this.peakHoldOn = peakHoldOn;
        this.setBorder((Border)new MediaBorder());
        this.setPreferredSize(new Dimension(100, 18));
        if (level != null) {
            level.setOpaque(false);
            level.setBackground(new Color(0, 0, 0, 0));
            level.setPaintTrack(false);
            this.add((Component)level, null);
        }
    }

    public void setDelta(int d) {
        this.delta = d;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.level != null) {
            int w = this.getWidth();
            int h = this.level.getPreferredSize().height;
            int y = (this.getHeight() - h) / 2;
            this.level.setBounds(0, y, w, h);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int lastX = 0;
        Color lastColor = null;
        super.paintComponent(g);
        Dimension s = this.getSize();
        Insets ins = this.mborder.getBorderInsets((Component)this);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, s.width, s.height);
        Rectangle bar = new Rectangle(this.delta, this.delta, s.width - 2 * this.delta, s.height - 2 * this.delta);
        this.mborder.paintBorder((Component)this, g, bar.x, bar.y, bar.width, bar.height);
        g.setColor(backColor);
        g.fillRect(bar.x + ins.left, bar.y + ins.top, bar.width - ins.left - ins.right, bar.height - ins.top - ins.bottom);
        int nSegments = bar.width / 4;
        int nLit = this.value * nSegments / this.range;
        int yLimit = (int)(this.yThreshold * (float)nSegments);
        int rLimit = (int)(this.rThreshold * (float)nSegments);
        int x = bar.x + ins.left + 1;
        int y = bar.y + ins.top + 1;
        int barHeight = bar.height - ins.top - ins.bottom - 2;
        Color color = unlitColor;
        for (int i = 0; i < nSegments; ++i) {
            if (i >= nLit) {
                color = unlitColor;
            } else {
                color = i > rLimit ? loudColor : (i > yLimit ? thresholdColor : goodColor);
                lastColor = color;
                lastX = x;
            }
            int barWidth = 3;
            if (x + barWidth > bar.width - ins.right - 1) {
                barWidth = bar.width - ins.right - 1 - x;
            }
            g.setColor(color);
            g.fillRect(x, y, barWidth, barHeight);
            x += 4;
        }
        if (this.peakHoldOn) {
            if (lastX > this.peakX || this.peakTime <= System.currentTimeMillis()) {
                this.peakTime = System.currentTimeMillis() + 750L;
                this.peakX = lastX;
                this.peakColor = lastColor;
            }
            if (this.peakX > 0) {
                g.setColor(this.peakColor);
                g.fillRect(this.peakX + 3 - 2, y, 2, barHeight);
            }
            this.peakTimer.scheduleAt(this.peakTime + 750L);
        }
    }

    @Override
    public void paintBorder(Graphics g) {
        super.paintBorder(g);
    }

    public void setValue(int newValue) {
        long now = Platform.currentTimeMillis();
        if (this.maxValueSinceLastRepaint < newValue || now - this.lastRepaintTime > 250L) {
            this.maxValueSinceLastRepaint = newValue;
        }
        if (now - this.lastRepaintTime < 250L) {
            return;
        }
        if (this.value != this.maxValueSinceLastRepaint) {
            this.value = this.maxValueSinceLastRepaint;
            this.repaint();
        }
        this.lastRepaintTime = now;
        this.maxValueSinceLastRepaint = 0;
    }

    public void clearValue() {
        this.peakX = 0;
        this.value = 0;
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public void setRange(int newRange) {
        this.range = newRange;
        if (this.value > this.range) {
            this.value = this.range;
        }
        this.repaint();
    }

    public int getRange() {
        return this.range;
    }

    public void setYellowPercent(int percent) {
        this.yThreshold = (float)percent / 100.0f;
    }

    public int getYellowPercent() {
        return (int)(this.yThreshold * 100.0f);
    }

    public void setRedPercent(int red) {
        this.rThreshold = (float)red / 100.0f;
    }

    public int getRedPercent() {
        return (int)(this.rThreshold * 100.0f);
    }
}

