/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.module;

import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.groupware.audio.AudioDebug;
import com.elluminate.groupware.audio.module.AudioSupport;
import com.elluminate.groupware.audio.module.DeviceSelectionPanel;
import com.elluminate.groupware.audio.module.InputEvent;
import com.elluminate.groupware.audio.module.InputListener;
import com.elluminate.groupware.audio.module.SampleData;
import com.elluminate.groupware.audio.module.StringsProperties;
import com.elluminate.groupware.audio.resampler.Resampler;
import com.elluminate.groupware.audio.webrtc.WebRTC;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.HistogramPanel;
import com.elluminate.gui.event.ModalDialogAsyncRequest;
import com.elluminate.gui.swing.CFrame;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.Resource;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TooManyListenersException;
import javax.swing.JButton;
import javax.swing.JFrame;

public class AudioEngine {
    private static final String BROWSER_SUPPORT = "com.elluminate.groupware.audio.module.browser.BrowserAudioSupport";
    private static final String WIN_SUPPORT = "com.elluminate.groupware.audio.module.windows.WinAudioSupport";
    private static final String OSX_SUPPORT = "com.elluminate.groupware.audio.module.macosx.MacOSXAudioSupport";
    private static final String JAVA_SUPPORT = "com.elluminate.groupware.audio.module.javasound.JavaSoundAudioSupport";
    private static final int DEV_CLOSED = 0;
    private static final int DEV_ERROR = -1;
    private static final int DEV_OPEN = 1;
    private static final int DEV_SUSPENDED = 2;
    private static final int DEV_EAVESDROP = 3;
    private static final float LEGACY_MIKE_EXTRA_GAIN_LIM = 10.0f;
    private static final int MIKE_REQ_CLOSE = 1;
    private static final int MIKE_REQ_NONE = 0;
    private static final int MIKE_REQ_OPEN = 2;
    private static final int MIKE_REQ_FORCE_CLOSE = 3;
    private static final int MIKE_REQ_OPEN_EAVESDROP = 4;
    private static final int SPKR_QUEUE_WARN_SECS = 60;
    private static final int SPKR_REQ_NONE = 0;
    private static final int SPKR_REQ_RESUME = 1;
    private static final int SPKR_REQ_SUSPEND = 2;
    private static final int WARNING_TRY_CNT = 10;
    private static final int BEEP_CHN = 34;
    private static final int CODEC_FRAME_LEN = 160;
    public static final int CODEC_FRAME_MILLIS = 20;
    private static final int CODEC_SAMP_RATE = 8000;
    private static final int CUST_SOUND_CHN = 35;
    private static final int MAX_FRAMES_PER_PACKET = 12;
    private static final int MAX_MILLIS_PER_PACKET = 240;
    private static final int MIN_MILLIS_PER_PACKET = 20;
    private static final int SPKR_CHN_CNT = 36;
    private static final int SPKR_QUEUE_LIM_INC = 480000;
    private static final int SPKR_MIXER_CNT = 160;
    private static final int SPKR_MIXER_MILLIS = 20;
    private static final byte[] MIKE_BEGIN = new byte[]{4};
    private static final byte[] MIKE_END = new byte[]{5};
    private static final byte[] MIKE_END_BEGIN = new byte[]{5, 4};
    private static Object audioLock = new Object();
    private static Object audioSupportInputLock = new Object();
    private static Object audioSupportOutputLock = new Object();
    private static Object changeListenerLock = new Object();
    private static ArrayList changeListenerVec = new ArrayList();
    private static int spkrBacklogMaxTrimPct = 100;
    private static AudioEngine theEngine = null;
    private static boolean theEngineInit = false;
    private static final boolean _isOSX = Platform.getOS() == 202;
    private static final boolean _isWin = Platform.getPlatform() == 1;
    private static final boolean _isX86_32_or_64 = Platform.getArch() == 101;
    private static final boolean _isOSX_new_enough = _isOSX && Platform.checkOSVersion((int)202, (String)"10.6+");
    private static boolean webrtcSupported = (_isOSX_new_enough || _isWin) && _isX86_32_or_64;
    private static final boolean latencyImplemented = Platform.getPlatform() != 3 && Platform.getPlatform() != 0;
    private static boolean overrideAudioStackSelection = false;
    private WebRTC webrtc;
    private volatile boolean useAEC = false;
    private volatile boolean useAGC = false;
    private AudioSupport audioSupport = null;
    private volatile long beepDoneTime = 0L;
    private short[] beepSamps = null;
    private LinkedList customSoundInfos = new LinkedList();
    private boolean enforceHalfDuplex = false;
    private I18n i18n = I18n.create((Object)this);
    private volatile int latencyOverrideMilliSecs = 0;
    private float mikeExtraGain = 1.0f;
    private Object mikeLock = new Object();
    private volatile int mikeState = 0;
    private InputListener mikeListener = null;
    private Object mikeListenerLock = new Object();
    private volatile int mikeMillisPerPacket = 20;
    private long mikeMillisRead = 0L;
    private Resampler mikeResampler = new Resampler(8000, 0);
    private short[] mikeResamplerBuf = new short[1920];
    private int mikeSampRate = 8000;
    private int mikeStateReq = 0;
    private Thread mikeThread = null;
    private short[] mixedBuf = new short[160];
    private int[] mixingBuf = new int[160];
    private boolean muteWhenTalking = false;
    private volatile int digitalGainLimit = 6;
    private volatile float digitalGainMin = 1.5f;
    private Component owner = null;
    private float peakedSampleRunCount = 0.0f;
    private int preferredMikeSampRate = 0;
    private int preferredSpkrSampRate = 0;
    private SerializerThread diagnosticThread = new SerializerThread("Audio Diagnostic Thread");
    private volatile boolean showingBacklogWarning = false;
    private volatile long spkrDoneTime = 0L;
    private long spkrDoneTimeCnt = 0L;
    private Object spkrLock = new Object();
    private int spkrQueueLim = 480000;
    private LinkedList[] spkrQueues = new LinkedList[36];
    private volatile int[] spkrQueuesAmt = new int[36];
    private Resampler spkrResampler = new Resampler(8000, 0);
    private short[] spkrResamplerBuf = new short[0];
    private int spkrSampRate = 8000;
    private volatile int spkrState = 0;
    private int spkrStateReq = 0;
    private int startSpkrTryCnt = 0;
    private Thread spkrThread = null;
    private Resampler[] trimResampler = new Resampler[36];
    private int echoArrayFrameCount = 0;
    private int[] echoCount = new int[10];
    private ModalDialogAsyncRequest cantConnectSpkrMsgDialog = null;
    private ContentCapture contentCapture;
    private static ContentCaptureProvider contentCaptureProvider;
    private HistogramPanel histoPanel = null;
    private JFrame histoFrame = null;
    private final int[] histogramData = new int[16];

    public static void initContentCaptureProvider(ContentCaptureProvider contentCaptureProviderArg) {
        contentCaptureProvider = contentCaptureProviderArg;
    }

    @Inject
    private AudioEngine() {
        if (this.audioSupport == null && contentCaptureProvider.get().isCapturingData() && !contentCaptureProvider.get().isEchoingData()) {
            this.audioSupport = this.loadAudioSupport(BROWSER_SUPPORT, this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_BROWSERSUPPORT));
            return;
        }
        if (this.audioSupport == null && Platform.getPlatform() == 1) {
            this.audioSupport = this.loadAudioSupport(WIN_SUPPORT, this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_WINSUPPORT));
        }
        if (this.audioSupport == null && Platform.getOS() == 202) {
            this.audioSupport = this.loadAudioSupport(OSX_SUPPORT, this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_MACOSXSUPPORT));
        }
        if (this.audioSupport == null) {
            this.audioSupport = this.loadAudioSupport(JAVA_SUPPORT, this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_JAVASUPPORT));
        }
        if (this.audioSupport == null) {
            throw new IllegalStateException(this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_NOAUDIOSUPPORT));
        }
        AudioDebug.HISTOGRAM.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (AudioDebug.HISTOGRAM.show()) {
                    if (AudioEngine.this.histoFrame == null) {
                        AudioEngine.this.histoPanel = new HistogramPanel(32);
                        AudioEngine.this.histoFrame = (JFrame)new CFrame("Audio Histogram");
                        AudioEngine.this.histoFrame.getContentPane().add((Component)AudioEngine.this.histoPanel);
                        AudioEngine.this.histoFrame.setSize(new Dimension(288, 256));
                    }
                    AudioEngine.this.histoFrame.show();
                } else if (AudioEngine.this.histoFrame != null) {
                    AudioEngine.this.histoFrame.dispose();
                }
            }
        });
        AudioDebug.OLDGAIN.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    AudioEngine.controlChanged(1);
                }
            }
        });
        AudioDebug.SQUAREGAIN.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    AudioEngine.controlChanged(1);
                }
            }
        });
        AudioDebug.LEGACYOVERRIDE.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    if (!Boolean.parseBoolean(evt.getNewValue().toString())) {
                        AudioEngine.this.initializeWebRTC();
                    }
                    AudioEngine.controlChanged(1);
                }
            }
        });
        AudioDebug.NS_OFF.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && AudioEngine.this.webrtc != null) {
                    boolean nsOffFlag = Boolean.parseBoolean(evt.getNewValue().toString());
                    AudioEngine.this.webrtc.setNoiseSuppression(!nsOffFlag);
                }
            }
        });
        AudioDebug.AECMETRICS.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && AudioEngine.this.webrtc != null) {
                    boolean metricsFlag = Boolean.parseBoolean(evt.getNewValue().toString());
                    AudioEngine.this.webrtc.enableMetrics(metricsFlag && AudioEngine.this.useAEC);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        Debug.lockEnter((Object)this, (String)"addChangeListener", (String)"changeListenerLock", (Object)changeListenerLock);
        Object object = changeListenerLock;
        synchronized (object) {
            if (!changeListenerVec.contains(listener)) {
                ArrayList newList = (ArrayList)changeListenerVec.clone();
                newList.add(listener);
                changeListenerVec = newList;
            }
        }
        Debug.lockLeave((Object)this, (String)"addChangeListener", (String)"changeListenerLock", (Object)changeListenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputListener(InputListener l) throws TooManyListenersException {
        Debug.lockEnter((Object)this, (String)"addInputListener", (String)"mikeListenerLock", (Object)this.mikeListenerLock);
        Object object = this.mikeListenerLock;
        synchronized (object) {
            if (this.mikeListener != null) {
                LogSupport.error((Object)this, (String)"addInputListener", (String)"Too many input listeners.");
                throw new TooManyListenersException("Too many Input listeners.");
            }
            this.mikeListener = l;
        }
        Debug.lockLeave((Object)this, (String)"addInputListener", (String)"mikeListenerLock", (Object)this.mikeListenerLock);
    }

    protected boolean useLegacy() {
        boolean newVal = AudioDebug.LEGACYOVERRIDE.show();
        if (webrtcSupported && newVal != overrideAudioStackSelection) {
            overrideAudioStackSelection = newVal;
            LogSupport.message((Object)this, (String)"useLegacy", (String)("audio stack selection override (use legacy audio processing): " + overrideAudioStackSelection));
        }
        return !webrtcSupported || overrideAudioStackSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void audioInputTask() {
        int mikeReadMillis = 20;
        Thread thisThread = Thread.currentThread();
        try {
            thisThread.setPriority(10);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"audioInputTask", (String)("Cannot increase thread priority:\n" + t));
        }
        short[] mikeSampBuf = new short[]{};
        while (!thisThread.isInterrupted()) {
            long loopStartTime = Platform.currentTimeMillis();
            this.setMikeState();
            if (this.mikeState == 1 || this.mikeState == 3) {
                int mikeSampCnt;
                String diagnostic;
                block23: {
                    diagnostic = null;
                    mikeReadMillis = this.mikeMillisPerPacket;
                    long prevMikeMillisRead = this.mikeMillisRead;
                    this.mikeMillisRead += (long)mikeReadMillis;
                    mikeSampCnt = (int)((long)this.mikeSampRate * this.mikeMillisRead / 1000L - (long)this.mikeSampRate * prevMikeMillisRead / 1000L);
                    if (mikeSampBuf.length < mikeSampCnt) {
                        mikeSampBuf = new short[mikeSampCnt];
                    }
                    try {
                        Debug.lockEnter((Object)this, (String)"audioInputTask", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
                        Object object = audioSupportInputLock;
                        synchronized (object) {
                            this.audioSupport.readMike(mikeSampBuf, 0, mikeSampCnt);
                        }
                        Debug.lockLeave((Object)this, (String)"audioInputTask", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
                    }
                    catch (Throwable t) {
                        if (t instanceof IllegalThreadStateException && t.getMessage().equalsIgnoreCase("Interrupted")) break;
                        diagnostic = t.toString();
                        if (diagnostic != null && diagnostic.length() >= 1) break block23;
                        diagnostic = "Unknown error";
                    }
                }
                if (diagnostic == null) {
                    this.processMikeInput(mikeSampBuf, mikeSampCnt, this.mikeSampRate);
                } else {
                    Debug.lockEnter((Object)this, (String)"audioInputTask", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
                    Object t = audioSupportInputLock;
                    synchronized (t) {
                        this.audioSupport.closeMike();
                        this.mikeState = 0;
                    }
                    Debug.lockLeave((Object)this, (String)"audioInputTask", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
                    for (int i = 0; i < MIKE_END.length; ++i) {
                        this.fireOnInput(MIKE_END[i]);
                    }
                    LogSupport.message((Object)this, (String)"audioInputTask", (String)("Reading from mike: " + diagnostic));
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this.owner, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_CANTREADMIKEMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_ERRORTITLE), (int)0);
                }
            }
            if (this.mikeState == 1 || this.mikeState == 3) {
                long loopMillis = Platform.currentTimeMillis() - loopStartTime;
                long sleepMillis = (long)(mikeReadMillis / 2) - loopMillis;
                if (sleepMillis <= 0L) continue;
                try {
                    Thread.sleep(mikeReadMillis / 2);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            this.waitForMikeWork();
        }
        if (this.mikeState == 1 || this.mikeState == 3) {
            Debug.lockEnter((Object)this, (String)"audioInputTask", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
            Object object = audioSupportInputLock;
            synchronized (object) {
                this.audioSupport.closeMike();
                this.mikeState = 0;
            }
            Debug.lockLeave((Object)this, (String)"audioInputTask", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void audioOutputTask() {
        Thread thisThread = Thread.currentThread();
        try {
            thisThread.setPriority(10);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"audioOutputTask", (String)("Cannot increase thread priority:\n" + t));
        }
        boolean someQExhausted = false;
        while (!thisThread.isInterrupted()) {
            long bufferedMillis2;
            long loopStartTime = Platform.currentTimeMillis();
            this.setSpkrState();
            if (this.spkrState == 1 && ((bufferedMillis2 = this.spkrDoneTime - Platform.currentTimeMillis()) < 20L || bufferedMillis2 < 100L && !someQExhausted)) {
                Debug.lockEnter((Object)this, (String)"audioOutputTask", (String)"spkrLock", (Object)this.spkrLock);
                Object object = this.spkrLock;
                synchronized (object) {
                    someQExhausted = this.feedSpkr();
                }
                Debug.lockLeave((Object)this, (String)"audioOutputTask", (String)"spkrLock", (Object)this.spkrLock);
            }
            if (this.spkrState == 1 && Platform.currentTimeMillis() > this.spkrDoneTime + 1000L && this.getSpkrBacklogMillis() < 1) {
                Debug.lockEnter((Object)this, (String)"audioOutputTask", (String)"audioSupportOutputLock", (Object)audioSupportOutputLock);
                Object bufferedMillis2 = audioSupportOutputLock;
                synchronized (bufferedMillis2) {
                    this.audioSupport.closeSpkr();
                    this.spkrState = 0;
                }
                Debug.lockLeave((Object)this, (String)"audioOutputTask", (String)"audioSupportOutputLock", (Object)audioSupportOutputLock);
                if (!this.useLegacy() && this.webrtc != null) {
                    this.webrtc.stopDebugRecording();
                }
            }
            if (this.spkrState == 1) {
                long now = Platform.currentTimeMillis();
                long loopMillis = now - loopStartTime;
                long sleepMillis = 10L - loopMillis;
                if (sleepMillis <= 0L) continue;
                try {
                    Thread.sleep(sleepMillis);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            Debug.lockEnter((Object)this, (String)"audioOutputTask", (String)"spkrLock", (Object)this.spkrLock);
            Object object = this.spkrLock;
            synchronized (object) {
                if (this.getSpkrBacklogMillis() < 1) {
                    this.waitForSpkrWork();
                }
            }
            Debug.lockLeave((Object)this, (String)"audioOutputTask", (String)"spkrLock", (Object)this.spkrLock);
        }
        if (this.spkrState == 1) {
            Object loopStartTime = audioSupportOutputLock;
            synchronized (loopStartTime) {
                this.audioSupport.flushSpkr();
                this.audioSupport.closeSpkr();
                this.spkrState = 0;
                if (this.webrtc != null) {
                    this.webrtc.stopDebugRecording();
                }
            }
        }
        for (int q = 0; q < this.spkrQueues.length; ++q) {
            Debug.lockEnter((Object)this, (String)"audioOutputTask", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
            LinkedList linkedList = this.spkrQueues[q];
            synchronized (linkedList) {
                this.spkrQueues[q].clear();
                this.spkrQueuesAmt[q] = 0;
            }
            Debug.lockLeave((Object)this, (String)"audioOutputTask", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
        }
    }

    public static void beep() {
        if (theEngine == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            theEngine.playBeep();
        }
    }

    public void close() {
        this.mikeThread.interrupt();
        this.spkrThread.interrupt();
        long abortWaitTime = Platform.currentTimeMillis() + 2000L;
        while (this.spkrThread.isAlive() && Platform.currentTimeMillis() < abortWaitTime) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {}
        }
        this.audioSupport.terminate();
        if (!this.useLegacy() && this.webrtc != null) {
            this.webrtc.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void controlChanged(int ctrlIdx) {
        if (ctrlIdx == 1) {
            try {
                int percent;
                int boostLevel;
                Object object = audioSupportInputLock;
                synchronized (object) {
                    float minExtraGain;
                    boostLevel = theEngine.getMikeBoost();
                    boolean boosting = boostLevel > 0;
                    float f = minExtraGain = boosting ? 1.0f : AudioEngine.theEngine.digitalGainMin;
                    float extraGainLimit = theEngine.useLegacy() ? 10.0f : (boosting ? 2.0f : (float)AudioEngine.theEngine.digitalGainLimit);
                    int extraFactor = 1;
                    int denominator = 100;
                    percent = AudioEngine.theEngine.audioSupport.getMikeGain();
                    if (AudioDebug.SQUAREGAIN.show()) {
                        extraFactor = percent;
                        denominator = 10000;
                    }
                    AudioEngine.theEngine.mikeExtraGain = theEngine.useLegacy() || AudioDebug.OLDGAIN.show() ? (float)(percent * percent) * (extraGainLimit - 1.0f) / 10000.0f + 1.0f : (float)(percent * extraFactor) * (extraGainLimit - minExtraGain) / (float)denominator + minExtraGain;
                }
                if (AudioDebug.GAIN.show()) {
                    float prettyMikeExtraGain = (float)((int)(AudioEngine.theEngine.mikeExtraGain * 100.0f)) / 100.0f;
                    LogSupport.message((String)("controlChanged:          analog mic level: " + percent + "%   digital gain: " + prettyMikeExtraGain + "x   boost: " + boostLevel));
                }
            }
            catch (Throwable t) {
                LogSupport.message((String)("AudioEngine: " + t.getMessage()));
            }
        }
        ChangeEvent event = new ChangeEvent(ctrlIdx);
        for (ChangeListener cl : changeListenerVec) {
            try {
                cl.stateChanged(event);
            }
            catch (Throwable t) {
                LogSupport.exception(AudioEngine.class, (String)"controlChanged", (Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean feedSpkr() {
        if (AudioDebug.SUPPRESS_SPKR_OUTPUT.isEnabled()) {
            return false;
        }
        int firstQ = -1;
        int lastQ = -1;
        for (int q = 0; q < this.spkrQueues.length; ++q) {
            Debug.lockEnter((Object)this, (String)"feedSpkr", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
            LinkedList linkedList = this.spkrQueues[q];
            synchronized (linkedList) {
                if (!this.spkrQueues[q].isEmpty()) {
                    if (firstQ < 0) {
                        firstQ = q;
                    }
                    lastQ = q;
                }
            }
            Debug.lockLeave((Object)this, (String)"feedSpkr", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
        }
        if (firstQ < 0) {
            boolean spkrStarving;
            boolean bl = spkrStarving = this.spkrDoneTime - Platform.currentTimeMillis() <= 0L;
            if (!this.useLegacy() && this.useAEC && spkrStarving && this.webrtc != null) {
                int blankSize = 160;
                short[] blank = new short[160];
                for (int i = 0; i < 160; ++i) {
                    blank[i] = 0;
                }
                this.webrtc.analyzeReverseStream(160, blank);
                try {
                    this.writeSpkrAndEstFinish(blank, 0, 160);
                }
                catch (Throwable t) {
                    Object object = audioSupportOutputLock;
                    synchronized (object) {
                        this.audioSupport.closeSpkr();
                        this.spkrState = -1;
                    }
                    this.webrtc.stopDebugRecording();
                    LogSupport.message((Object)this, (String)"feedSpkr", (String)("Writing silence to speaker: " + t));
                }
            }
            return false;
        }
        if (firstQ != lastQ) {
            for (int i = 0; i < 160; ++i) {
                this.mixingBuf[i] = 0;
            }
        }
        int mixedCnt = 0;
        boolean someQExhausted = false;
        for (int q = firstQ; q <= lastQ; ++q) {
            int sampleCnt = 0;
            Debug.lockEnter((Object)this, (String)"feedSpkr", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
            LinkedList linkedList = this.spkrQueues[q];
            synchronized (linkedList) {
                while (sampleCnt < 160 && this.spkrQueues[q].size() > 0) {
                    int needed = 160 - sampleCnt;
                    SampleData sampleData = (SampleData)this.spkrQueues[q].getFirst();
                    if (needed < sampleData.dataLen) {
                        System.arraycopy(sampleData.dataBuf, sampleData.dataOff, this.mixedBuf, sampleCnt, needed);
                        sampleData.dataOff += needed;
                        sampleData.dataLen -= needed;
                        sampleCnt += needed;
                        int n = q;
                        this.spkrQueuesAmt[n] = this.spkrQueuesAmt[n] - needed;
                    } else {
                        System.arraycopy(sampleData.dataBuf, sampleData.dataOff, this.mixedBuf, sampleCnt, sampleData.dataLen);
                        sampleCnt += sampleData.dataLen;
                        this.spkrQueues[q].removeFirst();
                        int n = q;
                        this.spkrQueuesAmt[n] = this.spkrQueuesAmt[n] - sampleData.dataLen;
                    }
                    if (this.spkrQueuesAmt[q] > 0) continue;
                    someQExhausted = true;
                }
            }
            Debug.lockLeave((Object)this, (String)"feedSpkr", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
            if (sampleCnt < 1) continue;
            if (mixedCnt < sampleCnt) {
                mixedCnt = sampleCnt;
            }
            short fill = this.mixedBuf[sampleCnt - 1];
            while (sampleCnt < 160) {
                this.mixedBuf[sampleCnt++] = fill;
            }
            if (firstQ == lastQ) continue;
            for (int i = 0; i < 160; ++i) {
                int n = i;
                this.mixingBuf[n] = this.mixingBuf[n] + this.mixedBuf[i];
            }
        }
        if (firstQ != lastQ) {
            for (int i = 0; i < mixedCnt; ++i) {
                int sample = this.mixingBuf[i];
                int clipper = Short.MIN_VALUE - sample;
                sample += clipper & ~(clipper >> 31);
                clipper = Short.MAX_VALUE - sample;
                this.mixedBuf[i] = (short)(sample += clipper & clipper >> 31);
            }
        }
        if (!this.useLegacy() && this.useAEC && this.webrtc != null) {
            this.webrtc.analyzeReverseStream(mixedCnt, this.mixedBuf);
        }
        try {
            int spkrDataCnt;
            if (this.spkrSampRate < 1) {
                throw new IllegalArgumentException("Not a valid speaker sample rate: " + this.spkrSampRate);
            }
            if (this.spkrSampRate == 8000) {
                short[] spkrData = this.mixedBuf;
                spkrDataCnt = mixedCnt;
                this.writeSpkrAndEstFinish(spkrData, 0, spkrDataCnt);
            } else {
                int minBufSize = (this.spkrSampRate * mixedCnt + 8000 - 1) / 8000;
                if (this.spkrResamplerBuf.length < minBufSize) {
                    this.spkrResamplerBuf = new short[minBufSize];
                }
                short[] spkrData = this.spkrResamplerBuf;
                spkrDataCnt = this.spkrResampler.resample(this.mixedBuf, 0, mixedCnt, this.spkrSampRate, this.spkrResamplerBuf, 0);
                this.writeSpkrAndEstFinish(spkrData, 0, spkrDataCnt);
            }
        }
        catch (Throwable t) {
            Object object = audioSupportOutputLock;
            synchronized (object) {
                this.audioSupport.closeSpkr();
                this.spkrState = -1;
            }
            if (this.webrtc != null) {
                this.webrtc.stopDebugRecording();
            }
            LogSupport.message((Object)this, (String)"feedSpkr", (String)("Writing to speaker: " + t));
            this.diagnosticThread.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModalDialog.showMessageDialog((Component)AudioEngine.this.owner, (Object)AudioEngine.this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_CANTWRITESPKRMSG), (String)AudioEngine.this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_ERRORTITLE), (int)0);
                }
            });
            return false;
        }
        return someQExhausted;
    }

    private void fireOnInput(short[] buffer) {
        InputListener localListener = this.mikeListener;
        if (this.mikeListener == null) {
            LogSupport.error((Object)this, (String)"fireOnInput", (String)"No microphone input listener.");
        } else {
            try {
                this.mikeListener.onInput(new InputEvent(this, 3, buffer));
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireOnInput", (Throwable)t, (boolean)true);
            }
        }
    }

    private void fireOnInput(byte op) {
        InputListener localListener = this.mikeListener;
        if (localListener == null) {
            LogSupport.error((Object)this, (String)"fireOnInput", (String)"No microphone input listener.");
        } else {
            try {
                localListener.onInput(new InputEvent(this, op, null));
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireOnInput", (Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOutput() {
        for (int q = 0; q < this.spkrQueues.length; ++q) {
            Debug.lockEnter((Object)this, (String)"flushOutput", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
            LinkedList linkedList = this.spkrQueues[q];
            synchronized (linkedList) {
                this.spkrQueues[q].clear();
                this.spkrQueuesAmt[q] = 0;
            }
            Debug.lockLeave((Object)this, (String)"flushOutput", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
        }
        if (this.spkrState == 1) {
            Debug.lockEnter((Object)this, (String)"flushOuptput", (String)"audioSupportOutputLock", (Object)audioSupportOutputLock);
            Object object = audioSupportOutputLock;
            synchronized (object) {
                this.audioSupport.flushSpkr();
            }
            Debug.lockLeave((Object)this, (String)"flushOuptput", (String)"audioSupportOutputLock", (Object)audioSupportOutputLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInputDevice() {
        String inputDevice;
        Debug.lockEnter((Object)this, (String)"getInputDevice", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
        Object object = audioSupportInputLock;
        synchronized (object) {
            inputDevice = this.audioSupport.getInputDevice();
        }
        Debug.lockLeave((Object)this, (String)"getInputDevice", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
        return inputDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInputDeviceDisplayName(String deviceHnd) {
        String name;
        Object object = audioSupportInputLock;
        synchronized (object) {
            name = this.audioSupport.getInputDeviceDisplayName(deviceHnd);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInputDeviceList() {
        String[] inputDeviceList;
        Object object = audioSupportInputLock;
        synchronized (object) {
            inputDeviceList = this.audioSupport.getInputDeviceList();
        }
        return inputDeviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceSelectionPanel getInputDeviceSelectionPanel(JButton okBtn, ActionListener selectionAL) {
        DeviceSelectionPanel panel;
        Debug.lockEnter((Object)this, (String)"getInputDeviceSelectionPanel", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
        Object object = audioSupportInputLock;
        synchronized (object) {
            panel = this.audioSupport.getInputDeviceSelectionPanel(okBtn, selectionAL);
        }
        Debug.lockLeave((Object)this, (String)"getInputDeviceSelectionPanel", (String)"audioSupportInputLock", (Object)audioSupportInputLock);
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioEngine getInstance(Component owner) {
        if (contentCaptureProvider.get() == null) {
            throw new RuntimeException("Use AudioEngine before AudioModule inits ContentCaptureProvider");
        }
        Debug.lockEnter(null, (String)"getInstance", (String)"audioLock", (Object)audioLock);
        Object object = audioLock;
        synchronized (object) {
            if (!theEngineInit) {
                try {
                    theEngine = new AudioEngine();
                    theEngine.setOwner(owner);
                    theEngine.initialize();
                }
                catch (Throwable t) {
                    LogSupport.message(AudioEngine.class, (String)"getInstance", (String)("Cannot create the AudioEngine object: " + t));
                    if (AudioDebug.GENERAL.show()) {
                        LogSupport.message(AudioEngine.class, (String)"getInstance", (String)Debug.getStackTrace((Throwable)t));
                    }
                    theEngine = null;
                }
                theEngineInit = true;
            }
        }
        Debug.lockLeave(null, (String)"getInstance", (String)"audioLock", (Object)audioLock);
        return theEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMikeBoost() {
        Object object = audioSupportInputLock;
        synchronized (object) {
            return this.audioSupport.getMikeBoost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMikeGain() {
        Object object = audioSupportInputLock;
        synchronized (object) {
            return this.audioSupport.getMikeGain();
        }
    }

    public int getMikeSampRate() {
        return this.preferredMikeSampRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutputDevice() {
        String outputDevice;
        Object object = audioSupportOutputLock;
        synchronized (object) {
            outputDevice = this.audioSupport.getOutputDevice();
        }
        return outputDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getOutputDeviceList() {
        String[] outputDeviceList;
        Object object = audioSupportOutputLock;
        synchronized (object) {
            outputDeviceList = this.audioSupport.getOutputDeviceList();
        }
        return outputDeviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutputDeviceDisplayName(String deviceHnd) {
        String name;
        Object object = audioSupportOutputLock;
        synchronized (object) {
            name = this.audioSupport.getOutputDeviceDisplayName(deviceHnd);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceSelectionPanel getOutputDeviceSelectionPanel(JButton okBtn, ActionListener selectionAL) {
        DeviceSelectionPanel panel;
        Object object = audioSupportOutputLock;
        synchronized (object) {
            panel = this.audioSupport.getOutputDeviceSelectionPanel(okBtn, selectionAL);
        }
        return panel;
    }

    public Component getOwner() {
        return this.owner;
    }

    public int getSpkrBacklogMillis() {
        int maxQueuedAmt = 0;
        for (int i = 0; i < this.spkrQueuesAmt.length; ++i) {
            int queuedAmt = this.spkrQueuesAmt[i];
            if (maxQueuedAmt >= queuedAmt) continue;
            maxQueuedAmt = queuedAmt;
        }
        long backlog = (1000L * (long)maxQueuedAmt + 8000L - 1L) / 8000L;
        long spkrBuffered = this.spkrDoneTime - Platform.currentTimeMillis();
        if (spkrBuffered > 0L) {
            backlog += spkrBuffered;
        }
        if (this.audioSupport.getLatentOutputSamplesCount() > 0) {
            int latentOutputSamplesCount = this.audioSupport.getLatentOutputSamplesCount();
            long latency = Math.max(1L, 1000L * (long)latentOutputSamplesCount / (long)this.spkrSampRate);
            backlog += latency;
        }
        return (int)backlog;
    }

    public int getSpkrBacklogMillis(int spkrChn) {
        if (spkrChn < 0 || spkrChn >= this.spkrQueuesAmt.length) {
            throw new IllegalArgumentException("Invalid spkrChn: " + spkrChn);
        }
        long backlog = 1000L * (long)this.spkrQueuesAmt[spkrChn] / 8000L;
        long spkrBuffered = this.spkrDoneTime - Platform.currentTimeMillis();
        if (spkrBuffered > 0L) {
            backlog += spkrBuffered;
        }
        return (int)backlog;
    }

    public static int getSpkrBacklogTrimPct(long backlogMillis) {
        int trimPct = 0;
        if (backlogMillis > 40L && (trimPct = backlogMillis > 3000L ? 10 : (backlogMillis > 2500L ? 8 : (backlogMillis > 2000L ? 6 : (backlogMillis > 1500L ? 4 : (backlogMillis > 1000L ? 3 : (backlogMillis > 500L ? 2 : 1)))))) > spkrBacklogMaxTrimPct) {
            trimPct = spkrBacklogMaxTrimPct;
        }
        return trimPct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSpkrVolume() {
        Object object = audioSupportOutputLock;
        synchronized (object) {
            return this.audioSupport.getSpkrVolume();
        }
    }

    private short hash(short[] samples) {
        int hashCode = samples.length;
        int modulus = 65521;
        for (int i = 0; i < samples.length; ++i) {
            hashCode = (hashCode << 16 | samples[i] & 0xFFFF) % modulus;
        }
        return (short)hashCode;
    }

    private void initialize() {
        this.audioSupport.initialize();
        this.enforceHalfDuplex = !this.supportsFullDuplex();
        for (int i = 0; i < this.spkrQueues.length; ++i) {
            this.spkrQueues[i] = new LinkedList();
            this.spkrQueuesAmt[i] = 0;
            this.trimResampler[i] = new Resampler(8000, 0);
        }
        if (!this.useLegacy()) {
            this.initializeWebRTC();
        } else {
            LogSupport.message((String)"using LEGACY audio stack - as of right now");
        }
        this.mikeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AudioEngine.this.audioInputTask();
            }
        }, "Audio Input Thread");
        this.mikeThread.setDaemon(true);
        this.mikeThread.start();
        this.spkrThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AudioEngine.this.audioOutputTask();
            }
        }, "Audio Output Thread");
        this.spkrThread.setDaemon(true);
        this.spkrThread.start();
    }

    private void initializeWebRTC() {
        if (this.webrtc == null) {
            this.webrtc = new WebRTC();
            int ret = this.webrtc.defaultInit(8000);
            if (ret != 0) {
                webrtcSupported = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputDeviceSelectionSupported() {
        boolean isSupported;
        Object object = audioSupportInputLock;
        synchronized (object) {
            isSupported = this.audioSupport.isInputDeviceSelectionSupported();
        }
        return isSupported;
    }

    public boolean isMikeOpen() {
        return this.mikeState == 1 || this.mikeState == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputDeviceSelectionSupported() {
        boolean isSupported;
        Object object = audioSupportOutputLock;
        synchronized (object) {
            isSupported = this.audioSupport.isOutputDeviceSelectionSupported();
        }
        return isSupported;
    }

    private AudioSupport loadAudioSupport(String cls, String desc) {
        try {
            Class<?> supportClass = Class.forName(cls);
            AudioSupport support = (AudioSupport)supportClass.newInstance();
            if (AudioDebug.GENERAL.show()) {
                LogSupport.message((Object)this, (String)"loadAudioSupport", (String)("Loaded " + desc + ": " + cls));
            }
            return support;
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"loadAudioSupport", (String)this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_CANTLOAD, new Object[]{desc, t.toString()}));
            return null;
        }
    }

    public boolean muteWhenTalking() {
        return this.muteWhenTalking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLatency() {
        int latency;
        if (this.mikeSampRate == 0 || this.spkrSampRate == 0) {
            latency = 0;
        } else {
            int latentOutputSamplesCount;
            int latentInputSamplesCount;
            Object object = audioSupportInputLock;
            synchronized (object) {
                latentInputSamplesCount = this.audioSupport.getLatentInputSamplesCount();
            }
            object = audioSupportOutputLock;
            synchronized (object) {
                latentOutputSamplesCount = this.audioSupport.getLatentOutputSamplesCount();
            }
            if (latentInputSamplesCount == -1) {
                if (!latencyImplemented) {
                    latency = 100;
                    if (AudioDebug.LATENCY.show()) {
                        System.out.println("latency GUESS for platform type " + Platform.getPlatform() + ": " + latency);
                    }
                } else {
                    LogSupport.message((Object)this, (String)"getLatency", (String)("unexpected unsupported platform for input latency check: " + Platform.getPlatform() + "  ret: " + latentInputSamplesCount));
                    latency = 100;
                }
            } else {
                int inputLatency = 1000 * latentInputSamplesCount / this.mikeSampRate;
                int outputLatency = 1000 * latentOutputSamplesCount / this.spkrSampRate;
                if (latentInputSamplesCount < 0 || inputLatency < 0) {
                    inputLatency = 0;
                    LogSupport.message((Object)this, (String)"getLatency", (String)("Input latency check error: " + latentInputSamplesCount + "   " + inputLatency + " ms"));
                }
                if (latentOutputSamplesCount < 0 || outputLatency < 0) {
                    outputLatency = 0;
                    LogSupport.message((Object)this, (String)"getLatency", (String)("Output latency check error: " + latentOutputSamplesCount + "   " + outputLatency + " ms"));
                }
                latency = inputLatency + outputLatency;
                if (AudioDebug.LATENCY.show() && this.spkrDoneTimeCnt % 30L == 0L) {
                    LogSupport.message((Object)this, (String)"getLatency", (String)("latency = " + (inputLatency + outputLatency) + ":  " + inputLatency + "ms in  +  " + outputLatency + "ms out"));
                }
            }
        }
        return latency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openMike(boolean logFailure, boolean eavesdrop) {
        int desiredSampRate = this.preferredMikeSampRate > 0 ? this.preferredMikeSampRate : 8000;
        try {
            Object object = audioSupportInputLock;
            synchronized (object) {
                this.mikeSampRate = this.audioSupport.openMike(desiredSampRate);
                this.mikeState = eavesdrop ? 3 : 1;
            }
            if (AudioDebug.LOG_SAMPLE_RATE.isEnabled()) {
                LogSupport.message((Object)this, (String)"openMike", (String)("asked for " + desiredSampRate + " Hz, got " + this.mikeSampRate + " Hz"));
            }
            this.mikeMillisRead = 0L;
            this.mikeResampler.reset(this.mikeSampRate, this.mikeSampRate / 1000);
            return true;
        }
        catch (Throwable t) {
            this.mikeState = 0;
            if (logFailure) {
                LogSupport.message((Object)this, (String)"openMike", (String)("open at " + desiredSampRate + " Hz failed: " + t));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openSpkr(boolean logFailure) {
        int desiredSampRate = this.preferredSpkrSampRate > 0 ? this.preferredSpkrSampRate : 8000;
        try {
            Object object = audioSupportOutputLock;
            synchronized (object) {
                this.spkrSampRate = this.audioSupport.openSpkr(desiredSampRate);
                this.spkrState = 1;
            }
            if (AudioDebug.WEBRTC_DEBUG_RECORD.isEnabled() && !this.useLegacy() && this.webrtc != null) {
                this.webrtc.startDebugRecording();
            }
            if (AudioDebug.LOG_SAMPLE_RATE.isEnabled()) {
                LogSupport.message((Object)this, (String)"openSpkr", (String)("asked for " + desiredSampRate + " Hz, got " + this.spkrSampRate + " Hz"));
            }
            this.spkrResampler.reset(8000, 20);
            return true;
        }
        catch (Throwable t) {
            this.spkrState = 0;
            if (logFailure) {
                LogSupport.message((Object)this, (String)"openSpkr", (String)("open at " + desiredSampRate + " Hz failed: " + t));
            }
            return false;
        }
    }

    public void playBeep() {
        long now;
        if (this.beepSamps == null) {
            byte[] beepBytes = null;
            try {
                Resource beepRes = new Resource((Object)this, "beep.aud");
                beepBytes = beepRes.load();
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"playBeep", (Throwable)t, (boolean)false);
            }
            if (beepBytes != null && beepBytes.length / 2 >= 2000) {
                this.beepSamps = new short[beepBytes.length / 2];
                for (int i = 0; i < this.beepSamps.length; ++i) {
                    this.beepSamps[i] = (short)((beepBytes[2 * i] & 0xFF) + 256 * beepBytes[2 * i + 1]);
                }
            } else {
                int BeepAmp = 6553;
                int BeepFreq = 784;
                this.beepSamps = new short[6000];
                for (int i = 0; i < this.beepSamps.length; ++i) {
                    this.beepSamps[i] = (short)(6553.0 * Math.sin(Math.PI * 2 * (double)i / 8000.0 * 784.0));
                }
            }
        }
        if (this.beepDoneTime <= (now = Platform.currentTimeMillis())) {
            this.beepDoneTime = now + 1000L * (long)this.beepSamps.length / 8000L;
            this.write(34, this.beepSamps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playCustomSound(short[] samples) {
        short hashCode = this.hash(samples);
        long now = Platform.currentTimeMillis();
        LinkedList linkedList = this.customSoundInfos;
        synchronized (linkedList) {
            CustomSoundInfo info;
            Iterator iter = this.customSoundInfos.iterator();
            while (iter.hasNext()) {
                info = (CustomSoundInfo)iter.next();
                if (info.playDoneTime <= now) {
                    iter.remove();
                    continue;
                }
                if (info.hashCode != hashCode) continue;
                return;
            }
            info = new CustomSoundInfo();
            info.hashCode = hashCode;
            info.playDoneTime = now + 1000L * (long)(this.spkrQueuesAmt[35] + samples.length) / 8000L;
            this.customSoundInfos.addLast(info);
        }
        this.write(35, samples);
    }

    protected void setWebrtcTargetLevel(int level) {
        if (!this.useLegacy() && this.webrtc != null) {
            this.webrtc.setTargetLevel(level);
        }
    }

    protected void setWebrtcCompressionGain(int gain) {
        if (!this.useLegacy() && this.webrtc != null) {
            this.webrtc.setCompressionGain(gain);
        }
    }

    protected void setWebrtcLatencyOverrideMilliSecs(int ms) {
        this.latencyOverrideMilliSecs = ms;
    }

    protected void setWebrtcNoiseSuppressionLevel(int level) {
        if (!this.useLegacy() && this.webrtc != null) {
            this.webrtc.setNoiseSuppressionLevel(level);
        }
    }

    protected void setWebrtcEchoCancellationLevel(int level) {
        if (!this.useLegacy() && this.webrtc != null) {
            this.webrtc.setEchoCancellationLevel(level);
        }
    }

    protected void setDigitalGainLimit(int limit) {
        this.digitalGainLimit = limit;
        AudioEngine.controlChanged(1);
    }

    protected void setDigitalGainMin(float min) {
        this.digitalGainMin = min;
        AudioEngine.controlChanged(1);
    }

    private boolean detectPeaking(short[] samples, String tag) {
        boolean peakingDetected = false;
        int peakedCount = 0;
        short peakLimit = 32112;
        int clippedCount = 0;
        short clipLimit = 32762;
        for (int i = 0; i < samples.length; ++i) {
            if (samples[i] < 0) {
                if (-samples[i] > peakLimit) {
                    ++peakedCount;
                }
                if (-samples[i] <= clipLimit) continue;
                ++clippedCount;
                continue;
            }
            if (samples[i] > peakLimit) {
                ++peakedCount;
            }
            if (samples[i] <= clipLimit) continue;
            ++clippedCount;
        }
        if (peakedCount > 4) {
            if (this.peakedSampleRunCount == 0.0f && AudioDebug.CLIPPING.show()) {
                LogSupport.message((Object)this, (String)"detectPeaking", (String)"...");
            }
            this.peakedSampleRunCount += 1.0f;
            if (AudioDebug.CLIPPING.show()) {
                LogSupport.message((Object)this, (String)"detectPeaking", (String)(tag + " This packet's peakedCount = " + peakedCount + "   peakedSampleRunCount = " + this.peakedSampleRunCount + "   clippedCount: " + clippedCount + "  <======="));
            }
            peakingDetected = true;
        } else {
            this.peakedSampleRunCount = 0.0f;
            peakingDetected = false;
        }
        return peakingDetected;
    }

    private void showEcho() {
        ++this.echoArrayFrameCount;
        if (this.webrtc.hasEcho()) {
            int frameIndex;
            int n = frameIndex = this.echoArrayFrameCount / 5 % 10;
            this.echoCount[n] = this.echoCount[n] + 1;
        }
        if (this.echoArrayFrameCount % 50 == 0) {
            char[] echoStr = new char[10];
            for (int i = 0; i < 10; ++i) {
                switch (this.echoCount[i]) {
                    case 0: {
                        echoStr[i] = 32;
                        break;
                    }
                    case 1: {
                        echoStr[i] = 46;
                        break;
                    }
                    case 2: {
                        echoStr[i] = 58;
                        break;
                    }
                    case 3: {
                        echoStr[i] = 124;
                        break;
                    }
                    case 4: {
                        echoStr[i] = 63;
                        break;
                    }
                    default: {
                        echoStr[i] = 35;
                    }
                }
                this.echoCount[i] = 0;
            }
            LogSupport.message((Object)this, (String)"showEcho", (String)(" '" + new String(echoStr) + "'"));
        }
    }

    private void handleAGC(int prescribedMicGain, int currMicGain, boolean rawPeaking) {
        boolean considerPeaking;
        boolean prescriptionUseful = prescribedMicGain != currMicGain && prescribedMicGain > 0;
        boolean agcPeaking = this.detectPeaking(this.mikeResamplerBuf, "AGC'd");
        boolean peaking = agcPeaking || rawPeaking;
        boolean bl = considerPeaking = peaking && !AudioDebug.PEAKREDUCER_OFF.show();
        if (prescriptionUseful || considerPeaking) {
            int prescription = prescribedMicGain;
            if (considerPeaking) {
                double attenuationFactor = 0.98;
                int peakingPrescription = (int)(attenuationFactor * (double)currMicGain);
                if (prescriptionUseful && prescribedMicGain < peakingPrescription) {
                    peakingPrescription = (int)(attenuationFactor * (double)prescribedMicGain);
                }
                prescription = peakingPrescription;
            }
            if (prescription > 0) {
                this.setMikeGain(prescription);
                if (this.mikeState != 3) {
                    AudioEngine.controlChanged(3);
                }
            }
        }
    }

    private void processMikeInput(short[] mikeSampBuf, int mikeSampCnt, int mikeSampRate) {
        int mikeResampledCnt = this.mikeResampler.resample(mikeSampBuf, 0, mikeSampCnt, 8000, this.mikeResamplerBuf, 0);
        if (mikeResampledCnt % 160 != 0) {
            LogSupport.error((Object)this, (String)"processMikeInput", (String)("mikeResampledCnt (" + mikeResampledCnt + ") not a multiple of CODEC_FRAME_LEN (" + 160 + ")"));
        }
        boolean rawPeaking = false;
        if (this.mikeState != 3) {
            if (this.useLegacy() && AudioDebug.CLIPPING.show()) {
                this.detectPeaking(this.mikeResamplerBuf, "LEGACY RAW");
            } else if (this.useAGC) {
                rawPeaking = this.detectPeaking(this.mikeResamplerBuf, "RAW");
            }
        }
        if (!this.useLegacy() && this.webrtc != null) {
            int latency;
            int currMicGain = this.useAGC ? this.getMikeGain() : 100;
            int n = latency = this.useAEC ? this.getLatency() : 0;
            if (AudioDebug.WEBRTC_OVERRIDE_LATENCY.show()) {
                latency = this.latencyOverrideMilliSecs;
            }
            if (this.mikeExtraGain != 1.0f) {
                this.applyDigitalGain(this.mikeResamplerBuf, mikeResampledCnt);
            }
            int prescribedMicGain = this.webrtc.processStream(mikeResampledCnt, this.mikeResamplerBuf, currMicGain, latency);
            if (AudioDebug.WEBRTC_SHOWECHO.show() && this.mikeState != 3) {
                this.showEcho();
            }
            if (this.useAGC) {
                this.handleAGC(prescribedMicGain, currMicGain, rawPeaking);
            }
        }
        if (this.mikeState == 3) {
            return;
        }
        short[] codecSampBuf = new short[mikeResampledCnt];
        System.arraycopy(this.mikeResamplerBuf, 0, codecSampBuf, 0, mikeResampledCnt);
        if (AudioDebug.HISTOGRAM.show() && this.histoPanel != null) {
            this.histoPanel.update(codecSampBuf);
        }
        if (AudioDebug.STATS.show()) {
            long sumSqr = 0L;
            int rawSum = 0;
            short maxAmp = 0;
            for (int ix = 0; ix < mikeSampCnt; ++ix) {
                short val = mikeSampBuf[ix] < 0 ? -mikeSampBuf[ix] : mikeSampBuf[ix];
                rawSum += val;
                sumSqr += (long)(val * val);
                if (maxAmp >= val) continue;
                maxAmp = val;
            }
            int rawAvg = rawSum / mikeSampCnt;
            int rms = (int)(Math.sqrt(sumSqr / (long)mikeSampCnt) + 0.5);
            LogSupport.message((Object)this, (String)"processMikeInput", (String)("Mike Data (original)  Peak=" + maxAmp + " RMS=" + rms + " Avg=" + rawAvg));
            if (mikeSampCnt != mikeResampledCnt) {
                sumSqr = 0L;
                maxAmp = 0;
                for (int ix = 0; ix < mikeResampledCnt; ++ix) {
                    short val = codecSampBuf[ix] < 0 ? -codecSampBuf[ix] : codecSampBuf[ix];
                    sumSqr += (long)(val * val);
                    if (maxAmp >= val) continue;
                    maxAmp = val;
                }
                rms = (int)(Math.sqrt(sumSqr / (long)mikeResampledCnt) + 0.5);
                LogSupport.message((Object)this, (String)"processMikeInput", (String)("Mike Data (resampled) Peak=" + maxAmp + " RMS=" + rms + " Avg=" + rawAvg));
            }
        }
        if (this.useLegacy() && this.mikeExtraGain != 1.0f) {
            this.applyDigitalGain(codecSampBuf, mikeResampledCnt);
        }
        this.fireOnInput(codecSampBuf);
    }

    private void applyDigitalGain(short[] samples, int count) {
        for (int i = 0; i < count; ++i) {
            float scaledSample = (float)samples[i] * this.mikeExtraGain;
            if (scaledSample < -32768.0f) {
                scaledSample = -32768.0f;
            } else if (scaledSample > 32767.0f) {
                scaledSample = 32767.0f;
            }
            samples[i] = (short)scaledSample;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        Debug.lockEnter((Object)this, (String)"removeChangeListener", (String)"changeListenerLock", (Object)changeListenerLock);
        Object object = changeListenerLock;
        synchronized (object) {
            if (changeListenerVec.contains(listener)) {
                ArrayList newList = (ArrayList)changeListenerVec.clone();
                newList.remove(listener);
                changeListenerVec = newList;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeChangeListener", (String)"changeListenerLock", (Object)changeListenerLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInputListener(InputListener l) {
        Debug.lockEnter((Object)this, (String)"removeInputListener", (String)"mikeListenerLock", (Object)this.mikeListenerLock);
        Object object = this.mikeListenerLock;
        synchronized (object) {
            if (this.mikeListener == l) {
                this.mikeListener = null;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeInputListener", (String)"mikeListenerLock", (Object)this.mikeListenerLock);
    }

    public void resetSpkrChannel(int spkrChn) {
        if (spkrChn < 0 || spkrChn >= 36) {
            throw new IllegalArgumentException("Invalid speaker channel: " + spkrChn);
        }
        this.trimResampler[spkrChn].reset(8000, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSpkr() {
        Debug.lockEnter((Object)this, (String)"resumeSpkr", (String)"spkrLock", (Object)this.spkrLock);
        Object object = this.spkrLock;
        synchronized (object) {
            this.spkrStateReq = 1;
            this.spkrLock.notify();
        }
        Debug.lockLeave((Object)this, (String)"resumeSpkr", (String)"spkrLock", (Object)this.spkrLock);
    }

    public static void setSpkrBacklogMaxTrimPct(int pct) {
        if (pct < 0 || pct > 100) {
            throw new IllegalArgumentException("pct = " + pct);
        }
        spkrBacklogMaxTrimPct = pct;
        if (AudioDebug.BACKLOG.isEnabled()) {
            LogSupport.message((String)("AudioEngine.setSpkrBacklogTrimPct: pct = " + pct));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputDevice(String device) {
        Object object = audioSupportInputLock;
        synchronized (object) {
            this.audioSupport.setInputDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMikeBoost(int percent) {
        Object object = audioSupportInputLock;
        synchronized (object) {
            this.audioSupport.setMikeBoost(percent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMikeGain(int percent) {
        int curGain;
        int boostLevel;
        Object object = audioSupportInputLock;
        synchronized (object) {
            float minExtraGain;
            boostLevel = this.getMikeBoost();
            boolean boosting = boostLevel > 0;
            float f = minExtraGain = boosting ? 1.0f : this.digitalGainMin;
            float extraGainLimit = this.useLegacy() ? 10.0f : (boosting ? 2.0f : (float)this.digitalGainLimit);
            int extraFactor = 1;
            int denominator = 100;
            int prevGain = -3;
            curGain = -3;
            if (AudioDebug.GAIN.show()) {
                prevGain = this.audioSupport.getMikeGain();
            }
            if (AudioDebug.SQUAREGAIN.show()) {
                extraFactor = percent;
                denominator = 10000;
            }
            this.audioSupport.setMikeGain(percent);
            this.mikeExtraGain = this.useLegacy() || AudioDebug.OLDGAIN.show() ? (float)(percent * percent) * (extraGainLimit - 1.0f) / 10000.0f + 1.0f : (float)(percent * extraFactor) * (extraGainLimit - minExtraGain) / (float)denominator + minExtraGain;
            if (AudioDebug.GAIN.show()) {
                curGain = this.audioSupport.getMikeGain();
            }
        }
        if (AudioDebug.GAIN.show()) {
            float prettyMikeExtraGain = (float)((int)(this.mikeExtraGain * 100.0f)) / 100.0f;
            LogSupport.message((Object)this, (String)"setMikeGain", (String)("analog mic level: " + curGain + "%   digital gain: " + prettyMikeExtraGain + "x   boost: " + boostLevel));
        }
    }

    public void setMikeMillisPerPacket(int millisPerPacket) {
        LogSupport.message((Object)this, (String)"setMikeMillisPerPacket", (String)("setting ms/packet to " + millisPerPacket));
        this.mikeMillisPerPacket = millisPerPacket <= 20 ? 20 : (millisPerPacket >= 240 ? 240 : (millisPerPacket + 20 - 1) / 20 * 20);
    }

    public void setMikeSampRate(int sampRate) {
        this.preferredMikeSampRate = sampRate;
        LogSupport.message((Object)this, (String)"setMikeSampRate", (String)("Preferred mike sampling rate set to " + this.preferredMikeSampRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStopInput() {
        Object object = this.mikeLock;
        synchronized (object) {
            this.mikeStateReq = 3;
            this.mikeLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMikeState() {
        byte[] events = null;
        Debug.lockEnter((Object)this, (String)"setDeviceStates", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            Object object2;
            if (this.mikeStateReq == 3) {
                if (this.mikeState == 3 || this.mikeState == 1) {
                    boolean sendEnd = this.mikeState == 1;
                    object2 = audioSupportInputLock;
                    synchronized (object2) {
                        this.audioSupport.closeMike();
                        this.mikeState = 0;
                    }
                    if (sendEnd) {
                        events = MIKE_END;
                    }
                }
            } else if (this.mikeStateReq == 1) {
                if (this.mikeState == 1) {
                    if (this.useLegacy() || !this.useAEC && !this.useAGC) {
                        Object object3 = audioSupportInputLock;
                        synchronized (object3) {
                            this.audioSupport.closeMike();
                            this.mikeState = 0;
                        }
                    } else {
                        this.mikeState = 3;
                    }
                    events = MIKE_END;
                } else {
                    events = MIKE_END;
                }
            } else if (this.mikeStateReq == 4) {
                if (this.mikeState == 0 && !this.useLegacy() && (this.useAEC || this.useAGC)) {
                    this.openMike(false, true);
                }
            } else if (this.mikeStateReq == 2) {
                if (this.mikeState == 1) {
                    events = MIKE_END_BEGIN;
                } else {
                    if (this.enforceHalfDuplex) {
                        Object object4 = this.spkrLock;
                        synchronized (object4) {
                            this.flushOutput();
                            if (this.spkrState == 1) {
                                object2 = audioSupportOutputLock;
                                synchronized (object2) {
                                    this.audioSupport.closeSpkr();
                                    this.spkrState = 0;
                                }
                                if (!this.useLegacy()) {
                                    this.webrtc.stopDebugRecording();
                                }
                            }
                        }
                    }
                    if (this.mikeState == 3) {
                        this.mikeState = 1;
                        events = MIKE_BEGIN;
                    } else if (this.openMike(true, false)) {
                        events = MIKE_BEGIN;
                    } else {
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)this.owner, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_CANTCONNECTMIKEMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_ERRORTITLE), (int)0);
                        events = MIKE_END;
                    }
                }
            }
            this.mikeStateReq = 0;
        }
        Debug.lockLeave((Object)this, (String)"setDeviceStates", (String)"mikeLock", (Object)this.mikeLock);
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                this.fireOnInput(events[i]);
            }
        }
    }

    public void setMuteWhenTalking(boolean mute) {
        this.muteWhenTalking = mute;
        this.enforceHalfDuplex = mute || !this.supportsFullDuplex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputDevice(String device) {
        Object object = audioSupportOutputLock;
        synchronized (object) {
            this.audioSupport.setOutputDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(Component who) {
        this.owner = who;
        Object object = audioLock;
        synchronized (object) {
            if (this.audioSupport != null) {
                this.audioSupport.setOwner(this.owner);
            }
        }
    }

    public void setSpkrSampRate(int sampRate) {
        this.preferredSpkrSampRate = sampRate;
        LogSupport.message((Object)this, (String)"setSpkrSampRate", (String)("Preferred spkr sampling rate set to " + this.preferredSpkrSampRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSpkrState() {
        boolean mayOpenSpkr;
        Debug.lockEnter((Object)this, (String)"setDeviceStates", (String)"spkrLock", (Object)this.spkrLock);
        Object object = this.spkrLock;
        synchronized (object) {
            if (this.spkrStateReq == 1) {
                if (this.spkrState == 2) {
                    this.spkrState = 0;
                }
            } else if (this.spkrStateReq == 2) {
                if (this.spkrState == 1) {
                    Object object2 = audioSupportOutputLock;
                    synchronized (object2) {
                        this.audioSupport.flushSpkr();
                        this.audioSupport.closeSpkr();
                    }
                    if (!this.useLegacy()) {
                        this.webrtc.stopDebugRecording();
                    }
                }
                this.spkrState = 2;
            }
            this.spkrStateReq = 0;
        }
        boolean bl = mayOpenSpkr = this.mikeState == 0 || this.mikeState == 3 || !this.enforceHalfDuplex;
        if (this.spkrState == 0 && mayOpenSpkr && !this.spkrQueuesEmpty()) {
            if (this.openSpkr(this.startSpkrTryCnt == 9)) {
                if (this.cantConnectSpkrMsgDialog != null) {
                    this.cantConnectSpkrMsgDialog.cancel();
                    this.cantConnectSpkrMsgDialog = null;
                    LogSupport.message((Object)this, (String)"setSpkrState", (String)("Speaker finally opened after: " + this.startSpkrTryCnt + " tries."));
                }
                this.startSpkrTryCnt = 0;
            } else {
                ++this.startSpkrTryCnt;
                if (this.startSpkrTryCnt == 10) {
                    this.cantConnectSpkrMsgDialog = ModalDialog.showMessageDialogAsync((int)-1, (Component)this.owner, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_CANTCONNECTSPKRMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_ERRORTITLE), (int)0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpkrVolume(int percent) {
        int curGain;
        int prevGain;
        Object object = audioSupportOutputLock;
        synchronized (object) {
            prevGain = -3;
            curGain = -3;
            if (AudioDebug.GAIN.show()) {
                prevGain = this.audioSupport.getSpkrVolume();
            }
            this.audioSupport.setSpkrVolume(percent);
            if (AudioDebug.GAIN.show()) {
                curGain = this.audioSupport.getSpkrVolume();
            }
        }
        if (AudioDebug.GAIN.show()) {
            LogSupport.message((Object)this, (String)"setSpkrVolume", (String)("req=" + percent + "%,gain=" + curGain + "%,prev=" + prevGain));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean spkrQueuesEmpty() {
        for (int q = 0; q < this.spkrQueues.length; ++q) {
            try {
                Debug.lockEnter((Object)this, (String)"spkrQueuesEmpty", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
                LinkedList linkedList = this.spkrQueues[q];
                synchronized (linkedList) {
                    block9: {
                        if (this.spkrQueues[q].isEmpty()) break block9;
                        boolean bl = false;
                        return bl;
                    }
                    continue;
                }
            }
            finally {
                Debug.lockLeave((Object)this, (String)"spkrQueuesEmpty", (String)"spkrQueues[q]", (Object)this.spkrQueues[q]);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEavesdrop() {
        Debug.lockEnter((Object)this, (String)"startEavesdrop", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            this.mikeStateReq = 4;
            this.mikeLock.notify();
        }
        Debug.lockLeave((Object)this, (String)"startEavesdrop", (String)"mikeLock", (Object)this.mikeLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startInput() {
        Debug.lockEnter((Object)this, (String)"startInput", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            this.mikeStateReq = 2;
            this.mikeLock.notify();
        }
        Debug.lockLeave((Object)this, (String)"startInput", (String)"mikeLock", (Object)this.mikeLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopInput() {
        Debug.lockEnter((Object)this, (String)"stopInput", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            this.mikeStateReq = 1;
            this.mikeLock.notify();
        }
        Debug.lockLeave((Object)this, (String)"stopInput", (String)"mikeLock", (Object)this.mikeLock);
    }

    public void waitForMicrophoneStop() {
        long abortWaitTime = Platform.currentTimeMillis() + 500L;
        while (this.mikeThread.isAlive() && (this.mikeState == 1 || this.mikeState == 3) && Platform.currentTimeMillis() < abortWaitTime) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean supportsFullDuplex() {
        return this.audioSupport.supportsFullDuplex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendSpkr() {
        Debug.lockEnter((Object)this, (String)"suspendSpkr", (String)"spkrLock", (Object)this.spkrLock);
        Object object = this.spkrLock;
        synchronized (object) {
            this.spkrStateReq = 2;
            this.spkrLock.notify();
        }
        Debug.lockLeave((Object)this, (String)"suspendSpkr", (String)"spkrLock", (Object)this.spkrLock);
    }

    public void waitForSpeakerSuspend() {
        long abortWaitTime = Platform.currentTimeMillis() + 500L;
        while (this.spkrThread.isAlive() && this.spkrState == 1 && Platform.currentTimeMillis() < abortWaitTime) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMikeWork() {
        Debug.lockEnter((Object)this, (String)"waitForMikeWork", (String)"mikeLock", (Object)this.mikeLock);
        Object object = this.mikeLock;
        synchronized (object) {
            try {
                this.mikeLock.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Debug.lockLeave((Object)this, (String)"waitForMikeWork", (String)"mikeLock", (Object)this.mikeLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForSpkrWork() {
        Debug.lockEnter((Object)this, (String)"waitForSpkrWork", (String)"spkrLock", (Object)this.spkrLock);
        Object object = this.spkrLock;
        synchronized (object) {
            try {
                this.spkrLock.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Debug.lockLeave((Object)this, (String)"waitForSpkrWork", (String)"spkrLock", (Object)this.spkrLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int spkrChn, short[] data) {
        if (!contentCaptureProvider.get().isEchoingData()) {
            return;
        }
        if (spkrChn < 0 || spkrChn >= this.spkrQueues.length) {
            throw new IllegalArgumentException("spkrChn invalid: " + spkrChn);
        }
        if (data == null) {
            throw new IllegalArgumentException("data = null");
        }
        if (this.mikeState == 1 && this.enforceHalfDuplex) {
            return;
        }
        int sampleCnt = data.length;
        if (spkrChn < 34) {
            long backlog = this.getSpkrBacklogMillis(spkrChn);
            int trimPct = AudioEngine.getSpkrBacklogTrimPct(backlog);
            if (trimPct > 0 && AudioDebug.BACKLOG.isEnabled()) {
                LogSupport.message((String)("SpkrChn #" + spkrChn + ": backlog = " + backlog + " ms, trimming " + trimPct + "%"));
            }
            int trimSampRate = (100 - trimPct) * 8000 / 100;
            sampleCnt = this.trimResampler[spkrChn].resampleWithoutFiltering(data, 0, sampleCnt, trimSampRate, data, 0);
        }
        if (AudioDebug.HISTOGRAM.show() && this.mikeState != 1 && this.histoPanel != null) {
            this.histoPanel.update(data, 0, sampleCnt);
        }
        SampleData sampleData = new SampleData(data, 0, sampleCnt);
        Debug.lockEnter((Object)this, (String)"write", (String)"spkrQueues[spkrChn]", (Object)this.spkrQueues[spkrChn]);
        Object object = this.spkrQueues[spkrChn];
        synchronized (object) {
            this.spkrQueues[spkrChn].addLast(sampleData);
            int n = spkrChn;
            this.spkrQueuesAmt[n] = this.spkrQueuesAmt[n] + sampleCnt;
        }
        Debug.lockLeave((Object)this, (String)"write", (String)"spkrQueues[spkrChn]", (Object)this.spkrQueues[spkrChn]);
        Debug.lockEnter((Object)this, (String)"write", (String)"spkrLock", (Object)this.spkrLock);
        object = this.spkrLock;
        synchronized (object) {
            this.spkrLock.notify();
        }
        Debug.lockLeave((Object)this, (String)"write", (String)"spkrLock", (Object)this.spkrLock);
        final int spkrBacklog = (int)((long)this.getSpkrBacklogMillis() * 8000L / 1000L);
        if (spkrBacklog >= this.spkrQueueLim && !this.showingBacklogWarning) {
            this.showingBacklogWarning = true;
            LogSupport.message((Object)this, (String)"write", (String)("Spkr backed up " + spkrBacklog / 8000 + " secs"));
            this.diagnosticThread.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (contentCaptureProvider.get().isEchoingData()) {
                        int selection = ModalDialog.showConfirmDialogTimeout((int)15, (Component)AudioEngine.this.owner, (Object)AudioEngine.this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOENGINE_BACKLOGMSG, new Object[]{new Integer(spkrBacklog / 8000), new Integer(spkrBacklog)}), (String)AudioEngine.this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOSYSTEM_WARNINGTITLE), (int)0, (int)2, null);
                        if (selection == 0) {
                            AudioEngine.this.spkrQueueLim += 480000;
                        } else {
                            AudioEngine.this.flushOutput();
                            AudioEngine.this.spkrQueueLim = 480000;
                            LogSupport.message((String)"Spkr backlog discarded");
                        }
                    } else {
                        AudioEngine.this.flushOutput();
                        AudioEngine.this.spkrQueueLim = 480000;
                    }
                    AudioEngine.this.showingBacklogWarning = false;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSpkrAndEstFinish(short[] data, int dataOff, int dataLen) {
        long outputSpkrDoneTimeLatency = 0L;
        Object object = audioSupportOutputLock;
        synchronized (object) {
            this.audioSupport.writeSpkr(data, dataOff, dataLen);
            if (latencyImplemented && ++this.spkrDoneTimeCnt % 30L == 0L) {
                int latentOutputSamplesCount = this.audioSupport.getLatentOutputSamplesCount();
                outputSpkrDoneTimeLatency = 1000L * (long)latentOutputSamplesCount / (long)this.spkrSampRate;
            }
        }
        long now = Platform.currentTimeMillis();
        if (this.spkrDoneTime == 0L || !latencyImplemented && this.spkrDoneTime < now) {
            this.spkrDoneTime = now;
        }
        this.spkrDoneTime += (long)((int)(1000L * (long)dataLen / (long)this.spkrSampRate));
        if (outputSpkrDoneTimeLatency != 0L) {
            long diff = outputSpkrDoneTimeLatency - this.spkrDoneTime + now;
            if (this.spkrDoneTimeCnt % 120L == 0L && AudioDebug.LATENCY.show()) {
                LogSupport.message((String)("writeSpkrAndEstFinish:  spkrDoneTime: " + (this.spkrDoneTime - now) + "   output latency: " + outputSpkrDoneTimeLatency + "   extra buffer (diff): " + diff + "  sDT corrected to: " + (this.spkrDoneTime - now + (diff - 40L) / 2L)));
            }
            this.spkrDoneTime += (diff - 40L) / 2L;
        }
    }

    public void setAecWebrtcEnabled(boolean enable) {
        this.useAEC = enable;
        if (!this.useLegacy()) {
            if (this.webrtc.initAEC(enable) == 0) {
                this.useAEC = enable;
                LogSupport.message((String)("now using AEC: " + this.useAEC));
                this.webrtc.enableMetrics(this.useAEC && AudioDebug.AECMETRICS.show());
            } else {
                LogSupport.message((Object)this, (String)"setAecEnabled", (String)"operation failed. NOT using AEC");
                this.useAEC = false;
            }
        }
    }

    public void setAgcWebrtcEnabled(boolean enable) {
        this.useAGC = enable;
        if (!this.useLegacy()) {
            if (this.webrtc.initAGC(enable) == 0) {
                this.useAGC = enable;
                LogSupport.message((String)("now using webrtc-based AGC: " + this.useAGC));
            } else {
                LogSupport.message((Object)this, (String)"setAgcEnabled", (String)"operation failed. NOT using webrtc-based AGC");
                this.useAGC = false;
            }
        }
    }

    public static class ChangeEvent
    extends EventObject {
        public static final int MIKE_BOOST = 0;
        public static final int MIKE_GAIN = 1;
        public static final int SPKR_VOLUME = 2;
        public static final int MIKE_GAIN_ADJUSTED_BY_ENGINE = 3;

        public ChangeEvent(int controlIdx) {
            super(new Integer(controlIdx));
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }

    private static class CustomSoundInfo {
        short hashCode;
        long playDoneTime;

        private CustomSoundInfo() {
        }
    }
}

