/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.ecelp;

import com.elluminate.groupware.audio.ecelp.Base;
import com.elluminate.groupware.audio.ecelp.PF;
import com.elluminate.groupware.audio.ecelp.PF2;
import com.elluminate.groupware.audio.ecelp.ZF;
import com.elluminate.groupware.audio.ecelp.ZF2;

public class Encoder
extends Base {
    static final float Gamma2 = 0.8f;
    static final int TACCnt = 10;
    static final int TwoTo28 = 0x10000000;
    static final float TwoTo32 = 4.2949673E9f;
    static int[] intADelayIdx = new int[148];
    float[] encode_hamw;
    PF2 encode_hppf;
    ZF2 encode_hpzf;
    float[] encode_prevLSPFreq;
    float[] encode_sold;
    float[] encodeSubframe_acBuf;
    PF encodeSubframe_predictor;
    PF encodeSubframe_pwpf;
    ZF encodeSubframe_pwzf;
    float[] encode_fpc = new float[11];
    float[] encode_spc;
    float[] encode_lspFreq;
    float[] encode_newLSPFreq;
    float[] encode_snew;
    float[][] encode_ssub;
    float[] encodeSubframe_e0;
    float[] encodeSubframe_e1;
    float[] encodeSubframe_fctemp;
    float[] encodeSubframe_h;
    float[] encodeSubframe_predictorMemSave;
    float[] encodeSubframe_pwpfMemSave;
    float[] encodeSubframe_pwzfMemSave;
    float[] encodeSubframe_v;
    float[] searchACB_gain;
    float[] searchACB_match;
    float[] searchACB_y;
    float[] searchACB_y2;
    float[] searchSCB_cor;
    float[] searchSCB_topAbsCor;
    int[] searchSCB_topAbsCorLoc;
    float[] searchSCB_y;
    float[] searchSCB_z;

    Encoder() {
        this.encode_hamw = new float[160];
        this.encode_hppf = new PF2();
        this.encode_hpzf = new ZF2();
        this.encode_lspFreq = new float[10];
        this.encode_newLSPFreq = new float[11];
        this.encode_prevLSPFreq = new float[10];
        this.encode_snew = new float[160];
        this.encode_sold = new float[160];
        this.encode_spc = new float[11];
        this.encode_ssub = new float[4][40];
        this.encodeSubframe_acBuf = new float[187];
        this.encodeSubframe_e0 = new float[40];
        this.encodeSubframe_e1 = new float[40];
        this.encodeSubframe_fctemp = new float[11];
        this.encodeSubframe_h = new float[40];
        this.encodeSubframe_predictor = new PF();
        this.encodeSubframe_predictorMemSave = new float[11];
        this.encodeSubframe_pwpf = new PF();
        this.encodeSubframe_pwpfMemSave = new float[11];
        this.encodeSubframe_pwzf = new ZF();
        this.encodeSubframe_pwzfMemSave = new float[11];
        this.encodeSubframe_v = new float[40];
        this.searchACB_gain = new float[256];
        this.searchACB_match = new float[256];
        this.searchACB_y = new float[40];
        this.searchACB_y2 = new float[40];
        this.searchSCB_cor = new float[512];
        this.searchSCB_topAbsCor = new float[10];
        this.searchSCB_topAbsCorLoc = new int[10];
        this.searchSCB_y = new float[40];
        this.searchSCB_z = new float[40];
        float[] hppfCoeffs = new float[]{1.0f, -1.889033f, 0.8948743f};
        float[] hpzfCoeffs = new float[]{0.946f, -1.892f, 0.946f};
        this.encode_hppf.setCoeffs(hppfCoeffs);
        this.encode_hpzf.setCoeffs(hpzfCoeffs);
        Encoder.initHammingWindow(160, this.encode_hamw);
        this.reset();
    }

    static float dotProduct(int n, float[] u, float[] v) {
        float dotProd = 0.0f;
        while (n > 0 && (n & 3) != 0) {
            dotProd += u[--n] * v[n];
        }
        while (n > 0) {
            dotProd += u[(n -= 4) + 3] * v[n + 3] + u[n + 2] * v[n + 2] + u[n + 1] * v[n + 1] + u[n] * v[n];
        }
        return dotProd;
    }

    void encode(short[] speechBuf, int speechOff, byte[] encodingBuf, int encodingOff) {
        int i;
        float Omega = 0.994127f;
        float[] fpc = this.encode_fpc;
        float[] hamw = this.encode_hamw;
        PF2 hppf = this.encode_hppf;
        ZF2 hpzf = this.encode_hpzf;
        float[] lspFreq = this.encode_lspFreq;
        float[] newLSPFreq = this.encode_newLSPFreq;
        float[] prevLSPFreq = this.encode_prevLSPFreq;
        float[] snew = this.encode_snew;
        float[] sold = this.encode_sold;
        float[] spc = this.encode_spc;
        float[][] ssub = this.encode_ssub;
        for (i = 0; i < 160; ++i) {
            snew[i] = speechBuf[i + speechOff];
        }
        hpzf.filter(160, snew);
        hppf.filter(160, snew);
        for (i = 0; i < 80; ++i) {
            ssub[i / 40][i % 40] = sold[i + 80];
            ssub[i / 40 + 2][i % 40] = snew[i];
        }
        if (!this.analAutocor(0.994127f, snew, hamw, fpc)) {
            fpc[0] = 1.0f;
            for (i = 1; i <= 10; ++i) {
                fpc[i] = 0.0f;
            }
        }
        this.pctolsp(fpc, newLSPFreq);
        this.quantizeLSPFreqs(newLSPFreq, this.lspi);
        for (int subframeIdx = 0; subframeIdx < 4; ++subframeIdx) {
            for (i = 0; i < 10; ++i) {
                lspFreq[i] = ((float)(7 - 2 * subframeIdx) * prevLSPFreq[i] + (float)(1 + 2 * subframeIdx) * newLSPFreq[i]) / 8.0f;
            }
            this.lsptopc(lspFreq, spc);
            this.encodeSubframe(subframeIdx, ssub[subframeIdx], spc);
        }
        System.arraycopy(newLSPFreq, 0, prevLSPFreq, 0, 10);
        System.arraycopy(snew, 0, sold, 0, 160);
        this.pack(encodingBuf, encodingOff);
    }

    void encodeSubframe(int subframeIdx, float[] s, float[] pc) {
        float scale;
        int i;
        float[] acBuf = this.encodeSubframe_acBuf;
        float[] e0 = this.encodeSubframe_e0;
        float[] e1 = this.encodeSubframe_e1;
        float[] h = this.encodeSubframe_h;
        PF predictor = this.encodeSubframe_predictor;
        float[] predictorMemSave = this.encodeSubframe_predictorMemSave;
        PF pwpf = this.encodeSubframe_pwpf;
        float[] pwpfMemSave = this.encodeSubframe_pwpfMemSave;
        ZF pwzf = this.encodeSubframe_pwzf;
        float[] pwzfMemSave = this.encodeSubframe_pwzfMemSave;
        float[] v = this.encodeSubframe_v;
        System.arraycopy(predictor.getMemory(), 0, predictorMemSave, 0, 11);
        System.arraycopy(pwpf.getMemory(), 0, pwpfMemSave, 0, 11);
        System.arraycopy(pwzf.getMemory(), 0, pwzfMemSave, 0, 11);
        Encoder.zeroArray(e0);
        predictor.setCoeffs(pc);
        predictor.filter(40, e0);
        for (i = 0; i < 40; ++i) {
            e0[i] = s[i] - e0[i];
        }
        pwzf.setCoeffs(pc);
        pwzf.filter(40, e0);
        Encoder.expandBandwidth(0.8f, pc, pwpf.getCoeffs());
        pwpf.filter(40, e0);
        Encoder.zeroArray(h);
        h[0] = 1.0f;
        pwpf.zeroMemory();
        pwpf.filter(40, h);
        predictor.setMemory(predictorMemSave);
        pwpf.setMemory(pwpfMemSave);
        pwzf.setMemory(pwzfMemSave);
        this.searchACB(subframeIdx, e0, h, acBuf, e1);
        predictor.filter(40, e1);
        for (i = 0; i < 40; ++i) {
            e1[i] = s[i] - e1[i];
        }
        pwzf.filter(40, e1);
        pwpf.filter(40, e1);
        float e0Eng = Encoder.dotProduct(40, e0, e0);
        float ccor = Encoder.dotProduct(40, e0, e1);
        if (e0Eng != 0.0f) {
            ccor /= e0Eng;
        }
        if ((scale = (float)Math.sqrt(Math.abs(ccor))) < 0.2f) {
            scale = 0.2f;
        } else if (scale > 0.9f) {
            scale *= 1.4f;
        }
        this.searchSCB(subframeIdx, scale, e1, h, v);
        float aDelay = ADelayTbl[this.adi[subframeIdx]];
        float aGain = AGainTbl[this.agi[subframeIdx]];
        this.updateACB(aDelay, aGain, acBuf, v);
        predictor.filter(40, v);
        for (i = 0; i < 40; ++i) {
            e0[i] = s[i] - v[i];
        }
        pwzf.filter(40, e0);
        pwpf.filter(40, e0);
    }

    void reset() {
        super.resetBase();
        this.encode_hppf.zeroMemory();
        this.encode_hpzf.zeroMemory();
        System.arraycopy(InitLSPFreq, 0, this.encode_prevLSPFreq, 0, 10);
        Encoder.zeroArray(this.encode_sold);
        Encoder.zeroArray(this.encodeSubframe_acBuf);
        this.encodeSubframe_predictor.zeroMemory();
        this.encodeSubframe_pwpf.zeroMemory();
        this.encodeSubframe_pwzf.zeroMemory();
    }

    void searchACB(int subframeIdx, float[] e, float[] h, float[] acBuf, float[] v) {
        int hiTrialIdx;
        float eng;
        float cor;
        int k;
        int kLim;
        int j;
        int aDelayIdx;
        int maxIdx;
        int minIdx;
        int ADI_ABS_LIM = 256;
        int ADI_REL_LIM = 64;
        int IRLen = 20;
        float[] gain = this.searchACB_gain;
        float[] match = this.searchACB_match;
        float[] y = this.searchACB_y;
        float[] y2 = this.searchACB_y2;
        if (subframeIdx % 2 == 0) {
            minIdx = 0;
            maxIdx = 255;
        } else {
            minIdx = this.adi[subframeIdx - 1] - 31;
            maxIdx = this.adi[subframeIdx - 1] + 32;
            if (minIdx < 0) {
                minIdx = 0;
                maxIdx = 63;
            }
            if (maxIdx > 255) {
                maxIdx = 255;
                minIdx = 192;
            }
        }
        int bestIntMatchIdx = minIdx;
        float bestIntMatch = -1.0f;
        boolean first = true;
        for (aDelayIdx = minIdx; aDelayIdx <= maxIdx; ++aDelayIdx) {
            int aDelayInt = (int)ADelayTbl[aDelayIdx];
            if (ADelayTbl[aDelayIdx] != (float)aDelayInt) continue;
            int xOff = 147 - aDelayInt;
            if (first) {
                for (j = 0; j < 40; ++j) {
                    float sum = 0.0f;
                    int jP1 = j + 1;
                    int kBeg = jP1 < aDelayInt ? 0 : jP1 - aDelayInt;
                    kLim = jP1 < 20 ? jP1 : 20;
                    for (k = kBeg; k < kLim; ++k) {
                        sum += h[k] * acBuf[xOff + j - k];
                    }
                    y[j] = sum;
                }
                first = false;
            } else {
                for (j = 39; j >= 20; --j) {
                    y[j] = y[j - 1];
                }
                float xSub0 = acBuf[xOff];
                while (j > 0) {
                    y[j] = y[j - 1] + h[j] * xSub0;
                    --j;
                }
                y[0] = h[0] * xSub0;
            }
            if (aDelayInt < 40) {
                System.arraycopy(y, 0, y2, 0, 40);
                for (j = aDelayInt; j < 40; ++j) {
                    int n = j;
                    y2[n] = y2[n] + y[j - aDelayInt];
                }
                if (aDelayInt < 20) {
                    for (j = 2 * aDelayInt; j < 40; ++j) {
                        int n = j;
                        y2[n] = y2[n] + y[j - 2 * aDelayInt];
                    }
                }
                cor = Encoder.dotProduct(40, y2, e);
                eng = Encoder.dotProduct(40, y2, y2);
            } else {
                cor = Encoder.dotProduct(40, y, e);
                eng = Encoder.dotProduct(40, y, y);
            }
            gain[aDelayIdx] = eng <= 0.0f ? cor : cor / eng;
            match[aDelayIdx] = cor * gain[aDelayIdx];
            if (!(match[aDelayIdx] > bestIntMatch)) continue;
            bestIntMatch = match[aDelayIdx];
            bestIntMatchIdx = aDelayIdx;
        }
        if (subframeIdx % 2 == 0) {
            float bestSubmultMatch = -1.0f;
            int bestSubmultMatchIdx = -1;
            for (int divisor = (int)((double)(ADelayTbl[bestIntMatchIdx] / ADelayTbl[0]) + 0.5); divisor >= 2; --divisor) {
                int submultDly = (int)((double)(ADelayTbl[bestIntMatchIdx] / (float)divisor) + 0.5);
                int submultIdx = intADelayIdx[submultDly];
                if (submultIdx < 0 || !(match[submultIdx] > bestSubmultMatch)) continue;
                bestSubmultMatch = match[submultIdx];
                bestSubmultMatchIdx = submultIdx;
            }
            if (bestSubmultMatch >= 0.88f * bestIntMatch) {
                bestIntMatchIdx = bestSubmultMatchIdx;
            }
        }
        for (int loTrialIdx = bestIntMatchIdx; loTrialIdx > minIdx && ADelayTbl[bestIntMatchIdx] - ADelayTbl[loTrialIdx - 1] <= 0.5f; --loTrialIdx) {
        }
        for (hiTrialIdx = bestIntMatchIdx; hiTrialIdx < maxIdx && ADelayTbl[hiTrialIdx + 1] - ADelayTbl[bestIntMatchIdx] <= 0.5f; ++hiTrialIdx) {
        }
        int bestMatchIdx = bestIntMatchIdx;
        for (aDelayIdx = loTrialIdx; aDelayIdx <= hiTrialIdx; ++aDelayIdx) {
            if (aDelayIdx == bestIntMatchIdx) continue;
            Encoder.getACodeVec8(ADelayTbl[aDelayIdx], acBuf);
            for (j = 0; j < 40; ++j) {
                float sum = 0.0f;
                kLim = j < 20 ? j + 1 : 20;
                for (k = 0; k < kLim; ++k) {
                    sum += h[k] * acBuf[j - k + 147];
                }
                y[j] = sum;
            }
            cor = Encoder.dotProduct(40, y, e);
            eng = Encoder.dotProduct(40, y, y);
            gain[aDelayIdx] = eng <= 0.0f ? cor : cor / eng;
            match[aDelayIdx] = cor * gain[aDelayIdx];
            if (!(match[aDelayIdx] > match[bestMatchIdx])) continue;
            bestMatchIdx = aDelayIdx;
        }
        this.adi[subframeIdx] = bestMatchIdx;
        this.agi[subframeIdx] = Encoder.quantizeAGain(gain[bestMatchIdx]);
        float aDelay = ADelayTbl[this.adi[subframeIdx]];
        float aGain = AGainTbl[this.agi[subframeIdx]];
        Encoder.getACodeVec40(aDelay, acBuf);
        for (int i = 0; i < 40; ++i) {
            v[i] = aGain * acBuf[i + 147];
        }
    }

    void searchSCB(int subframeIdx, float gainScale, float[] e, float[] h, float[] v) {
        int xOff;
        int sCodeIdx;
        int j;
        int i;
        float[] cor = this.searchSCB_cor;
        float[] topAbsCor = this.searchSCB_topAbsCor;
        int[] topAbsCorLoc = this.searchSCB_topAbsCorLoc;
        float[] y = this.searchSCB_y;
        float[] z = this.searchSCB_z;
        for (i = 0; i < 40; ++i) {
            float dotProduct = 0.0f;
            for (j = 40 - i - 1; j >= 0; --j) {
                dotProduct += h[j] * e[i + j];
            }
            z[i] = dotProduct;
        }
        for (i = 0; i < 10; ++i) {
            topAbsCorLoc[i] = -1;
            topAbsCor[i] = -1;
        }
        int sCodeLim = subframeIdx % 2 == 1 ? 512 : 256;
        for (sCodeIdx = 0; sCodeIdx < sCodeLim; ++sCodeIdx) {
            xOff = 2 * (511 - sCodeIdx);
            float curCor = 0.0f;
            for (i = 0; i < 40; ++i) {
                if (SCodebook[i + xOff] == 0) continue;
                if (SCodebook[i + xOff] < 0) {
                    curCor -= z[i];
                    continue;
                }
                curCor += z[i];
            }
            cor[sCodeIdx] = curCor;
            if (curCor < 0.0f) {
                curCor = -curCor;
            }
            if (!(curCor > topAbsCor[9])) continue;
            for (i = 0; i < 10 && !(curCor > topAbsCor[i]); ++i) {
            }
            for (j = 9; j > i; --j) {
                topAbsCor[j] = topAbsCor[j - 1];
                topAbsCorLoc[j] = topAbsCorLoc[j - 1];
            }
            topAbsCor[i] = curCor;
            topAbsCorLoc[i] = sCodeIdx;
        }
        int bestCodeIdx = 0;
        float bestGain = 0.0f;
        float bestMatch = -1.0f;
        for (int k = 0; k < 10; ++k) {
            sCodeIdx = topAbsCorLoc[k];
            xOff = 2 * (511 - sCodeIdx);
            Encoder.zeroArray(y);
            for (i = 0; i < 40; ++i) {
                if (SCodebook[i + xOff] == 0) continue;
                if (SCodebook[i + xOff] < 0) {
                    for (j = 0; j < 40 - i; ++j) {
                        int n = i + j;
                        y[n] = y[n] - h[j];
                    }
                    continue;
                }
                for (j = 0; j < 40 - i; ++j) {
                    int n = i + j;
                    y[n] = y[n] + h[j];
                }
            }
            float eng = Encoder.dotProduct(40, y, y);
            float gain = eng <= 0.0f ? cor[sCodeIdx] : cor[sCodeIdx] / eng;
            float match = gain * cor[sCodeIdx];
            if (!(match > bestMatch)) continue;
            bestMatch = match;
            bestGain = gain;
            bestCodeIdx = sCodeIdx;
        }
        int bestGainIdx = Encoder.quantizeSGain(gainScale * bestGain);
        bestGain = SGainTbl[bestGainIdx];
        xOff = 2 * (511 - bestCodeIdx);
        for (i = 0; i < 40; ++i) {
            v[i] = bestGain * (float)SCodebook[i + xOff];
        }
        this.sci[subframeIdx] = bestCodeIdx;
        this.sgi[subframeIdx] = bestGainIdx;
    }

    static {
        for (int i = 0; i < intADelayIdx.length; ++i) {
            Encoder.intADelayIdx[i] = -1;
        }
        for (int aDelayIdx = 0; aDelayIdx < ADelayTbl.length; ++aDelayIdx) {
            int aDelayInt = (int)ADelayTbl[aDelayIdx];
            if (ADelayTbl[aDelayIdx] != (float)aDelayInt) continue;
            Encoder.intADelayIdx[aDelayInt] = aDelayIdx;
        }
    }
}

