/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.audio.ecelp;

import com.elluminate.groupware.audio.ecelp.Decoder;
import com.elluminate.groupware.audio.ecelp.Encoder;
import com.elluminate.util.log.LogSupport;

public class ECELPCodec {
    private static final String CODEC_NAME = "Elluminate CELP";
    private static final int DATA_FORMAT = 1;
    private static final String LIB_NAME = "JINECELP";
    public static final int ENCODED_FRAME_SIZE = 18;
    public static final int FRAME_LEN = 160;
    public static final int FRAME_MILLIS = 20;
    public static final int SAMP_RATE = 8000;
    private static final int CLOSED_HND = 0;
    Decoder decoder = null;
    long decoderHnd = 0L;
    Encoder encoder = null;
    long encoderHnd = 0L;
    boolean usingNativeDecoder = false;
    boolean usingNativeEncoder = false;
    private static boolean nativeLibLoaded = false;

    private static native void nativeCloseDecoder(long var0);

    private static native void nativeCloseEncoder(long var0);

    private static native void nativeDecode(long var0, byte[] var2, short[] var3);

    private static native void nativeEncode(long var0, short[] var2, byte[] var3);

    private static native String nativeGetVersion();

    private static native long nativeOpenDecoder();

    private static native long nativeOpenEncoder();

    private static native void nativeResetDecoder(long var0);

    private static native void nativeResetEncoder(long var0);

    public synchronized void closeDecoder() {
        if (this.usingNativeDecoder) {
            this.usingNativeDecoder = false;
            if (this.decoderHnd != 0L) {
                ECELPCodec.nativeCloseDecoder(this.decoderHnd);
                this.decoderHnd = 0L;
            }
        } else {
            this.decoder = null;
        }
    }

    public synchronized void closeEncoder() {
        if (this.usingNativeEncoder) {
            this.usingNativeEncoder = false;
            if (this.encoderHnd != 0L) {
                ECELPCodec.nativeCloseEncoder(this.encoderHnd);
                this.encoderHnd = 0L;
            }
        } else {
            this.encoder = null;
        }
    }

    public short[] decode(byte[] source) {
        return this.decode(source, null);
    }

    public synchronized short[] decode(byte[] source, short[] result) {
        if (this.decoder == null && this.decoderHnd == 0L) {
            throw new IllegalStateException("Decoder not open.");
        }
        if (source == null) {
            throw new IllegalArgumentException("null source");
        }
        if (source.length < 1 || source.length % 18 != 0) {
            throw new IllegalArgumentException("source length not a multiple of 18: " + source.length);
        }
        int frameCnt = source.length / 18;
        int sampleSize = frameCnt * 160;
        if (result == null || result.length != sampleSize) {
            result = new short[sampleSize];
        }
        if (this.usingNativeDecoder) {
            ECELPCodec.nativeDecode(this.decoderHnd, source, result);
        } else {
            for (int frameIdx = 0; frameIdx < frameCnt; ++frameIdx) {
                this.decoder.decode(source, frameIdx * 18, result, frameIdx * 160);
            }
        }
        return result;
    }

    public byte[] encode(short[] source) {
        return this.encode(source, null);
    }

    public synchronized byte[] encode(short[] source, byte[] result) {
        if (this.encoder == null && this.encoderHnd == 0L) {
            throw new IllegalStateException("Encoder not open.");
        }
        if (source == null) {
            throw new IllegalArgumentException("null source");
        }
        if (source.length < 1 || source.length % 160 != 0) {
            throw new IllegalArgumentException("source length not a multiple of 160: " + source.length);
        }
        int frameCnt = source.length / 160;
        int arraySize = frameCnt * 18;
        if (result == null || result.length != arraySize) {
            result = new byte[arraySize];
        }
        if (this.usingNativeEncoder) {
            ECELPCodec.nativeEncode(this.encoderHnd, source, result);
        } else {
            for (int frameIdx = 0; frameIdx < frameCnt; ++frameIdx) {
                this.encoder.encode(source, frameIdx * 160, result, frameIdx * 18);
            }
        }
        return result;
    }

    public synchronized boolean isDecoderOpen() {
        return this.usingNativeDecoder ? this.decoderHnd != 0L : this.decoder != null;
    }

    public synchronized boolean isEncoderOpen() {
        return this.usingNativeEncoder ? this.encoderHnd != 0L : this.encoder != null;
    }

    public synchronized boolean openDecoder() {
        if (this.decoder != null || this.decoderHnd != 0L) {
            throw new IllegalStateException("Decoder already open.");
        }
        if (nativeLibLoaded) {
            try {
                this.decoderHnd = ECELPCodec.nativeOpenDecoder();
                this.usingNativeDecoder = this.decoderHnd != 0L;
                return this.usingNativeDecoder;
            }
            catch (Throwable t) {
                LogSupport.message((Object)this, (String)"openDecoder", (String)("Falling back to pure Java decoder: " + t));
            }
        }
        this.decoder = new Decoder();
        this.usingNativeDecoder = false;
        return this.decoder != null;
    }

    public synchronized boolean openEncoder() {
        if (this.encoder != null || this.encoderHnd != 0L) {
            throw new IllegalStateException("Encoder already open.");
        }
        if (nativeLibLoaded) {
            try {
                this.encoderHnd = ECELPCodec.nativeOpenEncoder();
                this.usingNativeEncoder = this.encoderHnd != 0L;
                return this.usingNativeEncoder;
            }
            catch (Throwable t) {
                LogSupport.message((Object)this, (String)"openEncoder", (String)("Falling back to pure Java encoder: " + t));
            }
        }
        this.encoder = new Encoder();
        this.usingNativeEncoder = false;
        return this.encoder != null;
    }

    public synchronized void resetDecoder() {
        if (this.usingNativeDecoder) {
            if (this.decoderHnd != 0L) {
                ECELPCodec.nativeResetDecoder(this.decoderHnd);
            }
        } else if (this.decoder != null) {
            this.decoder.reset();
        }
    }

    public synchronized void resetEncoder() {
        if (this.usingNativeEncoder) {
            if (this.encoderHnd != 0L) {
                ECELPCodec.nativeResetEncoder(this.encoderHnd);
            }
        } else if (this.encoder != null) {
            this.encoder.reset();
        }
    }

    static {
        try {
            System.loadLibrary(LIB_NAME);
            nativeLibLoaded = true;
            LogSupport.message((String)("Loaded native library JINECELP, version " + ECELPCodec.nativeGetVersion()));
        }
        catch (Throwable t) {
            LogSupport.message((String)("Using Java ECELP codec because native not available:\n" + t));
        }
    }
}

