/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony;

import com.elluminate.groupware.telephony.TelephonyFlags;
import com.elluminate.groupware.telephony.TelephonyProtocol;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class TelephonyMessage {
    private byte cmd = 0;
    private boolean accept = false;
    private I18nMessage reason = null;
    private short originator = (short)-32767;
    private int type = 0;
    private String call = null;
    private String pin = null;
    private String gateway = null;
    private String user = null;
    private String password = null;
    private int status = 0;
    private short senderAddr = (short)-32767;

    public TelephonyMessage(ChannelDataEvent ev) throws IOException {
        this.loadEvent(ev);
    }

    public TelephonyMessage() {
    }

    protected TelephonyMessage(byte cmd) {
        this.cmd = cmd;
    }

    public static TelephonyMessage createConnectMsg() {
        return new TelephonyMessage(1);
    }

    public static TelephonyMessage createDisconnectMsg() {
        return new TelephonyMessage(3);
    }

    public static TelephonyMessage createReconnectMsg() {
        return new TelephonyMessage(6);
    }

    public static TelephonyMessage createCancelConnectMsg() {
        return new TelephonyMessage(7);
    }

    public static TelephonyMessage createDisconnectCallMsg() {
        return new TelephonyMessage(35);
    }

    public static TelephonyMessage createConnectionSucceededMsg() {
        return new TelephonyMessage(9);
    }

    public static TelephonyMessage createAcceptConnectionMsg() {
        return new TelephonyMessage(11);
    }

    public static TelephonyMessage createRejectConnectionMsg() {
        return new TelephonyMessage(12);
    }

    public static TelephonyMessage createAnnounceMsg() {
        return new TelephonyMessage(14);
    }

    public static TelephonyMessage createCancelQueryMsg() {
        return new TelephonyMessage(13);
    }

    public static TelephonyMessage createOutVolumeUpMsg() {
        return new TelephonyMessage(36);
    }

    public static TelephonyMessage createOutVolumeDownMsg() {
        return new TelephonyMessage(37);
    }

    protected TelephonyMessage(byte cmd, boolean accept, I18nMessage reason) {
        this.cmd = cmd;
        this.accept = accept;
        this.reason = reason;
    }

    public static TelephonyMessage createConnectAckMsg(boolean accept, I18nMessage reason) {
        return new TelephonyMessage(2, accept, reason);
    }

    public static TelephonyMessage createDisconnectAckMsg(boolean accept, I18nMessage reason) {
        return new TelephonyMessage(4, accept, reason);
    }

    protected TelephonyMessage(byte cmd, I18nMessage reason) {
        this.cmd = cmd;
        this.reason = reason;
    }

    public static TelephonyMessage createRemoteDisconnectMsg(I18nMessage reason) {
        return new TelephonyMessage(5, reason);
    }

    protected TelephonyMessage(byte cmd, short originator, I18nMessage reason) {
        this.cmd = cmd;
        this.originator = originator;
        this.reason = reason;
    }

    public static TelephonyMessage createConnectionFailedMsg(short origin, I18nMessage reason) {
        return new TelephonyMessage(10, origin, reason);
    }

    protected TelephonyMessage(byte cmd, int status, I18nMessage reason) {
        this.cmd = cmd;
        this.status = status;
        this.reason = reason;
    }

    public static TelephonyMessage createCallAckMsg(int status, I18nMessage reason) {
        return new TelephonyMessage(34, status, reason);
    }

    public static TelephonyMessage createConnectionStatusMsg(int status, I18nMessage reason) {
        return new TelephonyMessage(8, status, reason);
    }

    protected TelephonyMessage(byte cmd, int type, String call, String pin) {
        this.cmd = cmd;
        this.type = type;
        this.call = call;
        this.pin = pin;
    }

    protected TelephonyMessage(byte cmd, int type, String call, String pin, String address, String userName, String password) {
        this.cmd = cmd;
        this.type = type;
        this.call = call;
        this.pin = pin;
        this.gateway = address;
        this.user = userName;
        this.password = password;
    }

    public static TelephonyMessage createPlaceCallMsg(int type, String call, String pin) {
        return new TelephonyMessage(33, type, call, pin);
    }

    public static TelephonyMessage createPlaceCallMsg(int type, String call, String pin, String address, String userName, String password) {
        return new TelephonyMessage(33, type, call, pin, address, userName, password);
    }

    public byte getCommand() {
        return this.cmd;
    }

    public boolean getAccept() {
        return this.accept;
    }

    public int getType() {
        return this.type;
    }

    public int getStatus() {
        return this.status;
    }

    public I18nMessage getReason() {
        return this.reason;
    }

    public short getOriginator() {
        return this.originator;
    }

    public String getCall() {
        return this.call;
    }

    public String getPIN() {
        return this.pin;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public short getSender() {
        return this.senderAddr;
    }

    public void clear() {
        this.cmd = 0;
        this.accept = false;
        this.reason = null;
        this.originator = (short)-32767;
        this.type = 0;
        this.call = null;
        this.pin = null;
        this.gateway = null;
        this.user = null;
        this.password = null;
        this.status = 0;
        this.senderAddr = (short)-32767;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(256);
        result.append("TelephonyMessage: ");
        result.append(TelephonyProtocol.getCommandName(this.cmd));
        block0 : switch (this.cmd) {
            case 2: 
            case 4: {
                result.append(" accept=" + this.accept);
                if (this.reason == null) break;
                result.append(" reason=" + this.reason);
                break;
            }
            case 10: {
                result.append(" originator=" + this.originator);
            }
            case 5: {
                if (this.reason == null) break;
                result.append(" reason=" + this.reason);
                break;
            }
            case 33: {
                result.append(" type=" + this.type);
                result.append(" call=" + this.call);
                result.append(" pin=" + this.pin);
                switch (this.type) {
                    case 1: 
                    case 5: {
                        break block0;
                    }
                    case 2: 
                    case 6: {
                        result.append(" user=" + this.user);
                        if (this.password == null) break block0;
                        result.append(" password=*****");
                        break block0;
                    }
                    case 3: {
                        result.append(" gateway=" + this.gateway);
                        break block0;
                    }
                    case 4: {
                        result.append(" user=" + this.user);
                        if (this.password != null) {
                            result.append(" password=*****");
                        }
                        result.append(" gateway=" + this.gateway);
                        break block0;
                    }
                }
                throw new RuntimeException("Invalid CALL type: " + this.type);
            }
            case 34: {
                result.append(" status=" + this.status);
                if (this.reason == null) break;
                result.append(" reason=" + this.reason);
                break;
            }
            case 8: {
                result.append(" status=" + this.status);
                if (this.reason == null) break;
                result.append(" reason=" + this.reason);
            }
        }
        return result.toString();
    }

    public ChannelDataEvent createEventRec(Object src, short to) throws IOException {
        ChannelDataEvent ev = ChannelDataEvent.getInstance((Object)src, (short)to, (byte)this.cmd);
        DataOutputStream s = ev.write();
        if (s == null) {
            throw new RuntimeException("Failed to obtain output stream from ChannelDataEvent.");
        }
        try {
            this.write(s);
            s.close();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"createEventRec", (Throwable)t, (boolean)true);
            try {
                s.close();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new RuntimeException("I/O error on channel data event stream.", t);
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEvent(ChannelDataEvent ev) throws IOException {
        FilterInputStream s = null;
        try {
            this.clear();
            this.senderAddr = ev.getSourceAddress();
            this.cmd = ev.getCommand();
            s = ev.read();
            block3 : switch (this.cmd) {
                case 2: 
                case 4: {
                    this.accept = ((DataInputStream)s).readBoolean();
                    if (this.accept || s.available() <= 0) break;
                    this.reason = I18nMessage.read((DataInputStream)s);
                    break;
                }
                case 10: {
                    this.originator = ((DataInputStream)s).readShort();
                }
                case 5: {
                    if (s.available() <= 0) break;
                    this.reason = I18nMessage.read((DataInputStream)s);
                    break;
                }
                case 33: {
                    this.type = ((DataInputStream)s).readShort();
                    this.call = ((DataInputStream)s).readUTF();
                    this.pin = ((DataInputStream)s).readUTF();
                    switch (this.type) {
                        case 1: 
                        case 5: {
                            break block3;
                        }
                        case 2: 
                        case 6: {
                            this.user = ((DataInputStream)s).readUTF();
                            this.password = ((DataInputStream)s).readUTF();
                            break block3;
                        }
                        case 3: {
                            this.gateway = ((DataInputStream)s).readUTF();
                            break block3;
                        }
                        case 4: {
                            this.user = ((DataInputStream)s).readUTF();
                            this.password = ((DataInputStream)s).readUTF();
                            this.gateway = ((DataInputStream)s).readUTF();
                            break block3;
                        }
                    }
                    throw new RuntimeException("Invalid CALL type: " + this.type);
                }
                case 34: {
                    this.status = ((DataInputStream)s).readShort();
                    if (this.status == 1 || s.available() <= 0) break;
                    this.reason = I18nMessage.read((DataInputStream)s);
                    break;
                }
                case 8: {
                    this.status = ((DataInputStream)s).readShort();
                    if (this.status != 5 || s.available() <= 0) break;
                    this.reason = I18nMessage.read((DataInputStream)s);
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 35: 
                case 36: 
                case 37: {
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Telephony command: " + this.cmd);
                }
            }
            if (TelephonyFlags.MESSAGE_DECODE.show() && s != null && s.available() > 0) {
                LogSupport.message((Object)this, (String)"loadEvent", (String)("Warning: message carries " + s.available() + " bytes extra data, ignored.\n" + "         " + this.toString()));
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void write(DataOutputStream s) throws IOException {
        block0 : switch (this.cmd) {
            case 2: 
            case 4: {
                s.writeBoolean(this.accept);
                if (this.accept || this.reason == null) break;
                this.reason.write(s);
                break;
            }
            case 10: {
                s.writeShort(this.originator);
            }
            case 5: {
                if (this.reason == null) break;
                this.reason.write(s);
                break;
            }
            case 33: {
                s.writeShort(this.type);
                s.writeUTF(this.call);
                s.writeUTF(this.pin);
                switch (this.type) {
                    case 1: 
                    case 5: {
                        break block0;
                    }
                    case 2: 
                    case 6: {
                        s.writeUTF(this.user);
                        s.writeUTF(this.password);
                        break block0;
                    }
                    case 3: {
                        s.writeUTF(this.gateway);
                        break block0;
                    }
                    case 4: {
                        s.writeUTF(this.user);
                        s.writeUTF(this.password);
                        s.writeUTF(this.gateway);
                        break block0;
                    }
                }
                throw new RuntimeException("Invalid CALL type: " + this.type);
            }
            case 34: {
                s.writeShort(this.status);
                if (this.status == 1 || this.reason == null) break;
                this.reason.write(s);
                break;
            }
            case 8: {
                s.writeShort(this.status);
                if (this.status != 5 || this.reason == null) break;
                this.reason.write(s);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid Telephony command: " + this.cmd);
            }
        }
    }
}

