/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.view;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.groupware.view.ViewSwitchEnabledRule;
import com.elluminate.groupware.view.ViewSwitchPolicyListener;
import com.elluminate.jinx.ClientList;
import java.util.HashMap;
import java.util.Map;

public class ViewSwitchPolicy {
    private Map<ViewMode, ViewSwitchEnabledRule> rules = new HashMap<ViewMode, ViewSwitchEnabledRule>();
    private ViewSwitchPolicyListener listener;

    public void addRule(ViewMode view, ViewSwitchEnabledRule rule) {
        this.rules.put(view, rule);
    }

    public void evalPolicy(CRParticipant participant) {
        for (ViewMode view : this.rules.keySet()) {
            this.listener.enableViewSwitch(view, this.canSwitchTo(view, participant));
        }
    }

    public void setViewSwitchPolicyListener(ViewSwitchPolicyListener listener) {
        this.listener = listener;
    }

    public boolean canSwitchTo(ViewMode view, CRParticipant participant) {
        ViewSwitchEnabledRule rule = this.rules.get(view);
        if (rule == null) {
            return false;
        }
        return rule.isEnabledFor(participant);
    }

    public boolean canSwitchTo(ViewMode view, short addr, ClientList clients) {
        ViewSwitchEnabledRule rule = this.rules.get(view);
        if (rule == null) {
            return false;
        }
        return rule.isEnabledFor(addr, clients);
    }
}

