/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.view;

import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.jinx.JinxProtocolAdapter;

public class ViewProtocol
extends JinxProtocolAdapter {
    public static final String MODE_PROPERTY = "view.mode";

    public ViewProtocol() {
        this.defineProperty(MODE_PROPERTY, (byte)2, ViewProtocol.encode(ViewMode.WHITEBOARD, (short)0));
    }

    public static ViewMode getMode(String value) {
        int brk = value.indexOf(58);
        if (brk < 0) {
            throw new IllegalArgumentException("Missing ':' in view mode value '" + value + "'");
        }
        String mode = value.substring(0, brk);
        try {
            return ViewMode.valueOf((String)mode);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Unknown mode value '" + mode + "'");
        }
    }

    public static short getAddress(String value) {
        int brk = value.indexOf(58);
        if (brk < 0) {
            throw new IllegalArgumentException("Missing ':' in view mode value '" + value + "'");
        }
        String part = value.substring(brk + 1);
        try {
            return Short.parseShort(part);
        }
        catch (NumberFormatException nfx) {
            throw new IllegalArgumentException("Invalid address value '" + part + "'");
        }
    }

    public static boolean isValid(String value, short address) {
        try {
            short addr = ViewProtocol.getAddress(value);
            if (addr != address) {
                return false;
            }
            ViewProtocol.getMode(value);
            return true;
        }
        catch (IllegalArgumentException iax) {
            return false;
        }
    }

    public static String encode(ViewMode mode, short address) {
        return mode.name() + ":" + address;
    }
}

