/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.AbstractLoader;
import com.elluminate.groupware.multimedia.LoaderListener;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.platform.Platform;
import com.elluminate.util.LightweightTimer;
import java.awt.Component;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.StringTokenizer;

public class URLLoader
extends AbstractLoader {
    private static final long TIMEOUT = 15000L;
    private static final byte ST_IDLE = 0;
    private static final byte ST_OPENING = 1;
    private static final byte ST_TIMEOUT = 2;
    private static final byte ST_CONNECTED = 3;
    private URL url;
    private URLConnection connection = null;
    private DataInputStream str = null;
    private LightweightTimer timeout = null;
    private byte state = 0;

    public URLLoader(int id, Object lock, URL url, LoaderListener lst, Channel chnl, short notify) throws IOException {
        super(URLLoader.extractDisplayName(url), id, lock, lst, chnl, notify);
        this.url = url;
    }

    public URLLoader(int id, Object lock, URL url, LoaderListener lst, Component parent) throws IOException {
        super(URLLoader.extractDisplayName(url), id, lock, lst, parent);
        this.url = url;
    }

    private static String extractDisplayName(URL url) {
        int pos;
        String path;
        String name = null;
        String qry = url.getQuery();
        if (qry != null) {
            StringTokenizer st = new StringTokenizer(qry, "&");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int pos2 = tok.indexOf(61);
                if (pos2 <= 0 || pos2 >= tok.length() - 1 || !tok.substring(0, pos2).equals("displayname")) continue;
                name = tok.substring(pos2 + 1);
                break;
            }
        }
        if (name == null && (path = url.getPath()) != null && path.length() > 0 && (pos = path.lastIndexOf(47)) >= 0 && pos < path.length() - 1) {
            name = path.substring(pos + 1);
        }
        if (name == null) {
            name = url.toString();
        }
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (Exception ex) {
            return name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean open() throws IOException {
        String type;
        long length;
        this.timeout = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                URLLoader.this.timeout();
            }
        });
        try {
            int semi;
            HttpURLConnection hc;
            int code;
            URLLoader uRLLoader = this;
            synchronized (uRLLoader) {
                this.timeout.scheduleIn(15000L);
                this.state = 1;
            }
            this.connection = this.url.openConnection();
            if (this.connection instanceof HttpURLConnection && (code = (hc = (HttpURLConnection)this.connection).getResponseCode()) >= 400) {
                throw new IOException(code + ": " + hc.getResponseMessage());
            }
            length = this.connection.getContentLength();
            type = this.connection.getContentType();
            if (type != null && (semi = type.indexOf(59)) > 0) {
                type = type.substring(0, semi);
            }
            if (type == null || type.equals("content/unknown") || type.equals("text/plain") || type.equals("application/octet-stream")) {
                String guess;
                String file = this.url.getFile();
                int q = file.lastIndexOf(63);
                if (q != -1) {
                    file = file.substring(0, q);
                }
                if ((guess = Platform.getMimeType((String)file)) != "application/octet-stream") {
                    type = guess;
                }
            }
        }
        catch (IOException io) {
            boolean rethrow;
            URLLoader uRLLoader = this;
            synchronized (uRLLoader) {
                rethrow = this.state == 1;
            }
            if (rethrow) {
                throw io;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.timeout.cancel();
        }
        URLLoader uRLLoader = this;
        synchronized (uRLLoader) {
            if (this.state == 2) {
                return false;
            }
            this.state = (byte)3;
        }
        this.str = new DataInputStream(this.connection.getInputStream());
        this.setLength(length);
        this.setMimeType(type);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeout() {
        URLLoader uRLLoader = this;
        synchronized (uRLLoader) {
            if (this.state == 3) {
                return;
            }
            this.state = (byte)2;
        }
        this.reportError("Multimedia.timedOut", "");
    }

    @Override
    protected void close() {
        if (this.str != null) {
            try {
                this.str.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.str = null;
            this.connection = null;
        }
    }

    private void setup(URL url) throws IOException {
        this.url = url;
    }

    @Override
    protected boolean read(ProtocolBuffer buf, int nBytes) {
        try {
            buf.readFrom((DataInput)this.str, 0, nBytes);
            return true;
        }
        catch (IOException ex) {
            this.reportError("AbstractLoader.readError", ex.toString());
            return false;
        }
    }
}

