/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.MediaLibraryEntry;
import com.elluminate.groupware.multimedia.StreamCache;
import com.elluminate.groupware.multimedia.StreamEvent;
import com.elluminate.groupware.multimedia.StreamListener;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.log.LogSupport;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class StreamProxy {
    private Channel chnl;
    private short addr;
    private int window;
    private HashMap streams = new HashMap();

    public StreamProxy(Channel ch, short uid, int win) {
        this.addr = uid;
        this.chnl = ch;
        this.window = win;
    }

    public void connect(MediaLibraryEntry ent) {
        short myAddr = this.chnl.getConnection().getAddress();
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)this.addr, (byte)18);
        try {
            DataOutputStream str = e.write();
            ent.encodeStatus(str, myAddr, 0L);
            str.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"connect", (Throwable)ex, (boolean)true);
        }
        this.chnl.onChannelData(e);
        this.reconnect(ent, 0L);
    }

    public void reconnect(MediaLibraryEntry ent, long from) {
        StreamCache c = ent.getCache();
        Integer key = new Integer(c.getStreamID());
        StreamInfo si = new StreamInfo(c, this.window);
        this.streams.put(key, si);
        si.attach(from);
    }

    public void disconnect(MediaLibraryEntry ent) {
        Integer key = new Integer(ent.getID());
        StreamInfo si = (StreamInfo)this.streams.remove(key);
        if (si != null) {
            si.dispose();
        }
    }

    public void dispose() {
        for (StreamInfo si : this.streams.values()) {
            si.dispose();
        }
    }

    public boolean isConnected(MediaLibraryEntry ent) {
        return this.streams.containsKey(new Integer(ent.getID()));
    }

    public long getLocation(MediaLibraryEntry ent) {
        StreamInfo si = (StreamInfo)this.streams.get(new Integer(ent.getID()));
        if (si == null) {
            return -1L;
        }
        return si.getLocation();
    }

    public short getAddress() {
        return this.addr;
    }

    public void ack(int streamid, int nBytes) {
        Integer key = new Integer(streamid);
        StreamInfo si = (StreamInfo)this.streams.get(key);
        if (si != null) {
            si.ack(nBytes);
        }
    }

    public void onTransmitStatusChanged(TransmitStatusEvent e) {
        try {
            StreamInfo si = (StreamInfo)e.getContext();
            si.setQuiesced();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUrgent(int streamid, boolean urgent) {
        Integer key = new Integer(streamid);
        StreamInfo si = (StreamInfo)this.streams.get(key);
        si.setUrgent(urgent);
    }

    class StreamInfo
    implements StreamListener {
        StreamCache cache;
        int avail;
        volatile boolean urgent = false;
        volatile boolean quiescing = false;
        long loc;

        public StreamInfo(StreamCache c, int w) {
            this.cache = c;
            this.avail = w;
            this.loc = 0L;
        }

        public void attach(long f) {
            this.loc = f;
            this.cache.addStreamListener(this, f);
        }

        public void dispose() {
            this.cache.suspendStreamListener(this);
            this.cache.removeStreamListener(this);
            this.cache = null;
        }

        @Override
        public void streamingData(StreamEvent e) {
            boolean suspend;
            ProtocolBuffer buf = e.getBuffer();
            ChannelDataEvent cde = null;
            if (this.quiescing) {
                LogSupport.error((Object)this, (String)"streamingData", (String)"Data received while quiescing stream");
                suspend = false;
            } else {
                int size = buf.getSize();
                this.avail -= size;
                this.loc += (long)size;
                suspend = this.avail <= 0;
                try {
                    DataOutputStream ostr = buf.addHeader();
                    ostr.writeInt(e.getStreamID());
                    ostr.close();
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"streamingData", (Throwable)ex, (boolean)true);
                    return;
                }
                cde = ChannelDataEvent.getInstance((Object)this, (short)StreamProxy.this.addr, (byte)22, (ProtocolBuffer)buf);
            }
            if (cde != null) {
                if (suspend && this.cache != null) {
                    this.cache.suspendStreamListener(this);
                }
                StreamProxy.this.chnl.onChannelData(cde, this.urgent ? (byte)0 : -2);
            }
            e.dispose();
        }

        public void ack(int nBytes) {
            boolean resume;
            this.avail += nBytes;
            boolean bl = resume = this.avail > 0 && !this.quiescing;
            if (resume) {
                this.cache.resumeStreamListener(this);
            }
        }

        public void setUrgent(boolean on) {
            byte urgency = this.urgent ? (byte)0 : -2;
            this.urgent = on;
            if (!this.quiescing) {
                this.quiescing = true;
                this.cache.suspendStreamListener(this);
                StreamProxy.this.chnl.requestCompletionNotify(StreamProxy.this.addr, urgency, (Object)this);
            }
        }

        public void setQuiesced() {
            this.quiescing = false;
            if (this.avail > 0) {
                this.cache.resumeStreamListener(this);
            }
        }

        public long getLocation() {
            return this.loc;
        }
    }
}

