/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaExecutable;
import com.elluminate.groupware.agenda.AgendaFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;

public class AgendaUtils {
    private static final int SHORT_ITEM_NAME_LENGTH = 32;
    private static FileView fileView;
    private static Map<String, Icon> iconCache;

    private AgendaUtils() {
    }

    public static String[] parseFileName(URL url) {
        String name = null;
        String qry = url.getQuery();
        if (qry != null) {
            StringTokenizer st = new StringTokenizer(qry, "&");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int pos = tok.indexOf(61);
                if (pos <= 0 || pos >= tok.length() - 1 || !tok.substring(0, pos).equals("displayname")) continue;
                name = tok.substring(pos + 1);
                break;
            }
        }
        if (name == null) {
            name = "index";
            String path = url.getPath();
            int pos = path.lastIndexOf("/");
            if (pos != -1 && pos < path.length() - 1) {
                name = path.substring(pos + 1);
            }
        }
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return AgendaUtils.parseFileName(name);
    }

    public static String[] parseFileName(File file) {
        return AgendaUtils.parseFileName(file.getName());
    }

    public static String[] parseFileName(String filename) {
        String name = filename;
        String ext = null;
        int pos = filename.lastIndexOf(".");
        if (pos != -1) {
            name = filename.substring(0, pos);
            if (pos < filename.length() - 1) {
                ext = filename.substring(pos + 1).toLowerCase(Locale.ENGLISH);
            }
        }
        return new String[]{name, ext};
    }

    public static Icon getFileIcon(File file) {
        String ext = AgendaUtils.parseFileName(file.getAbsolutePath())[1];
        if (ext == null) {
            return UIManager.getIcon("FileView.fileIcon");
        }
        Icon ic = iconCache.get(ext);
        if (ic != null) {
            return ic;
        }
        fileView = AgendaUtils.getFileView();
        if (file.exists()) {
            ic = fileView.getIcon(file);
            iconCache.put(ext, ic);
            return ic;
        }
        try {
            File f = File.createTempFile("icon", "." + ext);
            f.deleteOnExit();
            ic = fileView.getIcon(f);
            iconCache.put(ext, ic);
            f.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ic;
    }

    private static synchronized FileView getFileView() {
        if (fileView == null) {
            JFileChooser ch = new JFileChooser();
            fileView = ch.getUI().getFileView(ch);
        }
        return fileView;
    }

    public static String filterFileName(String filename) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (!Character.isLetter(ch) && !Character.isDigit(ch)) continue;
            b.append(ch);
        }
        return b.toString();
    }

    public static String getNameFromPath(String fullPath) {
        int pos = fullPath.lastIndexOf("/");
        if (pos == -1 && (fullPath.length() >= 3 && fullPath.charAt(1) == ':' && fullPath.charAt(2) == '\\' || fullPath.length() >= 2 && fullPath.charAt(0) == '\\' && fullPath.charAt(1) == '\\')) {
            pos = fullPath.lastIndexOf("\\");
        }
        if (pos != -1) {
            if (pos == fullPath.length() - 1) {
                return AgendaUtils.getNameFromPath(fullPath.substring(0, fullPath.length() - 1));
            }
            return fullPath.substring(pos + 1);
        }
        return fullPath;
    }

    public static File createSaveFile(File original) throws IOException {
        File fo = original.getParentFile();
        String name = original.getName();
        String suffix = ".tmp";
        int index = 2;
        File f = new File(fo, name + suffix);
        while (!f.createNewFile()) {
            f = new File(fo, name + index + suffix);
            ++index;
        }
        return f;
    }

    public static File createTempDirectory(String prefix) throws IOException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        if (!tmp.exists() && !tmp.mkdirs()) {
            throw new IOException("Unable to create directory " + tmp);
        }
        int index = 2;
        File fo = new File(tmp, prefix);
        while (fo.exists()) {
            fo = new File(tmp, prefix + index);
            ++index;
        }
        if (!fo.mkdir()) {
            throw new IOException("Unable to create directory " + fo);
        }
        return fo;
    }

    public static boolean deleteRecursively(File file) {
        File[] fs = file.listFiles();
        if (fs != null) {
            for (int i = fs.length - 1; i >= 0; --i) {
                if (AgendaUtils.deleteRecursively(fs[i])) continue;
                return false;
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File file, File folder) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            AgendaUtils.unzip(in, folder);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void unzip(InputStream in, File folder) throws IOException {
        ZipEntry en;
        ZipInputStream zin = new ZipInputStream(in);
        while ((en = zin.getNextEntry()) != null) {
            if (en.isDirectory()) {
                File fo = new File(folder, en.getName());
                if (!fo.exists() && !fo.mkdirs()) {
                    throw new IOException("Unable to create directory " + fo);
                }
                fo.deleteOnExit();
            } else {
                int bytesRead;
                String name = en.getName();
                File f = new File(folder, AgendaUtils.parseZIPPath(name));
                File fo = f.getParentFile();
                if (!fo.exists() && !fo.mkdirs()) {
                    throw new IOException("Unable to create directory " + fo);
                }
                fo.deleteOnExit();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buf = new byte[1024];
                while ((bytesRead = zin.read(buf)) != -1) {
                    out.write(buf, 0, bytesRead);
                }
                out.close();
                f.deleteOnExit();
            }
            zin.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File folder, File file) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            AgendaUtils.zip(folder, out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void zip(File folder, OutputStream out) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(out);
        AgendaUtils.zip(folder, folder, zout);
        zout.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File folder, File root, ZipOutputStream out) throws IOException {
        String rootPath = root.getAbsolutePath();
        if (!folder.getAbsolutePath().startsWith(rootPath)) {
            throw new IOException("Invalid root");
        }
        File[] fs = folder.listFiles();
        for (int i = 0; i < fs.length; ++i) {
            File f = fs[i];
            if (f.isDirectory()) {
                AgendaUtils.zip(f, root, out);
                continue;
            }
            BufferedInputStream in = null;
            try {
                int bytesRead;
                in = new BufferedInputStream(new FileInputStream(f));
                String name = f.getAbsolutePath().substring(rootPath.length());
                ZipEntry en = new ZipEntry(AgendaUtils.formatZIPPath(name));
                out.putNextEntry(en);
                byte[] buf = new byte[1024];
                while ((bytesRead = in.read(buf)) != -1) {
                    out.write(buf, 0, bytesRead);
                }
                continue;
            }
            finally {
                out.closeEntry();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            int bytesRead;
            in = new BufferedInputStream(new FileInputStream(from));
            out = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buf = new byte[1024];
            while ((bytesRead = in.read(buf)) != -1) {
                ((BufferedOutputStream)out).write(buf, 0, bytesRead);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static String getItemName(AgendaExecutable executable) {
        if (executable instanceof AgendaFile) {
            return ((AgendaFile)executable).getName();
        }
        if (executable instanceof AgendaAction) {
            return ((AgendaAction)executable).getDescription();
        }
        return null;
    }

    public static String getShortItemName(AgendaExecutable executable) {
        String name = AgendaUtils.getItemName(executable);
        if (name.length() <= 32) {
            return name;
        }
        return name.substring(0, 31) + "...";
    }

    private static String formatZIPPath(String path) {
        if (File.separatorChar != '/') {
            return path.replace(File.separatorChar, '/');
        }
        return path;
    }

    private static String parseZIPPath(String path) {
        if (File.separatorChar != '/') {
            return path.replace('/', File.separatorChar);
        }
        return path;
    }

    static {
        iconCache = new HashMap<String, Icon>();
    }
}

