/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaExecutable;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaObject;
import com.elluminate.groupware.agenda.AgendaProtocol;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.StringTokenizer;

public class AgendaFile
extends AgendaItem
implements AgendaExecutable {
    private String name;
    private String path;
    private long size;
    private boolean autoload = true;
    private String commandName = Agenda.FILE_COMMAND_DEFAULT;
    private HashMap commandParameters = new HashMap();

    @Override
    public Agenda getParentAgenda() {
        AgendaObject p = this.parent;
        if (p instanceof Agenda) {
            return (Agenda)p;
        }
        return null;
    }

    @Override
    public void removeFromParent() {
        AgendaObject p = this.parent;
        if (p instanceof Agenda) {
            ((Agenda)p).removeFile(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name == null && this.name != name || !this.name.equals(name)) {
            this.name = name;
            this.changeItemNotify(this, "name");
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        if (this.size != size) {
            this.size = size;
            this.changeItemNotify(this, "size");
        }
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public void setAutoload(boolean autoload) {
        if (this.autoload != autoload) {
            this.autoload = autoload;
            this.changeItemNotify(this, "autoload");
        }
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public void setCommandName(String commandName) {
        if (commandName != null && !commandName.equals(this.commandName) || this.commandName != null && !this.commandName.equals(commandName)) {
            this.commandName = commandName;
            this.clearCommandParameters();
            this.changeItemNotify(this, "command");
        }
    }

    @Override
    public String[] getCommandParameterNames() {
        return this.commandParameters.keySet().toArray(new String[0]);
    }

    @Override
    public String getCommandParameter(String name) {
        return (String)this.commandParameters.get(name);
    }

    @Override
    public void setCommandParameter(String name, String value) {
        if (value != null) {
            this.commandParameters.put(name, value);
        } else {
            this.commandParameters.remove(name);
        }
        this.changeItemNotify(this, AgendaProtocol.formatParameterName("parameter", name));
    }

    @Override
    public void clearCommandParameters() {
        this.commandParameters.clear();
    }

    @Override
    public String getStringParameter(String name) {
        return this.getCommandParameter(name);
    }

    @Override
    public Integer getIntegerParameter(String name) {
        Integer i = null;
        String value = this.getCommandParameter(name);
        if (value != null) {
            try {
                i = new Integer(Integer.parseInt(value));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return i;
    }

    @Override
    public Boolean getBooleanParameter(String name) {
        Boolean b = null;
        String value = this.getCommandParameter(name);
        if (value != null) {
            b = new Boolean(value.equalsIgnoreCase("true"));
        }
        return b;
    }

    @Override
    public Rectangle getRectangleParameter(String name) {
        StringTokenizer st;
        Rectangle r = null;
        String value = this.getCommandParameter(name);
        if (value != null && (st = new StringTokenizer(value, ",")).countTokens() == 4) {
            try {
                int x = Integer.parseInt(st.nextToken());
                int y = Integer.parseInt(st.nextToken());
                int w = Integer.parseInt(st.nextToken());
                int h = Integer.parseInt(st.nextToken());
                r = new Rectangle(x, y, w, h);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return r;
    }

    @Override
    public boolean canMoveUp() {
        Agenda ag = this.getParentAgenda();
        if (ag != null) {
            return ag.getFileIndex(this) != 0;
        }
        return false;
    }

    @Override
    public boolean canMoveDown() {
        Agenda ag = this.getParentAgenda();
        if (ag != null) {
            return ag.getFileIndex(this) != ag.getFileCount() - 1;
        }
        return false;
    }

    @Override
    public boolean canMoveLeft() {
        return false;
    }

    @Override
    public boolean canMoveRight() {
        return false;
    }

    @Override
    protected String paramString() {
        StringBuffer b = new StringBuffer();
        b.append(super.paramString());
        b.append(",name=");
        b.append(this.name);
        b.append(",path=");
        b.append(this.path);
        return b.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AgendaFile cl = (AgendaFile)super.clone();
        cl.commandParameters = (HashMap)this.commandParameters.clone();
        return cl;
    }

    public boolean equals(Object object) {
        return object instanceof AgendaFile && ((AgendaFile)object).path.equals(this.path);
    }
}

