/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit;

import com.teamdev.jxbrowser.mac.cocoa.awt.CocoaComponentFactory;
import com.teamdev.jxbrowser.webkit.BrowserEngine;
import com.teamdev.jxbrowser.webkit.DeadEngine;
import com.teamdev.jxbrowser.webkit.DialogCreator;
import com.teamdev.jxbrowser.webkit.JavaScriptJavaBridge;
import com.teamdev.jxbrowser.webkit.MouseKeyboardSupport;
import com.teamdev.jxbrowser.webkit.Properties;
import com.teamdev.jxbrowser.webkit.SafariBrowserFunction;
import com.teamdev.jxbrowser.webkit.SafariEngine;
import com.teamdev.jxbrowser.webkit.WebBrowser;
import com.teamdev.jxbrowser.webkit.WebBrowserWindow;
import com.teamdev.jxbrowser.webkit.WebPolicyDelegate;
import com.teamdev.jxbrowser.webkit.WindowCreator;
import com.teamdev.jxbrowser.webkit.event.BrowserListener;
import com.teamdev.jxbrowser.webkit.webkit.WebPreferences;
import com.teamdev.jxdesktop.macosx.MainMessageLoop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public class Safari
extends JComponent
implements WebBrowser {
    private Timer timer;
    private BrowserEngine engine = new SafariEngine();
    private final MouseKeyboardSupport mouseKeyboardSupport;
    private Component component;

    public Safari() {
        this.engine.setComponent(this);
        this.mouseKeyboardSupport = new MouseKeyboardSupport(this, this.engine);
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                Safari.this.component = CocoaComponentFactory.create((long)Safari.this.getNativePeer());
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.component, "Center");
    }

    public void addNotify() {
        super.addNotify();
        this.activateTimerForNativeLoop();
    }

    public void removeNotify() {
        super.removeNotify();
        this.deactivateTimerForNativeLoop();
    }

    public void setName(String string) {
        super.setName(string);
        this.component.setName(string);
    }

    private void activateTimerForNativeLoop() {
        Window window = SwingUtilities.windowForComponent(this);
        if (this.engine instanceof SafariEngine && window instanceof Dialog && ((Dialog)window).isModal()) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                public void run() {
                    ((SafariEngine)Safari.this.engine).runLoop();
                }
            }, 0L, 400L);
        }
    }

    private void deactivateTimerForNativeLoop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void setParentComponent(Component component) {
        this.engine.setParentComponent(component);
    }

    public void navigate(String string) {
        this.navigate(string, null);
    }

    public void navigate(String string, String string2) {
        this.navigate(string, string2, 0);
    }

    public void navigate(String string, String string2, int n) {
        this.engine.navigate(string, string2, n);
    }

    public String executeScript(String string) {
        return this.engine.executeScript(string);
    }

    public String getLocationURL() {
        return this.engine.getLocationURL();
    }

    public void setHTML(String string, String string2) {
        this.engine.setHTML(string, string2);
    }

    public String getHTML() {
        return this.engine.getHTML();
    }

    public String getTextContent() {
        return this.engine.getTextContent();
    }

    public void stop() {
        this.engine.stop();
    }

    public void reload() {
        this.engine.reload();
    }

    public void goBack() {
        this.engine.goBack();
    }

    public void goForward() {
        this.engine.goForward();
    }

    public boolean canGoBack() {
        return this.engine.canGoBack();
    }

    public boolean canGoForward() {
        return this.engine.canGoForward();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.mouseKeyboardSupport.dispose();
            this.engine.dispose();
            this.engine = new DeadEngine();
        }
    }

    public boolean isDisposed() {
        return this.engine instanceof DeadEngine;
    }

    public Component getComponent() {
        return this;
    }

    public void requestFocus() {
        ((SafariEngine)this.engine).requestFocus();
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.engine.addBrowserListener(browserListener);
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.engine.removeBrowserListener(browserListener);
    }

    public BrowserListener[] getBrowserListeners() {
        return this.engine.getBrowserListeners();
    }

    public void setDialogCreator(DialogCreator dialogCreator) {
        this.engine.setDialogCreator(dialogCreator);
    }

    public void setWindowCreator(WindowCreator windowCreator) {
        this.engine.setWindowCreator(windowCreator);
    }

    public void setWebPolicyDelegate(WebPolicyDelegate webPolicyDelegate) {
        this.engine.setWebPolicyDelegate(webPolicyDelegate);
    }

    public WebPolicyDelegate getWebPolicyDelegate() {
        return this.engine.getWebPolicyDelegate();
    }

    public Properties getProperties() {
        return this.engine.getProperties();
    }

    public Document getDocument() {
        return this.engine.getDocument();
    }

    public Image toImage() {
        return this.engine.toImage();
    }

    public Image toImage(Dimension dimension) {
        return this.engine.toImage(dimension);
    }

    public WebPreferences getPreferences() {
        return this.engine.getPreferences();
    }

    public void setPreferences(WebPreferences webPreferences) {
        this.engine.setPreferences(webPreferences);
    }

    public void setWebBrowserWindow(WebBrowserWindow webBrowserWindow) {
        this.engine.setWebBrowserWindow(webBrowserWindow);
    }

    public long getNativePeer() {
        return this.engine.getNSView();
    }

    public void setUserAgent(String string) {
        this.engine.setUserAgent(string);
    }

    public void addEventListener(Node node, String string, EventListener eventListener, boolean bl) {
        this.engine.addEventListener(node, string, eventListener, bl);
    }

    public void removeEventListener(Node node, String string, EventListener eventListener, boolean bl) {
        this.engine.removeEventListener(node, string, eventListener, bl);
    }

    boolean dispatchEvent(Node node, Event event) throws EventException {
        return this.engine.dispatchEvent(node, event);
    }

    public boolean isReady() {
        return this.engine.isReady();
    }

    public void registerFunction(String string, SafariBrowserFunction safariBrowserFunction) {
        this.executeScript("window." + string + " = function " + string + "() {\n" + "    return window.JavaScriptJavaBridge.callJavaFunction_withArguments_(\"" + string + "\", arguments);\n" + "}");
        JavaScriptJavaBridge javaScriptJavaBridge = this.engine.getJavaScriptJavaBridge();
        javaScriptJavaBridge.registerFunction(string, safariBrowserFunction);
    }

    public void removeAllCache() {
        this.engine.removeAllCache();
    }

    public boolean print() {
        SafariEngine safariEngine = (SafariEngine)this.engine;
        return safariEngine.print();
    }
}

