/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.engine;

import com.elluminate.engine.CommandInstantiationException;
import com.elluminate.engine.CommandNotFoundException;
import com.elluminate.engine.command.Command;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class ConferencingEngine {
    private Map<Class<?>, Provider<? extends Command>> commandMap = new HashMap();

    public boolean isCommandRegistered(Class<?> spec) {
        return this.commandMap.containsKey(spec);
    }

    public void registerCommand(Provider<? extends Command> prov) {
        Class<?>[] intfs;
        Command inst = (Command)prov.get();
        Class<?> cls = inst.getClass();
        for (Class<?> spec : intfs = cls.getInterfaces()) {
            if (!Command.class.isAssignableFrom(spec)) continue;
            this.commandMap.put(spec, prov);
        }
    }

    public Command newCommand(Class<?> spec) throws CommandNotFoundException, CommandInstantiationException {
        Provider<? extends Command> prov = this.commandMap.get(spec);
        if (prov == null) {
            throw new CommandNotFoundException("No command implementation found for interface " + spec.getName());
        }
        return (Command)prov.get();
    }
}

