/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.accessibility.cli;

import com.elluminate.accessibility.cli.CommandHandler;
import com.elluminate.engine.CommandInstantiationException;
import com.elluminate.engine.CommandNotFoundException;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.engine.command.Command;
import java.util.Collection;

public abstract class AbstractCommandHandler
implements CommandHandler {
    private ConferencingEngine conferencingEngine;

    @Override
    public String getParameterUsage() {
        return null;
    }

    protected Command createCommand(Class commandClass) throws CommandNotFoundException, CommandInstantiationException {
        if (this.getConferencingEngine() == null) {
            throw new CommandInstantiationException("Conference Engine was not initialized.");
        }
        return this.getConferencingEngine().newCommand(commandClass);
    }

    protected static String joinParameters(String ... parameters) {
        StringBuilder b = new StringBuilder();
        for (String param : parameters) {
            if (b.length() != 0) {
                b.append(" ");
            }
            b.append(param);
        }
        return b.toString();
    }

    protected static String joinChoices(Collection<String> choices) {
        StringBuilder b = new StringBuilder();
        for (String choice : choices) {
            if (b.length() != 0) {
                b.append("|");
            }
            b.append(choice);
        }
        return b.toString();
    }

    public ConferencingEngine getConferencingEngine() {
        return this.conferencingEngine;
    }

    @Override
    public void setConferencingEngine(ConferencingEngine conferencingEngine) {
        this.conferencingEngine = conferencingEngine;
    }
}

