/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.transfer.ResponderTransferLibrary;
import com.elluminate.groupware.transfer.TransferResponder;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.StringComparator;
import com.google.inject.Inject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class TransferProtocol
extends JinxProtocolAdapter {
    public static final byte BASE_PRIORITY = 2;
    public static final String PROPERTY = "transfer.file.access";
    public static final byte CATEGORY = 96;
    public static final byte CAT_LIB = 0;
    public static final byte LIB_LOAD = 1;
    public static final byte LIB_PUSH = 2;
    public static final byte LIB_RESUME = 3;
    public static final byte LIB_DELETE = 4;
    public static final byte LIB_SYNC = 5;
    public static final byte LIB_DATA = 6;
    public static final byte LIB_ACK = 7;
    public static final byte LIB_URGENT = 8;
    public static final byte LIB_ATTRIBUTE = 9;
    public static final byte LIB_STATUS = 10;
    public static final byte LIB_OK = 11;
    public static final byte LIB_ERROR = 15;
    public static final byte CAT_ID = 32;
    public static final byte ID_REQUEST = 33;
    public static final byte ID_ASSIGN = 34;
    public static final byte ID_ERROR = 47;
    public static final int[] STATUS_PERCENT = new int[]{49, 74, 94, 99, 100};
    public static final long WINDOW_MSEC = 3000L;
    public static final int WINDOW_MIN = 1024;
    public static final int WINDOW_MAX = 32768;
    private I18n i18n = I18n.create((Object)((Object)this));
    private Imps imps = null;
    private TransferResponder responder;

    public TransferProtocol() {
        this.defineProperty(PROPERTY, (byte)0, Boolean.FALSE);
    }

    @Inject
    public void initTransferResponder(TransferResponder responder) {
        this.responder = responder;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return "Library Load";
            }
            case 2: {
                return "Library Push";
            }
            case 3: {
                return "Library Resume";
            }
            case 4: {
                return "Library Delete";
            }
            case 5: {
                return "Library Sync";
            }
            case 6: {
                return "Library Data";
            }
            case 7: {
                return "Library Ack";
            }
            case 8: {
                return "Library Urgent";
            }
            case 9: {
                return "Library Attribute";
            }
            case 10: {
                return "Library Status";
            }
            case 11: {
                return "Library OK";
            }
            case 15: {
                return "Library Error";
            }
            case 33: {
                return "ID Request";
            }
            case 34: {
                return "ID Assign";
            }
            case 47: {
                return "ID Error";
            }
        }
        return "*** UNKNOWN COMMAND - " + cmd + " ***";
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String desc = this.commandToString(cmd);
        try {
            switch (cmd) {
                case 1: {
                    int seq = str.readInt();
                    String name = str.readUTF();
                    Map<String, String> attrs = TransferProtocol.readAttrs(str);
                    desc = desc + " - Request-" + seq + ": " + name + " " + this.formatAttrs(attrs);
                    break;
                }
                case 2: {
                    int seq = str.readInt();
                    int id = str.readInt();
                    String name = str.readUTF();
                    String type = str.readUTF();
                    String owner = str.readUTF();
                    long length = str.readLong();
                    long position = str.readLong();
                    String auth = str.readUTF();
                    Map<String, String> attrs = TransferProtocol.readAttrs(str);
                    desc = desc + " - Request " + seq + " [" + id + "(" + auth + "):" + name + "(" + owner + "," + type + "," + position + "/" + length + ")]" + this.formatAttrs(attrs);
                    break;
                }
                case 3: {
                    int id = str.readInt();
                    long position = str.readLong();
                    desc = desc + " - ID " + id + ", from offset " + position;
                    break;
                }
                case 5: {
                    desc = desc + ":";
                    int id = str.readInt();
                    while (id > 0) {
                        String name = str.readUTF();
                        String type = str.readUTF();
                        String owner = str.readUTF();
                        long length = str.readLong();
                        long position = str.readLong();
                        String auth = str.readUTF();
                        Map<String, String> attrs = TransferProtocol.readAttrs(str);
                        desc = desc + "\n    [" + id + "(" + auth + "): " + name + "(" + owner + "," + type + "," + position + "/" + length + ")]" + this.formatAttrs(attrs);
                        id = str.readInt();
                    }
                    break;
                }
                case 4: {
                    int seq = str.readInt();
                    int id = str.readInt();
                    desc = desc + " - Request-" + seq + ",ID=" + id;
                    break;
                }
                case 6: {
                    desc = desc + " - ID=" + str.readInt() + "," + str.available() + " bytes of data";
                    break;
                }
                case 7: {
                    desc = desc + " - ID=" + str.readInt() + "," + str.readInt() + " bytes received.";
                    break;
                }
                case 10: {
                    StringBuffer buf = new StringBuffer(desc);
                    buf.append(":");
                    int id = str.readInt();
                    while (id > 0) {
                        short percent = str.readByte();
                        buf.append("\n    [");
                        buf.append(id);
                        buf.append("(");
                        if (percent == 100) {
                            buf.append("complete,");
                        } else if (percent >= 0) {
                            buf.append("loading(");
                            buf.append(percent);
                            buf.append("),");
                        } else {
                            buf.append("incomplete(");
                            buf.append(-percent);
                            buf.append("),");
                        }
                        for (int i = 0; i < STATUS_PERCENT.length; ++i) {
                            percent = str.readShort();
                            if (i != 0) {
                                buf.append("/");
                            }
                            buf.append(percent);
                        }
                        buf.append(")]");
                        id = str.readInt();
                    }
                    desc = buf.toString();
                    break;
                }
                case 8: {
                    int id = str.readInt();
                    byte urgency = str.readByte();
                    desc = desc + " - ID=" + id + " (" + urgency + ")";
                    break;
                }
                case 9: {
                    int seq = str.readInt();
                    int id = str.readInt();
                    Map<String, String> attrs = TransferProtocol.readAttrs(str);
                    desc = desc + " - Request-" + seq + ", ID=" + id + " " + this.formatAttrs(attrs);
                    break;
                }
                case 11: {
                    int seq = str.readInt();
                    int id = str.readInt();
                    desc = desc + " - Request-" + seq + ", ID=" + id;
                    break;
                }
                case 15: {
                    int seq = str.readInt();
                    I18nMessage err = new I18nMessage(str);
                    desc = desc + " - Request-" + seq + ": " + err;
                    break;
                }
                case 34: {
                    int seq = str.readInt();
                    int id = str.readInt();
                    String dh = str.readUTF();
                    desc = desc + " - seq=" + seq + ", ID=" + id + ", dh='" + dh + "'";
                    break;
                }
                case 33: {
                    int seq = str.readInt();
                    String dh = str.readUTF();
                    desc = desc + " - seq=" + seq + ", dh='" + dh + "'";
                    break;
                }
                case 47: {
                    int seq = str.readInt();
                    String msg = str.readUTF();
                    desc = desc + " - seq=" + seq + ", " + this.i18n.getStringLegacy(msg);
                }
            }
        }
        catch (IOException ex) {
            desc = desc + " - " + ex + " while decoding message.";
        }
        return desc;
    }

    public static Map<String, String> readAttrs(DataInputStream str) throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>((Comparator<String>)new StringComparator());
        int n = str.readInt();
        for (int i = 0; i < n; ++i) {
            String nm = str.readUTF();
            String val = str.readUTF();
            map.put(nm, val);
        }
        return map;
    }

    public static void writeAttrs(DataOutputStream str, Map<String, String> attrs) throws IOException {
        str.writeInt(attrs.size());
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            String nm = e.getKey();
            String val = e.getValue();
            str.writeUTF(nm);
            str.writeUTF(val);
        }
    }

    private String formatAttrs(Map<String, String> attrs) {
        StringBuffer buf = new StringBuffer();
        int sep = 91;
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            String nm = e.getKey();
            String val = e.getValue();
            buf.append((char)sep);
            buf.append(nm);
            buf.append('=');
            buf.append(val);
            sep = 44;
        }
        if (sep != 91) {
            buf.append("]");
        }
        return buf.toString();
    }

    public ProtocolResponder getResponder() {
        if (this.responder == null) {
            ResponderTransferLibrary lib = new ResponderTransferLibrary();
            TransferResponder tmp = new TransferResponder();
            lib.initImps(this.imps);
            tmp.initTransferProtocol(this);
            tmp.initResponderTransferLibrary(lib);
            this.responder = tmp;
        }
        return this.responder;
    }
}

