/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.imps.filetransfer.FileTransferItem;
import com.elluminate.groupware.imps.filetransfer.FileTransferProgressListener;
import com.elluminate.groupware.imps.filetransfer.TransferActivityListener;
import com.elluminate.groupware.transfer.StreamCache;
import com.elluminate.groupware.transfer.StreamEvent;
import com.elluminate.groupware.transfer.StreamListener;
import com.elluminate.groupware.transfer.TransferProtocol;
import com.elluminate.groupware.transfer.Urgency;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.RecvWindow;
import com.elluminate.jinx.RecvWindowListener;
import com.elluminate.util.ShortList;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.crypto.DiffieHellman;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TransferLibraryEntry
implements FileTransferItem {
    private static int nextRequest = 1;
    private static Object requestLock = new Object();
    private int uid;
    private String name;
    private String mime;
    private long length;
    private BigInteger auth;
    private StreamCache cache = null;
    private short source = 0;
    private RecvWindow window = null;
    private String owner = null;
    private HashMap attrs = null;
    private byte serverPct = 0;
    private short[] status = new short[TransferProtocol.STATUS_PERCENT.length];
    private HashMap requests = new HashMap();
    private Urgency urgency = null;
    private HashSet activeUsers = new HashSet();
    private TransferActivityListener[] activeListeners = new TransferActivityListener[0];
    private byte priority = (byte)-2;
    private String saveLocation = null;

    public TransferLibraryEntry(int id, long length, BigInteger auth, String name, String type, String owner, Map attrs, RecvWindowListener lst, Urgency urgency) {
        this.uid = id;
        this.name = name;
        this.mime = type;
        this.length = length;
        this.auth = auth;
        this.owner = owner;
        this.urgency = urgency;
        this.attrs = attrs != null ? new HashMap(attrs) : new HashMap();
        if (lst != null) {
            this.window = new RecvWindow(3000L, 1024, 32768, lst, (Object)this);
        }
        if (this.length == 0L) {
            this.serverPct = (byte)100;
            this.status[this.status.length - 1] = 1;
        }
    }

    public TransferLibraryEntry(StreamCache cache, BigInteger auth, String name, String type, String owner, Map attrs, RecvWindowListener lst, Urgency urgency) {
        this.cache = cache;
        this.uid = cache.getStreamID();
        this.auth = auth;
        this.name = name;
        this.mime = type;
        this.length = cache.getLength();
        this.owner = owner;
        this.urgency = urgency;
        this.attrs = attrs != null ? new HashMap(attrs) : new HashMap();
        if (lst != null) {
            this.window = new RecvWindow(3000L, 1024, 32768, lst, (Object)this);
        }
        if (this.length == 0L) {
            this.serverPct = (byte)100;
            this.status[this.status.length - 1] = 1;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mime;
    }

    public int getUID() {
        return this.uid;
    }

    public long getLength() {
        return this.length;
    }

    public long getPosition() {
        if (this.cache == null) {
            return 0L;
        }
        return this.cache.getLocation();
    }

    public boolean isComplete() {
        return this.getLength() == this.getPosition();
    }

    public void setCache(StreamCache c) {
        this.cache = c;
    }

    public StreamCache getCache() {
        return this.cache;
    }

    public void write(ProtocolBuffer b) {
        if (this.cache != null) {
            this.cache.streamingData(StreamEvent.getInstance(this, this.uid, (ProtocolBuffer)b.clone()));
        }
        this.window.recv(b.getSize());
    }

    public void write(File f) throws IOException {
        RequestWaiter w = new RequestWaiter(f);
        w.waitFor();
        this.saveLocation = f.getAbsolutePath();
    }

    public void write(OutputStream str) throws IOException {
        RequestWaiter w = new RequestWaiter(str);
        w.waitFor();
    }

    public int write(File f, FileTransferProgressListener lst) {
        WriteRequest request = new WriteRequest(f, lst);
        this.saveLocation = f.getAbsolutePath();
        return request.getRequestID();
    }

    public int write(OutputStream str, FileTransferProgressListener lst) {
        WriteRequest request = new WriteRequest(str, lst);
        return request.getRequestID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWrite(int req) {
        WriteRequest request;
        this.saveLocation = null;
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            request = (WriteRequest)this.requests.get(new Integer(req));
        }
        if (request != null) {
            request.cancel();
        }
    }

    public void setAttribute(String nm, String val) {
        if (val != null) {
            this.attrs.put(nm, val);
        } else {
            this.attrs.remove(nm);
        }
    }

    public String getAttribute(String nm) {
        return (String)this.attrs.get(nm);
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this.attrs);
    }

    public String getSaveLocation() {
        return this.saveLocation;
    }

    public BigInteger getAuthCode() {
        return this.auth;
    }

    public void setSource(short src) {
        this.source = src;
    }

    public short getSource() {
        return this.source;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isServerComplete() {
        return this.serverPct == 100 | this.length == 0L;
    }

    public boolean isLoading() {
        return this.serverPct >= 0 && this.serverPct < 100 && this.length > 0L;
    }

    public boolean isIncomplete() {
        return this.serverPct < 0 && this.length > 0L;
    }

    public boolean isUploading() {
        return this.auth != null && !this.auth.equals("") && !this.isServerComplete();
    }

    public int getServerPercent() {
        return this.length == 0L ? 100 : (int)this.serverPct;
    }

    public boolean setServerPercent(byte pct) {
        boolean changed = this.serverPct != pct;
        this.serverPct = pct;
        return changed;
    }

    public short[] getStatusHist() {
        return (short[])this.status.clone();
    }

    public void getStatusHist(short[] hist) {
        System.arraycopy(this.status, 0, hist, 0, Math.min(this.status.length, hist.length));
    }

    public short getStatusCount(int idx) {
        return this.status[idx];
    }

    public boolean setStatusCount(int idx, short n) {
        boolean changed = this.status[idx] != n;
        this.status[idx] = n;
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityListener(TransferActivityListener lst) {
        HashSet hashSet = this.activeUsers;
        synchronized (hashSet) {
            int n = this.activeListeners.length;
            TransferActivityListener[] copy = new TransferActivityListener[n + 1];
            for (int i = 0; i < n; ++i) {
                TransferActivityListener l = this.activeListeners[i];
                if (l == lst) {
                    return;
                }
                copy[i] = l;
            }
            copy[n] = lst;
            this.activeListeners = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivityListener(TransferActivityListener lst) {
        HashSet hashSet = this.activeUsers;
        synchronized (hashSet) {
            int n = this.activeListeners.length;
            TransferActivityListener[] copy = new TransferActivityListener[n - 1];
            int j = 0;
            for (int i = 0; i < n; ++i) {
                TransferActivityListener l = this.activeListeners[i];
                if (l == lst) continue;
                if (j < n - 1) {
                    copy[j++] = l;
                    continue;
                }
                return;
            }
            this.activeListeners = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(short who, boolean active) {
        boolean wasActive = this.isActive();
        boolean wasUserActive = this.isActive(who);
        HashSet hashSet = this.activeUsers;
        synchronized (hashSet) {
            if (active) {
                this.activeUsers.add(ShortList.get((short)who));
            } else {
                this.activeUsers.remove(ShortList.get((short)who));
            }
        }
        if (wasActive != this.isActive()) {
            this.urgency.setUrgent(this.uid, this.isActive());
        }
        if (wasUserActive != active) {
            TransferActivityListener[] listeners = this.activeListeners;
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].activityChange((FileTransferItem)this, who, active);
                    continue;
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"setActive", (Throwable)t, (boolean)true);
                }
            }
        }
    }

    public boolean isActive(short who) {
        return this.activeUsers.contains(ShortList.get((short)who));
    }

    public boolean isActive() {
        return !this.activeUsers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList list;
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            list = new ArrayList(this.requests.values());
        }
        for (WriteRequest req : list) {
            req.cancel();
        }
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
    }

    public void reset() {
        if (this.window != null) {
            this.window.reset();
        }
    }

    public void encodeProgress(DataOutputStream str) throws IOException {
        str.writeInt(this.uid);
        str.writeByte(this.serverPct);
        for (int i = 0; i < this.status.length; ++i) {
            str.writeShort(this.status[i]);
        }
    }

    public void decodeProgress(DataInputStream str) throws IOException {
        this.serverPct = str.readByte();
        for (int i = 0; i < this.status.length; ++i) {
            this.status[i] = str.readShort();
        }
    }

    public void encodeStatus(DataOutputStream str, short addr) throws IOException {
        this.encodeStatus(str, addr, this.getPosition());
    }

    public void encodeStatus(DataOutputStream str, short addr, long from) throws IOException {
        str.writeInt(this.uid);
        str.writeUTF(this.name);
        str.writeUTF(this.mime);
        str.writeUTF(this.owner);
        str.writeLong(this.length);
        str.writeLong(from);
        if (addr == 0 || this.auth == null) {
            str.writeUTF("");
        } else {
            str.writeUTF(DiffieHellman.getKeyString((BigInteger)this.auth, (String)Short.toString(addr)));
        }
        TransferProtocol.writeAttrs(str, this.attrs);
    }

    public void setPriority(byte pri) {
        this.priority = pri;
    }

    public byte getPriority() {
        return this.priority;
    }

    public String toString() {
        return this.name + "(" + this.uid + "," + this.mime + "," + this.getPosition() + "/" + this.getLength() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer getNextRequest() {
        int req;
        Object object = requestLock;
        synchronized (object) {
            req = nextRequest++;
        }
        return new Integer(req);
    }

    class RequestWaiter
    implements FileTransferProgressListener {
        private int req;
        private IOException iox = null;
        private boolean done = false;

        public RequestWaiter(File f) {
            this.req = TransferLibraryEntry.this.write(f, (FileTransferProgressListener)this);
        }

        public RequestWaiter(OutputStream str) {
            this.req = TransferLibraryEntry.this.write(str, (FileTransferProgressListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exceptionNotify(int req, IOException iox) {
            RequestWaiter requestWaiter = this;
            synchronized (requestWaiter) {
                this.iox = iox;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void progressNotify(int req, int pct, boolean done) {
            if (!done) {
                return;
            }
            RequestWaiter requestWaiter = this;
            synchronized (requestWaiter) {
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor() throws IOException {
            IOException x = null;
            RequestWaiter requestWaiter = this;
            synchronized (requestWaiter) {
                while (!this.done && this.iox == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ix) {
                        TransferLibraryEntry.this.cancelWrite(this.req);
                        this.iox = new InterruptedIOException();
                    }
                }
                x = this.iox;
            }
            if (x != null) {
                throw x;
            }
        }
    }

    class WriteRequest
    extends WorkerThread
    implements StreamListener {
        private int req;
        private File file;
        private DataOutputStream stream;
        private FileTransferProgressListener listener;
        private long nWritten;
        private int percent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WriteRequest(File f, FileTransferProgressListener lst) {
            super("Transfer Write Thread - " + TransferLibraryEntry.this.name, 5);
            this.file = null;
            this.stream = null;
            this.listener = null;
            this.nWritten = 0L;
            this.percent = 0;
            Integer key = TransferLibraryEntry.getNextRequest();
            this.req = key;
            this.file = f;
            this.listener = lst;
            HashMap hashMap = TransferLibraryEntry.this.requests;
            synchronized (hashMap) {
                TransferLibraryEntry.this.requests.put(key, this);
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WriteRequest(OutputStream str, FileTransferProgressListener lst) {
            super("Transfer Write Thread - " + TransferLibraryEntry.this.name, 5);
            this.file = null;
            this.stream = null;
            this.listener = null;
            this.nWritten = 0L;
            this.percent = 0;
            Integer key = TransferLibraryEntry.getNextRequest();
            this.req = key;
            this.stream = new DataOutputStream(str);
            this.listener = lst;
            HashMap hashMap = TransferLibraryEntry.this.requests;
            synchronized (hashMap) {
                TransferLibraryEntry.this.requests.put(key, this);
            }
            this.start();
        }

        public int getRequestID() {
            return this.req;
        }

        @Override
        public void streamingData(StreamEvent e) {
            boolean done;
            ProtocolBuffer buf = e.getBuffer();
            try {
                buf.writeTo((DataOutput)this.stream);
            }
            catch (IOException iox) {
                this.listener.exceptionNotify(this.req, iox);
                this.cancel();
                e.dispose();
                return;
            }
            this.nWritten += (long)buf.getSize();
            int nPct = (int)(this.nWritten * 100L / TransferLibraryEntry.this.length);
            boolean bl = done = this.nWritten == TransferLibraryEntry.this.length;
            if (nPct != this.percent || done) {
                this.listener.progressNotify(this.req, nPct, done);
                this.percent = nPct;
                if (done) {
                    this.finish(false);
                }
            }
            e.dispose();
        }

        @Override
        public void streamAbort(StreamEvent e) {
            this.finish(true);
        }

        public void run() {
            if (this.stream == null) {
                try {
                    this.stream = new DataOutputStream(new FileOutputStream(this.file));
                }
                catch (IOException iox) {
                    this.listener.exceptionNotify(this.req, iox);
                    this.cancel();
                    return;
                }
            }
            TransferLibraryEntry.this.cache.addStreamListener(this);
            if (TransferLibraryEntry.this.cache.getLength() == 0L) {
                this.finish(false);
                this.listener.progressNotify(this.req, 100, true);
            }
        }

        public void cancel() {
            this.finish(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish(boolean delete) {
            HashMap hashMap = TransferLibraryEntry.this.requests;
            synchronized (hashMap) {
                TransferLibraryEntry.this.requests.remove(new Integer(this.req));
            }
            TransferLibraryEntry.this.cache.removeStreamListener(this);
            if (this.file != null) {
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (delete) {
                    this.file.delete();
                }
            }
        }
    }
}

