/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.imps.filetransfer.FileTransferException;
import com.elluminate.groupware.imps.filetransfer.FileTransferItem;
import com.elluminate.groupware.imps.filetransfer.FileTransferListener;
import com.elluminate.groupware.imps.filetransfer.FileTransferRequestListener;
import com.elluminate.groupware.transfer.SharedTransferClient;
import com.elluminate.groupware.transfer.TransferLibrary;
import com.elluminate.groupware.transfer.TransferProtocol;
import com.elluminate.util.I18nMessage;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractTransferClient
implements SharedTransferClient {
    protected TransferLibrary lib;

    public Object getLock() {
        return this.lib.getLock();
    }

    public int size() {
        return this.lib.size();
    }

    public Iterator iterator() {
        return this.lib.iterator();
    }

    public FileTransferItem getItem(int id) {
        return this.lib.get(id);
    }

    public FileTransferItem addItem(File f, Map attrs) throws FileTransferException {
        Result result = new Result();
        int request = this.addItem(f, attrs, (FileTransferRequestListener)result);
        int uid = result.waitFor();
        return this.lib.get(uid);
    }

    public FileTransferItem addItem(URL u, Map attrs) throws FileTransferException {
        Result result = new Result();
        int request = this.addItem(u, attrs, (FileTransferRequestListener)result);
        int uid = result.waitFor();
        return this.lib.get(uid);
    }

    public void removeItem(int id) throws FileTransferException {
        Result result = new Result();
        int request = this.removeItem(id, result);
        result.waitFor();
    }

    public int addItem(File f, Map attrs, FileTransferRequestListener lst) {
        return this.lib.load(f, attrs, lst);
    }

    public int addItem(URL u, Map attrs, FileTransferRequestListener lst) {
        return this.lib.load(u, attrs, lst);
    }

    public int removeItem(int id, FileTransferRequestListener lst) {
        return this.lib.remove(id, lst);
    }

    public int setItemAttributes(int id, Map attrs, FileTransferRequestListener lst) {
        return this.lib.setAttributes(id, attrs, lst);
    }

    public byte[] getStatusThresholds() {
        byte[] pct = new byte[TransferProtocol.STATUS_PERCENT.length];
        for (int i = 0; i < pct.length; ++i) {
            pct[i] = (byte)TransferProtocol.STATUS_PERCENT[i];
        }
        return pct;
    }

    @Override
    public void addFileTransferListener(FileTransferListener lst) {
        this.lib.addFileTransferListener(lst);
    }

    @Override
    public void removeFileTransferListener(FileTransferListener lst) {
        this.lib.removeFileTransferListener(lst);
    }

    protected class Result
    implements FileTransferRequestListener {
        public FileTransferException ex = null;
        public int id = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyComplete(int req, int uid) {
            Result result = this;
            synchronized (result) {
                this.id = uid;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyException(int req, FileTransferException ex) {
            Result result = this;
            synchronized (result) {
                this.ex = ex;
                this.notify();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int waitFor() throws FileTransferException {
            Result result = this;
            synchronized (result) {
                while (true) {
                    if (this.ex != null) {
                        throw this.ex;
                    }
                    if (this.id >= 0) {
                        return this.id;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ix) {
                        throw new FileTransferException(new I18nMessage(null, "Interrupted."));
                    }
                }
            }
        }
    }
}

