/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.transfer.LoaderListener;
import com.elluminate.groupware.transfer.StreamCache;
import com.elluminate.groupware.transfer.StreamEvent;
import com.elluminate.groupware.transfer.TransferLibrary;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.WorkerThread;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLoader {
    private Object lock;
    private String name;
    private int id;
    private Map attrs;
    private StreamCache cache = null;
    private Thread thread;
    private long length = -1L;
    private String mime = "application/octet-stream";
    private BigInteger auth;
    private int seq = -1;
    private short notify = (short)-32767;
    protected LoaderListener listener = null;
    protected TransferLibrary lib = null;

    protected AbstractLoader(int seq, String nm, int id, Map attrs, Object lock, LoaderListener listener, TransferLibrary lib, short notify) {
        this.seq = seq;
        this.name = nm;
        this.id = id;
        this.attrs = new HashMap(attrs);
        this.lock = lock;
        this.listener = listener;
        this.lib = lib;
        this.notify = notify;
    }

    protected AbstractLoader(int seq, String nm, int id, Map attrs, Object lock, LoaderListener listener, TransferLibrary lib) {
        this.seq = seq;
        this.name = nm;
        this.id = id;
        this.attrs = new HashMap(attrs);
        this.lock = lock;
        this.listener = listener;
        this.lib = lib;
    }

    protected void setName(String nm) {
        this.name = nm;
    }

    protected abstract boolean open() throws IOException;

    protected abstract void close();

    protected abstract boolean read(ProtocolBuffer var1, int var2);

    public void reportError(String msg, String details) {
        this.reportError(new I18nMessage(TransferLibrary.class, msg, new String[]{this.name, details}));
    }

    public void reportError(I18nMessage msg) {
        this.lib.sendError(this.notify, this.seq, msg);
        this.seq = -1;
        if (this.cache != null) {
            this.cache.streamAbort(StreamEvent.getInstance(this, this.id, null));
        }
    }

    public void reportOK() {
        this.lib.sendOK(this.notify, this.seq, this.id);
        this.seq = 0;
    }

    public String getName() {
        return this.name;
    }

    protected void setLength(long len) {
        this.length = len;
    }

    public long getLength() {
        return this.length;
    }

    protected void setMimeType(String type) {
        this.mime = type;
    }

    public String getMimeType() {
        return this.mime;
    }

    public void setAuth(BigInteger auth) {
        this.auth = auth;
    }

    public BigInteger getAuth() {
        return this.auth;
    }

    public short getNotifyAddress() {
        return this.notify;
    }

    public int getFID() {
        return this.id;
    }

    public int getRequestID() {
        return this.seq;
    }

    public void start() {
        class Loader
        implements Runnable {
            Loader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean abort;
                    long length;
                    if (!AbstractLoader.this.open()) {
                        return;
                    }
                    try {
                        length = AbstractLoader.this.getLength();
                        AbstractLoader.this.cache = new StreamCache(AbstractLoader.this.id, length);
                    }
                    catch (IOException ex) {
                        String msg = ex.getMessage();
                        if (msg == null) {
                            msg = ex.toString();
                        }
                        AbstractLoader.this.reportError("Transfer.cantConnect", msg);
                        AbstractLoader.this.close();
                        return;
                    }
                    Object msg = AbstractLoader.this.lock;
                    synchronized (msg) {
                        abort = !AbstractLoader.this.listener.startingLoad(AbstractLoader.this);
                    }
                    if (abort) {
                        AbstractLoader.this.close();
                        return;
                    }
                    boolean bl = abort = !AbstractLoader.this.listener.mayTransmit(AbstractLoader.this);
                    if (abort) {
                        AbstractLoader.this.close();
                        return;
                    }
                    while (length > 0L) {
                        ProtocolBuffer buf = ProtocolBuffer.getInstance();
                        int nBytes = 500;
                        if (length < 500L) {
                            nBytes = (int)length;
                        }
                        if (AbstractLoader.this.read(buf, nBytes)) {
                            length -= (long)nBytes;
                            Object object = AbstractLoader.this.lock;
                            synchronized (object) {
                                AbstractLoader.this.cache.streamingData(StreamEvent.getInstance(this, AbstractLoader.this.id, buf));
                                continue;
                            }
                        }
                        length = 0L;
                    }
                }
                finally {
                    AbstractLoader.this.close();
                }
            }
        }
        this.thread = new WorkerThread((Runnable)new Loader(), "Transfer Loader " + this.id);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public StreamCache getCache() {
        return this.cache;
    }

    public Map getAttributes() {
        return this.attrs;
    }
}

