/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session;

import com.elluminate.framework.moduleloading.states.ModulesState;
import com.elluminate.framework.moduleloading.states.ModulesStateListener;
import com.elluminate.framework.moduleloading.states.ModulesStateSrc;
import com.elluminate.framework.session.CRAnnotation;
import com.elluminate.framework.session.CRAnnotationFactory;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRPermissionStore;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSessionClientListener;
import com.elluminate.framework.session.CRSessionDebug;
import com.elluminate.framework.session.CRSessionGroupListener;
import com.elluminate.framework.session.CRSessionType;
import com.elluminate.framework.session.listener.CRAnnotationChangeListener;
import com.elluminate.framework.session.listener.CRParticipantDebug;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.CRRoomListener;
import com.elluminate.framework.session.listener.CRRoomListenerImpl;
import com.elluminate.framework.session.listener.event.CRAnnotationChangeEvent;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRParticipantEventType;
import com.elluminate.framework.session.listener.event.CRRoomEvent;
import com.elluminate.framework.session.listener.event.CRRoomEventType;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientGroupListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.ConferenceName;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ConnectionProvider;
import com.elluminate.jinx.provider.UninitializedException;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CRSession
extends CRPermissionStore
implements ModulesStateListener,
PropertyChangeListener {
    private CRSessionType type = CRSessionType.NONE;
    private CRParticipant me;
    private CRRoom mainRoom;
    private ClientList clientList;
    private Map<Short, CRParticipant> participantById = new HashMap<Short, CRParticipant>();
    private Map<String, CRParticipant> participantByName = new HashMap<String, CRParticipant>();
    private Map<Short, CRRoom> roomById = new HashMap<Short, CRRoom>();
    private Map<String, CRRoom> roomByName = new HashMap<String, CRRoom>();
    private Map<String, CRPermissionFactory> namePermissionFactoryMap = new HashMap<String, CRPermissionFactory>();
    private Map<String, List<CRAnnotationChangeListener>> nameAnnotationChangeListenerMap = new HashMap<String, List<CRAnnotationChangeListener>>();
    private Map<String, CRAnnotationFactory> nameAnnotationFactoryMap = new HashMap<String, CRAnnotationFactory>();
    private Map<String, List<CRPermissionChangeListener>> namePermissionChangeListenerMap = new HashMap<String, List<CRPermissionChangeListener>>();
    private ListenerRegistry<CRParticipantListener> participantListenerRegistry;
    private ListenerRegistry<CRRoomListener> roomListenerRegistry;
    private CRSessionClientListener clientListener;
    private CRSessionGroupListener groupListener;
    private CRParticipantListener partcipantListener;
    private CRRoomListener roomListener;
    private ConnectionProvider connectionProvider;
    private ModulesState attachingState;
    private ModulesState stoppingState;
    private Provider<CRAnnotationFactory> annotationFactoryProvider;
    private Object lock = new Object();
    private boolean running = false;

    @Inject
    protected void initConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Inject
    protected void initAnnotationFactoryProvider(Provider<CRAnnotationFactory> annotationFactoryProvider) {
        this.annotationFactoryProvider = annotationFactoryProvider;
    }

    @Inject
    protected void initParticipantListenerRegistry(ListenerRegistry<CRParticipantListener> registry) {
        if (CRSessionDebug.INFO.show()) {
            LogSupport.message((Object)this, (String)"initParticipantListenerRegistry", (String)registry.toString());
        }
        this.participantListenerRegistry = registry;
    }

    @Inject
    protected void initRoomListenerRegistry(ListenerRegistry<CRRoomListener> registry) {
        if (CRSessionDebug.INFO.show()) {
            LogSupport.message((Object)this, (String)"initRoomListenerRegistry", (String)registry.toString());
        }
        this.roomListenerRegistry = registry;
    }

    @Inject
    protected void initModuleState(ModulesStateSrc modulesStateSrc) {
        if (CRSessionDebug.INFO.show()) {
            LogSupport.message((Object)this, (String)"initModuleState", (String)modulesStateSrc.toString());
        }
        this.attachingState = modulesStateSrc.getState("attach", ModulesState.Status.ENTERING);
        this.stoppingState = modulesStateSrc.getState("stop", ModulesState.Status.ENTERING);
        modulesStateSrc.addStateListener((ModulesStateListener)this);
    }

    void start() {
        if (CRSessionDebug.INFO.show()) {
            LogSupport.message((Object)this, (String)"start", (String)this.connectionProvider.toString());
        }
        if (this.connectionProvider != null) {
            this.initConnection(this.connectionProvider.get());
        }
        this.running = true;
    }

    void stopping() {
        if (CRSessionDebug.INFO.show()) {
            LogSupport.message((Object)this, (String)"stopping", (String)this.connectionProvider.toString());
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void initConnection(Connection connection) {
        if (connection == null) {
            throw new RuntimeException("Connection is null");
        }
        if (connection.getConnectionType().equals((Object)Connection.Type.ONLINE_CLIENT)) {
            this.setSessionType(CRSessionType.ONLINE);
        } else if (connection.getConnectionType().equals((Object)Connection.Type.PLAYBACK_CLIENT)) {
            this.setSessionType(CRSessionType.PLAYBACK);
        } else {
            throw new RuntimeException("Unknown Connection Type: " + connection.getConnectionType());
        }
        if (CRSessionDebug.INFO.show()) {
            LogSupport.message((Object)this, (String)"initConnection", (String)("type " + (Object)((Object)this.type) + " " + connection));
        }
        this.init(connection, connection.getAddress(), CRPermissionScope.SESSION);
        this.clientList = connection.getClientList();
        this.clientList.addPropertyChangeListener((byte)0, (PropertyChangeListener)this);
        this.clientList.addPropertyChangeListener((byte)2, (PropertyChangeListener)this);
        this.clientList.addPropertyChangeListener((byte)1, (PropertyChangeListener)this);
        this.clientList.addClientListener((ClientListener)this.getClientListener());
        connection.addClientGroupListener((ClientGroupListener)this.getGroupListener());
        this.addParticipantListener(this.getParticipantListener());
        this.addRoomListener(this.getRoomListener());
    }

    CRParticipantListener getParticipantListener() {
        if (this.partcipantListener == null) {
            this.partcipantListener = new CRParticipantDebug();
        }
        return this.partcipantListener;
    }

    CRRoomListener getRoomListener() {
        if (this.roomListener == null) {
            this.roomListener = new CRRoomListenerImpl();
        }
        return this.roomListener;
    }

    CRSessionClientListener getClientListener() {
        if (this.clientListener == null) {
            this.clientListener = new CRSessionClientListener(this);
        }
        return this.clientListener;
    }

    CRSessionGroupListener getGroupListener() {
        if (this.groupListener == null) {
            this.groupListener = new CRSessionGroupListener(this);
        }
        return this.groupListener;
    }

    public void setSessionType(CRSessionType type) {
        this.type = type;
    }

    public CRSessionType getSessionType() {
        return this.type;
    }

    public String getSessionName() {
        if (this.clientList == null) {
            return "";
        }
        Connection con = this.clientList.getConnection();
        if (con == null) {
            return "";
        }
        ConferenceName conferenceName = con.getConferenceName();
        if (conferenceName == null) {
            return "";
        }
        String sessionName = conferenceName.getDisplayName();
        if (sessionName == null) {
            return "";
        }
        return sessionName;
    }

    public PropertyAccessAPI getPropertyStore() {
        return this.clientList;
    }

    public CRParticipant getMe() {
        return this.me;
    }

    public CRParticipant getParticipantById(short id) {
        return this.participantById.get(id);
    }

    public CRParticipant getParticipantByName(String name) {
        return this.participantByName.get(name);
    }

    public Iterator<CRParticipant> getParticipantIterator() {
        return this.participantById.values().iterator();
    }

    public int getNumberOfParticipants() {
        return this.participantById.size();
    }

    public boolean isChair(CRParticipant participant) {
        return participant != null && this.getPermissionValue("ChairPermission", participant.getID());
    }

    CRParticipant addParticipant(CRParticipant participant, short roomId) {
        CRParticipantEvent joinEvent = null;
        this.addParticipant(participant);
        CRRoom room = this.getRoomById(roomId);
        if (room == null) {
            room = this.getMainRoom();
        }
        if (participant != null && room != null) {
            joinEvent = room.addParticipant(participant);
        }
        if (joinEvent != null) {
            this.fireParticipantEvent(joinEvent);
        }
        return participant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addParticipant(final CRParticipant participant) {
        if (participant == null) {
            return;
        }
        short participantId = participant.getID();
        CRParticipantEvent addEvent = null;
        class FutureEvent {
            CRAnnotation annotation;

            public FutureEvent(CRAnnotation annotation) {
                this.annotation = annotation;
            }

            public void fire() {
                CRAnnotationChangeEvent event = new CRAnnotationChangeEvent(this.annotation);
                CRAnnotationFactory factory = this.annotation.getFactory();
                factory.fireAnnotationEvent(event);
            }
        }
        ArrayList<FutureEvent> annotationEvents = new ArrayList<FutureEvent>();
        boolean meAdded = false;
        Object object = this.lock;
        synchronized (object) {
            if (participant.isMe()) {
                this.me = participant;
                meAdded = true;
            }
            CRPermissionFactory pFactory = null;
            Object itr = this.getPermissionFactoryIterator();
            while (itr.hasNext()) {
                pFactory = itr.next();
                if (pFactory.getScope() != CRPermissionScope.PARTICIPANT) continue;
                CRPermission permission = pFactory.getPermissionInstance(participantId);
                participant.addPermission(permission);
            }
            if (this.getParticipantById(participantId) == null) {
                itr = this.lock;
                synchronized (itr) {
                    HashMap<Short, CRParticipant> byIdCopy = new HashMap<Short, CRParticipant>(this.participantById);
                    byIdCopy.put(participantId, participant);
                    this.participantById = byIdCopy;
                    HashMap<String, CRParticipant> byNameCopy = new HashMap<String, CRParticipant>(this.participantByName);
                    byNameCopy.put(participant.getName(), participant);
                    this.participantByName = byNameCopy;
                }
                addEvent = new CRParticipantEvent(CRParticipantEventType.ADDED, participant);
            }
            CRAnnotationFactory aFactory = null;
            Iterator<CRAnnotationFactory> itr2 = this.getAnnotationFactoryIterator();
            while (itr2.hasNext()) {
                aFactory = itr2.next();
                CRAnnotation annotation = aFactory.getAnnotationInstance(participantId);
                participant.addAnnotation(annotation);
                annotationEvents.add(new FutureEvent(annotation));
            }
        }
        if (addEvent != null) {
            this.fireParticipantEvent(addEvent);
        }
        if (meAdded) {
            this.participantListenerRegistry.fire((FiringFunctor)new FiringFunctor<CRParticipantListener>(){

                public void fire(CRParticipantListener listener) {
                    listener.onMeAdded(new CRParticipantEvent(CRParticipantEventType.ME_ADDED, participant));
                }
            });
        }
        for (FutureEvent event : annotationEvents) {
            event.fire();
        }
    }

    public void removeParticipant(short id) {
        CRParticipant participant = this.getParticipantById(id);
        this.removeParticipant(participant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeParticipant(final CRParticipant participant) {
        CRParticipantEvent removeEvent = null;
        CRParticipantEvent leaveEvent = null;
        if (participant == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            short participantId;
            CRRoom room = participant.getRoom();
            if (room != null) {
                leaveEvent = room.removeParticipant(participant);
            }
            if (participant.isMe()) {
                this.me = null;
            }
            if (this.participantById.containsKey(participantId = participant.getID())) {
                HashMap<Short, CRParticipant> byIdCopy = new HashMap<Short, CRParticipant>(this.participantById);
                byIdCopy.remove(participantId);
                this.participantById = byIdCopy;
                HashMap<String, CRParticipant> byNameCopy = new HashMap<String, CRParticipant>(this.participantByName);
                byNameCopy.remove(participant.getName());
                this.participantByName = byNameCopy;
                participant.removeAllPermissions();
                removeEvent = new CRParticipantEvent(CRParticipantEventType.REMOVED, participant);
            }
        }
        if (leaveEvent != null) {
            this.fireParticipantEvent(leaveEvent);
        }
        if (removeEvent != null) {
            this.fireParticipantEvent(removeEvent);
            if (participant.isMe()) {
                this.participantListenerRegistry.fire((FiringFunctor)new FiringFunctor<CRParticipantListener>(){

                    public void fire(CRParticipantListener listener) {
                        listener.onMeRemoved(new CRParticipantEvent(CRParticipantEventType.ME_REMOVED, participant));
                    }
                });
            }
        }
    }

    public CRRoom getRoomById(short id) {
        return this.roomById.get(id);
    }

    public CRRoom getRoomByName(String name) {
        return this.roomByName.get(name);
    }

    public CRRoom getMainRoom() {
        ClientGroup group;
        if (this.clientList == null) {
            throw new UninitializedException("Classroom Session has not been initialized.");
        }
        if (this.mainRoom == null && (group = this.clientList.getClientGroup((short)0)) != null) {
            CRRoom room = new CRRoom(this, group);
            this.addRoom(room);
        }
        return this.mainRoom;
    }

    public int getNumberOfRooms() {
        return this.roomById.size();
    }

    public Iterator<CRRoom> getRoomIterator() {
        return this.roomById.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRoom(CRRoom room) {
        CRRoomEvent event = null;
        if (room == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            short roomId = room.getID();
            if (room.isMain()) {
                this.mainRoom = room;
            }
            CRPermissionFactory factory = null;
            Iterator<CRPermissionFactory> itr = this.getPermissionFactoryIterator();
            while (itr.hasNext()) {
                factory = itr.next();
                if (factory.getScope() != CRPermissionScope.ROOM) continue;
                room.addPermission(factory.getPermissionInstance(roomId));
            }
            if (this.getRoomById(roomId) == null) {
                HashMap<Short, CRRoom> byIdCopy = new HashMap<Short, CRRoom>(this.roomById);
                byIdCopy.put(roomId, room);
                this.roomById = byIdCopy;
                HashMap<String, CRRoom> byNameCopy = new HashMap<String, CRRoom>(this.roomByName);
                byNameCopy.put(room.getName(), room);
                this.roomByName = byNameCopy;
                event = new CRRoomEvent(CRRoomEventType.CREATED, room);
            }
        }
        if (event != null) {
            this.fireRoomEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRoom(short id) {
        CRRoom room = null;
        CRRoomEvent event = null;
        ArrayList<CRParticipantEvent> events = null;
        Object object = this.lock;
        synchronized (object) {
            HashMap<Short, CRRoom> byIdCopy = new HashMap<Short, CRRoom>(this.roomById);
            room = (CRRoom)byIdCopy.remove(id);
            if (room != null) {
                this.roomById = byIdCopy;
                if (room.isMain()) {
                    this.mainRoom = null;
                } else if (this.mainRoom != null) {
                    Iterator<CRParticipant> itr = room.getParticipantIterator();
                    while (itr.hasNext()) {
                        CRParticipant p = itr.next();
                        if (events == null) {
                            events = new ArrayList<CRParticipantEvent>();
                        }
                        events.add(room.removeParticipant(p));
                        events.add(this.mainRoom.addParticipant(p));
                    }
                }
                HashMap<String, CRRoom> byNameCopy = new HashMap<String, CRRoom>(this.roomByName);
                byNameCopy.remove(room.getName());
                this.roomByName = byNameCopy;
            }
        }
        if (room != null) {
            room.removeAllPermissions();
            room.dispose();
            if (events != null) {
                for (CRParticipantEvent e : events) {
                    this.fireParticipantEvent(e);
                }
            }
            event = new CRRoomEvent(CRRoomEventType.DELETED, room);
            this.fireRoomEvent(event);
        }
    }

    public void addParticipantListener(CRParticipantListener listener) {
        this.participantListenerRegistry.add((Object)listener);
    }

    public void removeParticipantListener(CRParticipantListener listener) {
        this.participantListenerRegistry.remove((Object)listener);
    }

    public void addRoomListener(CRRoomListener listener) {
        this.roomListenerRegistry.add((Object)listener);
    }

    public void removeRoomListener(CRRoomListener listener) {
        this.roomListenerRegistry.remove((Object)listener);
    }

    void fireParticipantEvent(final CRParticipantEvent event) {
        Object ff = null;
        if (event.getEventType() == CRParticipantEventType.ADDED) {
            ff = new FiringFunctor<CRParticipantListener>(){

                public void fire(CRParticipantListener listener) {
                    listener.onParticipantAdded(event);
                }
            };
        } else if (event.getEventType() == CRParticipantEventType.REMOVED) {
            ff = new FiringFunctor<CRParticipantListener>(){

                public void fire(CRParticipantListener listener) {
                    listener.onParticipantRemoved(event);
                }
            };
        } else if (event.getEventType() == CRParticipantEventType.RENAMED) {
            ff = new FiringFunctor<CRParticipantListener>(){

                public void fire(CRParticipantListener listener) {
                    listener.onParticipantRenamed(event);
                }
            };
        } else if (event.getEventType() == CRParticipantEventType.JOINED) {
            ff = new FiringFunctor<CRParticipantListener>(){

                public void fire(CRParticipantListener listener) {
                    listener.onParticipantJoinedRoom(event);
                }
            };
        } else if (event.getEventType() == CRParticipantEventType.LEFT) {
            ff = new FiringFunctor<CRParticipantListener>(){

                public void fire(CRParticipantListener listener) {
                    listener.onParticipantLeftRoom(event);
                }
            };
        }
        this.participantListenerRegistry.fire((FiringFunctor)ff);
    }

    void fireRoomEvent(final CRRoomEvent event) {
        Object ff = null;
        if (event.getEventType() == CRRoomEventType.CREATED) {
            ff = new FiringFunctor<CRRoomListener>(){

                public void fire(CRRoomListener listener) {
                    listener.onRoomCreated(event);
                }
            };
        } else if (event.getEventType() == CRRoomEventType.DELETED) {
            ff = new FiringFunctor<CRRoomListener>(){

                public void fire(CRRoomListener listener) {
                    listener.onRoomDeleted(event);
                }
            };
        } else if (event.getEventType() == CRRoomEventType.RENAMED) {
            ff = new FiringFunctor<CRRoomListener>(){

                public void fire(CRRoomListener listener) {
                    listener.onRoomRenamed(event);
                }
            };
        }
        this.roomListenerRegistry.fire((FiringFunctor)ff);
    }

    public void moduleStateChanged(ModulesState state) {
        if (CRSessionDebug.INFO.show()) {
            LogSupport.message((Object)this, (String)"moduleStateChanged", (String)("new state - " + state));
        }
        if (state.equals((Object)this.attachingState)) {
            this.start();
        } else if (state.equals((Object)this.stoppingState)) {
            this.stopping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPermission(CRPermissionFactory factory) {
        if (factory == null) {
            throw new RuntimeException("Attempt to register a permission via a null factory");
        }
        if (factory.getName() == null) {
            throw new RuntimeException("Attempt to register a permission with a factory containing a null name");
        }
        if (factory.delegate == null) {
            throw new RuntimeException("Attempt to register a permission with " + factory.getName() + " factory containing a null delegate");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.namePermissionFactoryMap.containsKey(factory.getName())) {
                throw new RuntimeException("Attempt to register duplicate " + factory.getName() + " permission");
            }
            CRPermissionScope scope = factory.getScope();
            switch (scope) {
                case SESSION: {
                    CRPermission permission = factory.getPermissionInstance(this.getID());
                    this.addPermission(permission);
                    break;
                }
                case ROOM: {
                    CRPermission permission;
                    Iterator<CRRoom> roomI = this.getRoomIterator();
                    while (roomI.hasNext()) {
                        CRRoom room = roomI.next();
                        permission = factory.getPermissionInstance(room.getID());
                        room.addPermission(permission);
                    }
                    break;
                }
                case PARTICIPANT: {
                    CRPermission permission;
                    Iterator<CRParticipant> participantI = this.getParticipantIterator();
                    while (participantI.hasNext()) {
                        CRParticipant participant = participantI.next();
                        permission = factory.getPermissionInstance(participant.getID());
                        participant.addPermission(permission);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Attempt to register " + factory.getName() + " factory using unknown factory scope " + (Object)((Object)scope));
                }
            }
            List<CRPermissionChangeListener> listenerList = this.namePermissionChangeListenerMap.get(factory.getName());
            if (listenerList != null) {
                for (CRPermissionChangeListener lst : listenerList) {
                    factory.addListener(lst);
                }
            }
            HashMap<String, CRPermissionFactory> copy = new HashMap<String, CRPermissionFactory>(this.namePermissionFactoryMap);
            copy.put(factory.getName(), factory);
            this.namePermissionFactoryMap = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterPermission(String permissionName) {
        if (permissionName == null) {
            throw new RuntimeException("Attempt to deregister a permission factory using a null permissionName");
        }
        Object object = this.lock;
        synchronized (object) {
            CRPermissionFactory factory = this.namePermissionFactoryMap.get(permissionName);
            if (factory == null) {
                throw new RuntimeException("Attempt to deregister unknown " + permissionName + " permission factory");
            }
            switch (factory.getScope()) {
                case SESSION: {
                    this.removePermission(permissionName);
                    break;
                }
                case ROOM: {
                    Iterator<CRRoom> roomI = this.getRoomIterator();
                    while (roomI.hasNext()) {
                        CRRoom room = roomI.next();
                        room.removePermission(permissionName);
                    }
                    break;
                }
                case PARTICIPANT: {
                    Iterator<CRParticipant> participantI = this.getParticipantIterator();
                    while (participantI.hasNext()) {
                        CRParticipant participant = participantI.next();
                        participant.removePermission(permissionName);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Attempt to deregister permission factory with unknown permission scope " + (Object)((Object)factory.getScope()));
                }
            }
            List<CRPermissionChangeListener> listenerList = this.namePermissionChangeListenerMap.get(permissionName);
            if (listenerList != null) {
                for (CRPermissionChangeListener listener : listenerList) {
                    factory.removeListener(listener);
                }
            }
            HashMap<String, CRPermissionFactory> copy = new HashMap<String, CRPermissionFactory>(this.namePermissionFactoryMap);
            copy.remove(permissionName);
            this.namePermissionFactoryMap = copy;
        }
    }

    public void addPermissionChangeListener(String permissionName, CRPermissionChangeListener listener) {
        this.addOrRemovePermissionChangeListener(permissionName, listener, true);
    }

    public void removePermissionChangeListener(String permissionName, CRPermissionChangeListener listener) {
        this.addOrRemovePermissionChangeListener(permissionName, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrRemovePermissionChangeListener(String permissionName, CRPermissionChangeListener listener, boolean add) {
        if (listener == null) {
            throw new RuntimeException("Attempt to add or remove a null listener");
        }
        Object object = this.lock;
        synchronized (object) {
            List<CRPermissionChangeListener> listenerList = this.namePermissionChangeListenerMap.get(permissionName);
            if (listenerList == null) {
                listenerList = new ArrayList<CRPermissionChangeListener>();
                this.namePermissionChangeListenerMap.put(permissionName, listenerList);
            }
            CRPermissionFactory factory = this.namePermissionFactoryMap.get(permissionName);
            if (add) {
                if (factory != null) {
                    factory.addListener(listener);
                }
                listenerList.add(listener);
            } else {
                if (factory != null) {
                    factory.removeListener(listener);
                }
                listenerList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRPermission getPermission(String permissionName, short id) {
        CRPermission permission = null;
        Object object = this.lock;
        synchronized (object) {
            CRPermissionFactory factory = this.namePermissionFactoryMap.get(permissionName);
            if (factory == null) {
                if (this.getSessionType() == CRSessionType.PLAYBACK) {
                    return null;
                }
                throw new RuntimeException("Attempt to get unregistered permission: " + permissionName);
            }
            switch (factory.getScope()) {
                case SESSION: {
                    permission = this.getPermission(permissionName);
                    break;
                }
                case ROOM: {
                    CRRoom room = this.getRoomById(id);
                    if (room == null) break;
                    permission = room.getPermission(permissionName);
                    break;
                }
                case PARTICIPANT: {
                    CRParticipant participant = this.getParticipantById(id);
                    if (participant == null) break;
                    permission = participant.getPermission(permissionName);
                    break;
                }
                default: {
                    throw new RuntimeException("Attempt to get permission group using unknown scope: " + (Object)((Object)factory.getScope()));
                }
            }
        }
        return permission;
    }

    public String getPermissionGroup(String permissionName, short id) {
        CRPermission permission = this.getPermission(permissionName, id);
        if (permission != null) {
            return permission.getGroup();
        }
        return null;
    }

    public boolean getPermissionValue(String permissionName, short id) {
        CRPermission permission = this.getPermission(permissionName, id);
        if (permission != null) {
            return permission.getValue();
        }
        return this.getPermissionDefault(permissionName);
    }

    public void setPermissionValue(String permissionName, short id, boolean value) {
        CRPermission permission = this.getPermission(permissionName, id);
        if (permission != null) {
            permission.setValue(value);
        }
    }

    public void setPermissionValue(String permissionName, List<CRParticipant> participants, boolean value) {
        if (participants != null) {
            ArrayList<CRPermission> permissions = new ArrayList<CRPermission>();
            for (CRParticipant p : participants) {
                CRPermission permission;
                if (p == null || (permission = p.getPermission(permissionName)) == null) continue;
                permissions.add(permission);
            }
            if (permissions.size() > 0) {
                ((CRPermission)permissions.get(0)).setValue(permissions, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPermissionDefault(String permissionName) {
        boolean value = false;
        Object object = this.lock;
        synchronized (object) {
            CRPermissionDelegate delegate;
            CRPermissionFactory factory = this.namePermissionFactoryMap.get(permissionName);
            if (factory != null && (delegate = factory.delegate) != null) {
                value = delegate.getDefault();
            }
        }
        return value;
    }

    public void setPermissionDefault(String permissionName, short id, boolean value) {
        CRPermission permission = this.getPermission(permissionName, id);
        if (permission != null) {
            permission.setDefault(value);
        }
    }

    public boolean canSetPermission(String permissionName, short id) {
        CRPermission permission = this.getPermission(permissionName, id);
        if (permission != null) {
            return permission.canSet();
        }
        return false;
    }

    public boolean canSetPermissionDefault(String permissionName, short id) {
        CRPermission permission = this.getPermission(permissionName, id);
        if (permission != null) {
            return permission.canSetDefault();
        }
        return false;
    }

    private Iterator<CRPermissionFactory> getPermissionFactoryIterator() {
        return this.namePermissionFactoryMap.values().iterator();
    }

    public List<String> getPermissionNames(CRPermissionScope scope) {
        ArrayList<String> permissionNameList = new ArrayList<String>();
        for (CRPermissionFactory pFactory : this.namePermissionFactoryMap.values()) {
            String permissionName;
            if (pFactory.getScope() != scope || (permissionName = pFactory.getName()).equals("ChairPermission")) continue;
            permissionNameList.add(permissionName);
        }
        return permissionNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAnnotation(String annotationName, Object defaultValue) {
        if (annotationName == null) {
            throw new RuntimeException("Attempt to register an annotation with a null name");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.nameAnnotationFactoryMap.containsKey(annotationName)) {
                throw new RuntimeException("Attempt to register duplicate " + annotationName + " annotation");
            }
            CRAnnotationFactory factory = (CRAnnotationFactory)this.annotationFactoryProvider.get();
            factory.init(annotationName, defaultValue);
            this.nameAnnotationFactoryMap.put(annotationName, factory);
            List<CRAnnotationChangeListener> listenerList = this.nameAnnotationChangeListenerMap.get(annotationName);
            if (listenerList != null) {
                for (CRAnnotationChangeListener listener : listenerList) {
                    factory.addListener(listener);
                }
            }
            for (CRParticipant participant : this.participantById.values()) {
                CRAnnotation annotation = factory.getAnnotationInstance(participant.getID());
                participant.addAnnotation(annotation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterAnnotation(String annotationName) {
        if (annotationName == null) {
            throw new RuntimeException("Attempt to deregister a annotation factory using a null annotationName");
        }
        Object object = this.lock;
        synchronized (object) {
            CRAnnotationFactory factory = this.nameAnnotationFactoryMap.get(annotationName);
            if (factory == null) {
                return;
            }
            for (CRParticipant participant : this.participantById.values()) {
                participant.removeAnnotation(annotationName);
            }
            List<CRAnnotationChangeListener> listenerList = this.nameAnnotationChangeListenerMap.get(annotationName);
            if (listenerList != null) {
                for (CRAnnotationChangeListener listener : listenerList) {
                    factory.removeListener(listener);
                }
            }
            this.nameAnnotationFactoryMap.remove(annotationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRAnnotation getAnnotation(String annotationName, short id) {
        CRAnnotation annotation = null;
        Object object = this.lock;
        synchronized (object) {
            CRAnnotationFactory factory = this.nameAnnotationFactoryMap.get(annotationName);
            if (factory == null) {
                throw new RuntimeException("Attempt to get unregistered annotation: " + annotationName);
            }
            CRParticipant participant = this.getParticipantById(id);
            if (participant != null) {
                annotation = participant.getAnnotation(annotationName);
            }
        }
        return annotation;
    }

    public Object getAnnotationValue(CRParticipant participant, String annotationName) {
        if (participant != null) {
            return participant.getAnnotationValue(annotationName);
        }
        return null;
    }

    public Object getAnnotationValue(short id, String annotationName) {
        CRParticipant participant = this.getParticipantById(id);
        if (participant != null) {
            return this.getAnnotationValue(participant, annotationName);
        }
        return null;
    }

    public void setAnnotationValue(CRParticipant participant, String annotationName, Object value) {
        if (participant != null) {
            participant.setAnnotationValue(annotationName, value);
        }
    }

    public void setAnnotationValue(short id, String annotationName, Object value) {
        CRParticipant participant = this.getParticipantById(id);
        if (participant == null) {
            return;
        }
        this.setAnnotationValue(participant, annotationName, value);
    }

    private Iterator<CRAnnotationFactory> getAnnotationFactoryIterator() {
        return this.nameAnnotationFactoryMap.values().iterator();
    }

    public void addAnnotationChangeListener(String annotationName, CRAnnotationChangeListener listener) {
        this.addOrRemoveAnnotationChangeListener(annotationName, listener, true);
    }

    public void removeAnnotationChangeListener(String annotationName, CRAnnotationChangeListener listener) {
        this.addOrRemoveAnnotationChangeListener(annotationName, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrRemoveAnnotationChangeListener(String annotationName, CRAnnotationChangeListener listener, boolean add) {
        if (listener == null) {
            throw new RuntimeException("Attempt to add or remove a null listener");
        }
        Object object = this.lock;
        synchronized (object) {
            CRAnnotationFactory factory = this.nameAnnotationFactoryMap.get(annotationName);
            List<CRAnnotationChangeListener> listenerList = this.nameAnnotationChangeListenerMap.get(annotationName);
            if (listenerList == null) {
                listenerList = new ArrayList<CRAnnotationChangeListener>();
                this.nameAnnotationChangeListenerMap.put(annotationName, listenerList);
            }
            if (add) {
                listenerList.add(listener);
                if (factory != null) {
                    factory.addListener(listener);
                }
            } else {
                listenerList.remove(listener);
                if (factory != null) {
                    factory.removeListener(listener);
                }
            }
        }
    }

    @Override
    public String toString() {
        return "[Session: ID = " + this.getID() + ", type=" + (Object)((Object)this.getSessionType()) + ", mainRoom=" + this.mainRoom + ", me=" + this.getMe() + ", nameFactoryMap=" + this.namePermissionFactoryMap + ", participantMap=" + this.participantById + ", roomMap=" + this.roomById + "]";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (DebugFlag.get((String)"session.properties").isEnabled()) {
            LogSupport.log((Object)this, (String)"DEBUG", (String)("***** " + evt.getPropertyName() + " " + evt.getSource() + " " + evt.getOldValue() + " " + evt.getNewValue()));
        }
    }
}

