/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRPermissionStore;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRParticipantEventType;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.PropertyAccessAPI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CRRoom
extends CRPermissionStore {
    private ClientGroup group;
    private CRSession session;
    private Map<Short, CRParticipant> participantsById = new HashMap<Short, CRParticipant>();
    private Map<String, CRParticipant> participantsByName = new HashMap<String, CRParticipant>();

    public CRRoom(CRSession session, ClientGroup group) {
        this.setSession(session);
        this.setClientGroup(group);
        this.init(session.getConnection(), group.getGroupID(), CRPermissionScope.ROOM);
    }

    public CRSession getSession() {
        return this.session;
    }

    private void setSession(CRSession session) {
        this.session = session;
    }

    private ClientGroup getClientGroup() {
        return this.group;
    }

    private void setClientGroup(ClientGroup group) {
        this.group = group;
    }

    public String getName() {
        return this.getClientGroup() != null ? this.getClientGroup().getName() : null;
    }

    @Override
    public short getID() {
        return this.group.getGroupID();
    }

    public PropertyAccessAPI getPropertyStore() {
        return this.group;
    }

    public boolean isMain() {
        return this.group.getGroupID() == 0;
    }

    public int getNumberOfParticipants() {
        return this.participantsById.size();
    }

    public CRParticipant getParticipantById(Short id) {
        return this.participantsById.get(id);
    }

    public CRParticipant getParticipantByName(String name) {
        return this.participantsByName.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CRParticipantEvent addParticipant(CRParticipant participant) {
        if (participant == null) {
            return null;
        }
        Map<Short, CRParticipant> map = this.participantsById;
        synchronized (map) {
            short participantId = participant.getID();
            String participantName = participant.getName();
            if (this.participantsById.containsKey(participantId)) {
                throw new IllegalStateException("'" + participantName + "' is already in room " + this.group.getName());
            }
            HashMap<Short, CRParticipant> byIdCopy = new HashMap<Short, CRParticipant>(this.participantsById);
            byIdCopy.put(participantId, participant);
            this.participantsById = byIdCopy;
            HashMap<String, CRParticipant> byNameCopy = new HashMap<String, CRParticipant>(this.participantsByName);
            byNameCopy.put(participantName, participant);
            this.participantsByName = byNameCopy;
            participant.setRoom(this);
            return new CRParticipantEvent(CRParticipantEventType.JOINED, participant, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CRParticipantEvent removeParticipant(CRParticipant participant) {
        CRParticipantEvent event = null;
        if (participant == null) {
            return event;
        }
        Map<Short, CRParticipant> map = this.participantsById;
        synchronized (map) {
            short id = participant.getID();
            String name = participant.getName();
            HashMap<Short, CRParticipant> byIdCopy = new HashMap<Short, CRParticipant>(this.participantsById);
            if (byIdCopy.remove(id) != null) {
                this.participantsById = byIdCopy;
                HashMap<String, CRParticipant> byNameCopy = new HashMap<String, CRParticipant>(this.participantsByName);
                byNameCopy.remove(name);
                this.participantsByName = byNameCopy;
                if (participant.getRoom() == this) {
                    participant.setRoom(null);
                }
                event = new CRParticipantEvent(CRParticipantEventType.LEFT, participant, this);
            }
        }
        return event;
    }

    public Iterator<CRParticipant> getParticipantIterator() {
        return this.participantsById.values().iterator();
    }

    public void dispose() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CRRoom)) {
            return false;
        }
        CRRoom other = (CRRoom)obj;
        return other.getID() == this.getID();
    }

    @Override
    public String toString() {
        return "[Room: ID = " + this.getID() + ", name=" + this.getName() + ", mainRoom=" + this.isMain() + ", participantCount=" + this.getNumberOfParticipants() + "]";
    }
}

