/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.session;

import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSessionDebug;
import com.elluminate.jinx.Connection;
import com.elluminate.util.log.LogSupport;
import java.util.HashMap;
import java.util.Map;

public class CRPermissionStore {
    private short id = (short)-32767;
    private CRPermissionScope scope = CRPermissionScope.UNKNOWN;
    private Connection connection = null;
    private Map<String, CRPermission> namePermissionMap = new HashMap<String, CRPermission>();

    protected final void init(Connection connection, short addr, CRPermissionScope scope) {
        if (CRSessionDebug.INFO.show()) {
            LogSupport.message((Object)this, (String)"init", (String)("init: " + connection + " " + addr));
        }
        if (connection == null) {
            return;
        }
        this.id = addr;
        this.connection = connection;
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPermission(CRPermission permission) {
        if (permission == null) {
            return;
        }
        Map<String, CRPermission> map = this.namePermissionMap;
        synchronized (map) {
            this.namePermissionMap.put(permission.getName(), permission);
            if (CRSessionDebug.PERMISSION_TRACE.show()) {
                LogSupport.message((Object)this, (String)"addPermission", (String)("Added permission: " + permission + " to store: " + this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CRPermission getPermission(String permissionName) {
        Map<String, CRPermission> map = this.namePermissionMap;
        synchronized (map) {
            CRPermission permission = this.namePermissionMap.get(permissionName);
            if (CRSessionDebug.PERMISSION_TRACE.show()) {
                LogSupport.message((Object)this, (String)"getPermission", (String)("Fetched permission " + permission + " from store: " + this));
            }
            return permission;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePermission(String permissionName) {
        Map<String, CRPermission> map = this.namePermissionMap;
        synchronized (map) {
            CRPermission permission = this.namePermissionMap.remove(permissionName);
            if (CRSessionDebug.PERMISSION_TRACE.show()) {
                LogSupport.message((Object)this, (String)"removePermission", (String)("Removed permission " + permission + " from store: " + this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllPermissions() {
        Map<String, CRPermission> map = this.namePermissionMap;
        synchronized (map) {
            this.namePermissionMap.clear();
            if (CRSessionDebug.PERMISSION_TRACE.show()) {
                LogSupport.message((Object)this, (String)"removeAllPermissions", (String)("Removed all permissions from store: " + this));
            }
        }
    }

    public short getID() {
        return this.id;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public CRPermissionScope getScope() {
        return this.scope;
    }

    public String toString() {
        String descStr = "[CRPermissionStore: ";
        if (this.getID() == -1) {
            descStr = descStr + "UNDEFINED]";
            return descStr;
        }
        descStr = descStr + "ID=" + this.getID() + " scope=" + (Object)((Object)this.scope);
        return descStr;
    }
}

