/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ResponderProfile {
    private static Map<String, ResponderProfile> profiles = new HashMap<String, ResponderProfile>();
    public static final ResponderProfile ALL = new AllProfile();
    public static final ResponderProfile DESKTOP = new DesktopProfile();
    public static final ResponderProfile MOBILE = new MobileProfile();
    public static final int ALL_PROFILE = 0;
    public static final int DESKTOP_PROFILE = 1;
    public static final int MOBILE_PROFILE = 2;
    public static final String[] PROFILE_NAMES = new String[]{"DESKTOP", "MOBILE", "ALL"};
    public static final int[] PROFILE_TYPES = new int[]{1, 2, 0};
    public static final ResponderProfile[] PROFILES = new ResponderProfile[]{DESKTOP, MOBILE, ALL};
    private Set<String> blacklist = null;
    private Set<String> whitelist = null;

    public static ResponderProfile getInstance(String name) {
        ResponderProfile profile = profiles.get(name);
        if (profile == null) {
            throw new IllegalArgumentException("Unknown responder profile '" + name + "'");
        }
        return profile;
    }

    public static ResponderProfile getInstance(String name, ResponderProfile dft) {
        ResponderProfile profile = profiles.get(name);
        if (profile == null) {
            profile = dft;
        }
        return profile;
    }

    private ResponderProfile(String nm) {
        profiles.put(nm, this);
    }

    public boolean enableResponderForChannel(String name) {
        if (this.whitelist != null) {
            return this.whitelist.contains(name);
        }
        if (this.blacklist != null) {
            return !this.blacklist.contains(name);
        }
        return true;
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    protected void blacklistChannel(String channel) {
        if (this.whitelist != null) {
            throw new IllegalStateException("Either whitelist or blacklist - pick one");
        }
        if (this.blacklist == null) {
            this.blacklist = new HashSet<String>();
        }
        this.blacklist.add(channel);
    }

    protected void whitelistChannel(String channel) {
        if (this.blacklist != null) {
            throw new IllegalStateException("Either whitelist or blacklist - pick one");
        }
        if (this.whitelist == null) {
            this.whitelist = new HashSet<String>();
        }
        this.whitelist.add(channel);
    }

    static class AllProfile
    extends ResponderProfile {
        public AllProfile() {
            super("all");
        }
    }

    static class DesktopProfile
    extends ResponderProfile {
        public DesktopProfile() {
            super("desktop");
            this.blacklistChannel("svgWhiteboard");
        }
    }

    static class MobileProfile
    extends ResponderProfile {
        public MobileProfile() {
            super("mobile");
            this.whitelistChannel("control");
            this.whitelistChannel("audio");
            this.whitelistChannel("directMessaging");
            this.whitelistChannel("svgWhiteboard");
            this.whitelistChannel("hand");
            this.whitelistChannel("AppSharing");
        }
    }
}

